"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchAllInvestigationTags = useFetchAllInvestigationTags;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _query_key_factory = require("./query_key_factory");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchAllInvestigationTags() {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    isInitialLoading,
    isLoading,
    isError,
    isSuccess,
    isRefetching,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: _query_key_factory.investigationKeys.tags(),
    queryFn: async ({
      signal
    }) => {
      return await http.get(`/api/observability/investigations/_tags`, {
        version: '2023-10-31',
        signal
      });
    },
    staleTime: 15 * 1000,
    refetchOnWindowFocus: false,
    retry: false,
    onError: error => {
      toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.investigateApp.useFetchAllInvestigationTags.errorTitle', {
          defaultMessage: 'Something went wrong while fetching the investigation tags'
        })
      });
    }
  });
  return {
    data,
    isInitialLoading,
    isLoading,
    isRefetching,
    isSuccess,
    isError
  };
}