"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAddInvestigationItem = useAddInvestigationItem;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAddInvestigationItem() {
  const {
    core: {
      http,
      notifications: {
        toasts
      }
    }
  } = (0, _use_kibana.useKibana)();
  return (0, _reactQuery.useMutation)(['addInvestigationItem'], ({
    investigationId,
    item
  }) => {
    const body = JSON.stringify(item);
    return http.post(`/api/observability/investigations/${investigationId}/items`, {
      body,
      version: '2023-10-31'
    });
  }, {
    onSuccess: (response, {}) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.investigateApp.addInvestigationItem.successMessage', {
        defaultMessage: 'Item saved'
      }));
    },
    onError: (error, {}, context) => {
      var _error$body$message, _error$body;
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : _i18n.i18n.translate('xpack.investigateApp.addInvestigationItem.errorMessage', {
        defaultMessage: 'an error occurred'
      })), {
        title: _i18n.i18n.translate('xpack.investigateApp.addInvestigationItem.errorTitle', {
          defaultMessage: 'Error'
        })
      });
    }
  });
}