"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExternalIncidentField = ExternalIncidentField;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactHookForm = require("react-hook-form");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const I18N_LABEL = _i18n.i18n.translate('xpack.investigateApp.investigationEditForm.externalIncidentUrlLabel', {
  defaultMessage: 'External incident URL'
});
function ExternalIncidentField() {
  const {
    control,
    getFieldState
  } = (0, _reactHookForm.useFormContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: getFieldState('externalIncidentUrl').invalid,
    label: I18N_LABEL
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "externalIncidentUrl",
    control: control,
    rules: {
      required: false
    },
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState
    }) => /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({}, field, {
      value: field.value || '',
      "data-test-subj": "investigateAppExternalIncidentFieldFieldText",
      fullWidth: true,
      isInvalid: fieldState.invalid,
      placeholder: I18N_LABEL
    }))
  }));
}