"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRCAContext = getRCAContext;
exports.sanitizeAlert = sanitizeAlert;
var _technical_rule_data_field_names = require("@kbn/rule-registry-plugin/common/technical_rule_data_field_names");
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function sanitizeAlert(alert) {
  return (0, _lodash.omit)(alert, _technical_rule_data_field_names.ALERT_RULE_EXECUTION_TIMESTAMP, '_index', _technical_rule_data_field_names.ALERT_FLAPPING_HISTORY, _technical_rule_data_field_names.EVENT_ACTION, _technical_rule_data_field_names.EVENT_KIND, _technical_rule_data_field_names.ALERT_RULE_EXECUTION_UUID, '@timestamp');
}
function getRCAContext(alert, serviceName) {
  return `The user is investigating an alert for the ${serviceName} service,
    and wants to find the root cause. Here is the alert:
  
    ${JSON.stringify(sanitizeAlert(alert))}`;
}