"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.extractEntityIndexPatternsFromDefinitions = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const extractEntityIndexPatternsFromDefinitions = entityDefinitionsSource => entityDefinitionsSource.reduce((acc, {
  ['type_id']: typeId,
  index_patterns: indexPatterns
}) => (acc[typeId] = (0, _lodash.compact)((0, _lodash.uniq)((0, _lodash.concat)(acc[typeId], indexPatterns))), acc), {});
exports.extractEntityIndexPatternsFromDefinitions = extractEntityIndexPatternsFromDefinitions;