"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.INVENTORY_SERVER_FEATURE = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _common = require("@kbn/features-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const INVENTORY_SERVER_FEATURE_ID = 'inventory';
const INVENTORY_SERVER_FEATURE = exports.INVENTORY_SERVER_FEATURE = {
  id: INVENTORY_SERVER_FEATURE_ID,
  name: _i18n.i18n.translate('xpack.inventory.featureRegistry.inventoryFeatureName', {
    defaultMessage: 'Inventory'
  }),
  order: 1000,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
  app: [INVENTORY_SERVER_FEATURE_ID],
  catalogue: [INVENTORY_SERVER_FEATURE_ID],
  alerting: [],
  // see x-pack/platform/plugins/shared/features/common/feature_kibana_privileges.ts
  privileges: {
    all: {
      app: [INVENTORY_SERVER_FEATURE_ID],
      api: [INVENTORY_SERVER_FEATURE_ID],
      catalogue: [INVENTORY_SERVER_FEATURE_ID],
      savedObject: {
        all: [],
        read: []
      },
      alerting: {
        alert: {
          all: []
        },
        rule: {
          all: []
        }
      },
      ui: ['show', 'save']
    },
    read: {
      app: [INVENTORY_SERVER_FEATURE_ID],
      api: [INVENTORY_SERVER_FEATURE_ID],
      catalogue: [INVENTORY_SERVER_FEATURE_ID],
      savedObject: {
        all: [],
        read: []
      },
      alerting: {
        alert: {
          read: []
        },
        rule: {
          read: []
        }
      },
      ui: ['show']
    }
  }
};