"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryPage = InventoryPage;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _useEffectOnce = _interopRequireDefault(require("react-use/lib/useEffectOnce"));
var _entities_summary = require("../../components/entities_summary");
var _entity_group_accordion = require("../../components/entity_group_accordion");
var _use_unified_search_context = require("../../hooks/use_unified_search_context");
var _group_by_selector = require("../../components/group_by_selector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InventoryPage() {
  const {
    refreshSubject$,
    value,
    refresh,
    loading
  } = (0, _use_unified_search_context.useUnifiedSearchContext)();
  (0, _useEffectOnce.default)(() => {
    const refreshSubscription = refreshSubject$.subscribe(refresh);
    return () => refreshSubscription.unsubscribe();
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_entities_summary.EntitiesSummary, {
    totalEntities: value === null || value === void 0 ? void 0 : value.totalEntities,
    totalGroups: value === null || value === void 0 ? void 0 : value.entityTypes.length
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_group_by_selector.GroupBySelector, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), value === null || value === void 0 ? void 0 : value.entityTypes.map(entityType => {
    return /*#__PURE__*/_react.default.createElement(_entity_group_accordion.EntityGroupAccordion, {
      key: `entity.type-${entityType.id}`,
      groupValue: entityType.id,
      groupLabel: entityType.display_name,
      groupCount: entityType.count,
      isLoading: loading
    });
  }));
}