"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnifiedSearchContext = exports.UnifiedSearchProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _rxjs = require("rxjs");
var _use_adhoc_data_view = require("./use_adhoc_data_view");
var _use_inventory_decoded_query_params = require("./use_inventory_decoded_query_params");
var _use_inventory_abortable_async = require("./use_inventory_abortable_async");
var _group_entity_types_by_status = require("../utils/group_entity_types_by_status");
var _use_kibana = require("./use_kibana");
var _use_inventory_params = require("./use_inventory_params");
var _use_fetch_entity_definition_index_patterns = require("./use_fetch_entity_definition_index_patterns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUnifiedSearch() {
  var _join, _definitionIndexPatte2;
  const {
    services: {
      inventoryAPIClient
    }
  } = (0, _use_kibana.useKibana)();
  const {
    query: {
      kuery
    }
  } = (0, _use_inventory_params.useInventoryParams)('/');
  const {
    entityTypes
  } = (0, _use_inventory_decoded_query_params.useInventoryDecodedQueryParams)();
  const {
    definitionIndexPatterns,
    isIndexPatternsLoading
  } = (0, _use_fetch_entity_definition_index_patterns.useFetchEntityDefinitionIndexPattern)();
  const [singleEntityType, setSingleEntityType] = (0, _react.useState)('');
  const {
    value,
    refresh,
    loading
  } = (0, _use_inventory_abortable_async.useInventoryAbortableAsync)(({
    signal
  }) => {
    const {
      entityTypesOff,
      entityTypesOn
    } = (0, _group_entity_types_by_status.groupEntityTypesByStatus)(entityTypes);
    return inventoryAPIClient.fetch('GET /internal/inventory/entities/types', {
      params: {
        query: {
          includeEntityTypes: entityTypesOn.length ? JSON.stringify(entityTypesOn) : undefined,
          excludeEntityTypes: entityTypesOff.length ? JSON.stringify(entityTypesOff) : undefined,
          kuery
        }
      },
      signal
    });
  }, [entityTypes, inventoryAPIClient, kuery]);
  const entityTypeIds = (0, _react.useMemo)(() => {
    var _value$entityTypes$ma;
    return (_value$entityTypes$ma = value === null || value === void 0 ? void 0 : value.entityTypes.map(entityType => entityType.id)) !== null && _value$entityTypes$ma !== void 0 ? _value$entityTypes$ma : [];
  }, [value === null || value === void 0 ? void 0 : value.entityTypes]);
  const allDefinitionIndexPatterns = (0, _react.useMemo)(() => {
    const filteredDefinitionIndexPatterns = entityTypeIds.flatMap(id => {
      var _definitionIndexPatte;
      return (_definitionIndexPatte = definitionIndexPatterns === null || definitionIndexPatterns === void 0 ? void 0 : definitionIndexPatterns[id]) !== null && _definitionIndexPatte !== void 0 ? _definitionIndexPatte : [];
    });
    return Array.from(new Set(filteredDefinitionIndexPatterns)).join(',');
  }, [definitionIndexPatterns, entityTypeIds]);
  const {
    dataView
  } = (0, _use_adhoc_data_view.useAdHocDataView)(allDefinitionIndexPatterns !== null && allDefinitionIndexPatterns !== void 0 ? allDefinitionIndexPatterns : '');
  const discoverDataview = (0, _use_adhoc_data_view.useAdHocDataView)((_join = ((_definitionIndexPatte2 = definitionIndexPatterns[singleEntityType !== null && singleEntityType !== void 0 ? singleEntityType : '']) !== null && _definitionIndexPatte2 !== void 0 ? _definitionIndexPatte2 : []).join(',')) !== null && _join !== void 0 ? _join : '');
  const [refreshSubject$] = (0, _react.useState)(new _rxjs.Subject());
  return {
    dataView,
    definitionIndexPatterns,
    refreshSubject$,
    loading: loading || isIndexPatternsLoading,
    refresh,
    value,
    discoverDataview,
    setSingleEntityType
  };
}
const UnifiedSearch = (0, _constate.default)(useUnifiedSearch);
const [UnifiedSearchProvider, useUnifiedSearchContext] = UnifiedSearch;
exports.useUnifiedSearchContext = useUnifiedSearchContext;
exports.UnifiedSearchProvider = UnifiedSearchProvider;