"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchEntityDefinitionIndexPattern = void 0;
var _use_inventory_abortable_async = require("./use_inventory_abortable_async");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchEntityDefinitionIndexPattern = () => {
  const {
    services: {
      inventoryAPIClient
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value = {
      definitionIndexPatterns: {}
    },
    loading
  } = (0, _use_inventory_abortable_async.useInventoryAbortableAsync)(({
    signal
  }) => {
    return inventoryAPIClient.fetch('GET /internal/inventory/entity/definitions/sources', {
      signal
    });
  }, [inventoryAPIClient]);
  return {
    definitionIndexPatterns: value === null || value === void 0 ? void 0 : value.definitionIndexPatterns,
    isIndexPatternsLoading: loading
  };
};
exports.useFetchEntityDefinitionIndexPattern = useFetchEntityDefinitionIndexPattern;