"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchEntityDefinition = void 0;
var _use_abortable_async = require("@kbn/observability-utils-browser/hooks/use_abortable_async");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchEntityDefinition = id => {
  const {
    services: {
      entityManager
    }
  } = (0, _use_kibana.useKibana)();
  const {
    value,
    loading
  } = (0, _use_abortable_async.useAbortableAsync)(({
    signal
  }) => {
    return entityManager.entityClient.getEntityDefinition(id);
  }, [entityManager.entityClient, id]);
  return {
    entityDefinitions: value === null || value === void 0 ? void 0 : value.definitions,
    isEntityDefinitionLoading: loading
  };
};
exports.useFetchEntityDefinition = useFetchEntityDefinition;