"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAdHocDataView = useAdHocDataView;
var _i18n = require("@kbn/i18n");
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useAdHocDataView(title) {
  const {
    services: {
      dataViews,
      notifications
    }
  } = (0, _use_kibana.useKibana)();
  const [dataView, setDataView] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    async function fetchDataView() {
      try {
        const displayError = false;
        return await dataViews.create({
          title
        }, undefined, displayError);
      } catch (e) {
        const noDataScreen = e.message.includes('No matching indices found');
        if (noDataScreen) {
          return;
        }
        notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.inventory.data_view.creation_failed', {
            defaultMessage: 'An error occurred while creating the data view'
          }),
          text: e.message
        });
        throw e;
      }
    }
    fetchDataView().then(setDataView);
  }, [dataViews, title, notifications.toasts]);
  return {
    dataView
  };
}