"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = SearchBar;
var _i18n = require("@kbn/i18n");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = _interopRequireWildcard(require("react"));
var _use_inventory_params = require("../../hooks/use_inventory_params");
var _use_inventory_router = require("../../hooks/use_inventory_router");
var _use_kibana = require("../../hooks/use_kibana");
var _use_unified_search_context = require("../../hooks/use_unified_search_context");
var _get_kql_field_names_with_fallback = require("../../utils/get_kql_field_names_with_fallback");
var _entity_types_multi_select = require("./entity_types_multi_select");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SearchBar() {
  const {
    refreshSubject$,
    dataView
  } = (0, _use_unified_search_context.useUnifiedSearchContext)();
  const inventoryRoute = (0, _use_inventory_router.useInventoryRouter)();
  const {
    query,
    query: {
      kuery
    }
  } = (0, _use_inventory_params.useInventoryParams)('/*');
  const {
    services: {
      unifiedSearch,
      telemetry,
      data: {
        query: {
          queryString: queryStringService
        }
      }
    }
  } = (0, _use_kibana.useKibana)();
  const {
    SearchBar: UnifiedSearchBar
  } = unifiedSearch.ui;
  const syncSearchBarWithUrl = (0, _react.useCallback)(() => {
    const _query = kuery ? {
      query: kuery,
      language: 'kuery'
    } : undefined;
    if (_query && !(0, _fastDeepEqual.default)(queryStringService.getQuery(), _query)) {
      queryStringService.setQuery(_query);
    }
    if (!_query) {
      queryStringService.clearQuery();
    }
  }, [kuery, queryStringService]);
  (0, _react.useEffect)(() => {
    syncSearchBarWithUrl();
  }, [syncSearchBarWithUrl]);
  const handleQuerySubmit = (0, _react.useCallback)(({
    query: _query = {
      language: 'kuery',
      query: ''
    }
  }, isUpdate) => {
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        kuery: _query === null || _query === void 0 ? void 0 : _query.query
      }
    });
    if (!isUpdate) {
      refreshSubject$.next();
    }
    telemetry.reportEntityInventorySearchQuerySubmitted({
      kuery_fields: (0, _get_kql_field_names_with_fallback.getKqlFieldsWithFallback)(_query === null || _query === void 0 ? void 0 : _query.query),
      action: isUpdate ? 'submit' : 'refresh'
    });
  }, [inventoryRoute, query, telemetry, refreshSubject$]);
  return /*#__PURE__*/_react.default.createElement(UnifiedSearchBar, {
    appName: "Inventory",
    displayStyle: "inPage",
    indexPatterns: dataView ? [dataView] : undefined,
    renderQueryInputAppend: () => /*#__PURE__*/_react.default.createElement(_entity_types_multi_select.EntityTypesMultiSelect, null),
    onQuerySubmit: handleQuerySubmit,
    placeholder: _i18n.i18n.translate('xpack.inventory.searchBar.placeholder', {
      defaultMessage: 'Search for your entities by name or its metadata (e.g. entity.type : service)'
    }),
    showDatePicker: false,
    showFilterBar: false
  });
}