"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityTypesMultiSelect = EntityTypesMultiSelect;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _rt_types = require("../../../common/rt_types");
var _use_inventory_abortable_async = require("../../hooks/use_inventory_abortable_async");
var _use_inventory_decoded_query_params = require("../../hooks/use_inventory_decoded_query_params");
var _use_inventory_params = require("../../hooks/use_inventory_params");
var _use_inventory_router = require("../../hooks/use_inventory_router");
var _use_kibana = require("../../hooks/use_kibana");
var _group_entity_types_by_status = require("../../utils/group_entity_types_by_status");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EntityTypesMultiSelect() {
  const inventoryRoute = (0, _use_inventory_router.useInventoryRouter)();
  const {
    query
  } = (0, _use_inventory_params.useInventoryParams)('/*');
  const {
    entityTypes: selectedEntityTypes
  } = (0, _use_inventory_decoded_query_params.useInventoryDecodedQueryParams)();
  const {
    services: {
      inventoryAPIClient,
      telemetry
    }
  } = (0, _use_kibana.useKibana)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const {
    value,
    loading
  } = (0, _use_inventory_abortable_async.useInventoryAbortableAsync)(({
    signal
  }) => inventoryAPIClient.fetch('GET /internal/inventory/entities/types', {
    signal
  }), [inventoryAPIClient]);
  const items = (0, _react.useMemo)(() => (value === null || value === void 0 ? void 0 : value.entityTypes.map(type => {
    const checked = selectedEntityTypes === null || selectedEntityTypes === void 0 ? void 0 : selectedEntityTypes[type.id];
    return {
      label: type.display_name,
      key: type.id,
      checked,
      'data-test-subj': `entityTypes_multiSelect_filter_selection_${type.id}`
    };
  })) || [], [selectedEntityTypes, value === null || value === void 0 ? void 0 : value.entityTypes]);
  const registerEntityTypeFilteredEvent = (0, _react.useCallback)(({
    filterEntityTypes
  }) => {
    const {
      entityTypesOff,
      entityTypesOn
    } = (0, _group_entity_types_by_status.groupEntityTypesByStatus)(filterEntityTypes);
    telemetry.reportEntityInventoryEntityTypeFiltered({
      include_entity_types: entityTypesOn,
      exclude_entity_types: entityTypesOff
    });
  }, [telemetry]);
  function handleEntityTypeChecked(nextItems) {
    registerEntityTypeFilteredEvent({
      filterEntityTypes: nextItems
    });
    inventoryRoute.push('/', {
      path: {},
      query: {
        ...query,
        entityTypes: _rt_types.entityTypesRt.encode(nextItems)
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "entityTypeMultiSelector",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
      "data-test-subj": "entityTypes_multiSelect_filter",
      iconType: "arrowDown",
      badgeColor: "success",
      onClick: () => setIsPopoverOpen(state => !state),
      isSelected: isPopoverOpen,
      numFilters: items.filter(item => item.checked !== 'off').length,
      hasActiveFilters: !!items.find(item => item.checked === 'on'),
      numActiveFilters: items.filter(item => item.checked === 'on').length
    }, _i18n.i18n.translate('xpack.inventory.entityTypesMultiSelect.typeFilterButtonLabel', {
      defaultMessage: 'Type'
    })),
    isOpen: isPopoverOpen,
    closePopover: () => setIsPopoverOpen(false),
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    allowExclusions: true,
    searchable: true,
    searchProps: {
      placeholder: _i18n.i18n.translate('xpack.inventory.entityTypesMultiSelect.euiSelectable.placeholder', {
        defaultMessage: 'Filter types'
      }),
      compressed: true
    },
    "aria-label": _i18n.i18n.translate('xpack.inventory.entityTypesMultiSelect.euiSelectable.typeLabel', {
      defaultMessage: 'Entity type'
    }),
    options: items,
    onChange: newOptions => {
      handleEntityTypeChecked(newOptions.filter(item => item.checked).reduce((acc, curr) => {
        acc[curr.key] = curr.checked;
        return acc;
      }, {}));
    },
    isLoading: loading,
    loadingMessage: _i18n.i18n.translate('xpack.inventory.entityTypesMultiSelect.euiSelectable.loading', {
      defaultMessage: 'Loading types'
    }),
    emptyMessage: _i18n.i18n.translate('xpack.inventory.entityTypesMultiSelect.euiSelectable.empty', {
      defaultMessage: 'No types available'
    }),
    noMatchesMessage: _i18n.i18n.translate('xpack.inventory.entityTypesMultiSelect.euiSelectable.notFound', {
      defaultMessage: 'No types found'
    })
  }, (list, search) => /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: 300
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, {
    paddingSize: "s"
  }, search), list))));
}