"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryPageTemplate = InventoryPageTemplate;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_kibana = require("../../hooks/use_kibana");
var _search_bar = require("../search_bar");
var _use_inventory_abortable_async = require("../../hooks/use_inventory_abortable_async");
var _empty_state = require("../empty_states/empty_state");
var _use_is_loading_complete = require("../../hooks/use_is_loading_complete");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageTitle = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  gutterSize: "s"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, _i18n.i18n.translate('xpack.inventory.inventoryPageHeaderLabel', {
  defaultMessage: 'Inventory'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_public.TechnicalPreviewBadge, null)));
const INVENTORY_FEEDBACK_LINK = 'https://ela.st/feedback-new-inventory';
function InventoryPageTemplate({
  children
}) {
  const {
    services: {
      observabilityShared,
      inventoryAPIClient,
      kibanaEnvironment,
      telemetry
    }
  } = (0, _use_kibana.useKibana)();
  const {
    PageTemplate: ObservabilityPageTemplate
  } = observabilityShared.navigation;
  const {
    value = {
      hasData: false
    },
    loading: hasDataLoading
  } = (0, _use_inventory_abortable_async.useInventoryAbortableAsync)(({
    signal
  }) => {
    return inventoryAPIClient.fetch('GET /internal/inventory/has_data', {
      signal
    });
  }, [inventoryAPIClient]);
  const isLoadingComplete = (0, _use_is_loading_complete.useIsLoadingComplete)({
    loadingStates: [hasDataLoading]
  });
  (0, _react.useEffect)(() => {
    if (isLoadingComplete) {
      const viewState = value.hasData ? 'populated' : 'empty';
      telemetry.reportEntityInventoryViewed({
        view_state: viewState
      });
    }
  }, [value.hasData, telemetry, isLoadingComplete]);
  if (hasDataLoading) {
    return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
      pageHeader: {
        pageTitle
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
        logo: "logoObservability",
        size: "xl"
      })
    }));
  }
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageHeader: {
      pageTitle,
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
        "data-test-subj": "inventoryFeedbackButton",
        formUrl: INVENTORY_FEEDBACK_LINK,
        kibanaVersion: kibanaEnvironment.kibanaVersion,
        isCloudEnv: kibanaEnvironment.isCloudEnv,
        isServerlessEnv: kibanaEnvironment.isServerlessEnv
      })]
    }
  }, value.hasData ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, children)) : /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, null));
}