"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InventoryComponentWrapperMock = InventoryComponentWrapperMock;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _history = require("history");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _get_mock_inventory_context = require("../../../../.storybook/get_mock_inventory_context");
var _config = require("../../../routes/config");
var _inventory_context_provider = require("../../../context/inventory_context_provider");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function InventoryComponentWrapperMock({
  children
}) {
  const context = (0, _get_mock_inventory_context.getMockInventoryContext)();
  const KibanaReactContext = (0, _public.createKibanaReactContext)(context);
  const history = (0, _history.createMemoryHistory)({
    initialEntries: ['/']
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, null, /*#__PURE__*/_react.default.createElement(KibanaReactContext.Provider, null, /*#__PURE__*/_react.default.createElement(_inventory_context_provider.InventoryContextProvider, {
    context: (0, _get_mock_inventory_context.getMockInventoryContext)()
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    router: _config.inventoryRouter,
    history: history
  }, children)))));
}