"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntityName = EntityName;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../hooks/use_kibana");
var _entity_icon = require("../../entity_icon");
var _use_detail_view_redirect = require("../../../hooks/use_detail_view_redirect");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EntityName({
  entity
}) {
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibana)();
  const {
    getEntityRedirectUrl
  } = (0, _use_detail_view_redirect.useDetailViewRedirect)();
  const href = getEntityRedirectUrl(entity);
  const handleLinkClick = (0, _react.useCallback)(() => {
    telemetry.reportEntityViewClicked({
      view_type: 'detail',
      entity_type: entity.entityType
    });
  }, [entity, telemetry]);
  const entityName = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 0
  }, /*#__PURE__*/_react.default.createElement(_entity_icon.EntityIcon, {
    entity: entity
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate",
    "data-test-subj": "entityNameDisplayName"
  }, entity.entityDisplayName)));
  return href ?
  /*#__PURE__*/
  // eslint-disable-next-line @elastic/eui/href-or-on-click
  _react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "entityNameLink",
    href: href,
    onClick: handleLinkClick
  }, entityName) : entityName;
}