"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppRoot = AppRoot;
exports.InventoryHeaderActionMenu = InventoryHeaderActionMenu;
var _eui = require("@elastic/eui");
var _public = require("@kbn/observability-shared-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _typedReactRouterConfig = require("@kbn/typed-react-router-config");
var _react = _interopRequireDefault(require("react"));
var _inventory_context_provider = require("../../context/inventory_context_provider");
var _use_unified_search_context = require("../../hooks/use_unified_search_context");
var _config = require("../../routes/config");
var _header_action_menu = require("./header_action_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AppRoot({
  coreStart,
  pluginsStart,
  services,
  appMountParameters,
  kibanaEnvironment
}) {
  const {
    history
  } = appMountParameters;
  const context = {
    ...coreStart,
    ...pluginsStart,
    ...services,
    kibanaEnvironment
  };
  return /*#__PURE__*/_react.default.createElement(_inventory_context_provider.InventoryContextProvider, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: coreStart
  }, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouterProvider, {
    history: history,
    router: _config.inventoryRouter
  }, /*#__PURE__*/_react.default.createElement(_use_unified_search_context.UnifiedSearchProvider, null, /*#__PURE__*/_react.default.createElement(_typedReactRouterConfig.RouteRenderer, null), /*#__PURE__*/_react.default.createElement(InventoryHeaderActionMenu, {
    appMountParameters: appMountParameters
  })))));
}
function InventoryHeaderActionMenu({
  appMountParameters
}) {
  const {
    setHeaderActionMenu,
    theme$
  } = appMountParameters;
  return /*#__PURE__*/_react.default.createElement(_public.HeaderMenuPortal, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_header_action_menu.HeaderActionMenuItems, null))));
}