"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityTypesRt = exports.entityPaginationRt = void 0;
var _rison = require("@kbn/rison");
var _Either = require("fp-ts/lib/Either");
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validate = validationRt => (input, context) => {
  switch (typeof input) {
    case 'string':
      {
        try {
          const decoded = (0, _rison.decode)(input);
          const validation = validationRt.decode(decoded);
          if ((0, _Either.isRight)(validation)) {
            return t.success(validation.right);
          }
          return t.failure(input, context);
        } catch (e) {
          return t.failure(input, context);
        }
      }
    case 'undefined':
      return t.success(input);
    default:
      {
        const validation = validationRt.decode(input);
        if ((0, _Either.isRight)(validation)) {
          return t.success(validation.right);
        }
        return t.failure(input, context);
      }
  }
};
const entityTypeCheckOptions = t.union([t.literal('on'), t.literal('off'), t.literal('mixed')]);
const entityTypeRt = t.record(t.string, entityTypeCheckOptions);
const entityTypesRt = exports.entityTypesRt = new t.Type('entityTypesRt', entityTypeRt.is, validate(entityTypeRt), o => (0, _rison.encode)(o));
const paginationRt = t.record(t.string, t.number);
const entityPaginationRt = exports.entityPaginationRt = new t.Type('entityPaginationRt', paginationRt.is, validate(paginationRt), o => (0, _rison.encode)(o));