"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InspectorPublicPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var React = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _view_registry = require("./view_registry");
var _inspector_panel = require("./ui/inspector_panel");
var _views = require("./views");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class InspectorPublicPlugin {
  constructor(_initializerContext) {
    (0, _defineProperty2.default)(this, "views", void 0);
  }
  setup(_core) {
    this.views = new _view_registry.InspectorViewRegistry();
    this.views.register((0, _views.getRequestsViewDescription)());
    return {
      registerView: this.views.register.bind(this.views),
      __LEGACY: {
        views: this.views
      }
    };
  }
  start(core, startDeps) {
    const isAvailable = adapters => this.views.getVisible(adapters).length > 0;
    const closeButtonLabel = _i18n.i18n.translate('inspector.closeButton', {
      defaultMessage: 'Close Inspector'
    });
    const open = (adapters, options = {}) => {
      const views = this.views.getVisible(adapters);

      // Don't open inspector if there are no views available for the passed adapters
      if (!views || views.length === 0) {
        throw new Error(`Tried to open an inspector without views being available.
          Make sure to call Inspector.isAvailable() with the same adapters before to check
          if an inspector can be shown.`);
      }
      return core.overlays.openFlyout((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/React.createElement(_inspector_panel.InspectorPanel, {
        views: views,
        adapters: adapters,
        title: options.title,
        options: options.options,
        dependencies: {
          application: core.application,
          http: core.http,
          uiSettings: core.uiSettings,
          share: startDeps.share,
          settings: core.settings,
          theme: core.theme
        }
      }), core), {
        'data-test-subj': 'inspectorPanel',
        closeButtonProps: {
          'aria-label': closeButtonLabel
        },
        type: options.flyoutType
      });
    };
    return {
      isAvailable,
      open
    };
  }
  stop() {}
}
exports.InspectorPublicPlugin = InspectorPublicPlugin;