"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.documentationService = exports.DocumentationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DocumentationService {
  constructor() {
    (0, _defineProperty2.default)(this, "esDocBasePath", '');
    (0, _defineProperty2.default)(this, "ingestNodeUrl", '');
    (0, _defineProperty2.default)(this, "processorsUrl", '');
    (0, _defineProperty2.default)(this, "handlingFailureUrl", '');
    (0, _defineProperty2.default)(this, "createPipelineUrl", '');
    (0, _defineProperty2.default)(this, "createPipelineCSVUrl", '');
    (0, _defineProperty2.default)(this, "simulatePipelineApiUrl", '');
    (0, _defineProperty2.default)(this, "enrichDataUrl", '');
    (0, _defineProperty2.default)(this, "geoMatchUrl", '');
    (0, _defineProperty2.default)(this, "dissectKeyModifiersUrl", '');
    (0, _defineProperty2.default)(this, "classificationUrl", '');
    (0, _defineProperty2.default)(this, "regressionUrl", '');
    (0, _defineProperty2.default)(this, "documentationUrl", '');
  }
  setup(docLinks) {
    const {
      DOC_LINK_VERSION,
      ELASTIC_WEBSITE_URL,
      links
    } = docLinks;
    const docsBase = `${ELASTIC_WEBSITE_URL}guide/en`;
    this.esDocBasePath = `${docsBase}/elasticsearch/reference/${DOC_LINK_VERSION}`;
    this.ingestNodeUrl = links.ingest.pipelines;
    this.processorsUrl = links.ingest.processors;
    this.handlingFailureUrl = links.ingest.pipelineFailure;
    this.createPipelineUrl = links.ingest.pipelines;
    this.createPipelineCSVUrl = links.ingest.csvPipelines;
    this.simulatePipelineApiUrl = links.apis.simulatePipeline;
    this.enrichDataUrl = links.ingest.enrich;
    this.geoMatchUrl = links.ingest.geoMatch;
    this.dissectKeyModifiersUrl = links.ingest.dissectKeyModifiers;
    this.classificationUrl = links.ingest.inferenceClassification;
    this.regressionUrl = links.ingest.inferenceRegression;
    this.documentationUrl = links.ingest.inference;
  }
  getEsDocsBasePath() {
    return this.esDocBasePath;
  }
  getIngestNodeUrl() {
    return this.ingestNodeUrl;
  }
  getProcessorsUrl() {
    return this.processorsUrl;
  }
  getHandlingFailureUrl() {
    return this.handlingFailureUrl;
  }
  getCreatePipelineUrl() {
    return this.createPipelineUrl;
  }
  getCreatePipelineCSVUrl() {
    return this.createPipelineCSVUrl;
  }
  getSimulatePipelineApiUrl() {
    return this.simulatePipelineApiUrl;
  }
  getEnrichDataUrl() {
    return this.enrichDataUrl;
  }
  getGeoMatchUrl() {
    return this.geoMatchUrl;
  }
  getDissectKeyModifiersUrl() {
    return this.dissectKeyModifiersUrl;
  }
  getClassificationUrl() {
    return this.classificationUrl;
  }
  getRegressionUrl() {
    return this.regressionUrl;
  }
  getDocumentationUrl() {
    return this.documentationUrl;
  }
}
exports.DocumentationService = DocumentationService;
const documentationService = exports.documentationService = new DocumentationService();