"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("../../../shared_imports");
var _details_flyout = require("./details_flyout");
var _not_found_flyout = require("./not_found_flyout");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineFlyout = ({
  pipeline,
  onClose,
  onEditClick,
  onCloneClick,
  onDeleteClick
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const pipelineName = pipeline && typeof pipeline === 'string' ? pipeline : '';
  const {
    data,
    isLoading,
    error
  } = services.api.useLoadPipeline(pipelineName);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isLoading && /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.list.pipelineDetails.loading",
    defaultMessage: "Loading pipeline\u2026"
  })), error && /*#__PURE__*/_react.default.createElement(_not_found_flyout.PipelineNotFoundFlyout, {
    pipelineName: pipelineName,
    onClose: onClose,
    error: error
  }), data && /*#__PURE__*/_react.default.createElement(_details_flyout.PipelineDetailsFlyout, {
    pipeline: data,
    onClose: onClose,
    onEditClick: onEditClick,
    onCloneClick: onCloneClick,
    onDeleteClick: onDeleteClick
  }));
};
exports.PipelineFlyout = PipelineFlyout;