"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mountManagementSection = mountManagementSection;
var _services = require("./services");
var _ = require(".");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function mountManagementSection({
  http,
  getStartServices,
  notifications
}, params) {
  const {
    element,
    setBreadcrumbs,
    history,
    license,
    config
  } = params;
  const [coreStart, depsStart] = await getStartServices();
  const {
    docLinks,
    application,
    executionContext,
    overlays
  } = coreStart;
  _services.documentationService.setup(docLinks);
  _services.breadcrumbService.setup(setBreadcrumbs);
  const services = {
    breadcrumbs: _services.breadcrumbService,
    metric: _services.uiMetricService,
    documentation: _services.documentationService,
    api: _services.apiService,
    fileReader: _services.fileReaderService,
    notifications,
    history,
    uiSettings: coreStart.uiSettings,
    settings: coreStart.settings,
    share: depsStart.share,
    fileUpload: depsStart.fileUpload,
    application,
    executionContext,
    license,
    consolePlugin: depsStart.console,
    overlays,
    http,
    config
  };
  return (0, _.renderApp)(element, services, {
    ...coreStart,
    http
  });
}