"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDocumentsAccordion = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../../shared_imports");
var _use_is_mounted = require("../../../../../use_is_mounted");
var _add_document_form = require("../add_document_form");
require("./add_docs_accordion.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  addDocumentsButton: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocumentsAccordion.addDocumentsButtonLabel', {
    defaultMessage: 'Add a test document from an index'
  }),
  addDocumentsDescription: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.addDocumentsAccordion.contentDescriptionText', {
    defaultMessage: `Provide the document's index and document ID.`
  })
};
const AddDocumentsAccordion = ({
  onAddDocuments
}) => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const isMounted = (0, _use_is_mounted.useIsMounted)();
  const [discoverLink, setDiscoverLink] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const getDiscoverUrl = async () => {
      var _services$share;
      const locator = (_services$share = services.share) === null || _services$share === void 0 ? void 0 : _services$share.url.locators.get('DISCOVER_APP_LOCATOR');
      if (!locator) {
        setDiscoverLink(undefined);
        return;
      }
      const discoverUrl = await locator.getUrl({
        indexPatternId: undefined
      });
      if (!isMounted.current) return;
      setDiscoverLink(discoverUrl);
    };
    getDiscoverUrl();
  }, [isMounted, services.share]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "addDocumentsAccordion",
    buttonContent: i18nTexts.addDocumentsButton,
    paddingSize: "s",
    "data-test-subj": "addDocumentsAccordion"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "addDocumentsAccordion"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18nTexts.addDocumentsDescription, discoverLink && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.pipelineEditor.addDocumentsAccordion.discoverLinkDescriptionText",
    defaultMessage: "To explore your existing data, use {discoverLink}.",
    values: {
      discoverLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: discoverLink,
        target: "_blank",
        external: true
      }, "Discover")
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_add_document_form.AddDocumentForm, {
    onAddDocuments: onAddDocuments
  })));
};
exports.AddDocumentsAccordion = AddDocumentsAccordion;