/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.infra_bundle_jsonpfunction=self.infra_bundle_jsonpfunction||[]).push([[729],{7434:(e,t,s)=>{s.d(t,{s:()=>r});var a=s(5008);const r=e=>{const t={avg:a.i18n.translate("xpack.infra.waffle.aggregationNames.avg",{defaultMessage:"Avg of {field}",values:{field:e.field}}),max:a.i18n.translate("xpack.infra.waffle.aggregationNames.max",{defaultMessage:"Max of {field}",values:{field:e.field}}),min:a.i18n.translate("xpack.infra.waffle.aggregationNames.min",{defaultMessage:"Min of {field}",values:{field:e.field}}),rate:a.i18n.translate("xpack.infra.waffle.aggregationNames.rate",{defaultMessage:"Rate of {field}",values:{field:e.field}})};return e.label?e.label:t[e.aggregation]}},6984:(e,t,s)=>{s.d(t,{o:()=>l,x:()=>u});var a=s(8919);let r=function(e){return e.bytesDecimal="bytesDecimal",e.bitsDecimal="bitsDecimal",e.abbreviatedNumber="abbreviatedNumber",e}({});const i={[r.bytesDecimal]:["B","kB","MB","GB","TB","PB","EB","ZB","YB"],[r.bitsDecimal]:["bit","kbit","Mbit","Gbit","Tbit","Pbit","Ebit","Zbit","Ybit"],[r.abbreviatedNumber]:["","K","M","B","T"]},o={[r.bytesDecimal]:1e3,[r.bitsDecimal]:1e3,[r.abbreviatedNumber]:1e3},n=e=>t=>{const s=i[e],n=o[e],l=e===r.bitsDecimal?8*t:t,u=Math.min(Math.floor(Math.log(Math.abs(l))/Math.log(n)),s.length-1);return u<0?`${(0,a.Z)(l)} ${s[0]}`:`${(0,a.Z)(l/Math.pow(n,u))} ${s[u]}`},l={number:a.Z,abbreviatedNumber:n(r.abbreviatedNumber),bytes:n(r.bytesDecimal),bits:n(r.bitsDecimal),percent:e=>`${(0,a.Z)(100*e)}%`,highPrecision:e=>Number(e).toLocaleString("en",{maximumFractionDigits:5})},u=(e,t="{{value}}")=>s=>{if(null==s)return"";const a=(0,l[e])(Number(s));return t.replace(/{{value}}/g,a)}},3038:(e,t,s)=>{s.d(t,{t:()=>l});var a=s(5008),r=s(770);const i={CPUUsageTotal:a.i18n.translate("xpack.infra.waffle.metricOptions.cpuUsageTotalText",{defaultMessage:"CPU usage"}),CPUUsageLegacy:a.i18n.translate("xpack.infra.waffle.metricOptions.cpuUsageLegacyText",{defaultMessage:"CPU usage (Legacy)"}),MemoryUsage:a.i18n.translate("xpack.infra.waffle.metricOptions.memoryUsageText",{defaultMessage:"memory usage"}),InboundTraffic:a.i18n.translate("xpack.infra.waffle.metricOptions.inboundTrafficText",{defaultMessage:"inbound traffic"}),OutboundTraffic:a.i18n.translate("xpack.infra.waffle.metricOptions.outboundTrafficText",{defaultMessage:"outbound traffic"}),InboundTrafficLegacy:a.i18n.translate("xpack.infra.waffle.metricOptions.inboundTrafficText",{defaultMessage:"inbound traffic (Legacy)"}),OutboundTrafficLegacy:a.i18n.translate("xpack.infra.waffle.metricOptions.outboundTrafficText",{defaultMessage:"outbound traffic (Legacy)"}),LogRate:a.i18n.translate("xpack.infra.waffle.metricOptions.hostLogRateText",{defaultMessage:"log rate"}),Load:a.i18n.translate("xpack.infra.waffle.metricOptions.loadText",{defaultMessage:"load"}),Count:a.i18n.translate("xpack.infra.waffle.metricOptions.countText",{defaultMessage:"count"}),DiskIOReadBytes:a.i18n.translate("xpack.infra.waffle.metricOptions.diskIOReadBytes",{defaultMessage:"disk reads"}),DiskIOWriteBytes:a.i18n.translate("xpack.infra.waffle.metricOptions.diskIOWriteBytes",{defaultMessage:"disk writes"}),s3BucketSize:a.i18n.translate("xpack.infra.waffle.metricOptions.s3BucketSize",{defaultMessage:"bucket size"}),s3TotalRequests:a.i18n.translate("xpack.infra.waffle.metricOptions.s3TotalRequests",{defaultMessage:"total requests"}),s3NumberOfObjects:a.i18n.translate("xpack.infra.waffle.metricOptions.s3NumberOfObjects",{defaultMessage:"number of objects"}),s3DownloadBytes:a.i18n.translate("xpack.infra.waffle.metricOptions.s3DownloadBytes",{defaultMessage:"downloads (bytes)"}),s3UploadBytes:a.i18n.translate("xpack.infra.waffle.metricOptions.s3UploadBytes",{defaultMessage:"uploads (bytes)"}),rdsConnections:a.i18n.translate("xpack.infra.waffle.metricOptions.rdsConnections",{defaultMessage:"connections"}),rdsQueriesExecuted:a.i18n.translate("xpack.infra.waffle.metricOptions.rdsQueriesExecuted",{defaultMessage:"queries executed"}),rdsActiveTransactions:a.i18n.translate("xpack.infra.waffle.metricOptions.rdsActiveTransactions",{defaultMessage:"active transactions"}),rdsLatency:a.i18n.translate("xpack.infra.waffle.metricOptions.rdsLatency",{defaultMessage:"latency"}),sqsMessagesVisible:a.i18n.translate("xpack.infra.waffle.metricOptions.sqsMessagesVisible",{defaultMessage:"messages available"}),sqsMessagesDelayed:a.i18n.translate("xpack.infra.waffle.metricOptions.sqsMessagesDelayed",{defaultMessage:"messages delayed"}),sqsMessagesSent:a.i18n.translate("xpack.infra.waffle.metricOptions.sqsMessagesSent",{defaultMessage:"messages added"}),sqsMessagesEmpty:a.i18n.translate("xpack.infra.waffle.metricOptions.sqsMessagesEmpty",{defaultMessage:"messages returned empty"}),sqsOldestMessage:a.i18n.translate("xpack.infra.waffle.metricOptions.sqsOldestMessage",{defaultMessage:"oldest message"})},o=(0,r.mapValues)(i,(e=>`${e[0].toUpperCase()}${e.slice(1)}`)),n=e=>"host"===e,l=(e,t)=>{switch(e){case"cpuV2":return{text:o.CPUUsageTotal,textLC:i.CPUUsageTotal,value:"cpuV2"};case"cpu":return{text:n(t)?o.CPUUsageLegacy:o.CPUUsageTotal,textLC:n(t)?i.CPUUsageLegacy:i.CPUUsageTotal,value:"cpu"};case"memory":return{text:o.MemoryUsage,textLC:i.MemoryUsage,value:"memory"};case"rx":return{text:n(t)?o.InboundTrafficLegacy:o.InboundTraffic,textLC:n(t)?i.InboundTrafficLegacy:i.InboundTraffic,value:"rx"};case"tx":return{text:n(t)?o.OutboundTrafficLegacy:o.OutboundTraffic,textLC:n(t)?i.OutboundTrafficLegacy:i.OutboundTraffic,value:"tx"};case"rxV2":return{text:o.InboundTraffic,textLC:i.InboundTraffic,value:"rxV2"};case"txV2":return{text:o.OutboundTraffic,textLC:i.OutboundTraffic,value:"txV2"};case"logRate":return{text:o.LogRate,textLC:i.LogRate,value:"logRate"};case"load":return{text:o.Load,textLC:i.Load,value:"load"};case"count":return{text:o.Count,textLC:i.Count,value:"count"};case"diskIOReadBytes":return{text:o.DiskIOReadBytes,textLC:i.DiskIOReadBytes,value:"diskIOReadBytes"};case"diskIOWriteBytes":return{text:o.DiskIOWriteBytes,textLC:i.DiskIOWriteBytes,value:"diskIOWriteBytes"};case"s3BucketSize":return{text:o.s3BucketSize,textLC:i.s3BucketSize,value:"s3BucketSize"};case"s3TotalRequests":return{text:o.s3TotalRequests,textLC:i.s3TotalRequests,value:"s3TotalRequests"};case"s3NumberOfObjects":return{text:o.s3NumberOfObjects,textLC:i.s3NumberOfObjects,value:"s3NumberOfObjects"};case"s3DownloadBytes":return{text:o.s3DownloadBytes,textLC:i.s3DownloadBytes,value:"s3DownloadBytes"};case"s3UploadBytes":return{text:o.s3UploadBytes,textLC:i.s3UploadBytes,value:"s3UploadBytes"};case"rdsConnections":return{text:o.rdsConnections,textLC:i.rdsConnections,value:"rdsConnections"};case"rdsQueriesExecuted":return{text:o.rdsQueriesExecuted,textLC:i.rdsQueriesExecuted,value:"rdsQueriesExecuted"};case"rdsActiveTransactions":return{text:o.rdsActiveTransactions,textLC:i.rdsActiveTransactions,value:"rdsActiveTransactions"};case"rdsLatency":return{text:o.rdsLatency,textLC:i.rdsLatency,value:"rdsLatency"};case"sqsMessagesVisible":return{text:o.sqsMessagesVisible,textLC:i.sqsMessagesVisible,value:"sqsMessagesVisible"};case"sqsMessagesDelayed":return{text:o.sqsMessagesDelayed,textLC:i.sqsMessagesDelayed,value:"sqsMessagesDelayed"};case"sqsMessagesSent":return{text:o.sqsMessagesSent,textLC:i.sqsMessagesSent,value:"sqsMessagesSent"};case"sqsMessagesEmpty":return{text:o.sqsMessagesEmpty,textLC:i.sqsMessagesEmpty,value:"sqsMessagesEmpty"};case"sqsOldestMessage":return{text:o.sqsOldestMessage,textLC:i.sqsOldestMessage,value:"sqsOldestMessage"}}}},1729:(e,t,s)=>{s.r(t),s.d(t,{ExpressionRow:()=>se,Expressions:()=>Z,default:()=>Y,defaultExpression:()=>H,nodeTypes:()=>oe});var a=s(1319),r=s(5008),i=s(6791),o=s(5879),n=s(3073),l=s(770),u=s(4286),c=s.n(u),d=s(1517),m=s(1474),p=s(8786),f=s(5170),g=s(4791),x=s(4332),b=s(3038),y=s(6505),h=s(2622),v=s(9274),T=s(3059),k=s(1783),M=s.n(k),w=s(3651),C=s(7529),j=s(1136),S=s(5825),E=s(2959),B=s(4339),O=s(9874),L=s(192),R=s(7852);const F=.3,I=({threshold:e,sortedThresholds:t,comparator:s,color:a,id:r,firstTimestamp:o,lastTimestamp:n,domain:u})=>{if(!s||!e)return null;const d=[p.o.GREATER_THAN,p.o.GREATER_THAN_OR_EQUALS].includes(s),m=[p.o.LESS_THAN,p.o.LESS_THAN_OR_EQUALS].includes(s);return(0,i.jsx)(c().Fragment,null,(0,i.jsx)(T.LineAnnotation,{id:`${r}-thresholds`,domainType:T.AnnotationDomainType.YDomain,"data-test-subj":"threshold-line",dataValues:t.map((e=>({dataValue:e}))),style:{line:{strokeWidth:2,stroke:(0,C.hR)(a),opacity:1}}}),2===t.length&&s===p.o.BETWEEN?(0,i.jsx)(c().Fragment,null,(0,i.jsx)(T.RectAnnotation,{id:`${r}-lower-threshold`,"data-test-subj":"between-rect",style:{fill:(0,C.hR)(a),opacity:F},dataValues:[{coordinates:{x0:o,x1:n,y0:(0,l.first)(e),y1:(0,l.last)(e)}}]})):null,2===t.length&&s===p.o.NOT_BETWEEN?(0,i.jsx)(c().Fragment,null,(0,i.jsx)(T.RectAnnotation,{id:`${r}-lower-threshold`,"data-test-subj":"outside-range-lower-rect",style:{fill:(0,C.hR)(a),opacity:F},dataValues:[{coordinates:{x0:o,x1:n,y0:u.min,y1:(0,l.first)(e)}}]}),(0,i.jsx)(T.RectAnnotation,{id:`${r}-upper-threshold`,"data-test-subj":"outside-range-upper-rect",style:{fill:(0,C.hR)(a),opacity:F},dataValues:[{coordinates:{x0:o,x1:n,y0:(0,l.last)(e),y1:u.max}}]})):null,m&&null!=(0,l.first)(e)?(0,i.jsx)(T.RectAnnotation,{id:`${r}-upper-threshold`,"data-test-subj":"below-rect",style:{fill:(0,C.hR)(a),opacity:F},dataValues:[{coordinates:{x0:o,x1:n,y0:u.min,y1:(0,l.first)(e)}}]}):null,d&&null!=(0,l.first)(e)?(0,i.jsx)(T.RectAnnotation,{id:`${r}-upper-threshold`,"data-test-subj":"above-rect",style:{fill:(0,C.hR)(a),opacity:F},dataValues:[{coordinates:{x0:o,x1:n,y0:(0,l.first)(e),y1:u.max}}]}):null)},A=({expression:e,filterQuery:t,nodeType:s,sourceId:n,accountId:d="",region:m=""})=>{var p,g,x,b,y;const h=(0,w.a)(),v=(0,u.useMemo)((()=>({interval:`${e.timeSize||1}${e.timeUnit}`,from:M()().subtract(20*(e.timeSize||1),e.timeUnit).valueOf(),to:M()().valueOf(),forceInterval:!0})),[e.timeSize,e.timeUnit]),k=e=>({...e,type:"custom"}),{loading:F,nodes:A}=(0,j.s)({filterQuery:t,metrics:"custom"===e.metric?[k(e.customMetric)]:[{type:e.metric}],groupBy:[],nodeType:s,sourceId:n,currentTime:0,accountId:d,region:m,timerange:v}),N={field:e.metric,aggregation:"avg",color:C.Q1.color0},q=(0,u.useMemo)((()=>{var e,t,s,a;const r=null===(e=A[0])||void 0===e||null===(t=e.metrics[0])||void 0===t?void 0:t.timeseries,i=null===(s=(0,l.first)(null==r?void 0:r.rows))||void 0===s?void 0:s.timestamp,o=null===(a=(0,l.last)(null==r?void 0:r.rows))||void 0===a?void 0:a.timestamp;return null==i||null==o?e=>`${e}`:(0,T.niceTimeFormatter)([i,o])}),[A]),U=(0,u.useCallback)((0,S.L)("custom"===e.metric?k(e.customMetric):{type:e.metric}),[e.metric]);if(F||!A)return(0,i.jsx)(R.Gu,null);const _=t=>P(e.metric,t),V=e.threshold.map(_),D=null!==(p=null===(g=e.warningThreshold)||void 0===g?void 0:g.map(_))&&void 0!==p?p:[],z=V.slice().sort(),Q=D.slice().sort(),W=[...z,...Q].sort(),G=null===(x=A[0])||void 0===x||null===(b=x.metrics[0])||void 0===b?void 0:b.timeseries;if(!G||!G.rows||0===G.rows.length)return(0,i.jsx)(R.HQ,null);const $={...G,id:null===(y=A[0])||void 0===y?void 0:y.name,rows:G.rows.map((e=>{const t={...e};return W.forEach(((e,s)=>{t[(0,B.G)(N,`threshold_${s}`)]=e})),t}))},H=(0,l.first)(G.rows).timestamp,Z=(0,l.last)(G.rows).timestamp,Y=(0,E.X)($,[N],!1),J={max:1.1*Math.max(Y.max,(0,l.last)(W)||Y.max),min:.9*Math.min(Y.min,(0,l.first)(W)||Y.min)};J.min===(0,l.first)(V)&&(J.min=.9*J.min);const{timeSize:K,timeUnit:X}=e,ee=R.CD[X];return(0,i.jsx)(c().Fragment,null,(0,i.jsx)(R.at,null,(0,i.jsx)(T.Chart,null,(0,i.jsx)(O.PZ,{type:L.$m.bar,metric:N,id:"0",series:$,stack:!1}),(0,i.jsx)(I,{comparator:(0,f.convertToBuiltInComparators)(e.comparator),threshold:V,sortedThresholds:z,color:C.Q1.color1,id:"critical",firstTimestamp:H,lastTimestamp:Z,domain:J}),e.warningComparator&&e.warningThreshold&&(0,i.jsx)(I,{comparator:(0,f.convertToBuiltInComparators)(e.warningComparator),threshold:D,sortedThresholds:Q,color:C.Q1.color5,id:"warning",firstTimestamp:H,lastTimestamp:Z,domain:J}),(0,i.jsx)(T.Axis,{id:"timestamp",position:T.Position.Bottom,showOverlappingTicks:!0,tickFormat:q}),(0,i.jsx)(T.Axis,{id:"values",position:T.Position.Left,tickFormat:U,domain:J}),(0,i.jsx)(T.Settings,{baseTheme:h.baseTheme,locale:r.i18n.getLocale()}),(0,i.jsx)(T.Tooltip,R.yV))),(0,i.jsx)("div",{style:{textAlign:"center"}},"ALL"!==$.id?(0,i.jsx)(a.EuiText,{size:"xs",color:"subdued"},(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alerts.dataTimeRangeLabelWithGrouping",defaultMessage:"Last {lookback} {timeLabel} of data for {id}",values:{id:$.id,timeLabel:ee,lookback:20*K}})):(0,i.jsx)(a.EuiText,{size:"xs",color:"subdued"},(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alerts.dataTimeRangeLabel",defaultMessage:"Last {lookback} {timeLabel}",values:{timeLabel:ee,lookback:20*K}}))))},P=(e,t)=>N[e]?N[e](t):t,N={cpu:e=>Number(e)/100,cpuV2:e=>Number(e)/100,memory:e=>Number(e)/100,tx:e=>Number(e)/8,rx:e=>Number(e)/8,rxV2:e=>Number(e)/8,txV2:e=>Number(e)/8};var q=s(8410),U=s(7434),_=s(5377);const V={txV2:"tx",rxV2:"rx",cpuV2:"cpu"},D={avg:r.i18n.translate("xpack.infra.waffle.customMetrics.aggregationLables.avg",{defaultMessage:"Average"}),max:r.i18n.translate("xpack.infra.waffle.customMetrics.aggregationLables.max",{defaultMessage:"Max"}),min:r.i18n.translate("xpack.infra.waffle.customMetrics.aggregationLables.min",{defaultMessage:"Min"}),rate:r.i18n.translate("xpack.infra.waffle.customMetrics.aggregationLables.rate",{defaultMessage:"Rate"})},z=_.jz.map((e=>({text:D[e],value:e}))),Q=({metric:e,metrics:t,customMetric:s,errors:n,onChange:d,onChangeCustom:m,popupPosition:p,nodeType:f})=>{var g;const[x,b]=(0,u.useState)(!1),[h,v]=(0,u.useState)("custom"===(null==e?void 0:e.value)),[T,k]=(0,u.useState)(null==e?void 0:e.value),[M,w]=(0,u.useState)(null==s?void 0:s.label),{metricsView:C}=(0,y.NT)(),j={text:r.i18n.translate("xpack.infra.metrics.alertFlyout.expression.metric.selectFieldLabel",{defaultMessage:"Select a metric"}),value:""},S=(0,u.useMemo)((()=>{var e;return(null!==(e=null==C?void 0:C.fields)&&void 0!==e?e:[]).filter((e=>e.aggregatable&&"number"===e.type&&!((null==s?void 0:s.field)===e.name))).map((e=>({label:e.name})))}),[null==C?void 0:C.fields,null==s?void 0:s.field]),E=(0,u.useMemo)((()=>h?(null==s?void 0:s.field)&&(0,U.s)(s):(null==e?void 0:e.text)||j.text),[h,e,s,j]),B=(0,u.useCallback)((e=>{"metric-popover-custom"===e?(v(!0),d("custom")):(v(!1),d(T))}),[v,d,T]),O=(0,u.useCallback)((e=>{const t=e.target.value,a=_.KJ.is(t)?t:"avg",r={...s,aggregation:a};_.YH.is(r)&&m(r)}),[s,m]),L=(0,u.useCallback)((e=>{const t={...s,field:e[0].label};_.YH.is(t)&&m(t)}),[s,m]),R=(0,l.debounce)(m,500),F=(0,u.useCallback)((e=>{w(e.target.value);const t={...s,label:e.target.value};_.YH.is(t)&&R(t)}),[s,R]),I=t.map((e=>V[e.value])).filter((e=>!!e)),A=(0,u.useMemo)((()=>t.filter((t=>(null==e?void 0:e.value)===t.value||!I.includes(t.value))).map((e=>({label:e.text,value:e.value})))),[null==e?void 0:e.value,t,I]);return(0,i.jsx)(a.EuiPopover,{id:"metricPopover",button:(0,i.jsx)(a.EuiExpression,{description:r.i18n.translate("xpack.infra.metrics.alertFlyout.expression.metric.whenLabel",{defaultMessage:"When"}),value:E,isActive:Boolean(x||n.metric&&n.metric.length>0),onClick:()=>{b(!0)},color:null!==(g=n.metric)&&void 0!==g&&g.length?"danger":"success"}),isOpen:x,closePopover:()=>{b(!1)},anchorPosition:null!=p?p:"downRight",zIndex:8e3},(0,i.jsx)("div",{style:{width:620}},(0,i.jsx)(W,{onClose:()=>b(!1)},(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alertFlyout.expression.metric.popoverTitle",defaultMessage:"Metric"})),(0,i.jsx)(a.EuiButtonGroup,{isFullWidth:!0,buttonSize:"compressed",legend:"Metric type",options:[{id:"metric-popover-default",label:"Default metric"},{id:"metric-popover-custom",label:"Custom metric"}],idSelected:h?"metric-popover-custom":"metric-popover-default",onChange:B}),(0,i.jsx)(a.EuiSpacer,{size:"m"}),h?(0,i.jsx)(c().Fragment,null,(0,i.jsx)(a.EuiFormRow,{fullWidth:!0},(0,i.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,i.jsx)(a.EuiFlexItem,{grow:!1},(0,i.jsx)(a.EuiSelect,{"data-test-subj":"infraMetricExpressionSelect",onChange:O,value:(null==s?void 0:s.aggregation)||"avg",options:z,fullWidth:!0})),(0,i.jsx)(a.EuiFlexItem,{grow:!1},(0,i.jsx)(a.EuiText,{color:"subdued"},(0,i.jsx)("span",null,r.i18n.translate("xpack.infra.waffle.customMetrics.of",{defaultMessage:"of"})))),(0,i.jsx)(a.EuiFlexItem,null,(0,i.jsx)(a.EuiComboBox,{fullWidth:!0,placeholder:r.i18n.translate("xpack.infra.waffle.customMetrics.fieldPlaceholder",{defaultMessage:"Select a field"}),singleSelection:{asPlainText:!0},selectedOptions:null!=s&&s.field?[{label:s.field}]:[],options:S,onChange:L,isClearable:!1,isInvalid:n.metric.length>0})))),(0,i.jsx)(a.EuiFormRow,{label:r.i18n.translate("xpack.infra.waffle.alerting.customMetrics.labelLabel",{defaultMessage:"Metric name (optional)"}),display:"rowCompressed",fullWidth:!0,helpText:r.i18n.translate("xpack.infra.waffle.alerting.customMetrics.helpText",{defaultMessage:'Choose a name to help identify your custom metric. Defaults to "<function> of <field name>".',ignoreTag:!0})},(0,i.jsx)(a.EuiFieldText,{"data-test-subj":"infraMetricExpressionFieldText",name:"label",placeholder:r.i18n.translate("xpack.infra.waffle.customMetrics.labelPlaceholder",{defaultMessage:'Choose a name to appear in the "Metric" dropdown'}),value:M,fullWidth:!0,onChange:F}))):(0,i.jsx)(a.EuiFormRow,{fullWidth:!0},(0,i.jsx)(a.EuiFlexGroup,{direction:"column",gutterSize:"s"},"host"===f&&(0,i.jsx)(a.EuiFlexItem,null,(0,i.jsx)(a.EuiLink,{"data-test-subj":"alertFlyoutHostMetricsDocumentationLink",href:q.G,target:"_blank"},r.i18n.translate("xpack.infra.metrics.alertFlyout.expression.metric.whatAreTheseMetricsLink",{defaultMessage:"What are these metrics?"}))),(0,i.jsx)(a.EuiFlexItem,{className:"actOf__metricContainer"},(0,i.jsx)(a.EuiComboBox,{fullWidth:!0,singleSelection:{asPlainText:!0},"data-test-subj":"availableFieldsOptionsComboBox",isInvalid:n.metric.length>0,placeholder:j.text,options:A,noSuggestions:!A.length,selectedOptions:e?A.filter((t=>t.value===e.value)):[],renderOption:e=>e.label,onChange:e=>{e.length>0?(d(e[0].value),k(e[0].value)):d()}}))))))},W=({children:e,onClose:t})=>(0,i.jsx)(a.EuiPopoverTitle,null,(0,i.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,i.jsx)(a.EuiFlexItem,null,e),(0,i.jsx)(a.EuiFlexItem,{grow:!1},(0,i.jsx)(a.EuiButtonIcon,{"data-test-subj":"infraClosablePopoverTitleButton",iconType:"cross",color:"danger","aria-label":r.i18n.translate("xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel",{defaultMessage:"Close"}),onClick:()=>t()})))),G=({value:e,options:t,onChange:s,popupPosition:n})=>{const[l,c]=(0,u.useState)(!1);return(0,i.jsx)(a.EuiPopover,{button:(0,i.jsx)(a.EuiExpression,{"data-test-subj":"nodeTypeExpression",description:r.i18n.translate("xpack.infra.metrics.alertFlyout.expression.for.descriptionLabel",{defaultMessage:"For"}),value:t[e].text,isActive:l,onClick:()=>{c(!0)}}),isOpen:l,closePopover:()=>{c(!1)},ownFocus:!0,anchorPosition:null!=n?n:"downLeft"},(0,i.jsx)("div",null,(0,i.jsx)($,{onClose:()=>c(!1)},(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alertFlyout.expression.for.popoverTitle",defaultMessage:"Node Type"})),(0,i.jsx)(a.EuiSelect,{"data-test-subj":"forExpressionSelect",value:e,fullWidth:!0,onChange:e=>{s(e.target.value),c(!1)},options:Object.values(t).map((e=>e))})))},$=({children:e,onClose:t})=>(0,i.jsx)(a.EuiPopoverTitle,null,(0,i.jsx)(a.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,i.jsx)(a.EuiFlexItem,null,e),(0,i.jsx)(a.EuiFlexItem,{grow:!1},(0,i.jsx)(a.EuiButtonIcon,{"data-test-subj":"infraClosablePopoverTitleButton",iconType:"cross",color:"danger","aria-label":r.i18n.translate("xpack.infra.metrics.expressionItems.components.closablePopoverTitle.closeLabel",{defaultMessage:"Close"}),onClick:()=>t()})))),H={metric:"cpuV2",comparator:p.o.GREATER_THAN,threshold:[],timeSize:1,timeUnit:"m",customMetric:{type:"custom",id:"alert-custom-metric",field:"",aggregation:"avg"}},Z=e=>{const{setRuleParams:t,ruleParams:s,errors:d,metadata:m}=e,{source:p}=(0,y.Ss)(),[f,b]=(0,u.useState)(1),[T,k]=(0,u.useState)("m"),{metricsView:M}=(0,y.NT)(),w=(0,u.useCallback)(((e,a)=>{const r=s.criteria?s.criteria.slice():[];r[e]=a,t("criteria",r)}),[t,s.criteria]),C=(0,u.useCallback)((()=>{var e;const a=(null===(e=s.criteria)||void 0===e?void 0:e.slice())||[];a.push({...H,timeSize:null!=f?f:H.timeSize,timeUnit:null!=T?T:H.timeUnit}),t("criteria",a)}),[t,s.criteria,f,T]),j=(0,u.useCallback)((e=>{const a=s.criteria.slice();a.length>1&&(a.splice(e,1),t("criteria",a))}),[t,s.criteria]),S=(0,u.useCallback)((e=>{t("filterQueryText",null!=e?e:"");try{t("filterQuery",(0,v._)(e,null==M?void 0:M.dataViewReference,!1)||"")}catch(e){t("filterQuery",x.H2)}}),[null==M?void 0:M.dataViewReference,t]),E=(0,u.useCallback)((0,l.debounce)(S,500),[S]),B=(0,u.useMemo)((()=>({aggField:[],timeSizeUnit:[],timeWindowSize:[]})),[]),O=(0,u.useCallback)((e=>{const a=s.criteria.map((t=>({...t,timeSize:e})));b(e||void 0),t("criteria",a)}),[s.criteria,t]),L=(0,u.useCallback)((e=>{const a=s.criteria.map((t=>({...t,timeUnit:e})));k(e),t("criteria",a)}),[s.criteria,t]),R=(0,u.useCallback)((e=>{t("nodeType",e)}),[t]),F=(0,u.useCallback)((e=>S(e.target.value)),[S]),I=(0,u.useCallback)((()=>{const e=m;e&&e.options?t("criteria",[{...H,metric:e.options.metric.type,customMetric:g.YH.is(e.options.metric)?e.options.metric:H.customMetric}]):t("criteria",[H])}),[m,t]),P=(0,u.useCallback)((()=>{const e=m;e&&e.filter&&(t("filterQueryText",e.filter),t("filterQuery",(0,v._)(e.filter,null==M?void 0:M.dataViewReference)||""))}),[m,null==M?void 0:M.dataViewReference,t]);return(0,u.useEffect)((()=>{const e=m;s.nodeType||(e&&e.nodeType?t("nodeType",e.nodeType):t("nodeType","host")),s.criteria&&s.criteria.length?(b(s.criteria[0].timeSize),k(s.criteria[0].timeUnit)):I(),void 0===s.filterQuery&&P(),s.sourceId||t("sourceId",(null==p?void 0:p.id)||"default")}),[m,null==M?void 0:M.dataViewReference,H,p]),(0,i.jsx)(c().Fragment,null,(0,i.jsx)(a.EuiSpacer,{size:"m"}),(0,i.jsx)(a.EuiText,{size:"xs"},(0,i.jsx)("h4",null,(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alertFlyout.conditions",defaultMessage:"Conditions"}))),(0,i.jsx)("div",{css:X},(0,i.jsx)(a.EuiFlexGroup,{css:K},(0,i.jsx)("div",{css:J},(0,i.jsx)(G,{options:oe,value:s.nodeType||"host",onChange:R})))),(0,i.jsx)(a.EuiSpacer,{size:"xs"}),s.criteria&&s.criteria.map(((e,t)=>(0,i.jsx)(se,{nodeType:s.nodeType,canDelete:s.criteria.length>1,remove:j,addExpression:C,key:t,expressionId:t,setRuleParams:w,errors:d[t]||B,expression:e||{}},(0,i.jsx)(A,{expression:e,filterQuery:s.filterQuery,nodeType:s.nodeType,sourceId:s.sourceId,accountId:s.accountId,region:s.region,"data-test-subj":"preview-chart"})))),(0,i.jsx)("div",{css:J},(0,i.jsx)(n.ForLastExpression,{timeWindowSize:f,timeWindowUnit:T,errors:B,onChangeWindowSize:O,onChangeWindowUnit:L})),(0,i.jsx)("div",null,(0,i.jsx)(a.EuiButtonEmpty,{"data-test-subj":"infraExpressionsAddConditionButton",color:"primary",iconSide:"left",flush:"left",iconType:"plusInCircleFilled",onClick:C},(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alertFlyout.addCondition",defaultMessage:"Add condition"}))),(0,i.jsx)(a.EuiSpacer,{size:"m"}),(0,i.jsx)(a.EuiCheckbox,{id:"metrics-alert-no-data-toggle",label:(0,i.jsx)(c().Fragment,null,r.i18n.translate("xpack.infra.metrics.alertFlyout.alertOnNoData",{defaultMessage:"Alert me if there's no data"})," ",(0,i.jsx)(a.EuiIconTip,{type:"questionInCircle",color:"subdued",content:r.i18n.translate("xpack.infra.metrics.alertFlyout.noDataHelpText",{defaultMessage:"Enable this to trigger the action if the metric(s) do not report any data over the expected time period, or if the alert fails to query Elasticsearch"})})),checked:s.alertOnNoData,onChange:e=>t("alertOnNoData",e.target.checked)}),(0,i.jsx)(a.EuiSpacer,{size:"m"}),(0,i.jsx)(a.EuiFormRow,{label:r.i18n.translate("xpack.infra.metrics.alertFlyout.filterLabel",{defaultMessage:"Filter (optional)"}),helpText:r.i18n.translate("xpack.infra.metrics.alertFlyout.filterHelpText",{defaultMessage:"Use a KQL expression to limit the scope of your alert trigger."}),fullWidth:!0,display:"rowCompressed"},m?(0,i.jsx)(h.U,{onSubmit:S,onChange:E,value:s.filterQueryText}):(0,i.jsx)(a.EuiFieldSearch,{"data-test-subj":"infraExpressionsFieldSearch",onChange:F,value:s.filterQueryText,fullWidth:!0})),(0,i.jsx)(a.EuiSpacer,{size:"m"}))},Y=(0,y.$1)(Z)("default"),J={name:"1ytr1ch",styles:"margin-left:28px"},K={name:"1ch6gud",styles:"display:flex;flex-wrap:wrap;margin:0 -4px"},X={name:"dzd8y1",styles:"padding:0 4px"},ee={name:"158icaa",styles:"margin-left:4px"};var te={name:"1ng7rhk",styles:"padding:0 0 0 28px"};const se=e=>{var t,s,n;const[f,x]=(0,d.A)(!0),{children:y,setRuleParams:h,expression:v,errors:T,expressionId:k,remove:M,canDelete:w,nodeType:C}=e,{metric:j,comparator:S=p.o.GREATER_THAN,threshold:E=[],customMetric:B,warningThreshold:O=[],warningComparator:L}=v,[R,F]=(0,u.useState)(Boolean(null==O?void 0:O.length)),I=(0,u.useCallback)((e=>{const t=m.SnapshotMetricTypeRT.is(e)?e:Boolean(e)?"custom":void 0,s={...v,metric:t};h(k,s)}),[k,v,h]),A=(0,u.useCallback)((e=>{g.YH.is(e)&&h(k,{...v,customMetric:e})}),[k,v,h]),P=(0,u.useCallback)((e=>{h(k,{...v,comparator:e})}),[k,v,h]),N=(0,u.useCallback)((e=>{h(k,{...v,warningComparator:e})}),[k,v,h]),q=(0,u.useCallback)((e=>{e.join()!==v.threshold.join()&&h(k,{...v,threshold:e})}),[k,v,h]),U=(0,u.useCallback)((e=>{var t;e.join()!==(null===(t=v.warningThreshold)||void 0===t?void 0:t.join())&&h(k,{...v,warningThreshold:e})}),[k,v,h]),_=(0,u.useCallback)((()=>{R?(F(!1),h(k,(0,l.omit)(v,"warningComparator","warningThreshold"))):(F(!0),h(k,{...v,warningComparator:S,warningThreshold:[]}))}),[R,F,h,S,v,k]),V=(0,i.jsx)(re,{comparator:S,threshold:E,updateComparator:P,updateThreshold:q,errors:null!==(t=T.critical)&&void 0!==t?t:{},metric:j}),D=R&&(0,i.jsx)(re,{comparator:L||S,threshold:O,updateComparator:N,updateThreshold:U,errors:null!==(s=T.warning)&&void 0!==s?s:{},metric:j}),z=(0,u.useMemo)((()=>{let e=m.hostSnapshotMetricTypes;switch(C){case"awsEC2":e=m.awsEC2SnapshotMetricTypes;break;case"awsRDS":e=m.awsRDSSnapshotMetricTypes;break;case"awsS3":e=m.awsS3SnapshotMetricTypes;break;case"awsSQS":e=m.awsSQSSnapshotMetricTypes;break;case"host":e=m.hostSnapshotMetricTypes;break;case"pod":e=m.podSnapshotMetricTypes;break;case"container":e=m.containerSnapshotMetricTypes}return e.map((e=>(0,b.t)(e,C)))}),[C]);return(0,i.jsx)(c().Fragment,null,(0,i.jsx)(a.EuiFlexGroup,{gutterSize:"xs"},(0,i.jsx)(a.EuiFlexItem,{grow:!1},(0,i.jsx)(a.EuiButtonIcon,{"data-test-subj":"infraExpressionRowButton",iconType:f?"arrowDown":"arrowRight",onClick:x,"aria-label":r.i18n.translate("xpack.infra.metrics.alertFlyout.expandRowLabel",{defaultMessage:"Expand row."})})),(0,i.jsx)(a.EuiFlexItem,{grow:!0},(0,i.jsx)(a.EuiFlexGroup,{css:K},(0,i.jsx)("div",{css:X},(0,i.jsx)(Q,{metric:{value:j,text:(null===(n=z.find((e=>(null==e?void 0:e.value)===j)))||void 0===n?void 0:n.text)||""},metrics:z.filter((e=>void 0!==e&&void 0!==e.value)),nodeType:C,onChange:I,onChangeCustom:A,errors:T,customMetric:B})),!R&&V),R&&(0,i.jsx)(c().Fragment,null,(0,i.jsx)(a.EuiFlexGroup,{css:K},V,(0,i.jsx)(a.EuiHealth,{css:ee,color:"danger"},(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alertFlyout.criticalThreshold",defaultMessage:"Alert"}))),(0,i.jsx)(a.EuiFlexGroup,{css:K},D,(0,i.jsx)(a.EuiHealth,{css:ee,color:"warning"},(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alertFlyout.warningThreshold",defaultMessage:"Warning"})),(0,i.jsx)(a.EuiButtonIcon,{"data-test-subj":"infraExpressionRowButton","aria-label":r.i18n.translate("xpack.infra.metrics.alertFlyout.removeWarningThreshold",{defaultMessage:"Remove warningThreshold"}),iconSize:"s",color:"text",iconType:"minusInCircleFilled",onClick:_}))),!R&&(0,i.jsx)(c().Fragment,null," ",(0,i.jsx)(a.EuiSpacer,{size:"xs"}),(0,i.jsx)(a.EuiFlexGroup,{css:K},(0,i.jsx)(a.EuiButtonEmpty,{"data-test-subj":"infraExpressionRowAddWarningThresholdButton",color:"primary",flush:"left",size:"xs",iconType:"plusInCircleFilled",onClick:_},(0,i.jsx)(o.FormattedMessage,{id:"xpack.infra.metrics.alertFlyout.addWarningThreshold",defaultMessage:"Add warning threshold"}))))),w&&(0,i.jsx)(a.EuiFlexItem,{grow:!1},(0,i.jsx)(a.EuiButtonIcon,{"data-test-subj":"infraExpressionRowButton","aria-label":r.i18n.translate("xpack.infra.metrics.alertFlyout.removeCondition",{defaultMessage:"Remove condition"}),color:"danger",iconType:"trash",onClick:()=>M(k)}))),f?(0,i.jsx)("div",{css:te},y):null,(0,i.jsx)(a.EuiSpacer,{size:"s"}))};var ae={name:"qbt5ty",styles:"align-self:center"};const re=({updateComparator:e,updateThreshold:t,threshold:s,metric:r,comparator:o,errors:l})=>{var u;return(0,i.jsx)(c().Fragment,null,(0,i.jsx)("div",{css:X},(0,i.jsx)(n.ThresholdExpression,{thresholdComparator:(0,f.convertToBuiltInComparators)(o)||p.o.GREATER_THAN,threshold:s,onChangeSelectedThresholdComparator:e,onChangeSelectedThreshold:t,errors:l})),r&&(0,i.jsx)("div",{css:ae},(0,i.jsx)(a.EuiText,{size:"s"},(null===(u=ne[r])||void 0===u?void 0:u.label)||"")))},ie=e=>(0,m.findInventoryModel)(e).displayName,oe={host:{text:ie("host"),value:"host"},pod:{text:ie("pod"),value:"pod"},container:{text:ie("container"),value:"container"},awsEC2:{text:ie("awsEC2"),value:"awsEC2"},awsS3:{text:ie("awsS3"),value:"awsS3"},awsRDS:{text:ie("awsRDS"),value:"awsRDS"},awsSQS:{text:ie("awsSQS"),value:"awsSQS"}},ne={count:{label:""},cpu:{label:"%"},cpuV2:{label:"%"},memory:{label:"%"},rx:{label:"bits/s"},tx:{label:"bits/s"},rxV2:{label:"bits/s"},txV2:{label:"bits/s"},logRate:{label:"/s"},diskIOReadBytes:{label:"bytes/s"},diskIOWriteBytes:{label:"bytes/s"},s3BucketSize:{label:"bytes"},s3TotalRequests:{label:""},s3NumberOfObjects:{label:""},s3UploadBytes:{label:"bytes"},s3DownloadBytes:{label:"bytes"},sqsOldestMessage:{label:"seconds"},rdsLatency:{label:"ms"},custom:{label:""}}},3268:(e,t,s)=>{s.d(t,{G:()=>o,r:()=>n});var a=s(3160),r=s(770),i=s(4286);const[o,n]=(0,a.A)((()=>({metricThresholdPrefill:(()=>{const[e,t]=(0,i.useState)({groupBy:void 0,filterQuery:void 0,metrics:[]}),{groupBy:s,filterQuery:a,metrics:o}=e;return{groupBy:s,filterQuery:a,metrics:o,setPrefillOptions(s){(0,r.isEqual)(s,e)||t(s)}}})(),inventoryPrefill:(()=>{const[e,t]=(0,i.useState)("host"),[s,a]=(0,i.useState)(),[r,o]=(0,i.useState)({type:"cpuV2"}),[n,l]=(0,i.useState)([]),[u,c]=(0,i.useState)(""),[d,m]=(0,i.useState)("");return{nodeType:e,filterQuery:s,metric:r,customMetrics:n,accountId:d,region:u,setAccountId:m,setNodeType:t,setFilterQuery:a,setMetric:o,setCustomMetrics:l,setRegion:c}})()})))},8248:(e,t,s)=>{s.d(t,{B_:()=>p,LH:()=>o,Zf:()=>d,ab:()=>c,uk:()=>l,yX:()=>m});var a=s(5008),r=s(3782);const i=r.keyof({gt:null,gte:null,lt:null,lte:null,eq:null}),o={status:a.i18n.translate("xpack.infra.legendControls.palettes.status",{defaultMessage:"Status"}),temperature:a.i18n.translate("xpack.infra.legendControls.palettes.temperature",{defaultMessage:"Temperature"}),cool:a.i18n.translate("xpack.infra.legendControls.palettes.cool",{defaultMessage:"Cool"}),warm:a.i18n.translate("xpack.infra.legendControls.palettes.warm",{defaultMessage:"Warm"}),positive:a.i18n.translate("xpack.infra.legendControls.palettes.positive",{defaultMessage:"Positive"}),negative:a.i18n.translate("xpack.infra.legendControls.palettes.negative",{defaultMessage:"Negative"})},n=r.intersection([r.type({value:r.number,operator:i,color:r.string}),r.partial({label:r.string})]),l=r.type({type:r.literal("step"),rules:r.array(n)}),u=r.type({value:r.number,color:r.string}),c=r.type({type:r.literal("gradient"),rules:r.array(u)}),d=r.type({type:r.literal("steppedGradient"),rules:r.array(u)});r.union([l,c,d]);let m=function(e){return e.gt="gt",e.gte="gte",e.lt="lt",e.lte="lte",e.eq="eq",e}({}),p=function(e){return e.number="number",e.abbreviatedNumber="abbreviatedNumber",e.bytes="bytes",e.bits="bits",e.percent="percent",e}({})},4215:(e,t,s)=>{s.d(t,{G:()=>a,Mn:()=>l,Vy:()=>i,bp:()=>r,iw:()=>o,sz:()=>n});const a="https://ela.st/docs-infra-host-metrics",r="https://ela.st/docs-infra-why-dotted",i="https://ela.st/docs-infra-docker-container-metrics",o="https://ela.st/hosts-missing-fields",n=150,l=300},8410:(e,t,s)=>{s.d(t,{G:()=>i.G,sz:()=>i.sz,kM:()=>r});var a=s(5008);const r={hostCount:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.hostCount",{defaultMessage:"Number of hosts returned by your search criteria."}),alertsCount:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.alertsCount",{defaultMessage:"The count of the active alerts"}),cpuUsage:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.cpuUsage",{defaultMessage:"Average of percentage of CPU time spent in states other than Idle and IOWait, normalised by the number of CPU cores. Includes both time spent on user space and kernel space. 100% means all CPUs of the host are busy."}),diskUsage:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.diskSpaceUsage",{defaultMessage:"Percentage of disk space used."}),diskLatency:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.diskLatency",{defaultMessage:"Time spent to service disk requests."}),memoryFree:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.memoryFree",{defaultMessage:"Total available memory including page cache."}),memoryTotal:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.memoryTotal",{defaultMessage:"Total memory capacity."}),memoryUsage:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.memoryUsage",{defaultMessage:"Percentage of main memory usage excluding page cache."}),normalizedLoad1m:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.normalizedLoad1m",{defaultMessage:"1 minute load average normalized by the number of CPU cores. "}),rx:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.rx",{defaultMessage:"Number of bytes which have been received per second on the public interfaces of the hosts."}),tx:a.i18n.translate("xpack.infra.hostsViewPage.metrics.tooltip.tx",{defaultMessage:"Number of bytes which have been sent per second on the public interfaces of the hosts."})};var i=s(4215)},3556:(e,t,s)=>{s.d(t,{_:()=>n});var a=s(8915),r=s(4286),i=s.n(r),o=s(409);class WithKueryAutocompletionComponent extends i().Component{constructor(...e){super(...e),(0,a.default)(this,"state",{currentRequest:null,suggestions:[]}),(0,a.default)(this,"loadSuggestions",(async(e,t,s,a)=>{var r;const{dataView:i}=this.props,o="kuery";if(!this.props.kibana.services.unifiedSearch.autocomplete.hasQuerySuggestions(o))return;this.setState({currentRequest:{expression:e,cursorPosition:t},suggestions:[]});const n=i&&null!==(r=await this.props.kibana.services.unifiedSearch.autocomplete.getQuerySuggestions({language:o,query:e,selectionStart:t,selectionEnd:t,indexPatterns:[i],boolFilter:[]}))&&void 0!==r?r:[],l=a?a(n):n;this.setState((a=>a.currentRequest&&a.currentRequest.expression!==e&&a.currentRequest.cursorPosition!==t?a:{...a,currentRequest:null,suggestions:s?l.slice(0,s):l}))}))}render(){const{currentRequest:e,suggestions:t}=this.state;return this.props.children({isLoadingSuggestions:null!==e,loadSuggestions:this.loadSuggestions,suggestions:t})}}const n=(0,o.withKibana)(WithKueryAutocompletionComponent)},7758:(e,t,s)=>{s.d(t,{Ls:()=>m,N6:()=>d,mm:()=>c,su:()=>u});var a=s(5008),r=s(4286),i=s.n(r),o=s(2503),n=s(1648),l=s(6791);let u=function(e){return e.LOADING="loading",e.SUCCESS="success",e.FAILURE="failure",e.NOT_INITIATED="not_initiated",e}({});const c=e=>e===u.LOADING||e===u.NOT_INITIATED,d=e=>e===u.FAILURE;function m(e,t=[],s={}){const{notifications:c,services:{http:d}}=(0,o.fJ)(),{autoFetch:m=!0,preservePreviousData:p=!0,showToastOnError:f=!0,requestObservable$:g}=s,[x,b]=(0,r.useState)({data:void 0,status:u.NOT_INITIATED}),{reloadRequestTime:y}=(0,n.MM)(),[h,v]=(0,r.useState)(y),T=(0,r.useRef)(m),k=(0,r.useRef)(new AbortController),M=(0,r.useCallback)((async()=>{k.current.abort(),k.current=new AbortController;const t=k.current.signal,s=e(function(e,t){return(s,a)=>t.fetch(s,{...a,signal:e}).catch((e=>{throw e})).then((e=>e))}(t,d));if(s){b((e=>({data:p?e.data:void 0,status:u.LOADING,error:void 0})));try{const e=await s;return t.aborted||b({data:e,status:u.SUCCESS,error:void 0}),e}catch(e){const s=e;if(!t.aborted){var r,o;const t=s.response?(n=s,(0,l.jsx)(i().Fragment,null,(0,l.jsx)("h5",null,a.i18n.translate("xpack.infra.useHTTPRequest.error.status",{defaultMessage:"Error"})),null===(m=n.response)||void 0===m?void 0:m.statusText," (",null===(g=n.response)||void 0===g?void 0:g.status,")",(0,l.jsx)("h5",null,a.i18n.translate("xpack.infra.useHTTPRequest.error.url",{defaultMessage:"URL"})),null===(x=n.response)||void 0===x?void 0:x.url,(0,l.jsx)("h5",null,a.i18n.translate("xpack.infra.useHTTPRequest.error.body.message",{defaultMessage:"Message"})),(null===(y=n.body)||void 0===y?void 0:y.message)||n.message)):null!==(r=null===(o=s.body)||void 0===o?void 0:o.message)&&void 0!==r?r:s.message;f&&c.toasts.danger({toastLifeTimeMs:3e3,title:a.i18n.translate("xpack.infra.useHTTPRequest.error.title",{defaultMessage:"Error while fetching resource"}),body:(0,l.jsx)("div",null,(0,l.jsx)("h5",null,a.i18n.translate("xpack.infra.fetcher.error.status",{defaultMessage:"Error"})),t)}),b({data:void 0,status:u.FAILURE,error:e})}}var n,m,g,x,y}}),t),w=(0,r.useCallback)((()=>{g?g.next(M):M()}),[g,M]);return(0,r.useEffect)((()=>{m&&v(y),T.current=m}),[m,y]),(0,r.useEffect)((()=>()=>{k.current.abort()}),[]),(0,r.useEffect)((()=>{T.current&&w()}),[T,M,h,w]),(0,r.useMemo)((()=>({...x,refetch:w})),[x,w])}},1357:(e,t,s)=>{s.d(t,{M:()=>n,x:()=>l});var a=s(4286),r=s(6753),i=s(3e3),o=s(2503);const n=({from:e,to:t})=>{const{services:s}=(0,o.fJ)();return[(0,a.useCallback)((()=>{const a=s.data.query.timefilter.timefilter;return a.isTimeTouched()?a.getTime():{from:e,to:t}}),[s.data.query.timefilter.timefilter,e,t]),s.data.query.timefilter.timefilter.setTime]},l=(e,t,s)=>{const{services:l}=(0,o.fJ)(),[u,c]=n(e);(0,i.A)((()=>{e.from===t.from&&e.to===t.to||c({from:t.from,to:t.to})})),(0,r.A)((()=>{c({from:t.from,to:t.to})}),[t.from,t.to,c]),(0,a.useEffect)((()=>{const e=l.data.query.timefilter.timefilter.getTimeUpdate$().subscribe((()=>{if(s){const e=u();s(e)}}));return()=>e.unsubscribe()}),[u,s,l.data.query.timefilter.timefilter])}},1648:(e,t,s)=>{s.d(t,{MM:()=>o,XB:()=>i});var a=s(3160),r=s(4286);const[i,o]=(0,a.A)((()=>{const[e,t]=(0,r.useState)(Date.now());return{updateReloadRequestTime:(0,r.useCallback)((()=>{t(Date.now())}),[]),reloadRequestTime:e}}))},1136:(e,t,s)=>{s.d(t,{s:()=>n});var a=s(4286),r=s(6524),i=s(7758),o=s(5377);function n(e,{sendRequestImmediately:t=!0}={}){const s=(0,a.useMemo)((()=>JSON.stringify(l(e))),[e]),{data:n,status:u,error:c,refetch:d}=(0,i.Ls)((async e=>{const t=await e("/api/metrics/snapshot",{method:"POST",body:s});return(0,r.GB)(o.WW)(t)}),[s],{autoFetch:t});return{error:c&&c.message||null,loading:(0,i.mm)(u),nodes:(null==n?void 0:n.nodes)||[],interval:(null==n?void 0:n.interval)||"60s",reload:d}}const l=e=>{const{accountId:t="",currentTime:s,dropPartialBuckets:a=!0,filterQuery:r="",groupBy:i=null,includeTimeseries:o=!0,metrics:n,nodeType:l,overrideCompositeSize:u,region:c="",sourceId:d,timerange:m}=e;return{accountId:t,dropPartialBuckets:a,filterQuery:r,groupBy:i,includeTimeseries:o,metrics:n,nodeType:l,sourceId:d,overrideCompositeSize:u,region:c,timerange:null!=m?m:{interval:"1m",to:s,from:s-12e5,lookbackSize:5}}}},5825:(e,t,s)=>{s.d(t,{L:()=>u});var a=s(770),r=s(8248),i=s(5377),o=s(2658),n=s(6984);const l={count:{formatter:r.B_.number,template:"{{value}}"},cpu:{formatter:r.B_.percent,template:"{{value}}"},cpuV2:{formatter:r.B_.percent,template:"{{value}}"},diskIOReadBytes:{formatter:r.B_.bytes,template:"{{value}}/s"},diskIOWriteBytes:{formatter:r.B_.bytes,template:"{{value}}/s"},diskLatency:{formatter:r.B_.number,template:"{{value}} ms"},diskSpaceUsage:{formatter:r.B_.percent,template:"{{value}}"},memory:{formatter:r.B_.percent,template:"{{value}}"},memoryFree:{formatter:r.B_.bytes,template:"{{value}}"},memoryTotal:{formatter:r.B_.bytes,template:"{{value}}"},normalizedLoad1m:{formatter:r.B_.percent,template:"{{value}}"},rx:{formatter:r.B_.bits,template:"{{value}}/s"},tx:{formatter:r.B_.bits,template:"{{value}}/s"},rxV2:{formatter:r.B_.bits,template:"{{value}}/s"},txV2:{formatter:r.B_.bits,template:"{{value}}/s"},logRate:{formatter:r.B_.abbreviatedNumber,template:"{{value}}/s"},s3BucketSize:{formatter:r.B_.bytes,template:"{{value}}"},s3TotalRequests:{formatter:r.B_.abbreviatedNumber,template:"{{value}}"},s3NumberOfObjects:{formatter:r.B_.abbreviatedNumber,template:"{{value}}"},s3UploadBytes:{formatter:r.B_.bytes,template:"{{value}}"},s3DownloadBytes:{formatter:r.B_.bytes,template:"{{value}}"},sqsOldestMessage:{formatter:r.B_.number,template:"{{value}} seconds"},rdsLatency:{formatter:r.B_.number,template:"{{value}} ms"}},u=e=>t=>{if(i.YH.is(e)){const s=(0,o.s)(e);return(0,a.isNumber)(t)?s(t):t}const s=(0,a.get)(l,e.type,l.count);return null!=t&&s?(0,n.x)(s.formatter,s.template)(t):""}},2959:(e,t,s)=>{s.d(t,{X:()=>n});var a=s(770),r=s(4339);const i=e=>{const t=(0,a.min)(e);return(0,a.isNumber)(t)&&Number.isFinite(t)?t:void 0},o=e=>{const t=(0,a.max)(e);return(0,a.isNumber)(t)&&Number.isFinite(t)?t:void 0},n=(e,t,s=!1)=>{const n=e.rows.reduce(((e,n)=>{const l=t.map(((e,t)=>n[(0,r.G)(e,t)]||null)).filter((e=>(0,a.isNumber)(e))),u=i(l),c=s?1.1*(0,a.sum)(l):o(l);return e.concat([u||null,c||null])}),[]).filter((e=>(0,a.isNumber)(e)));return{min:i(n)||0,max:o(n)||0}}},2658:(e,t,s)=>{s.d(t,{s:()=>l});var a=s(6752),r=s.n(a),i=s(6984),o=s(8248),n=s(7864);const l=e=>{if("custom"===(null==e?void 0:e.aggregation))return e=>r()(e).format("0.[0000]");if(e&&e.field){const t=(0,n.H)(e);return t===o.B_.bits&&"rate"===e.aggregation?(0,i.x)(o.B_.bits,"{{value}}/s"):(0,i.x)(t)}return(0,i.x)(o.B_.number)}},8396:(e,t,s)=>{s.d(t,{P:()=>a});const a=e=>e.label?e.label:`${e.aggregation}(${e.field||""})`},4339:(e,t,s)=>{s.d(t,{G:()=>a});const a=(e,t)=>`metric_${t}`},7864:(e,t,s)=>{s.d(t,{H:()=>i});var a=s(770),r=s(8248);const i=e=>{if(e&&e.field){const t=(0,a.last)(e.field.split(/\./));if("pct"===t)return r.B_.percent;if("bytes"===t&&"rate"===e.aggregation)return r.B_.bits;if("bytes"===t)return r.B_.bytes}return r.B_.number}},2622:(e,t,s)=>{s.d(t,{U:()=>d});var a=s(5008),r=s(5964),i=s(4286),o=s(3838),n=s(1319),l=s(6505),u=s(3556),c=s(6791);const d=({onSubmit:e,onChange:t,value:s,placeholder:d,curryLoadSuggestions:p=m,compressed:f})=>{const{metricsView:g}=(0,l.NT)(),[x,b]=(0,i.useState)(s||""),[y,h]=(0,i.useState)(!0);(0,i.useEffect)((()=>{s&&b(s)}),[s]);const{euiTheme:v}=(0,n.useEuiTheme)(),T=e=>{h(function(e){try{(0,r.fromKueryExpression)(e)}catch(e){return!1}return!0}(e)),b(e),t&&t(e)},k=a.i18n.translate("xpack.infra.homePage.toolbar.kqlSearchFieldPlaceholder",{defaultMessage:"Search for infrastructure data… (e.g. host.name:host-1)"});return(0,c.jsx)(u._,{dataView:null==g?void 0:g.dataViewReference},(({isLoadingSuggestions:t,loadSuggestions:s,suggestions:a})=>(0,c.jsx)(o.AutocompleteField,{compressed:f,"aria-label":d,isLoadingSuggestions:t,isValid:y,loadSuggestions:p(s),onChange:T,onSubmit:e,placeholder:d||k,suggestions:a,value:x,theme:v})))},m=e=>(...t)=>e(...t)},9874:(e,t,s)=>{s.d(t,{PZ:()=>c}),s(4286);var a=s(3059),r=s(7529),i=s(8396),o=s(192),n=s(6933),l=s(4339),u=s(6791);const c=e=>o.$m.bar===e.type?(0,u.jsx)(m,e):(0,u.jsx)(d,e),d=({metric:e,id:t,series:s,type:c,stack:d,opacity:m})=>{const p=(0,n.h)(),f=e.color&&(0,r.hR)(e.color)||(0,r.hR)(r.Q1.color0),g=Array.isArray(t)?t.map((t=>(0,l.G)(e,t))).slice(t.length-1,t.length):[(0,l.G)(e,t)],x=Array.isArray(t)&&t.length>1?t.map((t=>(0,l.G)(e,t))).slice(0,1):void 0,b=`series-${s.id}-${g.join("-")}`,y={line:{strokeWidth:2,visible:!0},area:{opacity:m||.5,visible:c===o.$m.area}};return(0,u.jsx)(a.AreaSeries,{id:b,key:b,name:(0,i.P)(e),xScaleType:a.ScaleType.Time,yScaleType:a.ScaleType.Linear,xAccessor:"timestamp",yAccessors:g,y0Accessors:x,data:s.rows,stackAccessors:d?["timestamp"]:void 0,areaSeriesStyle:y,color:f,timeZone:p})},m=({metric:e,id:t,series:s,stack:o})=>{const c=(0,n.h)(),d=e.color&&(0,r.hR)(e.color)||(0,r.hR)(r.Q1.color0),m=Array.isArray(t)?t.map((t=>(0,l.G)(e,t))).slice(t.length-1,t.length):[(0,l.G)(e,t)],p=`series-${s.id}-${m.join("-")}`,f={rectBorder:{stroke:d,strokeWidth:1,visible:!0},rect:{opacity:1}};return(0,u.jsx)(a.BarSeries,{id:p,key:p,name:(0,i.P)(e),xScaleType:a.ScaleType.Time,yScaleType:a.ScaleType.Linear,xAccessor:"timestamp",yAccessors:m,data:s.rows,stackAccessors:o?["timestamp"]:void 0,barSeriesStyle:f,color:d,timeZone:c})}},192:(e,t,s)=>{s.d(t,{$m:()=>l.$m,Op:()=>l.Op,a$:()=>b,d$:()=>l.d$,rn:()=>l.rn,uE:()=>l.uE,wv:()=>x});var a=s(6494),r=s.n(a),i=s(3782),o=s(3160),n=s(4286),l=s(5940),u=s(3268),c=s(7529),d=s(1357);i.type({fromTimestamp:i.number,toTimestamp:i.number,interval:i.string});const m=">=10s",p={type:l.$m.line,yAxisMode:l.Op.fromZero,stack:!1},f={aggregation:"avg",metrics:[{aggregation:"avg",field:"system.cpu.total.norm.pct",color:c.Q1.color0},{aggregation:"avg",field:"kubernetes.pod.cpu.usage.node.pct",color:c.Q1.color1},{aggregation:"avg",field:"docker.cpu.total.pct",color:c.Q1.color2}],source:"default"};function g(e,t){const s=localStorage.getItem(e),[a,r]=(0,n.useState)(function(e,t){if(!e)return t;try{return JSON.parse(e)}catch(e){return t}}(s,t));return(0,n.useEffect)((()=>{localStorage.setItem(e,JSON.stringify(a))}),[e,a]),[a,r]}const[x,b]=(0,o.A)((()=>{const e={from:"now-1h",to:"now"},[t]=(0,d.M)(e),{from:s,to:a}=t(),[i,o]=g("MetricsExplorerOptions",f),[l,c]=(0,n.useState)({from:s,to:a,interval:m}),[x,b]=(0,n.useState)((({from:e,to:t})=>({fromTimestamp:r().parse(e).valueOf(),toTimestamp:r().parse(t,{roundUp:!0}).valueOf(),interval:m}))({from:s,to:a}));(0,d.x)(e,{from:l.from,to:l.to});const[y,h]=g("MetricsExplorerChartOptions",p),[v,T]=(0,n.useState)(!1),{metricThresholdPrefill:k}=(0,u.r)(),M=(0,n.useMemo)((()=>k),[k]);return(0,n.useEffect)((()=>{if(M){const{setPrefillOptions:e}=M,{metrics:t,groupBy:s,filterQuery:a}=i;e({metrics:t,groupBy:s,filterQuery:a})}}),[i,M]),{defaultViewState:{options:f,chartOptions:p,currentTimerange:l},options:i,chartOptions:y,setChartOptions:h,timeRange:l,isAutoReloading:v,setOptions:o,setTimeRange:c,startAutoReload:()=>T(!0),stopAutoReload:()=>T(!1),timestamps:x,setTimestamps:b}}))},9274:(e,t,s)=>{s.d(t,{_:()=>r});var a=s(5964);const r=(e,t,s=!0)=>{try{return e?JSON.stringify((0,a.toElasticsearchQuery)((0,a.fromKueryExpression)(e),t)):""}catch(e){if(s)return"";throw e}}},8345:(e,t,s)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.useFirstMountState=void 0;var a=s(4286);t.useFirstMountState=function(){var e=a.useRef(!0);return e.current?(e.current=!1,!0):e.current}},1517:(e,t,s)=>{var a=s(4286),r=function(e,t){return"boolean"==typeof t?t:!e};t.A=function(e){return a.useReducer(r,e)}},6753:(e,t,s)=>{var a=s(4286),r=s(8345);t.A=function(e,t){var s=r.useFirstMountState();a.useEffect((function(){if(!s)return e()}),t)}}}]);