"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestEntity = getLatestEntity;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getLatestEntity({
  entityId,
  entityType,
  entityManagerClient,
  from,
  to,
  logger
}) {
  try {
    var _entityDefinitionsSou, _entityDefinitionsSou2;
    const entityDefinitionsSource = await entityManagerClient.v2.readSourceDefinitions({
      type: entityType
    });
    const hostOrContainerIdentityField = (_entityDefinitionsSou = entityDefinitionsSource[0]) === null || _entityDefinitionsSou === void 0 ? void 0 : (_entityDefinitionsSou2 = _entityDefinitionsSou.identity_fields) === null || _entityDefinitionsSou2 === void 0 ? void 0 : _entityDefinitionsSou2[0];
    if (hostOrContainerIdentityField === undefined) {
      return undefined;
    }
    const {
      entities
    } = await entityManagerClient.v2.searchEntities({
      type: entityType,
      limit: 1,
      metadata_fields: ['data_stream.type'],
      filters: [`${hostOrContainerIdentityField}: "${entityId}"`],
      start: from,
      end: to
    });
    const entityDataStreamType = entities[0]['data_stream.type'];
    return {
      sourceDataStreamType: (0, _lodash.isArray)(entityDataStreamType) ? entityDataStreamType.filter(Boolean) : entityDataStreamType
    };
  } catch (e) {
    logger.error(e);
  }
}