"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findCustomDashboard = findCustomDashboard;
var _saved_objects = require("../../../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function findCustomDashboard(assetType, savedObjectsClient) {
  const result = await savedObjectsClient.find({
    type: _saved_objects.INFRA_CUSTOM_DASHBOARDS_SAVED_OBJECT_TYPE,
    search: assetType,
    searchFields: ['assetType'],
    page: 1,
    perPage: 1000,
    sortField: 'updated_at',
    sortOrder: 'desc'
  });
  return result.saved_objects.map(({
    id,
    attributes
  }) => ({
    id,
    ...attributes
  }));
}