"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initCustomDashboardsRoutes = initCustomDashboardsRoutes;
var _get_custom_dashboard = require("./get_custom_dashboard");
var _save_custom_dashboard = require("./save_custom_dashboard");
var _delete_custom_dashboard = require("./delete_custom_dashboard");
var _update_custom_dashboard = require("./update_custom_dashboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initCustomDashboardsRoutes(framework) {
  (0, _get_custom_dashboard.initGetCustomDashboardRoute)(framework);
  (0, _save_custom_dashboard.initSaveCustomDashboardRoute)(framework);
  (0, _delete_custom_dashboard.initDeleteCustomDashboardRoute)(framework);
  (0, _update_custom_dashboard.initUpdateCustomDashboardRoute)(framework);
}