"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerMetricThresholdRuleType = registerMetricThresholdRuleType;
var _server = require("@kbn/core/server");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _metric_threshold = require("@kbn/response-ops-rule-params/metric_threshold");
var _metrics = require("../../../../common/alerting/metrics");
var _messages = require("../common/messages");
var _metric_threshold_executor = require("./metric_threshold_executor");
var _register_rule_types = require("../register_rule_types");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerMetricThresholdRuleType(alertingPlugin, libs, {
  featureFlags
}, locators) {
  if (!featureFlags.metricThresholdAlertRuleEnabled) {
    return;
  }
  const groupActionVariableDescription = _i18n.i18n.translate('xpack.infra.metrics.alerting.groupActionVariableDescription', {
    defaultMessage: 'Name of the group(s) reporting data. For accessing each group key, use context.groupByKeys.'
  });
  alertingPlugin.registerType({
    id: _metrics.METRIC_THRESHOLD_ALERT_TYPE_ID,
    name: _i18n.i18n.translate('xpack.infra.metrics.alertName', {
      defaultMessage: 'Metric threshold'
    }),
    fieldsForAAD: _constants.O11Y_AAD_FIELDS,
    validate: {
      params: _metric_threshold.metricThresholdRuleParamsSchema
    },
    defaultActionGroupId: _metric_threshold_executor.FIRED_ACTIONS.id,
    actionGroups: [_metric_threshold_executor.FIRED_ACTIONS, _metric_threshold_executor.WARNING_ACTIONS, _metric_threshold_executor.NO_DATA_ACTIONS],
    minimumLicenseRequired: 'basic',
    isExportable: true,
    executor: (0, _metric_threshold_executor.createMetricThresholdExecutor)(libs, locators),
    doesSetRecoveryContext: true,
    actionVariables: {
      context: [{
        name: 'group',
        description: groupActionVariableDescription
      }, {
        name: 'groupByKeys',
        description: _messages.groupByKeysActionVariableDescription
      }, {
        name: 'alertDetailsUrl',
        description: _messages.alertDetailUrlActionVariableDescription,
        usesPublicBaseUrl: true
      }, {
        name: 'alertState',
        description: _messages.alertStateActionVariableDescription
      }, {
        name: 'reason',
        description: _messages.reasonActionVariableDescription
      }, {
        name: 'timestamp',
        description: _messages.timestampActionVariableDescription
      }, {
        name: 'value',
        description: _messages.valueActionVariableDescription
      }, {
        name: 'metric',
        description: _messages.metricActionVariableDescription
      }, {
        name: 'threshold',
        description: _messages.thresholdActionVariableDescription
      }, {
        name: 'viewInAppUrl',
        description: _messages.viewInAppUrlActionVariableDescription,
        usesPublicBaseUrl: true
      }, {
        name: 'cloud',
        description: _messages.cloudActionVariableDescription
      }, {
        name: 'host',
        description: _messages.hostActionVariableDescription
      }, {
        name: 'container',
        description: _messages.containerActionVariableDescription
      }, {
        name: 'orchestrator',
        description: _messages.orchestratorActionVariableDescription
      }, {
        name: 'labels',
        description: _messages.labelsActionVariableDescription
      }, {
        name: 'tags',
        description: _messages.tagsActionVariableDescription
      }, {
        name: 'originalAlertState',
        description: _messages.originalAlertStateActionVariableDescription
      }, {
        name: 'originalAlertStateWasALERT',
        description: _messages.originalAlertStateWasActionVariableDescription
      }, {
        name: 'originalAlertStateWasWARNING',
        description: _messages.originalAlertStateWasActionVariableDescription
      }, {
        name: 'originalAlertStateWasNO_DATA',
        description: _messages.originalAlertStateWasActionVariableDescription
      }]
    },
    category: _server.DEFAULT_APP_CATEGORIES.observability.id,
    producer: 'infrastructure',
    alerts: _register_rule_types.MetricsRulesTypeAlertDefinition,
    getViewInAppRelativeUrl: ({
      rule
    }) => _common.observabilityPaths.ruleDetails(rule.id)
  });
}