"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Plugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-shared-plugin/common");
var _rxjs = require("rxjs");
var _constants = require("@kbn/deeplinks-observability/constants");
var _inventory = require("./alerting/inventory");
var _log_threshold = require("./alerting/log_threshold");
var _metric_threshold = require("./alerting/metric_threshold");
var _constants2 = require("./components/log_stream/constants");
var _metrics_overview_fetchers = require("./metrics_overview_fetchers");
var _register_feature = require("./register_feature");
var _inventory_views = require("./services/inventory_views");
var _metrics_explorer_views = require("./services/metrics_explorer_views");
var _telemetry = require("./services/telemetry");
var _logs_overview_fetchers = require("./utils/logs_overview_fetchers");
var _translations = require("./translations");
var _routes = require("./pages/logs/routes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class Plugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "inventoryViews", void 0);
    (0, _defineProperty2.default)(this, "metricsExplorerViews", void 0);
    (0, _defineProperty2.default)(this, "telemetry", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "isServerlessEnv", void 0);
    (0, _defineProperty2.default)(this, "appUpdater$", new _rxjs.BehaviorSubject(() => ({})));
    this.config = context.config.get();
    this.inventoryViews = new _inventory_views.InventoryViewsService();
    this.metricsExplorerViews = this.config.featureFlags.metricsExplorerEnabled ? new _metrics_explorer_views.MetricsExplorerViewsService() : undefined;
    this.telemetry = new _telemetry.TelemetryService();
    this.kibanaVersion = context.env.packageInfo.version;
    this.isServerlessEnv = context.env.packageInfo.buildFlavor === 'serverless';
  }
  setup(core, pluginsSetup) {
    var _this$config$sources, _this$config$sources$, _this$config$sources$2;
    if (pluginsSetup.home) {
      (0, _register_feature.registerFeatures)(pluginsSetup.home);
    }
    const assetDetailsLocator = pluginsSetup.share.url.locators.get(_common.ASSET_DETAILS_LOCATOR_ID);
    const inventoryLocator = pluginsSetup.share.url.locators.get(_common.INVENTORY_LOCATOR_ID);
    const metricsExplorerLocator = pluginsSetup.share.url.locators.get(_common.METRICS_EXPLORER_LOCATOR_ID);
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _inventory.createInventoryMetricRuleType)({
      assetDetailsLocator,
      inventoryLocator
    }));
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _metric_threshold.createMetricThresholdRuleType)({
      assetDetailsLocator,
      metricsExplorerLocator
    }));
    if (this.config.featureFlags.logsUIEnabled) {
      // fetchData `appLink` redirects to logs explorer
      pluginsSetup.observability.dashboard.register({
        appName: 'infra_logs',
        hasData: (0, _logs_overview_fetchers.getLogsHasDataFetcher)(core.getStartServices),
        fetchData: (0, _logs_overview_fetchers.getLogsOverviewDataFetcher)(core.getStartServices)
      });
    }
    pluginsSetup.observability.dashboard.register({
      appName: 'infra_metrics',
      hasData: (0, _metrics_overview_fetchers.createMetricsHasData)(core.getStartServices),
      fetchData: (0, _metrics_overview_fetchers.createMetricsFetchData)(core.getStartServices)
    });
    pluginsSetup.logsShared.logViews.setLogViewsStaticConfig({
      messageFields: (_this$config$sources = this.config.sources) === null || _this$config$sources === void 0 ? void 0 : (_this$config$sources$ = _this$config$sources.default) === null || _this$config$sources$ === void 0 ? void 0 : (_this$config$sources$2 = _this$config$sources$.fields) === null || _this$config$sources$2 === void 0 ? void 0 : _this$config$sources$2.message
    });
    const startDep$AndAccessibleFlag$ = (0, _rxjs.from)(core.getStartServices()).pipe((0, _rxjs.switchMap)(([{
      application
    }]) => (0, _rxjs.combineLatest)([(0, _rxjs.of)(application), getLogsExplorerAccessible$(application)])));
    const logRoutes = (0, _routes.getLogsAppRoutes)();

    /** !! Need to be kept in sync with the deepLinks in x-pack/solutions/observability/plugins/infra/public/plugin.ts */
    pluginsSetup.observabilityShared.navigation.registerSections(startDep$AndAccessibleFlag$.pipe((0, _rxjs.map)(([application, isLogsExplorerAccessible]) => {
      const {
        infrastructure,
        logs
      } = application.capabilities;
      return [...(logs.show ? [{
        label: _translations.logsTitle,
        sortKey: 200,
        entries: getLogsNavigationEntries({
          isLogsExplorerAccessible,
          config: this.config,
          routes: logRoutes
        })
      }] : []), ...(infrastructure.show ? [{
        label: _translations.metricsTitle,
        sortKey: 300,
        entries: [{
          label: _translations.inventoryTitle,
          app: 'metrics',
          path: '/inventory'
        }, ...(this.config.featureFlags.metricsExplorerEnabled ? [{
          label: _translations.metricsExplorerTitle,
          app: 'metrics',
          path: '/explorer'
        }] : []), {
          label: _translations.hostsTitle,
          app: 'metrics',
          path: '/hosts'
        }]
      }] : [])];
    })));
    pluginsSetup.embeddable.registerReactEmbeddableFactory(_constants2.LOG_STREAM_EMBEDDABLE, async () => {
      const {
        getLogStreamEmbeddableFactory
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/log_stream/log_stream_react_embeddable')));
      const [coreStart, pluginDeps, pluginStart] = await core.getStartServices();
      return getLogStreamEmbeddableFactory({
        coreStart,
        pluginDeps,
        pluginStart
      });
    });
    pluginsSetup.observability.observabilityRuleTypeRegistry.register((0, _log_threshold.createLogThresholdRuleType)(core, pluginsSetup.share.url));
    if (this.config.featureFlags.logsUIEnabled) {
      core.application.register({
        id: 'logs',
        title: _i18n.i18n.translate('xpack.infra.logs.pluginTitle', {
          defaultMessage: 'Logs'
        }),
        euiIconType: 'logoObservability',
        order: 8100,
        appRoute: '/app/logs',
        deepLinks: Object.values(logRoutes),
        category: _public.DEFAULT_APP_CATEGORIES.observability,
        mount: async params => {
          // mount callback should not use setup dependencies, get start dependencies instead
          const [coreStart, plugins, pluginStart] = await core.getStartServices();
          const isLogsExplorerAccessible = await (0, _rxjs.firstValueFrom)(getLogsExplorerAccessible$(coreStart.application));
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/logs_app')));
          return renderApp(coreStart, plugins, pluginStart, isLogsExplorerAccessible, params);
        }
      });
    }

    // !! Need to be kept in sync with the routes in x-pack/solutions/observability/plugins/infra/public/pages/metrics/index.tsx
    const getInfraDeepLinks = ({
      metricsExplorerEnabled
    }) => {
      const visibleIn = ['globalSearch'];
      return [{
        id: 'inventory',
        title: _translations.inventoryTitle,
        path: '/inventory',
        visibleIn
      }, {
        id: 'hosts',
        title: _i18n.i18n.translate('xpack.infra.homePage.metricsHostsTabTitle', {
          defaultMessage: 'Hosts'
        }),
        path: '/hosts',
        visibleIn
      }, ...(metricsExplorerEnabled ? [{
        id: 'metrics-explorer',
        title: _i18n.i18n.translate('xpack.infra.homePage.metricsExplorerTabTitle', {
          defaultMessage: 'Metrics Explorer'
        }),
        path: '/explorer'
      }] : []), {
        id: 'settings',
        title: _i18n.i18n.translate('xpack.infra.homePage.settingsTabTitle', {
          defaultMessage: 'Settings'
        }),
        path: '/settings'
      }, {
        id: 'assetDetails',
        title: '',
        // Internal deep link, not shown in the UI. Title is dynamically set in the app.
        path: '/detail',
        visibleIn: []
      }];
    };
    core.application.register({
      id: 'metrics',
      title: _i18n.i18n.translate('xpack.infra.metrics.pluginTitle', {
        defaultMessage: 'Infrastructure'
      }),
      euiIconType: 'logoObservability',
      order: 8200,
      appRoute: '/app/metrics',
      category: _public.DEFAULT_APP_CATEGORIES.observability,
      updater$: this.appUpdater$,
      deepLinks: getInfraDeepLinks({
        metricsExplorerEnabled: this.config.featureFlags.metricsExplorerEnabled
      }),
      mount: async params => {
        var _pluginsSetup$cloud, _pluginsSetup$cloud2;
        // mount callback should not use setup dependencies, get start dependencies instead
        const [coreStart, plugins, pluginStart] = await core.getStartServices();
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./apps/metrics_app')));
        const isCloudEnv = !!((_pluginsSetup$cloud = pluginsSetup.cloud) !== null && _pluginsSetup$cloud !== void 0 && _pluginsSetup$cloud.isCloudEnabled);
        const isServerlessEnv = ((_pluginsSetup$cloud2 = pluginsSetup.cloud) === null || _pluginsSetup$cloud2 === void 0 ? void 0 : _pluginsSetup$cloud2.isServerlessEnabled) || this.isServerlessEnv;
        return renderApp(coreStart, {
          ...plugins,
          licenseManagement: pluginsSetup.licenseManagement
        }, pluginStart, this.config, params, {
          kibanaVersion: this.kibanaVersion,
          isCloudEnv,
          isServerlessEnv
        });
      }
    });
    startDep$AndAccessibleFlag$.subscribe(([_applicationStart, _isLogsExplorerAccessible]) => {
      this.appUpdater$.next(() => ({
        deepLinks: getInfraDeepLinks({
          metricsExplorerEnabled: this.config.featureFlags.metricsExplorerEnabled
        })
      }));
    });

    // Setup telemetry events
    this.telemetry.setup({
      analytics: core.analytics
    });
    return {};
  }
  start(core, plugins) {
    var _this$metricsExplorer;
    const {
      http
    } = core;
    const inventoryViews = this.inventoryViews.start({
      http
    });
    const metricsExplorerViews = (_this$metricsExplorer = this.metricsExplorerViews) === null || _this$metricsExplorer === void 0 ? void 0 : _this$metricsExplorer.start({
      http
    });
    const telemetry = this.telemetry.start();
    const startContract = {
      inventoryViews,
      metricsExplorerViews,
      telemetry
    };
    return startContract;
  }
  stop() {}
}
exports.Plugin = Plugin;
const getLogsNavigationEntries = ({
  isLogsExplorerAccessible,
  config,
  routes
}) => {
  const entries = [];
  if (!config.featureFlags.logsUIEnabled) return entries;
  if (isLogsExplorerAccessible) {
    entries.push({
      label: 'Discover',
      app: 'observability-logs-explorer',
      path: '/'
    });
  }

  // Display always Logs Anomalies and Logs Categories entries
  entries.push(createNavEntryFromRoute(routes.logsAnomalies));
  entries.push(createNavEntryFromRoute(routes.logsCategories));
  return entries;
};
const getLogsExplorerAccessible$ = application => {
  const {
    applications$
  } = application;
  return applications$.pipe((0, _rxjs.map)(apps => {
    var _apps$get$status, _apps$get;
    return ((_apps$get$status = (_apps$get = apps.get(_constants.OBSERVABILITY_LOGS_EXPLORER_APP_ID)) === null || _apps$get === void 0 ? void 0 : _apps$get.status) !== null && _apps$get$status !== void 0 ? _apps$get$status : _public.AppStatus.inaccessible) === _public.AppStatus.accessible;
  }), (0, _rxjs.distinctUntilChanged)());
};
const createNavEntryFromRoute = ({
  path,
  title
}) => ({
  app: 'logs',
  label: title,
  path
});