"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WaffleTimeControls = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _convert_interval_to_string = require("../../../../../utils/convert_interval_to_string");
var _use_waffle_time = require("../../hooks/use_waffle_time");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WaffleTimeControls = exports.WaffleTimeControls = (0, _eui.withEuiTheme)(({
  interval
}) => {
  const {
    currentTime,
    isAutoReloading,
    startAutoReload,
    stopAutoReload,
    jumpToTime
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const currentMoment = (0, _moment.default)(currentTime);
  const intervalAsString = (0, _convert_interval_to_string.convertIntervalToString)(interval);
  const liveStreamingButton = isAutoReloading ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraWaffleTimeControlsStopRefreshingButton",
    color: "primary",
    iconSide: "left",
    iconType: "pause",
    onClick: stopAutoReload
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffleTime.stopRefreshingButtonLabel",
    defaultMessage: "Stop refreshing"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "infraWaffleTimeControlsAutoRefreshButton",
    iconSide: "left",
    iconType: "play",
    onClick: startAutoReload
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffleTime.autoRefreshButtonLabel",
    defaultMessage: "Auto-refresh"
  }));
  const handleChangeDate = (0, _react.useCallback)(time => {
    if (time) {
      jumpToTime(time.valueOf());
    }
  }, [jumpToTime]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "waffleDatePicker"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: `Last ${intervalAsString} of data for the selected time`,
    delay: "long",
    display: "inlineBlock",
    position: "top",
    "data-test-subj": "waffleDatePickerIntervalTooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
    dateFormat: "L LTS",
    disabled: isAutoReloading,
    injectTimes: currentMoment ? [currentMoment] : [],
    isLoading: isAutoReloading,
    onChange: handleChangeDate,
    popoverPlacement: "upRight",
    selected: currentMoment,
    shouldCloseOnSelect: true,
    showTimeSelect: true,
    timeFormat: "LT"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, liveStreamingButton));
});