"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsLinkToStream = void 0;
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/logs-shared-plugin/common");
var _public = require("@kbn/logs-shared-plugin/public");
var _moment = _interopRequireDefault(require("moment"));
var _use_kibana = require("../../../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsLinkToStream = ({
  startTime,
  endTime,
  query,
  logView
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    share
  } = services;
  const logsLocator = (0, _common.getLogsLocatorFromUrlService)(share.url);
  return /*#__PURE__*/_react.default.createElement(_public.OpenInLogsExplorerButton, {
    href: logsLocator.getRedirectUrl({
      timeRange: {
        from: (0, _moment.default)(startTime).toISOString(),
        to: (0, _moment.default)(endTime).toISOString()
      },
      filter: query,
      logView
    }),
    testSubject: "hostsView-logs-link-to-stream-button",
    flush: "both"
  });
};
exports.LogsLinkToStream = LogsLinkToStream;