"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamEmbeddableProviders = void 0;
exports.getLogStreamEmbeddableFactory = getLogStreamEmbeddableFactory;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/logs-shared-plugin/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _i18nReact = require("@kbn/i18n-react");
var _datemath = require("../../utils/datemath");
var _constants = require("./constants");
var _use_kibana = require("../../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLogStreamEmbeddableFactory(services) {
  const factory = {
    type: _constants.LOG_STREAM_EMBEDDABLE,
    deserializeState: state => state.rawState,
    buildEmbeddable: async (state, buildApi) => {
      const timeRangeContext = (0, _presentationPublishing.initializeTimeRange)(state);
      const titleManager = (0, _presentationPublishing.initializeTitleManager)(state);
      const api = buildApi({
        ...timeRangeContext.api,
        ...titleManager.api,
        serializeState: () => {
          return {
            rawState: {
              ...timeRangeContext.serialize(),
              ...titleManager.serialize()
            }
          };
        }
      }, {
        ...timeRangeContext.comparators,
        ...titleManager.comparators
      });
      return {
        api,
        Component: () => {
          const {
            filters,
            query,
            timeRange
          } = (0, _presentationPublishing.useFetchContext)(api);
          const {
            startTimestamp,
            endTimestamp
          } = (0, _react.useMemo)(() => {
            return {
              startTimestamp: timeRange ? (0, _datemath.datemathToEpochMillis)(timeRange.from) : undefined,
              endTimestamp: timeRange ? (0, _datemath.datemathToEpochMillis)(timeRange.to, 'up') : undefined
            };
          }, [timeRange]);
          const [darkMode, setDarkMode] = (0, _react.useState)(false);
          (0, _react.useEffect)(() => {
            const subscription = services.coreStart.theme.theme$.subscribe(theme => {
              setDarkMode(theme.darkMode);
            });
            return () => subscription.unsubscribe();
          }, []);
          return !startTimestamp || !endTimestamp ? null : /*#__PURE__*/_react.default.createElement(LogStreamEmbeddableProviders, {
            core: services.coreStart,
            plugins: services.pluginDeps,
            pluginStart: services.pluginStart,
            theme$: services.coreStart.theme.theme$
          }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
            darkMode: darkMode
          }, /*#__PURE__*/_react.default.createElement("div", {
            style: {
              width: '100%',
              position: 'relative'
            }
          }, /*#__PURE__*/_react.default.createElement(_public.LogStream, {
            logView: {
              type: 'log-view-reference',
              logViewId: 'default'
            },
            startTimestamp: startTimestamp,
            endTimestamp: endTimestamp,
            height: "100%",
            query: query,
            filters: filters
          }), /*#__PURE__*/_react.default.createElement(DeprecationCallout, null))));
        }
      };
    }
  };
  return factory;
}
const DISMISSAL_STORAGE_KEY = 'observability:logStreamEmbeddableDeprecationCalloutDismissed';
const SAVED_SEARCH_DOCS_URL = 'https://www.elastic.co/guide/en/kibana/current/save-open-search.html';
const DeprecationCallout = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isDismissed, setDismissed] = (0, _useLocalStorage.default)(DISMISSAL_STORAGE_KEY, false);
  if (isDismissed) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    iconType: "help",
    onDismiss: () => setDismissed(true),
    css: {
      position: 'absolute',
      bottom: euiTheme.size.m,
      right: euiTheme.size.m,
      width: 'min(100%, 40ch)'
    }
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logsStreamEmbeddable.deprecationWarningDescription",
    defaultMessage: "Logs Stream panels are no longer maintained. Try using {savedSearchDocsLink} for a similar visualization.",
    values: {
      savedSearchDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraDeprecationCalloutSavedSearchesLink",
        href: SAVED_SEARCH_DOCS_URL,
        target: "_blank"
      }, _i18n.i18n.translate('xpack.infra.logsStreamEmbeddable.deprecationWarningDescription.discoverSessionsLinkLabel', {
        defaultMessage: 'Discover sessions'
      }))
    }
  })));
};
const LogStreamEmbeddableProviders = ({
  children,
  core,
  pluginStart,
  plugins
}) => {
  const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins, pluginStart);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, {
    services: {
      ...core,
      ...plugins,
      ...pluginStart
    }
  }, children));
};
exports.LogStreamEmbeddableProviders = LogStreamEmbeddableProviders;