"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessesTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _formatters = require("../../../../../common/formatters");
var _process_row = require("./process_row");
var _state_badge = require("./state_badge");
var _states = require("./states");
var _metric_not_available_explanation = require("../../components/metric_not_available_explanation");
var _translations = require("../../translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useSortableProperties(sortablePropertyItems, defaultSortProperty, callback) {
  const [sortableProperties] = (0, _react.useState)(new _eui.SortableProperties(sortablePropertyItems, defaultSortProperty));
  return {
    updateSortableProperties: (0, _react.useCallback)(property => {
      sortableProperties.sortOn(property);
      callback((0, _lodash.omit)(sortableProperties.getSortedProperty(), 'getValue'));
    }, [sortableProperties, callback])
  };
}
const ProcessesTable = ({
  processList,
  currentTime,
  isLoading,
  sortBy,
  error,
  setSortBy,
  clearSearchBar
}) => {
  const {
    updateSortableProperties
  } = useSortableProperties([{
    name: 'startTime',
    getValue: item => Date.parse(item.startTime),
    isAscending: true
  }, {
    name: 'cpu',
    getValue: item => item.cpu,
    isAscending: false
  }, {
    name: 'memory',
    getValue: item => item.memory,
    isAscending: false
  }], 'cpu', setSortBy);
  const currentItems = (0, _react.useMemo)(() => processList.sort((a, b) => _states.STATE_ORDER.indexOf(a.state) - _states.STATE_ORDER.indexOf(b.state)), [processList]);
  if (!isLoading && currentItems.length === 0) return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "search",
    titleSize: "s",
    title: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.noProcesses",
      defaultMessage: "No processes found"
    })),
    body: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.noProcessesBody",
      defaultMessage: "Try modifying your filter. Only processes that are within the configured {metricbeatDocsLink} will display here.",
      values: {
        metricbeatDocsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "infraProcessesTableTopNByCpuOrMemoryLink",
          href: "https://www.elastic.co/guide/en/beats/metricbeat/current/metricbeat-module-system.html",
          target: "_blank"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.metrics.nodeDetails.noProcessesBody.metricbeatDocsLinkText",
          defaultMessage: "top N by CPU or Memory"
        }))
      }
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "infraProcessesTableClearFiltersButton",
      onClick: clearSearchBar
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.metrics.nodeDetails.noProcessesClearFilters",
      defaultMessage: "Clear filters"
    }))
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTable, {
    "data-test-subj": "infraAssetDetailsProcessesTable",
    responsiveBreakpoint: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    width: 24
  }), columns.map(column => {
    var _column$align;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
      key: `${String(column.field)}-header`,
      align: (_column$align = column.align) !== null && _column$align !== void 0 ? _column$align : _eui.LEFT_ALIGNMENT,
      width: column.width,
      onSort: column.sortable ? () => updateSortableProperties(column.field) : undefined,
      isSorted: sortBy.name === column.field,
      isSortAscending: sortBy.name === column.field && sortBy.isAscending
    }, column.name);
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableBody, {
    css: (0, _react2.css)`
          position: relative;
          & .euiTableCellContent {
            padding-top: 0;
            padding-bottom: 0;
          }
        `
  }, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    position: "absolute"
  }), isLoading && currentItems.length === 0 && !error && /*#__PURE__*/_react.default.createElement(ProcessesTableMessage, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.assetDetails.processes.loading",
    defaultMessage: "Loading..."
  })), error ? /*#__PURE__*/_react.default.createElement(ProcessesTableMessage, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "minusInCircle",
    color: "danger"
  }), " ", error) : /*#__PURE__*/_react.default.createElement(ProcessesTableBody, {
    items: currentItems,
    currentTime: currentTime
  })));
};
exports.ProcessesTable = ProcessesTable;
const ProcessesTableMessage = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
    "data-test-subj": "infraAssetDetailsProcessesSearchInputError",
    style: {
      paddingTop: `${euiTheme.size.s}`,
      paddingBottom: `${euiTheme.size.s}`
    },
    align: "center",
    colSpan: columns.length + 1,
    mobileOptions: {
      width: '100%'
    },
    textOnly: true
  }, children));
};
const ProcessesTableBody = ({
  items,
  currentTime
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, items.map((item, i) => {
  const cells = columns.map(column => {
    var _column$align2, _column$textOnly;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTableRowCell, {
      key: `${String(column.field)}-${i}`,
      mobileOptions: {
        header: column.name
      },
      align: (_column$align2 = column.align) !== null && _column$align2 !== void 0 ? _column$align2 : _eui.LEFT_ALIGNMENT,
      textOnly: (_column$textOnly = column.textOnly) !== null && _column$textOnly !== void 0 ? _column$textOnly : true,
      truncateText: column.truncateText
    }, column.render ? column.render(item[column.field], currentTime) : item[column.field]);
  });
  return /*#__PURE__*/_react.default.createElement(_process_row.ProcessRow, {
    cells: cells,
    item: item,
    key: `row-${i}`,
    supportAIAssistant: true
  });
}));
const ONE_MINUTE = 60 * 1000;
const ONE_HOUR = ONE_MINUTE * 60;
const RuntimeCell = ({
  startTime,
  currentTime
}) => {
  const runtimeLength = currentTime - startTime;
  let remainingRuntimeMS = runtimeLength;
  const runtimeHours = Math.floor(remainingRuntimeMS / ONE_HOUR);
  remainingRuntimeMS -= runtimeHours * ONE_HOUR;
  const runtimeMinutes = Math.floor(remainingRuntimeMS / ONE_MINUTE);
  remainingRuntimeMS -= runtimeMinutes * ONE_MINUTE;
  const runtimeSeconds = Math.floor(remainingRuntimeMS / 1000);
  remainingRuntimeMS -= runtimeSeconds * 1000;
  const runtimeDisplayHours = runtimeHours ? `${runtimeHours}:` : '';
  const runtimeDisplayMinutes = runtimeMinutes < 10 ? `0${runtimeMinutes}:` : `${runtimeMinutes}:`;
  const runtimeDisplaySeconds = runtimeSeconds < 10 ? `0${runtimeSeconds}` : runtimeSeconds;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, `${runtimeDisplayHours}${runtimeDisplayMinutes}${runtimeDisplaySeconds}`);
};
const columnLabelCPU = _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelCPU', {
  defaultMessage: 'CPU'
});
const columns = [{
  field: 'state',
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelState', {
    defaultMessage: 'State'
  }),
  sortable: false,
  render: state => /*#__PURE__*/_react.default.createElement(_state_badge.StateBadge, {
    state: state
  }),
  width: 84,
  textOnly: false
}, {
  field: 'command',
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelCommand', {
    defaultMessage: 'Command'
  }),
  sortable: false,
  width: '40%',
  truncateText: true,
  render: command => /*#__PURE__*/_react.default.createElement(CodeLine, {
    command: command
  })
}, {
  field: 'startTime',
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelTime', {
    defaultMessage: 'Time'
  }),
  align: _eui.RIGHT_ALIGNMENT,
  sortable: true,
  render: (startTime, currentTime) => /*#__PURE__*/_react.default.createElement(RuntimeCell, {
    startTime: startTime,
    currentTime: currentTime
  })
}, {
  field: 'cpu',
  name: columnLabelCPU,
  sortable: true,
  render: value => value === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _translations.NOT_AVAILABLE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_metric_not_available_explanation.MetricNotAvailableExplanationTooltip, {
    metricName: columnLabelCPU
  }))) : _formatters.FORMATTERS.percent(value)
}, {
  field: 'memory',
  name: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.columnLabelMemory', {
    defaultMessage: 'Mem.'
  }),
  sortable: true,
  render: value => value === null ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, _translations.NOT_AVAILABLE_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_metric_not_available_explanation.MetricNotAvailableExplanationTooltip, {
    metricName: _i18n.i18n.translate('xpack.infra.metrics.nodeDetails.processes.memory', {
      defaultMessage: 'memory'
    })
  }))) : _formatters.FORMATTERS.percent(value)
}];
const CodeLine = ({
  command
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        white-space: pre;
        overflow: hidden;
        text-overflow: ellipsis;
      `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    transparentBackground: true,
    css: (0, _react2.css)`
          color: ${euiTheme.colors.textParagraph};
          font-weight: ${euiTheme.font.weight.medium};
        `
  }, command));
};