"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsContent = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _build = require("../../../../utils/filters/build");
var _use_reload_request_time = require("../../../../hooks/use_reload_request_time");
var _use_log_charts = require("../../hooks/use_log_charts");
var _kpi = require("../../components/kpis/kpi");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogsContent = ({
  assetId,
  assetType,
  dataView,
  dateRange
}) => {
  const {
    reloadRequestTime
  } = (0, _use_reload_request_time.useReloadRequestTimeContext)();
  const filters = (0, _react.useMemo)(() => {
    return [(0, _build.buildCombinedAssetFilter)({
      field: (0, _common.findInventoryFields)(assetType).id,
      values: [assetId],
      dataView
    })];
  }, [dataView, assetId, assetType]);
  const {
    charts
  } = (0, _use_log_charts.useLogsCharts)({
    dataViewId: dataView === null || dataView === void 0 ? void 0 : dataView.id
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    "data-test-subj": "infraAssetDetailsLogsGrid"
  }, charts.map((chartProps, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: index
  }, /*#__PURE__*/_react.default.createElement(_kpi.Kpi, (0, _extends2.default)({}, chartProps, {
    dateRange: dateRange,
    filters: filters,
    lastReloadRequestTime: reloadRequestTime
  })))));
};
exports.LogsContent = LogsContent;