"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchCustomDashboards = useFetchCustomDashboards;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _custom_dashboards_api = require("../../../../common/http_api/custom_dashboards_api");
var _use_request_observable = require("./use_request_observable");
var _use_tab_switcher = require("./use_tab_switcher");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchCustomDashboards({
  assetType
}) {
  const {
    isActiveTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    request$
  } = (0, _use_request_observable.useRequestObservable)();
  const {
    data,
    status,
    error,
    refetch
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi(`/api/infra/${assetType}/custom-dashboards`, {
      method: 'GET'
    });
    return (0, _ioTsUtils.decodeOrThrow)(_custom_dashboards_api.InfraGetCustomDashboardsResponseBodyRT)(response);
  }, [assetType], {
    requestObservable$: request$,
    autoFetch: isActiveTab('dashboards')
  });
  return {
    error: error && error.message || null,
    loading: (0, _use_fetcher.isPending)(status),
    dashboards: data,
    reload: refetch
  };
}