"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogThresholdCountChart = LogThresholdCountChart;
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/embeddable-plugin/public");
var _eui = require("@elastic/eui");
var _use_kibana = require("../../../../../../hooks/use_kibana");
var _create_lens_definition = require("./create_lens_definition");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LogThresholdCountChart({
  kql,
  index,
  threshold,
  timeRange,
  alertRange,
  height,
  interval = 'auto',
  filter = ''
}) {
  const {
    lens: {
      EmbeddableComponent
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const lensDef = (0, _create_lens_definition.createLensDefinitionForCountChart)(index, euiTheme, kql, threshold, alertRange, interval, filter);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
    id: "logThresholdCountChart",
    style: {
      height
    },
    timeRange: timeRange,
    attributes: lensDef,
    viewMode: _public.ViewMode.VIEW,
    noPadding: true
  }));
}