"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.requestDocumentation = void 0;
var _lodash = require("lodash");
var _inferenceCommon = require("@kbn/inference-common");
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requestDocumentation = ({
  outputApi,
  system,
  messages,
  connectorId,
  functionCalling,
  metadata,
  toolOptions: {
    tools,
    toolChoice
  }
}) => {
  const hasTools = !(0, _lodash.isEmpty)(tools) && toolChoice !== _inferenceCommon.ToolChoiceType.none;
  return outputApi({
    id: 'request_documentation',
    connectorId,
    stream: true,
    functionCalling,
    metadata,
    system,
    previousMessages: messages,
    input: `Based on the previous conversation, request documentation
        from the ES|QL handbook to help you get the right information
        needed to generate a query.

        Examples for functions and commands:
        - Do you need to group data? Request \`STATS\`.
        - Extract data? Request \`DISSECT\` AND \`GROK\`.
        - Convert a column based on a set of conditionals? Request \`EVAL\` and \`CASE\`.

        ${hasTools ? `### Tools

        The following tools will be available to be called in the step after this.

        \`\`\`json
        ${JSON.stringify({
      tools,
      toolChoice
    })}
        \`\`\`` : ''}
      `,
    schema: _shared.requestDocumentationSchema
  }).pipe((0, _inferenceCommon.withoutOutputUpdateEvents)());
};
exports.requestDocumentation = requestDocumentation;