"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerConnectorsRoute = registerConnectorsRoute;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerConnectorsRoute({
  coreSetup,
  router
}) {
  router.get({
    path: '/internal/inference/connectors',
    security: {
      authz: {
        enabled: false,
        reason: 'This route is opted out from authorization'
      }
    },
    validate: {}
  }, async (_context, request, response) => {
    const actions = await coreSetup.getStartServices().then(([_coreStart, pluginsStart]) => pluginsStart.actions);
    const client = await actions.getActionsClientWithRequest(request);
    const allConnectors = await client.getAll({
      includeSystemActions: false
    });
    const connectors = allConnectors.filter(connector => (0, _inferenceCommon.isSupportedConnectorType)(connector.actionTypeId)).map(connector => {
      var _connector$config;
      return {
        connectorId: connector.id,
        name: connector.name,
        type: connector.actionTypeId,
        config: (_connector$config = connector.config) !== null && _connector$config !== void 0 ? _connector$config : {}
      };
    });
    return response.ok({
      body: {
        connectors
      }
    });
  });
}