"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fixSchemaArrayProperties = fixSchemaArrayProperties;
exports.toolsToBedrock = exports.toolChoiceToBedrock = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toolChoiceToBedrock = toolChoice => {
  if (toolChoice === _inferenceCommon.ToolChoiceType.required) {
    return {
      type: 'any'
    };
  } else if (toolChoice === _inferenceCommon.ToolChoiceType.auto) {
    return {
      type: 'auto'
    };
  } else if (typeof toolChoice === 'object') {
    return {
      type: 'tool',
      name: toolChoice.function
    };
  }
  // ToolChoiceType.none is not supported by claude
  // we are adding a directive to the system instructions instead in that case.
  return undefined;
};
exports.toolChoiceToBedrock = toolChoiceToBedrock;
const toolsToBedrock = (tools, messages) => {
  if (tools) {
    return Object.entries(tools).map(([toolName, toolDef]) => {
      var _toolDef$schema;
      return {
        name: toolName,
        description: toolDef.description,
        input_schema: fixSchemaArrayProperties((_toolDef$schema = toolDef.schema) !== null && _toolDef$schema !== void 0 ? _toolDef$schema : {
          type: 'object',
          properties: {}
        })
      };
    });
  }
  const hasToolUse = messages.filter(message => {
    var _message$toolCalls;
    return message.role === _inferenceCommon.MessageRole.Tool || message.role === _inferenceCommon.MessageRole.Assistant && ((_message$toolCalls = message.toolCalls) === null || _message$toolCalls === void 0 ? void 0 : _message$toolCalls.length);
  });
  if (hasToolUse) {
    return [{
      name: 'do_not_call_this_tool',
      description: 'Do not call this tool, it is strictly forbidden',
      input_schema: {
        type: 'object',
        properties: {}
      }
    }];
  }
};

/**
 * Claude is prone to ignoring the "array" part of an array type,
 * so this function patches it to add a message on each
 * array property to explicitly state that the value should
 * be returned as a json array...
 *
 */
exports.toolsToBedrock = toolsToBedrock;
function fixSchemaArrayProperties(schemaPart) {
  if (schemaPart.type === 'object' && schemaPart.properties) {
    return {
      ...schemaPart,
      properties: Object.fromEntries(Object.entries(schemaPart.properties).map(([key, childSchemaPart]) => {
        return [key, fixSchemaArrayProperties(childSchemaPart)];
      }))
    };
  }
  if (schemaPart.type === 'array') {
    return {
      ...schemaPart,
      // Claude is prone to ignoring the "array" part of an array type
      description: schemaPart.description ? `${schemaPart.description}. Must be provided as a JSON array` : 'Must be provided as a JSON array',
      items: fixSchemaArrayProperties(schemaPart.items)
    };
  }
  return schemaPart;
}