"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RankFeatureType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _edit_field = require("../edit_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RankFeatureType = () => {
  return /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, null, /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
    title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.rankFeature.positiveScoreImpactFieldTitle', {
      defaultMessage: 'Positive score impact'
    }),
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.rankFeature.positiveScoreImpactFieldDescription', {
      defaultMessage: 'Rank features that correlate negatively with the score should disable this field.'
    }),
    formFieldPath: "positive_score_impact"
  }));
};
exports.RankFeatureType = RankFeatureType;