"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.test = void 0;
exports.useDatastreamsRollover = useDatastreamsRollover;
var _react = _interopRequireWildcard(require("react"));
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _component_templates_context = require("../../component_templates_context");
var _mappings_datastreams_rollover_modal = require("./mappings_datastreams_rollover_modal");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const test = exports.test = {};
function useDatastreamsRollover() {
  const {
    api,
    startServices
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const showDatastreamRolloverModal = (0, _react.useCallback)(async componentTemplateName => {
    var _dataStreamResponse$d;
    const {
      data: dataStreamResponse
    } = await api.getComponentTemplateDatastreams(componentTemplateName);
    const dataStreams = (_dataStreamResponse$d = dataStreamResponse === null || dataStreamResponse === void 0 ? void 0 : dataStreamResponse.data_streams) !== null && _dataStreamResponse$d !== void 0 ? _dataStreamResponse$d : [];
    const dataStreamsToRollover = [];
    for (const dataStream of dataStreams) {
      try {
        const {
          error: applyMappingError
        } = await api.postDataStreamMappingsFromTemplate(dataStream);
        if (applyMappingError) {
          throw applyMappingError;
        }
      } catch (err) {
        dataStreamsToRollover.push(dataStream);
      }
    }
    if (dataStreamsToRollover.length) {
      const {
        overlays,
        ...mountServices
      } = startServices;
      const ref = overlays.openModal((0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_mappings_datastreams_rollover_modal.MappingsDatastreamRolloverModal, {
        componentTemplatename: componentTemplateName,
        dataStreams: dataStreamsToRollover,
        api: api,
        onClose: () => {
          ref.close();
        }
      }), mountServices));
      await ref.onClose;
    }
  }, [api, startServices]);
  return {
    showDatastreamRolloverModal
  };
}