"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterListButton = FilterListButton;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function FilterListButton({
  onChange,
  filters
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const activeFilters = Object.values(filters).filter(v => v.checked === 'on');
  const onButtonClick = () => {
    setIsPopoverOpen(!isPopoverOpen);
  };
  const closePopover = () => {
    setIsPopoverOpen(false);
  };
  const toggleFilter = filter => {
    const previousValue = filters[filter].checked;
    const nextValue = previousValue === 'on' ? 'off' : 'on';
    onChange({
      ...filters,
      [filter]: {
        ...filters[filter],
        checked: nextValue
      }
    });
  };
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    iconType: "arrowDown",
    onClick: onButtonClick,
    isSelected: isPopoverOpen,
    numFilters: Object.keys(filters).length,
    hasActiveFilters: activeFilters.length > 0,
    numActiveFilters: activeFilters.length,
    "data-test-subj": "filterButton"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.indexTemplatesList.filterButtonLabel",
    defaultMessage: "Filter"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    className: "componentTemplates__filterListButton"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    "data-test-subj": "filterList"
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "eui-yScroll",
    css: {
      maxHeight: euiTheme.base * 30
    }
  }, Object.entries(filters).map(([filter, item], index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFilterSelectItem, {
    checked: item.checked,
    key: index,
    onClick: () => toggleFilter(filter),
    "data-test-subj": "filterItem"
  }, item.name)))));
}