"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serializeAsESPolicy = exports.getPolicyType = exports.getESPolicyCreationApiCall = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPolicyType = policy => {
  if (policy.config.match) {
    return 'match';
  }
  if (policy.config.geo_match) {
    return 'geo_match';
  }
  if (policy.config.range) {
    return 'range';
  }
  throw new Error('Unknown policy type');
};
exports.getPolicyType = getPolicyType;
const getESPolicyCreationApiCall = policyName => {
  return `PUT _enrich/policy/${policyName}`;
};
exports.getESPolicyCreationApiCall = getESPolicyCreationApiCall;
const serializeAsESPolicy = policy => {
  const policyType = policy.type;
  return {
    [policyType]: {
      indices: policy.sourceIndices,
      match_field: policy.matchField,
      enrich_fields: policy.enrichFields,
      query: policy.query
    }
  };
};
exports.serializeAsESPolicy = serializeAsESPolicy;