"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditPolicy = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _unsavedChangesPrompt = require("@kbn/unsaved-changes-prompt");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
require("./edit_policy.scss");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _navigation = require("../../services/navigation");
var _form = require("./form");
var _save_policy = require("./save_policy");
var _components = require("./components");
var _edit_policy_context = require("./edit_policy_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const policyNamePath = 'name';
const EditPolicy = () => {
  (0, _react.useEffect)(() => {
    window.scrollTo(0, 0);
  }, []);
  const [isShowingPolicyJsonFlyout, setIsShowingPolicyJsonFlyout] = (0, _react.useState)(false);
  const {
    isNewPolicy,
    policy: currentPolicy,
    existingPolicies,
    policyName,
    license
  } = (0, _edit_policy_context.useEditPolicyContext)();
  const {
    services: {
      cloud,
      docLinks,
      history,
      navigateToUrl,
      overlays,
      http
    }
  } = (0, _shared_imports.useKibana)();
  const [isClonedPolicy, setIsClonedPolicy] = (0, _react.useState)(false);
  const [hasSubmittedForm, setHasSubmittedForm] = (0, _react.useState)(false);
  const originalPolicyName = isNewPolicy ? '' : policyName;
  const isAllowedByLicense = license.canUseSearchableSnapshot();
  const isCloudEnabled = Boolean(cloud === null || cloud === void 0 ? void 0 : cloud.isCloudEnabled);
  const serializer = (0, _react.useMemo)(() => {
    return (0, _form.createSerializer)(isNewPolicy ? undefined : currentPolicy);
  }, [isNewPolicy, currentPolicy]);
  const deserializer = (0, _react.useMemo)(() => {
    return (0, _form.createDeserializer)(isCloudEnabled);
  }, [isCloudEnabled]);
  const defaultValue = (0, _react.useMemo)(() => ({
    ...currentPolicy,
    name: originalPolicyName
  }), [currentPolicy, originalPolicyName]);
  const schema = (0, _react.useMemo)(() => {
    return (0, _form.getSchema)(isCloudEnabled);
  }, [isCloudEnabled]);
  const {
    form
  } = (0, _shared_imports.useForm)({
    schema,
    defaultValue,
    deserializer,
    serializer
  });
  const [formData] = (0, _shared_imports.useFormData)({
    form,
    watch: policyNamePath
  });
  const isFormDirty = (0, _shared_imports.useFormIsModified)({
    form
  });
  const getPolicyName = () => {
    return isNewPolicy || isClonedPolicy ? (0, _lodash.get)(formData, policyNamePath) : originalPolicyName;
  };
  const policyNameValidations = (0, _react.useMemo)(() => (0, _form.createPolicyNameValidations)({
    originalPolicyName,
    policies: existingPolicies,
    isClonedPolicy
  }), [originalPolicyName, existingPolicies, isClonedPolicy]);
  const backToPolicyList = name => {
    const url = name ? (0, _navigation.getPolicyViewPath)(name) : (0, _navigation.getPoliciesListPath)();
    history.push(url);
  };
  const submit = async () => {
    const {
      data: policy,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const name = getPolicyName();
    setHasSubmittedForm(true);
    const success = await (0, _save_policy.savePolicy)({
      ...policy,
      name
    }, isNewPolicy || isClonedPolicy);
    if (success) {
      backToPolicyList(name);
    }
  };
  const togglePolicyJsonFlyout = () => {
    setIsShowingPolicyJsonFlyout(!isShowingPolicyJsonFlyout);
  };
  (0, _unsavedChangesPrompt.useUnsavedChangesPrompt)({
    titleText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.unsavedPrompt.title', {
      defaultMessage: 'Exit without saving changes?'
    }),
    messageText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.unsavedPrompt.body', {
      defaultMessage: 'The data will be lost if you leave this page without saving the policy changes.'
    }),
    hasUnsavedChanges: isFormDirty && hasSubmittedForm === false,
    openConfirm: overlays.openConfirm,
    history,
    http,
    navigateToUrl
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "policyTitle"
    }, isNewPolicy ? _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.createPolicyMessage', {
      defaultMessage: 'Create policy'
    }) : _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.editPolicyMessage', {
      defaultMessage: 'Edit policy {originalPolicyName}',
      values: {
        originalPolicyName
      }
    })),
    bottomBorder: true,
    rightSideItems: [/*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      href: docLinks.links.elasticsearch.ilm,
      target: "_blank",
      iconType: "help"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.documentationLinkText",
      defaultMessage: "Documentation"
    }))]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_form.Form, {
    form: form
  }, isNewPolicy ? null : /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_components.EditWarning, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    "data-test-subj": "saveAsNewSwitch",
    style: {
      maxWidth: '100%'
    },
    checked: isClonedPolicy,
    onChange: e => {
      setIsClonedPolicy(e.target.checked);
    },
    label: /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.saveAsNewPolicyMessage",
      defaultMessage: "Save as new policy"
    }))
  }))), isClonedPolicy || isNewPolicy ? /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: policyNamePath,
    config: {
      label: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.policyNameLabel', {
        defaultMessage: 'Policy name'
      }),
      helpText: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.validPolicyNameMessage', {
        defaultMessage: 'A policy name cannot start with an underscore and cannot contain a comma or a space.'
      }),
      validations: policyNameValidations
    },
    component: _shared_imports.TextField,
    componentProps: {
      fullWidth: false,
      euiFieldProps: {
        'data-test-subj': 'policyNameField'
      }
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_components.Timeline, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTimeline, {
    className: "ilmPhases"
  }, /*#__PURE__*/_react.default.createElement(_components.HotPhase, null), /*#__PURE__*/_react.default.createElement(_components.WarmPhase, null), /*#__PURE__*/_react.default.createElement(_components.ColdPhase, null), isAllowedByLicense && /*#__PURE__*/_react.default.createElement(_components.FrozenPhase, null), /*#__PURE__*/_react.default.createElement(_components.DeletePhase, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_components.FormErrorsCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "savePolicyButton",
    fill: true,
    iconType: "check",
    iconSide: "left",
    disabled: form.isValid === false || form.isSubmitting,
    onClick: submit
  }, isClonedPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.saveAsNewButton",
    defaultMessage: "Save as new policy"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.saveButton",
    defaultMessage: "Save policy"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "cancelTestPolicy",
    onClick: () => backToPolicyList()
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.cancelButton",
    defaultMessage: "Cancel"
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: togglePolicyJsonFlyout,
    "data-test-subj": "requestButton"
  }, isShowingPolicyJsonFlyout ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.hidePolicyJsonButton",
    defaultMessage: "Hide request"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.showPolicyJsonButton",
    defaultMessage: "Show request"
  })))), isShowingPolicyJsonFlyout ? /*#__PURE__*/_react.default.createElement(_components.PolicyJsonFlyout, {
    policyName: getPolicyName(),
    close: () => setIsShowingPolicyJsonFlyout(false)
  }) : null));
};
exports.EditPolicy = EditPolicy;