/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
(self.fleet_bundle_jsonpfunction=self.fleet_bundle_jsonpfunction||[]).push([[248],{80382:(e,t,a)=>{"use strict";a.r(t),a.d(t,{ALLOWED_JOB_CONTENT_TYPES:()=>s,AuthenticationExpiredError:()=>AuthenticationExpiredError,BrowserCouldNotLaunchError:()=>BrowserCouldNotLaunchError,BrowserScreenshotError:()=>BrowserScreenshotError,BrowserUnexpectedlyClosedError:()=>BrowserUnexpectedlyClosedError,CancellationToken:()=>CancellationToken,DisallowedOutgoingUrl:()=>DisallowedOutgoingUrl,ILM_POLICY_NAME:()=>h,INTERNAL_ROUTES:()=>A,InvalidLayoutParametersError:()=>InvalidLayoutParametersError,JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY:()=>p,JOB_STATUS:()=>E,KibanaShuttingDownError:()=>KibanaShuttingDownError,LICENSE_TYPE_BASIC:()=>r,LICENSE_TYPE_CLOUD_STANDARD:()=>u,LICENSE_TYPE_ENTERPRISE:()=>g,LICENSE_TYPE_GOLD:()=>d,LICENSE_TYPE_PLATINUM:()=>c,LICENSE_TYPE_TRIAL:()=>o,PUBLIC_ROUTES:()=>_,PdfWorkerOutOfMemoryError:()=>PdfWorkerOutOfMemoryError,QueueTimeoutError:()=>QueueTimeoutError,REPORTING_MANAGEMENT_HOME:()=>x,REPORTING_REDIRECT_APP:()=>f,REPORTING_REDIRECT_LOCATOR_STORE_KEY:()=>m,REPORT_TABLE_ID:()=>y,REPORT_TABLE_ROW_ID:()=>k,ReportingError:()=>ReportingError,ReportingSavedObjectNotFoundError:()=>ReportingSavedObjectNotFoundError,UI_SETTINGS_CUSTOM_PDF_LOGO:()=>n,UI_SETTINGS_DATEFORMAT_TZ:()=>i,UI_SETTINGS_SEARCH_INCLUDE_FROZEN:()=>l,UnknownError:()=>UnknownError,VisualReportingSoftDisabledError:()=>VisualReportingSoftDisabledError,buildKibanaPath:()=>w,byteSizeValueToNumber:()=>I,durationToNumber:()=>S,numberToDuration:()=>F});const s=["application/json","application/pdf","text/csv","image/png","text/plain"],l="search:includeFrozen",n="xpackReporting:customPdfLogo",i="dateFormat:tz",o="trial",r="basic",u="standard",d="gold",c="platinum",g="enterprise",p="xpack.reporting.jobCompletionNotifications",f="/app/reportingRedirect",m="__REPORTING_REDIRECT_LOCATOR_STORE_KEY__",x="/app/management/insightsAndAlerting/reporting",h="kibana-reporting";let E=function(e){return e.PENDING="pending",e.PROCESSING="processing",e.COMPLETED="completed",e.FAILED="failed",e.WARNINGS="completed_with_warnings",e}({});const y="reportJobListing",k="reportJobRow";var v=a(68915),j=a(75008);class ReportingError extends Error{constructor(e){super(),this.details=e}get message(){const e="ReportingError";return this.details?`${e}(code: ${this.code}) "${this.details}"`:`${e}(code: ${this.code})`}toString(){return this.message}}class InvalidLayoutParametersError extends ReportingError{get code(){return InvalidLayoutParametersError.code}}(0,v.default)(InvalidLayoutParametersError,"code","invalid_layout_parameters_error");class DisallowedOutgoingUrl extends ReportingError{get code(){return DisallowedOutgoingUrl.code}}(0,v.default)(DisallowedOutgoingUrl,"code","disallowed_outgoing_url_error");class AuthenticationExpiredError extends ReportingError{get code(){return AuthenticationExpiredError.code}}(0,v.default)(AuthenticationExpiredError,"code","authentication_expired_error");class QueueTimeoutError extends ReportingError{get code(){return QueueTimeoutError.code}}(0,v.default)(QueueTimeoutError,"code","queue_timeout_error");class UnknownError extends ReportingError{get code(){return UnknownError.code}}(0,v.default)(UnknownError,"code","unknown_error");class PdfWorkerOutOfMemoryError extends ReportingError{get code(){return PdfWorkerOutOfMemoryError.code}humanFriendlyMessage(){return j.i18n.translate("reporting.common.pdfWorkerOutOfMemoryErrorMessage",{defaultMessage:"Can't generate a PDF due to insufficient memory. Try making a smaller PDF and retrying this report."})}}(0,v.default)(PdfWorkerOutOfMemoryError,"code","pdf_worker_out_of_memory_error");class BrowserCouldNotLaunchError extends ReportingError{get code(){return BrowserCouldNotLaunchError.code}humanFriendlyMessage(){return j.i18n.translate("reporting.common.browserCouldNotLaunchErrorMessage",{defaultMessage:"Can't generate screenshots because the browser did not launch. See the server logs for more information."})}}(0,v.default)(BrowserCouldNotLaunchError,"code","browser_could_not_launch_error");class BrowserUnexpectedlyClosedError extends ReportingError{get code(){return BrowserUnexpectedlyClosedError.code}}(0,v.default)(BrowserUnexpectedlyClosedError,"code","browser_unexpectedly_closed_error");class BrowserScreenshotError extends ReportingError{get code(){return BrowserScreenshotError.code}}(0,v.default)(BrowserScreenshotError,"code","browser_screenshot_error");class KibanaShuttingDownError extends ReportingError{get code(){return KibanaShuttingDownError.code}}(0,v.default)(KibanaShuttingDownError,"code","kibana_shutting_down_error");class VisualReportingSoftDisabledError extends ReportingError{get code(){return VisualReportingSoftDisabledError.code}humanFriendlyMessage(){return j.i18n.translate("reporting.common.cloud.insufficientSystemMemoryError",{defaultMessage:"Can't generate this report due to insufficient memory."})}}(0,v.default)(VisualReportingSoftDisabledError,"code","visual_reporting_soft_disabled_error");class ReportingSavedObjectNotFoundError extends ReportingError{get code(){return ReportingSavedObjectNotFoundError.code}}(0,v.default)(ReportingSavedObjectNotFoundError,"code","reporting_saved_object_not_found_error");var b=a(51783),M=a.n(b);const S=e=>"number"==typeof e?e:e.asMilliseconds(),F=e=>"number"==typeof e?M().duration(e,"milliseconds"):e,I=e=>"number"==typeof e?e:e.getValueInBytes();var T=a(30770);class CancellationToken{constructor(){(0,v.default)(this,"_isCancelled",void 0),(0,v.default)(this,"_callbacks",void 0),(0,v.default)(this,"on",(e=>{if(!(0,T.isFunction)(e))throw new Error("Expected callback to be a function");this._isCancelled?e():this._callbacks.push(e)})),(0,v.default)(this,"cancel",(()=>{this._isCancelled=!0,this._callbacks.forEach((e=>e()))})),this._isCancelled=!1,this._callbacks=[]}isCancelled(){return this._isCancelled}}const w=({basePath:e,appPath:t,spaceId:a})=>void 0===a||"default"===a.toLowerCase()?`${e}${t}`:`${e}/s/${a}${t}`,C="/internal/reporting",A={MIGRATE:{MIGRATE_ILM_POLICY:C+"/deprecations/migrate_ilm_policy",GET_ILM_POLICY_STATUS:C+"/ilm_policy_status"},DIAGNOSE:{BROWSER:C+"/diagnose/browser",SCREENSHOT:C+"/diagnose/screenshot"},JOBS:{COUNT:C+"/jobs/count",LIST:C+"/jobs/list",INFO_PREFIX:C+"/jobs/info",DELETE_PREFIX:C+"/jobs/delete",DOWNLOAD_PREFIX:C+"/jobs/download"},GENERATE_PREFIX:C+"/generate"},P="/api/reporting",_={GENERATE_PREFIX:P+"/generate",JOBS:{DOWNLOAD_PREFIX:P+"/jobs/download",DELETE_PREFIX:P+"/jobs/delete"}}},34127:(e,t,a)=>{"use strict";a.r(t),a.d(t,{InternalApiClientProvider:()=>k,Job:()=>Job,ReportingAPIClient:()=>ReportingAPIClient,checkLicense:()=>w,jobCompletionNotifications:()=>E,useCheckIlmPolicyStatus:()=>b,useInternalApiClient:()=>v,useKibana:()=>A});var s=a(68915),l=a(51783),n=a.n(l),i=a(84286),o=a.n(i),r=a(81319),u=a(75008),d=a(80382),c=a(96791);const{COMPLETED:g,FAILED:p,PENDING:f,PROCESSING:m,WARNINGS:x}=d.JOB_STATUS;class Job{constructor(e){var t,a,l,n,i,o;(0,s.default)(this,"payload",void 0),(0,s.default)(this,"id",void 0),(0,s.default)(this,"index",void 0),(0,s.default)(this,"objectType",void 0),(0,s.default)(this,"title",void 0),(0,s.default)(this,"isDeprecated",void 0),(0,s.default)(this,"spaceId",void 0),(0,s.default)(this,"browserTimezone",void 0),(0,s.default)(this,"layout",void 0),(0,s.default)(this,"pagingStrategy",void 0),(0,s.default)(this,"version",void 0),(0,s.default)(this,"jobtype",void 0),(0,s.default)(this,"created_by",void 0),(0,s.default)(this,"created_at",void 0),(0,s.default)(this,"started_at",void 0),(0,s.default)(this,"completed_at",void 0),(0,s.default)(this,"status",void 0),(0,s.default)(this,"attempts",void 0),(0,s.default)(this,"max_attempts",void 0),(0,s.default)(this,"timeout",void 0),(0,s.default)(this,"kibana_name",void 0),(0,s.default)(this,"kibana_id",void 0),(0,s.default)(this,"size",void 0),(0,s.default)(this,"content_type",void 0),(0,s.default)(this,"csv_contains_formulas",void 0),(0,s.default)(this,"max_size_reached",void 0),(0,s.default)(this,"metrics",void 0),(0,s.default)(this,"warnings",void 0),(0,s.default)(this,"error_code",void 0),(0,s.default)(this,"locatorParams",void 0),(0,s.default)(this,"queue_time_ms",void 0),(0,s.default)(this,"execution_time_ms",void 0),this.id=e.id,this.index=e.index,this.payload=e.payload,this.jobtype=e.jobtype,this.objectType=e.payload.objectType,this.title=e.payload.title,this.layout=e.payload.layout,this.pagingStrategy=e.payload.pagingStrategy,this.version=e.payload.version,this.created_by=e.created_by,this.created_at=e.created_at,this.started_at=e.started_at,this.completed_at=e.completed_at,this.status=e.status,this.attempts=e.attempts,this.max_attempts=e.max_attempts,this.timeout=e.timeout,this.kibana_name=e.kibana_name,this.kibana_id=e.kibana_id,this.browserTimezone=e.payload.browserTimezone,this.size=null===(t=e.output)||void 0===t?void 0:t.size,this.content_type=null===(a=e.output)||void 0===a?void 0:a.content_type,this.isDeprecated=e.payload.isDeprecated||!1,this.spaceId=e.payload.spaceId,this.csv_contains_formulas=null===(l=e.output)||void 0===l?void 0:l.csv_contains_formulas,this.max_size_reached=null===(n=e.output)||void 0===n?void 0:n.max_size_reached,this.warnings=null===(i=e.output)||void 0===i?void 0:i.warnings,this.error_code=null===(o=e.output)||void 0===o?void 0:o.error_code,this.locatorParams=e.payload.locatorParams,this.metrics=e.metrics,this.queue_time_ms=e.queue_time_ms,this.execution_time_ms=e.execution_time_ms}isSearch(){return"search"===this.objectType}getStatusMessage(){const e=this.status;let t,a;return e===f?t=u.i18n.translate("reporting.jobStatusDetail.pendingStatusReachedText",{defaultMessage:"Waiting for job to process."}):e===m?t=u.i18n.translate("reporting.jobStatusDetail.attemptXofY",{defaultMessage:"Attempt {attempts} of {max_attempts}.",values:{attempts:this.attempts,max_attempts:this.max_attempts}}):this.getWarnings()?t=u.i18n.translate("reporting.jobStatusDetail.warningsText",{defaultMessage:"See report info for warnings."}):this.getError()&&(t=u.i18n.translate("reporting.jobStatusDetail.errorText",{defaultMessage:"See report info for error details."})),this.isDeprecated&&(a=(0,c.jsx)(r.EuiText,{size:"s"}," ",(0,c.jsx)(r.EuiTextColor,{color:"warning"},u.i18n.translate("reporting.jobStatusDetail.deprecatedText",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})))),t?(0,c.jsx)(o().Fragment,null,(0,c.jsx)(r.EuiText,{size:"s"},(0,c.jsx)(r.EuiTextColor,{color:"subdued"},t)),a||null):null}get prettyStatus(){var e;return null!==(e=h.get(this.status))&&void 0!==e?e:u.i18n.translate("reporting.jobStatusDetail.unknownText",{defaultMessage:"Unknown"})}get canLinkToKibanaApp(){return Boolean(this.locatorParams)}get isDownloadReady(){return this.status===d.JOB_STATUS.COMPLETED||this.status===d.JOB_STATUS.WARNINGS}get prettyJobTypeName(){switch(this.jobtype){case"printable_pdf":case"printable_pdf_v2":return u.i18n.translate("reporting.jobType.pdfOutputName",{defaultMessage:"PDF"});case"PNG":case"PNGV2":return u.i18n.translate("reporting.jobType.pngOutputName",{defaultMessage:"PNG"});case"csv_v2":case"csv_searchsource":return u.i18n.translate("reporting.jobType.csvOutputName",{defaultMessage:"CSV"});default:return}}get prettyTimeout(){if(null==this.timeout)return u.i18n.translate("reporting.jobStatusDetail.timeoutSecondsUnknown",{defaultMessage:"Unknown"});const e=this.timeout/1e3;return u.i18n.translate("reporting.jobStatusDetail.timeoutSeconds",{defaultMessage:"{timeout} seconds",values:{timeout:e}})}getCreatedAtDate(){return this.formatDate(this.created_at)}getCreatedBy(){return this.created_by||u.i18n.translate("reporting.jobCreatedBy.unknownUserPlaceholderText",{defaultMessage:"Unknown"})}getCreatedAtLabel(){return this.created_by?(0,c.jsx)(o().Fragment,null,(0,c.jsx)("div",null,this.formatDate(this.created_at)),(0,c.jsx)("span",null,this.created_by)):this.formatDate(this.created_at)}getError(){if(this.status===p)return this.warnings}getDeprecatedMessage(){if(this.isDeprecated)return u.i18n.translate("reporting.jobWarning.exportTypeDeprecated",{defaultMessage:"This is a deprecated export type. Automation of this report will need to be re-created for compatibility with future versions of Kibana."})}getWarnings(){var e;const t=[],a=this.getDeprecatedMessage();if(a&&t.push(a),this.csv_contains_formulas&&t.push(u.i18n.translate("reporting.jobWarning.csvContainsFormulas",{defaultMessage:"Your CSV contains characters that spreadsheet applications might interpret as formulas."})),this.max_size_reached&&t.push(u.i18n.translate("reporting.jobWarning.maxSizeReachedTooltip",{defaultMessage:"Your search reached the max size and contains partial data."})),this.status!==p&&null!==(e=this.warnings)&&void 0!==e&&e.length&&t.push(...this.warnings),t.length)return(0,c.jsx)("ul",null,t.map(((e,t)=>(0,c.jsx)("li",{key:`warning-key-${t}`},e))))}getPrettyStatusTimestamp(){return this.formatDate(this.getStatusTimestamp())}formatDate(e){try{return n()(e).format("YYYY-MM-DD @ hh:mm A")}catch(t){return e}}getStatusTimestamp(){const e=this.status;return e===m&&this.started_at?this.started_at:this.completed_at&&[g,p,x].includes(e)?this.completed_at:this.created_at}}const h=new Map([[f,u.i18n.translate("reporting.jobStatuses.pendingText",{defaultMessage:"Pending"})],[m,u.i18n.translate("reporting.jobStatuses.processingText",{defaultMessage:"Processing"})],[g,u.i18n.translate("reporting.jobStatuses.completedText",{defaultMessage:"Completed"})],[x,u.i18n.translate("reporting.jobStatuses.warningText",{defaultMessage:"Completed"})],[p,u.i18n.translate("reporting.jobStatuses.failedText",{defaultMessage:"Failed"})]]);function E(){return{getPendingJobIds:function(){const e=[];for(const t in localStorage)if(0===t.indexOf(d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY)){const a=t.replace(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-`,"");e.push(a)}return e},addPendingJobId:function(e){localStorage.setItem(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-${e}`,e)},setPendingJobIds:function(e){for(const e in localStorage)0===e.indexOf(d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY)&&localStorage.removeItem(e);for(let t=0;t<e.length;t++){const a=e[t];localStorage.setItem(`${d.JOB_COMPLETION_NOTIFICATIONS_SESSION_KEY}-${a}`,a)}}}}const y=(0,i.createContext)(void 0),k=({apiClient:e,http:t,children:a})=>(0,c.jsx)(y.Provider,{value:{http:t,apiClient:e}},a),v=()=>{const e=(0,i.useContext)(y);if(!e)throw new Error('"useInternalApiClient" can only be used inside of "InternalApiClientContext"');return e};var j=a(18744);const b=()=>{const{services:{http:e}}=A();return(0,j.useRequest)(e,{path:d.INTERNAL_ROUTES.MIGRATE.GET_ILM_POLICY_STATUS,method:"get"})};var M=a(47400),S=a(45995),F=a.n(S),I=a(20151),T=a(43721);class ReportingAPIClient{constructor(e,t,a){(0,s.default)(this,"http",void 0),(0,s.default)(this,"addPendingJobId",E().addPendingJobId),(0,s.default)(this,"getManagementLink",(()=>this.http.basePath.prepend(d.REPORTING_MANAGEMENT_HOME))),(0,s.default)(this,"getDownloadLink",(e=>this.getReportURL(e))),(0,s.default)(this,"getServerBasePath",(()=>this.http.basePath.serverBasePath)),this.uiSettings=t,this.kibanaVersion=a,this.http=e}getKibanaAppHref(e){const t=(0,I.stringify)({jobId:e.id});return`${(0,d.buildKibanaPath)({basePath:this.http.basePath.serverBasePath,spaceId:e.spaceId,appPath:d.REPORTING_REDIRECT_APP})}?${t}`}getReportURL(e){return this.http.basePath.prepend(`${d.INTERNAL_ROUTES.JOBS.DOWNLOAD_PREFIX}/${e}?${M.SX}=true`)}downloadReport(e){const t=this.getReportURL(e);window.open(t)}async deleteReport(e){return await this.http.delete(`${d.INTERNAL_ROUTES.JOBS.DELETE_PREFIX}/${e}`)}async list(e=0,t=[]){const a={page:e};return t.length>0&&(a.ids=t.slice(0,10).join(",")),(await this.http.get(d.INTERNAL_ROUTES.JOBS.LIST,{query:a,asSystemRequest:!0})).map((e=>new Job(e)))}async total(){return await this.http.get(d.INTERNAL_ROUTES.JOBS.COUNT,{asSystemRequest:!0})}async getError(e){var t;const a=await this.getInfo(e);return null!==(t=a.warnings)&&void 0!==t&&t[0]?a.warnings[0]:u.i18n.translate("reporting.apiClient.unknownError",{defaultMessage:"Report job {job} failed. Error unknown.",values:{job:e}})}async getInfo(e){const t=await this.http.get(`${d.INTERNAL_ROUTES.JOBS.INFO_PREFIX}/${e}`);return new Job(t)}async findForJobIds(e){return(await this.http.fetch(d.INTERNAL_ROUTES.JOBS.LIST,{query:{page:0,ids:e.join(",")},method:"GET"})).map((e=>new Job(e)))}getReportingPublicJobPath(e,t){const a=(0,I.stringify)({jobParams:F().encode(t)});return`${this.http.basePath.prepend(d.PUBLIC_ROUTES.GENERATE_PREFIX)}/${e}?${a}`}async createReportingShareJob(e,t){const a=F().encode(t),s=await this.http.post(`${d.INTERNAL_ROUTES.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:a})});if(null!=s&&s.job)return this.addPendingJobId(s.job.id),new Job(s.job)}async createReportingJob(e,t){const a=F().encode(t);try{const t=await this.http.post(`${d.INTERNAL_ROUTES.GENERATE_PREFIX}/${e}`,{method:"POST",body:JSON.stringify({jobParams:a})});if(null!=t&&t.job)return this.addPendingJobId(t.job.id),new Job(t.job)}catch(e){var s;throw T.error(e),new Error(`${null===(s=e.body)||void 0===s?void 0:s.message}`)}}getDecoratedJobParams(e){return{browserTimezone:"Browser"===this.uiSettings.get("dateFormat:tz")?n().tz.guess():this.uiSettings.get("dateFormat:tz"),version:this.kibanaVersion,...e}}verifyBrowser(){return this.http.get(d.INTERNAL_ROUTES.DIAGNOSE.BROWSER)}verifyScreenCapture(){return this.http.post(d.INTERNAL_ROUTES.DIAGNOSE.SCREENSHOT)}migrateReportingIndicesIlmPolicy(){return this.http.put(d.INTERNAL_ROUTES.MIGRATE.MIGRATE_ILM_POLICY)}}const w=e=>{switch(e.state){case"valid":default:return{showLinks:!0,enableLinks:!0,message:""};case"invalid":return{showLinks:!1,enableLinks:!1,message:"Your license does not support Reporting. Please upgrade your license."};case"unavailable":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because license information is not available at this time."};case"expired":return{showLinks:!0,enableLinks:!1,message:"You cannot use Reporting because your license has expired."}}};var C=a(20409);const A=()=>(0,C.useKibana)()},18248:(e,t,a)=>{"use strict";a.d(t,{renderApp:()=>xi,teardownFleet:()=>hi});var s=a(84286),l=a.n(s),n=a(22874),i=a.n(n),o=a(1493),r=a(30193),u=a(51155),d=a(3185),c=a(81319),g=a(20482),p=a(75879),f=a(75008),m=a(77880),x=a(13530),h=a(45692),E=a(44081),y=a(20409),k=a(15006),v=a(52137),j=a(13528),b=a(26333),M=a(66720),S=a(42413),F=a(42398),I=a(7975),T=a(99132),w=a(3138),C=a(26768),A=a.n(C),P=a(46787),_=a(83424);const L=A()(c.EuiFlyout).withConfig({displayName:"FlyoutWithHigherZIndex",componentId:"sc-1pwanx7-0"})(["z-index:",";"],(e=>e.theme.eui.euiZLevel5)),D=({onClose:e,as:t,...a})=>{const{notifications:n}=(0,u.WeA)(),i=(0,u.iO7)().fleet.allAgentPolicies,o=(0,b.I)(),[r,g]=(0,s.useState)((0,_.b)({namespace:o.defaultNamespace})),[m,x]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!0),y=(0,w.FS)(r,{allowedNamespacePrefixes:null==o?void 0:o.allowedNamespacePrefixes}),[k,v]=(0,s.useState)(!1),[j,F]=(0,s.useState)(!1),I=l().createElement(c.EuiFlyoutHeader,{hasBorder:!0,"aria-labelledby":"CreateAgentPolicyFlyoutTitle"},l().createElement(c.EuiTitle,{size:"m"},l().createElement("h2",{id:"CreateAgentPolicyFlyoutTitle","data-test-subj":"createAgentPolicyFlyoutTitle"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.flyoutTitle",defaultMessage:"Create agent policy"}))),l().createElement(c.EuiSpacer,{size:"m"}),l().createElement(c.EuiText,{size:"s"},l().createElement("p",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.flyoutTitleDescription",defaultMessage:"Agent policies are used to manage settings across a group of agents. You can add integrations to your agent policy to specify what data your agents collect. When you edit an agent policy, you can use Fleet to deploy updates to a specified group of agents."})))),T=l().createElement(c.EuiFlyoutBody,null,l().createElement(w.Kb,{agentPolicy:r,updateAgentPolicy:e=>{g({...r,...e})},withSysMonitoring:h,updateSysMonitoring:e=>E(e),validation:y,updateAdvancedSettingsHasErrors:v,setInvalidSpaceError:F})),C=(0,s.useMemo)((()=>(0,P.gF)(r,h)),[r,h]),A=l().createElement(c.EuiFlyoutFooter,null,l().createElement(c.EuiFlexGroup,{justifyContent:"spaceBetween"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.cancelButtonLabel",defaultMessage:"Cancel"}))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiFlexGroup,{gutterSize:"none"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(M.T_,{isDisabled:m||Object.keys(y).length>0||k||j,description:f.i18n.translate("xpack.fleet.createAgentPolicy.devtoolsRequestDescription",{defaultMessage:"This Kibana request creates a new agent policy."}),request:C})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButton,{fill:!0,isLoading:m,isDisabled:!i||m||Object.keys(y).length>0||k||j,onClick:async()=>{x(!0);try{const{data:t,error:a}=await(async()=>await(0,u.iF6)(r,{withSysMonitoring:h}))();x(!1),t?(n.toasts.addSuccess(f.i18n.translate("xpack.fleet.createAgentPolicy.successNotificationTitle",{defaultMessage:"Agent policy ''{name}'' created",values:{name:r.name}})),e(t.item)):n.toasts.addDanger(a?a.message:f.i18n.translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}catch(e){x(!1),n.toasts.addDanger(f.i18n.translate("xpack.fleet.createAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to create agent policy"}))}},"data-test-subj":"createAgentPolicyFlyoutBtn"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.createAgentPolicy.submitButtonLabel",defaultMessage:"Create agent policy"})))))));return l().createElement(L,(0,d.default)({onClose:()=>e()},a,{maxWidth:S.MW}),I,T,A)};var O=a(96791);const R=()=>{var e,t;const{isSpaceAwarenessEnabled:a}=(0,u.YI3)();(0,u.ifo)("policies_list");const{getPath:n}=(0,u.iEg)(),i=(0,u.iO7)().fleet.allAgentPolicies,{agents:{enabled:r}}=(0,u.UKg)(),{urlParams:d,toUrlParams:g}=(0,u.zmo)(),[m,x]=(0,s.useState)(Array.isArray(d.kuery)?d.kuery[d.kuery.length-1]:null!==(e=d.kuery)&&void 0!==e?e:""),{pagination:h,pageSizeOptions:E,setPagination:y}=(0,u.WQC)(),{sorting:k,setSorting:v}=(0,u.KEg)({field:"updated_at",direction:"desc"}),j=(0,o.useHistory)(),b="create"in d,F=(0,s.useCallback)((e=>{if(e!==b)if(e)j.push(`${n("policies_list")}?${g({...d,create:null})}`);else{const{create:e,...t}=d;j.push(`${n("policies_list")}?${g(t)}`)}}),[n,j,b,g,d]),{isLoading:C,data:A,refetch:P}=(0,u.BOQ)({page:h.currentPage,perPage:h.pageSize,sortField:null==k?void 0:k.field,sortOrder:null==k?void 0:k.direction,kuery:m,withAgentCount:!0,full:!0}),_=(0,s.useMemo)((()=>{const e=[{field:"name",sortable:!0,name:f.i18n.translate("xpack.fleet.agentPolicyList.nameColumnTitle",{defaultMessage:"Name"}),width:"35%",render:(e,t)=>(0,O.jsx)(T.an,{policy:t,withDescription:!0})},{field:"updated_at",sortable:!0,name:f.i18n.translate("xpack.fleet.agentPolicyList.updatedOnColumnTitle",{defaultMessage:"Last updated on"}),render:e=>(0,O.jsx)(p.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})},{field:"agents",name:f.i18n.translate("xpack.fleet.agentPolicyList.agentsColumnTitle",{defaultMessage:"Unprivileged / Privileged"}),dataType:"number",render:(e,t)=>(0,O.jsx)(c.EuiFlexGroup,{direction:"row",gutterSize:"xs",justifyContent:"flexEnd"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.unprivilegedAgentsTooltip",defaultMessage:"Unprivileged agents"})},(0,O.jsx)(w.Oy,{count:t.unprivileged_agents||0,agentPolicyId:t.id,showAgentText:!1,privilegeMode:"unprivileged"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},"/"),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.privilegedAgentsTooltip",defaultMessage:"Privileged agents"})},(0,O.jsx)(w.Oy,{count:e-(t.unprivileged_agents||0),agentPolicyId:t.id,showAgentText:!1,privilegeMode:"privileged"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)("span",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltipWrapper",defaultMessage:"({message})",values:{message:(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.totalAgentsTooltip",defaultMessage:"Total agents"})},(0,O.jsx)(w.Oy,{count:e,agentPolicyId:t.id,showAgentText:!1}))}}))),(0,I.uo)(t.package_policies||[]).length>0&&(t.unprivileged_agents||0)>0&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiIconTip,{type:"warning",color:"warning",content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.containsUnprivilegedAgentsWarning",defaultMessage:"This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."})})))},{field:"package_policies",name:f.i18n.translate("xpack.fleet.agentPolicyList.packagePoliciesCountColumnTitle",{defaultMessage:"Integrations"}),dataType:"number",render:e=>e?e.length:0},{field:"actions",name:f.i18n.translate("xpack.fleet.agentPolicyList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:e=>(0,O.jsx)(w.Nu,{agentPolicy:e,onCopySuccess:()=>P()})}]}];return r?e:e.filter((e=>!("field"in e)||"agents"!==e.field))}),[r,P]),L=(0,s.useMemo)((()=>(0,O.jsx)(c.EuiButton,{fill:!0,iconType:"plusInCircle",isDisabled:!i,onClick:()=>F(!0),"data-test-subj":"createAgentPolicyButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"}))),[i,F]),R=(0,s.useMemo)((()=>(0,O.jsx)(c.EuiButton,{fill:!0,iconType:"plusInCircle",isDisabled:!i,onClick:()=>F(!0),"data-test-subj":"emptyPromptCreateAgentPolicyButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.addButton",defaultMessage:"Create agent policy"}))),[i,F]),B=(0,s.useMemo)((()=>(0,O.jsx)(c.EuiEmptyPrompt,{title:(0,O.jsx)("h2",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.noAgentPoliciesPrompt",defaultMessage:"No agent policies"})),actions:R})),[R]);return(0,O.jsx)(l().Fragment,null,b?(0,O.jsx)(D,{onClose:()=>{F(!1),P()}}):null,(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",gutterSize:"m"},(0,O.jsx)(c.EuiFlexItem,{grow:4},(0,O.jsx)(M.IW,{value:m,indexPattern:S.yb,fieldPrefix:a?S.ke:S.mm,onChange:e=>{y({...h,currentPage:1}),x(e)},dataTestSubj:"agentPolicyList.queryInput"})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{color:"primary",iconType:"refresh",onClick:()=>P()},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.reloadAgentPoliciesButtonText",defaultMessage:"Reload"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},L)),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiBasicTable,{loading:C,"data-test-subj":"agentPoliciesTable",noItemsMessage:C?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.loadingAgentPoliciesMessage",defaultMessage:"Loading agent policies…"}):m.trim()||0!==(null!==(t=null==A?void 0:A.total)&&void 0!==t?t:0)?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.noFilteredAgentPoliciesPrompt",defaultMessage:"No agent policies found. {clearFiltersLink}",values:{clearFiltersLink:(0,O.jsx)(c.EuiLink,{onClick:()=>x("")},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):B,items:A?A.items:[],itemId:"id",columns:_,pagination:{pageIndex:h.currentPage-1,pageSize:h.pageSize,totalItemCount:A?A.total:0,pageSizeOptions:E},sorting:{sort:k},onChange:e=>{const t={...h,currentPage:e.page.index+1,pageSize:e.page.size};y(t),v(e.sort)}}))};var B=a(5850),N=a(46048),z=a(53684);const U=(e,t)=>e.localeCompare(t),H=e=>({name:e,value:e}),W=({packagePolicies:e,agentPolicy:t,...a})=>{var n,i;const{application:o}=(0,u.WeA)(),r=(0,u.iO7)(),g=r.integrations.writeIntegrationPolicies,m=r.fleet.readAgentPolicies,x=r.integrations.readIntegrationPolicies,{isPackagePolicyUpgradable:h}=(0,u.hhZ)(),{getHref:E}=(0,u.iEg)(),{canUseMultipleAgentPolicies:y}=(0,u.phy)(),k=(0,u.B6B)(),v=!(null!==(n=k.data)&&void 0!==n&&n.success)&&"MISSING_SECURITY"===(null===(i=k.data)||void 0===i?void 0:i.error),[j,b]=(0,s.useMemo)((()=>{const t=new Set;return[e.map((e=>{var a,s,l,n,i,o;e.namespace&&t.add(e.namespace);const r=h(e);return{...e,packageName:null!==(a=null===(s=e.package)||void 0===s?void 0:s.name)&&void 0!==a?a:"",packageTitle:null!==(l=null===(n=e.package)||void 0===n?void 0:n.title)&&void 0!==l?l:"",packageVersion:null!==(i=null===(o=e.package)||void 0===o?void 0:o.version)&&void 0!==i?i:"",hasUpgrade:r}})),[...t].sort(U).map(H)]}),[e,h]),S=(0,s.useCallback)((e=>e.policy_ids.length||0),[]),{data:F,isLoading:I}=(0,u.Eiq)(),{output:T}=(0,u.OmG)(),w=(0,s.useMemo)((()=>{var e;return(null!==(e=null==F?void 0:F.items)&&void 0!==e?e:[]).reduce(((e,t)=>(e[t.id]=t.name,e)),{})}),[F]),C=(0,s.useMemo)((()=>[{field:"name",sortable:!0,truncateText:!0,name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.nameColumnTitle",{defaultMessage:"Integration policy"}),width:"35%",render:(e,a)=>(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,{"data-test-subj":"PackagePoliciesTableName",grow:!1},(0,O.jsx)(c.EuiLink,(0,d.default)({title:e},x?{href:E("edit_integration",{policyId:t.id,packagePolicyId:a.id})}:{disabled:!0}),(0,O.jsx)("span",{className:"eui-textTruncate"},e),a.description?(0,O.jsx)("span",null," ",(0,O.jsx)(c.EuiToolTip,{content:a.description},(0,O.jsx)(c.EuiIcon,{type:"help"}))):null)),y&&m&&x&&S(a)>1&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.sharedTooltip",defaultMessage:"This integration is shared by {numberShared} agent policies",values:{numberShared:S(a)}})},(0,O.jsx)(c.EuiText,{"data-test-subj":"PackagePoliciesTableSharedLabel",color:"subdued",size:"xs",className:"eui-textNoWrap"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentPolicyList.agentsColumn.sharedText",defaultMessage:"Shared"})," ",(0,O.jsx)(c.EuiIcon,{type:"iInCircle"})))))},{field:"packageTitle",sortable:!0,name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.packageNameColumnTitle",{defaultMessage:"Integration"}),render:(e,a)=>(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,{"data-test-subj":"PackagePoliciesTableLink",grow:!1},(0,O.jsx)(c.EuiLink,{href:a.package&&E("integration_details_overview",{pkgkey:(0,z.Ku)(a.package)})},(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},a.package&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(M.qD,{packageName:a.package.name,version:a.package.version,size:"m",tryApi:!0})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},e),a.package&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiText,{color:"subdued",size:"xs",className:"eui-textNoWrap"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.packageVersion",defaultMessage:"v{version}",values:{version:a.package.version}})))))),a.hasUpgrade&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.upgradeAvailable",{defaultMessage:"Upgrade Available"})},(0,O.jsx)(c.EuiIcon,{type:"warning",color:"warning"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{"data-test-subj":"PackagePoliciesTableUpgradeButton",size:"s",minWidth:"0",isDisabled:!g,href:`${E("upgrade_package_policy",{policyId:t.id,packagePolicyId:a.id})}?from=fleet-policy-list`},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetails.packagePoliciesTable.upgradeButton",defaultMessage:"Upgrade"})))))},{field:"namespace",name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:e=>e?(0,O.jsx)(c.EuiBadge,{color:"hollow"},e):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiBadge,{color:"default"},t.namespace),(0,O.jsx)(c.EuiIconTip,{content:"Namespace defined in parent agent policy",position:"right",type:"iInCircle",color:"subdued"}))},{field:"output_id",name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputColumnTitle",{defaultMessage:"Output"}),render:e=>I?null:e?(0,O.jsx)(c.EuiBadge,{color:"hollow"},w[e]||e):t.data_output_id?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiBadge,{color:"default"},w[t.data_output_id]||t.data_output_id)," ",(0,O.jsx)(c.EuiIconTip,{content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputFromParentPolicyText",{defaultMessage:"Output defined in parent agent policy"}),position:"right",type:"iInCircle",color:"subdued"})):T?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiBadge,{color:"default"},w[T.id]||T.id)," ",(0,O.jsx)(c.EuiIconTip,{content:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.outputFromFleetSettingsText",{defaultMessage:"Output defined in Fleet settings"}),position:"right",type:"iInCircle",color:"subdued"})):void 0},{name:f.i18n.translate("xpack.fleet.policyDetails.packagePoliciesTable.actionsColumnTitle",{defaultMessage:"Actions"}),width:"70px",actions:[{render:e=>g?(0,O.jsx)(M.Py,{agentPolicies:[t],from:"fleet-policy-list",packagePolicy:e,upgradePackagePolicyHref:`${E("upgrade_package_policy",{policyId:t.id,packagePolicyId:e.id})}?from=fleet-policy-list`}):(0,O.jsx)(l().Fragment,null)}]}]),[x,E,t,y,m,S,g,I,T,w]);return(0,O.jsx)(c.EuiInMemoryTable,(0,d.default)({itemId:"id",items:j,columns:C,sorting:{sort:{field:"name",direction:"asc"}}},a,{search:{toolsRight:t.is_managed||t.supports_agentless?[]:[(0,O.jsx)(M.rj,{key:"addPackagePolicyButton",fill:!0,isDisabled:!g,iconType:"plusInCircle",onClick:()=>{o.navigateToApp(B.INTEGRATIONS_PLUGIN_ID,{path:N.tn.integrations_all({})[1],state:{forAgentPolicyId:t.id}})},"data-test-subj":"addPackagePolicyButton",tooltip:g?void 0:{content:v?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.epm.addPackagePolicyButtonSecurityRequiredTooltip",defaultMessage:"To add Elastic Agent Integrations, you must have security enabled and have the All privilege for Fleet. Contact your administrator."}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.epm.addPackagePolicyButtonPrivilegesRequiredTooltip",defaultMessage:"Elastic Agent Integrations require the All privilege for Agent policies and All privilege for Integrations. Contact your administrator."})}},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetails.addPackagePolicyButtonText",defaultMessage:"Add integration"}))],box:{incremental:!0,schema:!0},filters:[{type:"field_value_selection",field:"namespace",name:"Namespace",options:b,multiSelect:"or",operator:"exact"}]}}))},G=(0,s.memo)((({policyId:e})=>{const{application:t}=(0,u.WeA)(),a=(0,u.iO7)(),s=a.integrations.writeIntegrationPolicies&&a.fleet.allAgentPolicies;return(0,O.jsx)(c.EuiEmptyPrompt,{iconType:"plusInCircle",title:(0,O.jsx)("h3",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstTitle",defaultMessage:"Add your first integration"})),body:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstMessage",defaultMessage:"This policy does not have any integrations yet."}),actions:(0,O.jsx)(c.EuiButton,{iconType:"plusInCircle",isDisabled:!s,fill:!0,onClick:()=>t.navigateToApp(S.A7,{path:S.tn.integrations_all({})[1],state:{forAgentPolicyId:e}}),"data-test-subj":"addPackagePolicyButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetailsPackagePolicies.createFirstButtonText",defaultMessage:"Add integration"}))})})),q=(0,s.memo)((({agentPolicy:e})=>((0,u.ifo)("policy_details",{policyName:e.name}),e.package_policies&&0!==e.package_policies.length?(0,O.jsx)(W,{agentPolicy:e,packagePolicies:e.package_policies}):(0,O.jsx)(G,{policyId:e.id}))));var K=a(30770),V=a(21254),$=a(4408);const Y=e=>{var t;return{...(0,K.pick)(e,["name","description","namespace","monitoring_enabled","unenroll_timeout","inactivity_timeout","data_output_id","monitoring_output_id","download_source_id","fleet_server_host_id","agent_features","is_protected","advanced_settings","global_data_tags","monitoring_pprof_enabled","monitoring_http","monitoring_diagnostics"]),...!(null!==(t=e.space_ids)&&void 0!==t&&t.includes($.eWz))&&{space_ids:e.space_ids}}},Q=A().div.withConfig({displayName:"FormWrapper",componentId:"sc-1lbh22t-0"})(["max-width:1200px;margin-right:auto;margin-left:auto;"]),J=(0,s.memo)((({agentPolicy:e})=>{(0,u.ifo)("policy_details",{policyName:e.name});const{notifications:t}=(0,u.WeA)(),{spaceId:a}=(0,u.YI3)(),{agents:{enabled:n}}=(0,u.UKg)(),{getPath:i}=(0,u.iEg)(),r=(0,u.iO7)().fleet.allAgentPolicies,d=(0,u.gCF)(),[g,m]=(0,s.useState)({...e}),x=(0,o.useHistory)(),h=(0,b.I)(),[E,y]=(0,s.useState)(!1),[k,v]=(0,s.useState)(!1),[j,S]=(0,s.useState)(0),[F,I]=(0,s.useState)(!0),T=(0,w.FS)(g,{allowedNamespacePrefixes:null==h?void 0:h.allowedNamespacePrefixes}),[C,A]=(0,s.useState)(!1),[_,L]=(0,s.useState)(!1),D=async()=>{y(!0);try{const{data:e,error:s}=await(0,u.Bs_)(g.id,Y(g));e?(t.toasts.addSuccess(f.i18n.translate("xpack.fleet.editAgentPolicy.successNotificationTitle",{defaultMessage:"Successfully updated ''{name}'' settings",values:{name:g.name}})),g.space_ids&&!g.space_ids.includes(null!=a?a:V.DEFAULT_SPACE_ID)?x.replace(i("policies_list")):(d(),v(!1))):t.toasts.addDanger(s?s.message:f.i18n.translate("xpack.fleet.editAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to update agent policy"}))}catch(e){t.toasts.addDanger(f.i18n.translate("xpack.fleet.editAgentPolicy.errorNotificationTitle",{defaultMessage:"Unable to update agent policy"}))}y(!1)},O=(0,s.useMemo)((()=>(0,P.Rq)(g.id,Y(g))),[g]);return l().createElement(Q,null,j?l().createElement(w.oR,{agentCount:j,agentPolicies:[g],onConfirm:()=>{S(0),D()},onCancel:()=>{S(0),y(!1)}}):null,l().createElement(w.Kb,{agentPolicy:g,updateAgentPolicy:e=>{m({...g,...e}),v(!0)},withSysMonitoring:F,updateSysMonitoring:e=>I(e),validation:T,isEditing:!0,updateAdvancedSettingsHasErrors:A,setInvalidSpaceError:L}),k?l().createElement(l().Fragment,null,l().createElement(c.EuiSpacer,{size:"xl"}),l().createElement(c.EuiSpacer,{size:"xl"}),l().createElement(c.EuiBottomBar,null,l().createElement(c.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(c.EuiFlexItem,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.unsavedChangesText",defaultMessage:"You have unsaved changes"})),l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{color:"text",onClick:()=>{m({...e}),v(!1)}},l().createElement(p.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.cancelButtonText",defaultMessage:"Cancel"}))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(M.T_,{isDisabled:E||Object.keys(T).length>0||C||_,btnProps:{color:"text"},description:f.i18n.translate("xpack.fleet.editAgentPolicy.devtoolsRequestDescription",{defaultMessage:"This Kibana request updates an agent policy."}),request:O})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButton,{onClick:async()=>{if(n){y(!0);const{data:e}=await(0,u.Wwg)({policyId:g.id});null!=e&&e.results.active?S(e.results.active):await D()}else await D()},isLoading:E,isDisabled:!r||E||Object.keys(T).length>0||C||_,"data-test-subj":"agentPolicyDetailsSaveButton",iconType:"save",color:"primary",fill:!0},E?l().createElement(p.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.savingButtonText",defaultMessage:"Saving…"}):l().createElement(p.FormattedMessage,{id:"xpack.fleet.editAgentPolicy.saveButtonText",defaultMessage:"Save changes"})))))))):null)})),X=({isLoading:e,policyId:t,agentPolicy:a})=>{const{getHref:s}=(0,u.iEg)();return(0,O.jsx)(c.EuiFlexGroup,{direction:"column",gutterSize:"s",alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiButtonEmpty,{iconType:"arrowLeft",href:s("policies_list"),flush:"left",size:"xs"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetails.viewAgentListTitle",defaultMessage:"View all agent policies"}))),(0,O.jsx)(c.EuiFlexItem,null,e?(0,O.jsx)(M.Rh,null):(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",wrap:!0,responsive:!1,gutterSize:"s"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiTitle,null,(0,O.jsx)("h1",null,a&&a.name||(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetails.policyDetailsTitle",defaultMessage:"Policy ''{id}''",values:{id:t}})))),(null==a?void 0:a.is_managed)&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiIconTip,{title:"Hosted agent policy",content:f.i18n.translate("xpack.fleet.policyDetails.policyDetailsHostedPolicyTooltip",{defaultMessage:"This policy is managed outside of Fleet. Most actions related to this policy are unavailable."}),type:"lock",size:"l",color:"subdued"})))),a&&a.description?(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiText,{color:"subdued",size:"s",className:"eui-textBreakWord"},a.description)):null)};var Z=a(57760),ee=a(87086);const te=A().div.withConfig({displayName:"Divider",componentId:"sc-zpeocb-0"})(["width:0;height:100%;border-left:",";"],(e=>e.theme.eui.euiBorderThin)),ae=({isLoading:e,agentPolicy:t,addAgent:a,onCancelEnrollment:n,isAddAgentHelpPopoverOpen:i,setIsAddAgentHelpPopoverOpen:r})=>{var d,g,m;const x=(0,u.iO7)(),{getPath:h}=(0,u.iEg)(),E=(0,o.useHistory)(),[y,k]=(0,s.useState)(!1),v=(0,u.gCF)(),{enableAutomaticAgentUpgrades:j}=z.ZX.get(),b=(0,s.useMemo)((()=>{var e;return null==t||null===(e=t.package_policies)||void 0===e?void 0:e.some((e=>{var t;return(null===(t=e.package)||void 0===t?void 0:t.name)===$.k7N}))}),[t]);if(!t)return null;const S=l().createElement(c.EuiLink,{onClick:a,"data-test-subj":"addAgentLink"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.policyDetails.addFleetServerButton",defaultMessage:"Add Fleet Server"})),F=l().createElement(c.EuiLink,{onClick:a,"data-test-subj":"addAgentLink"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.policyDetails.addAgentButton",defaultMessage:"Add agent"}));return l().createElement(l().Fragment,null,l().createElement(c.EuiFlexGroup,{justifyContent:"flexEnd",direction:"row"},e||!t?null:[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.revision",{defaultMessage:"Revision"}),content:null!==(d=t.revision)&&void 0!==d?d:0},{isDivider:!0},{label:f.i18n.translate("xpack.fleet.policyDetails.summary.integrations",{defaultMessage:"Integrations"}),content:l().createElement(c.EuiI18nNumber,{value:t.package_policies&&t.package_policies.length||0})},{isDivider:!0},...!x.fleet.readAgents||null!=t&&t.supports_agentless?[]:[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.usedBy",{defaultMessage:"Agents"}),content:!t.agents&&b&&x.fleet.addFleetServers?l().createElement(M.xt,{button:S,isOpen:i,offset:15,closePopover:()=>{r(!1)}}):t.agents||b||!x.fleet.addAgents?l().createElement(c.EuiFlexGroup,{direction:"row",gutterSize:"xs",alignItems:"center"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiToolTip,{content:l().createElement(c.EuiFlexGroup,{direction:"column",gutterSize:"xs"},l().createElement(c.EuiFlexItem,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.usedByUnprivilegedTooltip",defaultMessage:"{count, plural, one {# unprivileged agent} other {# unprivileged agents}}",values:{count:t.unprivileged_agents||0}})),l().createElement(c.EuiFlexItem,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.usedByPrivilegedTooltip",defaultMessage:"{count, plural, one {# privileged agent} other {# privileged agents}}",values:{count:(t.agents||0)-(t.unprivileged_agents||0)}})))},l().createElement(w.Oy,{count:t.agents||0,agentPolicyId:t.id,showAgentText:!0}))),(0,I.uo)(t.package_policies||[]).length>0&&(t.unprivileged_agents||0)>0&&l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiIconTip,{type:"warning",color:"warning",content:l().createElement(p.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.containsUnprivilegedAgentsWarning",defaultMessage:"This agent policy contains integrations that require Elastic Agents to have root privileges. Some enrolled agents are running in unprivileged mode."})}))):l().createElement(M.xt,{button:F,isOpen:i,offset:15,closePopover:()=>{r(!1)}})},{isDivider:!0}],{label:f.i18n.translate("xpack.fleet.policyDetails.summary.lastUpdated",{defaultMessage:"Last updated on"}),content:t&&l().createElement(p.FormattedDate,{value:null==t?void 0:t.updated_at,year:"numeric",month:"short",day:"2-digit"})||""},{isDivider:!0},...j&&x.fleet.allAgentPolicies?[{label:f.i18n.translate("xpack.fleet.policyDetails.summary.autoUpgrade",{defaultMessage:"Auto-upgrade agents"}),content:l().createElement(c.EuiFlexGroup,{gutterSize:"xs",justifyContent:"flexEnd",alignItems:"center",id:"auto-upgrade-manage-button"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiLink,{onClick:()=>{k(!y)}},l().createElement(p.FormattedMessage,{id:"xpack.fleet.policyDetails.summary.autoUpgradeButton",defaultMessage:"Manage"}))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiNotificationBadge,{color:null!==(g=t.required_versions)&&void 0!==g&&g.length?"accent":"subdued"},(null===(m=t.required_versions)||void 0===m?void 0:m.length)||0)))},{isDivider:!0}]:[],{content:t&&l().createElement(w.Nu,{agentPolicy:t,fullButton:!0,onCopySuccess:e=>{E.push(h("policy_details",{policyId:e.id}))},onCancelEnrollment:n})}].map(((e,t)=>{var a;return l().createElement(c.EuiFlexItem,{grow:!1,key:t},null!==(a=e.isDivider)&&void 0!==a&&a?l().createElement(te,null):e.label?l().createElement(c.EuiDescriptionList,{compressed:!0,textStyle:"reverse",style:{textAlign:"right"}},l().createElement(c.EuiDescriptionListTitle,{className:"eui-textNoWrap"},e.label),l().createElement(c.EuiDescriptionListDescription,{className:"eui-textNoWrap"},e.content)):e.content)}))),y&&l().createElement(c.EuiPortal,null,l().createElement(Z.i,{agentPolicy:t,agentCount:t.agents||0,onClose:e=>{k(!1),e&&v()}})),j?l().createElement(ee.i,{anchor:"#auto-upgrade-manage-button"}):null)},se=()=>{const{params:{policyId:e,tabId:t=""}}=(0,o.useRouteMatch)(),{getHref:a}=(0,u.iEg)(),n=(0,u.ZJQ)(e),i=n.data?n.data.item:null,{isLoading:r,error:d,sendRequest:g}=n,m=new URLSearchParams((0,o.useLocation)().search),x="true"===m.get("openEnrollmentFlyout"),h="true"===m.get("showAddAgentHelp"),[E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(x),[v,j]=(0,s.useState)(h),{application:{navigateToApp:b}}=(0,u.WeA)(),S=(0,u.g7J)(),{isReady:I}=(0,u.YI3)(),T=(0,s.useMemo)((()=>{if(S&&S.onDoneNavigateTo&&I){const[e,t]=S.onDoneNavigateTo;return()=>b(e,t)}}),[I,b,S]),w=(0,s.useCallback)((()=>{j(!1),k(!0)}),[]),C=(0,s.useMemo)((()=>[{id:"integrations",name:f.i18n.translate("xpack.fleet.policyDetails.subTabs.packagePoliciesTabText",{defaultMessage:"Integrations"}),href:a("policy_details",{policyId:e,tabId:"integrations"}),isSelected:""===t||"integrations"===t},{id:"settings",name:f.i18n.translate("xpack.fleet.policyDetails.subTabs.settingsTabText",{defaultMessage:"Settings"}),"data-test-subj":"agentPolicySettingsTab",href:a("policy_details",{policyId:e,tabId:"settings"}),isSelected:"settings"===t}]),[a,e,t]),A=(0,s.useMemo)((()=>E?(0,O.jsx)(o.Redirect,{to:"/"}):r?(0,O.jsx)(M.Rh,null):d?(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:d}):i?(0,O.jsx)(l().Fragment,null,y&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(M.rt,{agentPolicy:i,onClose:T||(()=>k(!1))})),(0,O.jsx)(le,{agentPolicy:i})):(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyDetails.unexceptedErrorTitle",defaultMessage:"An error happened while loading the agent policy"}),error:f.i18n.translate("xpack.fleet.policyDetails.policyNotFoundErrorTitle",{defaultMessage:"Policy ''{id}'' not found",values:{id:e}})})),[E,r,d,i,y,T,e]),P=(0,O.jsx)(X,{agentPolicy:i,policyId:e,isLoading:r}),_=(0,O.jsx)(ae,{agentPolicy:i,onCancelEnrollment:T,isLoading:r,isAddAgentHelpPopoverOpen:v,setIsAddAgentHelpPopoverOpen:j,addAgent:w});return(0,O.jsx)(u.qfp.Provider,{value:{refresh:g}},(0,O.jsx)(F.QA,{leftColumn:P,rightColumn:_,tabs:C},A))},le=({agentPolicy:e})=>((0,u.ifo)("policy_details",{policyName:e.name}),(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:S.X5.policy_details_settings,render:()=>(0,O.jsx)(J,{agentPolicy:e})}),(0,O.jsx)(r.Route,{path:S.X5.policy_details,render:()=>(0,O.jsx)(q,{agentPolicy:e})})));var ne=a(70940);const ie=(0,s.memo)((()=>{const{params:{packagePolicyId:e,policyId:t}}=(0,o.useRouteMatch)(),{search:a}=(0,o.useLocation)(),s=new URLSearchParams(a).get("from");let l;return s&&"fleet-policy-list"===s?l="upgrade-from-fleet-policy-list":s&&"integrations-policy-list"===s&&(l="upgrade-from-integrations-policy-list"),(0,O.jsx)(ne.R,{packagePolicyId:e,policyId:t,from:l,forceUpgrade:!0})})),oe=()=>((0,u.ifo)("policies"),(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:S.X5.edit_integration},(0,O.jsx)(ne.k,null)),(0,O.jsx)(r.Route,{path:S.X5.upgrade_package_policy},(0,O.jsx)(ie,null)),(0,O.jsx)(r.Route,{path:S.X5.policy_details},(0,O.jsx)(se,null)),(0,O.jsx)(r.Route,{path:S.X5.policies_list},(0,O.jsx)(F.iW,{section:"agent_policies"},(0,O.jsx)(R,null)))));var re=a(49358);const ue=(0,s.memo)((({datastream:e})=>{const{dashboards:t}=e,a=(0,u.e3j)(),s=(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.dataStreamList.viewDashboardActionText",defaultMessage:"View dashboard"}),l=(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.dataStreamList.viewDashboardsActionText",defaultMessage:"View dashboards"}),n=f.i18n.translate("xpack.fleet.dataStreamList.viewDashboardsPanelTitle",{defaultMessage:"View dashboards"}),i=f.i18n.translate("xpack.fleet.dataStreamList.viewInApmActionText",{defaultMessage:"View in APM"}),{isSuccessful:o,href:r}=(0,re.V)(e);if(o&&r){const e=[{id:0,items:[{icon:"apmApp",href:r,name:i}]}];return(0,O.jsx)(M.AK,{panels:e})}if(!t||0===t.length){const e=[{id:0,items:[{icon:"dashboardApp",disabled:!0,name:s}]}];return(0,O.jsx)(M.AK,{panels:e})}if(1===t.length){var d;const e=[{id:0,items:[{icon:"dashboardApp",href:null==a?void 0:a.getRedirectUrl({dashboardId:null===(d=t[0])||void 0===d?void 0:d.id}||""),name:s}]}];return(0,O.jsx)(M.AK,{panels:e})}const c=[{id:0,items:[{icon:"dashboardApp",panel:1,name:l}]},{id:1,title:n,items:t.map((e=>({icon:"dashboardApp",href:null==a?void 0:a.getRedirectUrl({dashboardId:null==e?void 0:e.id}||""),name:e.title})))}];return(0,O.jsx)(M.AK,{panels:c})})),de=()=>{(0,u.ifo)("data_streams");const{pagination:e,pageSizeOptions:t}=(0,u.WQC)(),{isLoading:a,data:n,resendRequest:i}=(0,u.FM)(),o=(0,s.useMemo)((()=>[{field:"dataset",sortable:!0,width:"25%",name:f.i18n.translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"})},{field:"type",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"})},{field:"namespace",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),render:e=>e?(0,O.jsx)(c.EuiBadge,{color:"hollow"},e):""},{field:"package",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),render:(e,t)=>(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},t.package_version&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(M.qD,{packageName:e,version:t.package_version,size:"m",tryApi:!0})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},e))},{field:"last_activity_ms",sortable:!0,width:"25%",dataType:"date",name:f.i18n.translate("xpack.fleet.dataStreamList.lastActivityColumnTitle",{defaultMessage:"Last activity"}),render:e=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedDate,{value:e,year:"numeric",month:"short",day:"numeric"}),(0,O.jsx)(l().Fragment,null," @ "),(0,O.jsx)(p.FormattedTime,{value:e,hour:"numeric",minute:"numeric",second:"numeric"}))},{field:"size_in_bytes",sortable:!0,name:f.i18n.translate("xpack.fleet.dataStreamList.sizeColumnTitle",{defaultMessage:"Size"}),render:(e,t)=>(0,O.jsx)(l().Fragment,null,t.size_in_bytes_formatted)},{name:f.i18n.translate("xpack.fleet.dataStreamList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:e=>(0,O.jsx)(ue,{datastream:e})}]}]),[]),r=(0,s.useMemo)((()=>(0,O.jsx)(c.EuiEmptyPrompt,{title:(0,O.jsx)("h2",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.dataStreamList.noDataStreamsPrompt",defaultMessage:"No data streams"}))})),[]),d={dataset:[],type:[],namespace:[],package:[]};if(n&&n.data_streams.length){const e={dataset:[],type:[],namespace:[],package:[]};n.data_streams.forEach((t=>{const{dataset:a,type:s,namespace:l,package:n}=t;e.dataset.includes(a)||e.dataset.push(a),e.type.includes(s)||e.type.push(s),e.namespace.includes(l)||e.namespace.push(l),e.package.includes(n)||e.package.push(n)}));for(const t in e)d[t]&&(d[t]=e[t].sort().map((e=>({value:e,name:e}))))}return(0,O.jsx)(c.EuiInMemoryTable,{loading:a,tableLayout:"auto",message:a?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.dataStreamList.loadingDataStreamsMessage",defaultMessage:"Loading data streams…"}):n&&!n.data_streams.length?r:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.dataStreamList.noFilteredDataStreamsMessage",defaultMessage:"No matching data streams found"}),items:n?n.data_streams:[],itemId:"index",columns:o,pagination:{initialPageSize:e.pageSize,pageSizeOptions:t},sorting:!0,search:{toolsRight:[(0,O.jsx)(c.EuiButton,{key:"reloadButton",color:"primary",iconType:"refresh",onClick:()=>i()},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.dataStreamList.reloadDataStreamsButtonText",defaultMessage:"Reload"}))],box:{placeholder:f.i18n.translate("xpack.fleet.dataStreamList.searchPlaceholderTitle",{defaultMessage:"Filter data streams"}),incremental:!0},filters:[{type:"field_value_selection",field:"dataset",name:f.i18n.translate("xpack.fleet.dataStreamList.datasetColumnTitle",{defaultMessage:"Dataset"}),multiSelect:"or",operator:"exact",options:d.dataset},{type:"field_value_selection",field:"type",name:f.i18n.translate("xpack.fleet.dataStreamList.typeColumnTitle",{defaultMessage:"Type"}),multiSelect:"or",operator:"exact",options:d.type},{type:"field_value_selection",field:"namespace",name:f.i18n.translate("xpack.fleet.dataStreamList.namespaceColumnTitle",{defaultMessage:"Namespace"}),multiSelect:"or",operator:"exact",options:d.namespace},{type:"field_value_selection",field:"package",name:f.i18n.translate("xpack.fleet.dataStreamList.integrationColumnTitle",{defaultMessage:"Integration"}),multiSelect:"or",operator:"exact",options:d.package}]}})},ce=()=>(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:S.X5.data_streams},(0,O.jsx)(F.iW,{section:"data_streams"},(0,O.jsx)(de,null))));var ge=a(30135),pe=a(86955),fe=a(19573);const me=({onClose:e,agents:t,agentCount:a})=>{const{notifications:l}=(0,u.WeA)(),[n,i]=(0,s.useState)(!1),r=Array.isArray(t)&&1===t.length,{getPath:d}=(0,u.iEg)(),g=(0,o.useHistory)(),[m,x]=(0,s.useState)(!1);return(0,O.jsx)(c.EuiConfirmModal,{"data-test-subj":"requestDiagnosticsModal",title:r?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.singleTitle",defaultMessage:"Request diagnostics"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.multipleTitle",defaultMessage:"Request diagnostics for {count} agents",values:{count:a}}),onCancel:e,onConfirm:async function(){try{i(!0);const a=m?[fe.m_.CPU]:[],{error:s}=r?await(0,u.o6X)(t[0].id,{additional_metrics:a}):await(0,u.aJz)({agents:"string"==typeof t?t:t.map((e=>e.id)),additional_metrics:a});if(s)throw s;i(!1);const n=f.i18n.translate("xpack.fleet.requestDiagnostics.successSingleNotificationTitle",{defaultMessage:"Request diagnostics submitted"});if(l.toasts.addSuccess(n),r){const e=d("agent_details_diagnostics",{agentId:t[0].id});g.push(e)}e()}catch(e){i(!1),l.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.requestDiagnostics.fatalErrorNotificationTitle",{defaultMessage:"Error requesting diagnostics {count, plural, one {agent} other {agents}}",values:{count:a}})})}},cancelButtonText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonDisabled:n,confirmButtonText:r?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.confirmSingleButtonLabel",defaultMessage:"Request diagnostics"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.confirmMultipleButtonLabel",defaultMessage:"Request diagnostics for {count} agents",values:{count:a}}),buttonColor:"primary"},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.description",defaultMessage:"Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy."})),(0,O.jsx)("p",null,(0,O.jsx)(c.EuiCheckbox,{id:"cpuMetricsCheckbox","data-test-subj":"cpuMetricsCheckbox",label:"Collect additional CPU metrics",checked:m,onChange:()=>x(!m)})))};function xe(e){return e.length>20?`${e.substring(0,20)}...`:e}function he(e){return e.replace(/[^a-zA-Z0-9 \-_]/g,"").slice(0,20)}const Ee=A().div.withConfig({displayName:"Wrapped",componentId:"sc-rnfjm9-0"})(["display:flex;.wrappedText{white-space:pre-wrap;}"]),ye=({tags:e,color:t,size:a})=>l().createElement(l().Fragment,null,l().createElement(Ee,null,l().createElement(c.EuiToolTip,{anchorClassName:"wrappedText",content:l().createElement("span",{"data-test-subj":"agentTagsTooltip"},e.join(", "))},l().createElement(c.EuiText,{size:a,color:t},l().createElement("span",{"data-test-subj":"agentTags"},(0,K.take)(e,3).map(xe).join(", "),e.length>3?` + ${e.length-3} more`:"")))));function ke(e,t){return void 0!==(null==e?void 0:e.cpu_avg)?(0,O.jsx)(c.EuiToolTip,{content:`${(100*e.cpu_avg).toFixed(4)} %`},(0,O.jsx)(l().Fragment,null,(100*e.cpu_avg).toFixed(2)," %")):(0,O.jsx)(pe.DQ,{agentPolicy:t})}function ve(e,t){return null!=e&&e.memory_size_byte_avg?function(e,t=0){if(0===e)return"0 Bytes";const a=t<0?0:t,s=Math.floor(Math.log(e)/Math.log(1024));return parseFloat((e/Math.pow(1024,s)).toFixed(a))+" "+["Bytes","KB","MB","GB","TB","PB","EB","ZB","YB"][s]}(e.memory_size_byte_avg):(0,O.jsx)(pe.DQ,{agentPolicy:t})}var je=a(51783),be=a.n(je);function Me(e){const t=Date.parse(e||"")-Date.now();return t<0?"":t<9e5?" The upgrade will start in less than 15 minutes.":t<18e5?" The upgrade will start in less than 30 minutes.":t<36e5?" The upgrade will start in less than 1 hour.":` The upgrade will start in less than ${Math.ceil(t/36e5)} hours.`}function Se(e){if(!e||void 0===e.download_percent&&void 0===e.download_rate)return"";let t="";return void 0!==e.download_percent&&(t=`${e.download_percent}%`),void 0!==e.download_rate&&(t+=` at ${Fe(e.download_rate)}`),` (${t.trim()})`}const Fe=e=>{let t=0;const a=[" Bps"," kBps"," MBps"," GBps"];for(;t<a.length-1&&!(e<1024);t++)e/=1024;return e.toFixed(1)+a[t]},Ie=e=>{if(!e)return"";const t=new Date(e).toISOString(),a=Date.parse(e)-Date.now(),s=be().utc(be().duration(a,"milliseconds").asMilliseconds()).format("HH:mm");return a>0?`Retrying until: ${t} (${s} remaining)`:""},Te=({isAgentUpgradable:e,agent:t,latestAgentVersion:a})=>{const l=(0,s.useMemo)((()=>t.upgrade_started_at&&!t.upgraded_at),[t.upgrade_started_at,t.upgraded_at]),n=(0,s.useMemo)((()=>function(e){var t,a,s;switch(null==e?void 0:e.state){case"UPG_REQUESTED":return{Badge:(0,O.jsx)(c.EuiBadge,{color:"accent",iconType:"calendar"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRequested",defaultMessage:"Upgrade requested"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRequested",defaultMessage:"The agent has requested an upgrade."})};case"UPG_SCHEDULED":return{Badge:(0,O.jsx)(c.EuiBadge,{color:"accent",iconType:"clock"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeScheduled",defaultMessage:"Upgrade scheduled"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeScheduled",defaultMessage:"The agent has been instructed to upgrade.{upgradeStartDelay}",values:{upgradeStartDelay:Me(null===(t=e.metadata)||void 0===t?void 0:t.scheduled_at)}})};case"UPG_DOWNLOADING":var l,n;return null!=e&&null!==(a=e.metadata)&&void 0!==a&&a.retry_error_msg?{Badge:(0,O.jsx)(c.EuiBadge,{color:"accent",iconType:"download"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeDownloading",defaultMessage:"Upgrade downloading"})),WarningTooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDownloadingFailed",defaultMessage:"Upgrade failing: {retryMsg}. {retryUntil}",values:{retryMsg:null==e||null===(l=e.metadata)||void 0===l?void 0:l.retry_error_msg,retryUntil:Ie(null==e||null===(n=e.metadata)||void 0===n?void 0:n.retry_until)}})}:{Badge:(0,O.jsx)(c.EuiBadge,{color:"accent",iconType:"download"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeDownloading",defaultMessage:"Upgrade downloading"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDownloading",defaultMessage:"Downloading the new agent artifact version{downloadEstimate}.",values:{downloadEstimate:Se(null==e?void 0:e.metadata)}})};case"UPG_EXTRACTING":return{Badge:(0,O.jsx)(c.EuiBadge,{color:"accent",iconType:"package"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeExtracting",defaultMessage:"Upgrade extracting"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeExtracting",defaultMessage:"The new agent artifact is extracting."})};case"UPG_REPLACING":return{Badge:(0,O.jsx)(c.EuiBadge,{color:"warning",iconType:"copy"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeReplacing",defaultMessage:"Upgrade replacing"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeReplacing",defaultMessage:"Replacing the agent artifact version."})};case"UPG_RESTARTING":return{Badge:(0,O.jsx)(c.EuiBadge,{color:"warning",iconType:"refresh"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRestarting",defaultMessage:"Upgrade restarting"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRestarting",defaultMessage:"The agent is restarting to apply the update."})};case"UPG_WATCHING":return{Badge:(0,O.jsx)(c.EuiBadge,{color:"warning",iconType:"inspect"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeMonitoring",defaultMessage:"Upgrade monitoring"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeMonitoring",defaultMessage:"Monitoring the new agent version for errors."})};case"UPG_ROLLBACK":return{Badge:(0,O.jsx)(c.EuiBadge,{color:"danger",iconType:"returnKey"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeRolledBack",defaultMessage:"Upgrade rolled back"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeRolledBack",defaultMessage:"Upgrade unsuccessful. Rolling back to previous version."})};case"UPG_FAILED":return{Badge:(0,O.jsx)(c.EuiBadge,{color:"danger",iconType:"error"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeFailed",defaultMessage:"Upgrade failed"})),TooltipText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeFailed",defaultMessage:"Upgrade failed: {errorMsg}.",values:{errorMsg:null==e||null===(s=e.metadata)||void 0===s?void 0:s.error_msg}})};default:return null}}(t.upgrade_details)),[t.upgrade_details]),i=(0,I.zm)(t,a);return e&&(0,I.vJ)(t,a)?(0,O.jsx)(c.EuiBadge,{color:"hollow",iconType:"sortUp"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.upgradeAvailable",defaultMessage:"Upgrade available"})):t.upgrade_details&&n?(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center",responsive:!1},(0,O.jsx)(c.EuiFlexItem,{grow:!1},n.Badge),n.TooltipText&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiIconTip,{type:"iInCircle",content:n.TooltipText,color:"subdued"})),n.WarningTooltipText&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiIconTip,{type:"warning",content:n.WarningTooltipText,color:"warning"}))):l?(0,O.jsx)(c.EuiIconTip,{type:"iInCircle",content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusTooltip.upgradeDetailsNotAvailable",defaultMessage:"Detailed upgrade status is available for Elastic Agents on version {minVersion} and higher.",values:{minVersion:"8.12"}}),color:"subdued"}):!e&&i?(0,O.jsx)(c.EuiIconTip,{type:"iInCircle",content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentUpgradeStatusBadge.notUpgradeable",defaultMessage:"Agent not upgradeable: {reason}",values:{reason:i}}),color:"subdued"}):null},we=({hasFleetAddAgentsPrivileges:e,setEnrollmentFlyoutState:t})=>(0,O.jsx)(c.EuiEmptyPrompt,{title:(0,O.jsx)("h2",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.noAgentsPrompt",defaultMessage:"No agents enrolled"})),actions:e?(0,O.jsx)(c.EuiButton,{fill:!0,iconType:"plusInCircle",onClick:()=>t({isOpen:!0})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})):null}),Ce="metrics";function Ae(e){return"string"!=typeof e?"-":e}const Pe=e=>{const{agents:t,isLoading:a,agentPoliciesIndexedById:l,renderActions:n,sortField:i,sortOrder:o,onTableChange:r,onSelectionChange:d,selected:g,totalAgents:m=0,showUpgradeable:x,pagination:h,pageSizeOptions:E,isUsingFilter:y,setEnrollmentFlyoutState:k,clearFilters:v,isCurrentRequestIncremented:j}=e,b=(0,u.iO7)(),{getHref:S}=(0,u.iEg)(),F=(0,u.JhS)(),I=(0,s.useCallback)((e=>{if(!e.active)return!1;if(!e.policy_id)return!0;const t=l[e.policy_id];return!(!0===(null==t?void 0:t.is_managed))}),[l]),T=(0,s.useMemo)((()=>m?x?t.filter((e=>I(e)&&(0,z._3)(e))):t:[]),[t,I,x,m]),w=a&&j?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.loadingAgentsMessage",defaultMessage:"Loading agents…"}):y?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.noFilteredAgentsPrompt",defaultMessage:"No agents found. {clearFiltersLink}",values:{clearFiltersLink:(0,O.jsx)(c.EuiLink,{onClick:()=>v()},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.clearFiltersLinkText",defaultMessage:"Clear filters"}))}}):(0,O.jsx)(we,{hasFleetAddAgentsPrivileges:b.fleet.addAgents,setEnrollmentFlyoutState:k}),C={sort:{field:i,direction:o}},A=[{field:"active",sortable:!1,width:"85px",name:f.i18n.translate("xpack.fleet.agentList.statusColumnTitle",{defaultMessage:"Status"}),render:(e,t)=>(0,O.jsx)(pe.u0,{agent:t})},{field:"local_metadata.host.hostname",sortable:!0,name:f.i18n.translate("xpack.fleet.agentList.hostColumnTitle",{defaultMessage:"Host"}),width:"185px",render:(e,t)=>{var a;return(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"none",direction:"column"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiLink,{href:S("agent_details",{agentId:t.id})},Ae(e))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(ye,{tags:null!==(a=t.tags)&&void 0!==a?a:[],color:"subdued",size:"xs"})))}},{field:"policy_id",sortable:!0,truncateText:!0,name:f.i18n.translate("xpack.fleet.agentList.policyColumnTitle",{defaultMessage:"Agent policy"}),width:"185px",render:(e,t)=>{const a=l[e],s=t.policy_revision&&(null==a?void 0:a.revision)>t.policy_revision;return(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"m",style:{minWidth:0},alignItems:"center"},a&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(M.an,{direction:"column",policy:a,agent:t})),s&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiText,{color:"subdued",size:"xs",className:"eui-textNoWrap"},(0,O.jsx)(c.EuiIcon,{size:"m",type:"warning",color:"warning"})," ",(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.outOfDateLabel",defaultMessage:"Outdated policy"}))))}},{field:Ce,sortable:!1,name:(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.cpuTooltip",defaultMessage:"Average CPU usage in the last 5 minutes. This includes usage from the Agent and the component it supervises. Possible value ranges from 0 to (number of available CPU cores * 100)"})},(0,O.jsx)("span",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.cpuTitle",defaultMessage:"CPU"})," ",(0,O.jsx)(c.EuiIcon,{type:"iInCircle"}))),width:"75px",render:(e,t)=>ke(t.metrics,t.policy_id?l[t.policy_id]:void 0)},{field:Ce,sortable:!1,name:(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.memoryTooltip",defaultMessage:"Average memory usage in the last 5 minutes"})},(0,O.jsx)("span",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.memoryTitle",defaultMessage:"Memory"})," ",(0,O.jsx)(c.EuiIcon,{type:"iInCircle"}))),width:"90px",render:(e,t)=>ve(t.metrics,t.policy_id?l[t.policy_id]:void 0)},{field:"last_checkin",sortable:!0,name:f.i18n.translate("xpack.fleet.agentList.lastCheckinTitle",{defaultMessage:"Last activity"}),width:"100px",render:e=>e?(0,O.jsx)(p.FormattedRelative,{value:e}):void 0},{field:"local_metadata.elastic.agent.version",sortable:!0,width:"220px",name:f.i18n.translate("xpack.fleet.agentList.versionTitle",{defaultMessage:"Version"}),render:(e,t)=>(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"none",style:{minWidth:0},direction:"column"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center",wrap:!0},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiText,{size:"s",className:"eui-textNoWrap"},Ae(e))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(Te,{isAgentUpgradable:!(!I(t)||!(0,z._3)(t)),agent:t,latestAgentVersion:F})))))},{name:f.i18n.translate("xpack.fleet.agentList.actionsColumnTitle",{defaultMessage:"Actions"}),actions:[{render:n}],width:"100px"}];return(0,O.jsx)(c.EuiBasicTable,{className:"fleet__agentList__table","data-test-subj":"fleetAgentListTable",loading:a,noItemsMessage:w,items:T,itemId:"id",columns:A,pagination:{pageIndex:h.currentPage-1,pageSize:h.pageSize,totalItemCount:m,pageSizeOptions:E},selection:{selected:g,onSelectionChange:d,selectable:I,selectableMessage:(e,t)=>e?"":t.active?t.policy_id&&l[t.policy_id].is_managed?"This action is not available for agents enrolled in an externally managed agent policy":"":"This agent is not active"},onChange:r,sorting:C})},_e=()=>{var e,t;const a=(0,u.UKg)();return(0,O.jsx)(c.EuiCallOut,{iconType:"warning",color:"warning",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentSoftLimitCallout.calloutTitle",defaultMessage:"Max number of online agents reached"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentSoftLimitCallout.calloutDescription",defaultMessage:"Fleet supports a maximum of {nbAgents} active agents. You need to unenroll some agents to ensure that all active agents are able to connect and new agents can be enrolled.",values:{nbAgents:(0,O.jsx)(p.FormattedNumber,{value:null!==(e=null===(t=a.internal)||void 0===t?void 0:t.activeAgentsSoftLimit)&&void 0!==e?e:25e3})}}))},Le=["healthy","unhealthy","orphaned","updating","offline","inactive","unenrolled","uninstalled"];function De(e,t){const a="EUI_THEME_AMSTERDAM"===t.themeName;switch(e){case"healthy":return a?t.colors.vis.euiColorVisBehindText0:t.colors.backgroundFilledSuccess;case"offline":case"uninstalled":return t.colors.lightShade;case"inactive":return t.colors.darkShade;case"unhealthy":case"orphaned":return a?t.colors.vis.euiColorVisBehindText5:t.colors.backgroundFilledWarning;case"updating":return a?t.colors.vis.euiColorVisBehindText1:t.colors.backgroundFilledPrimary;case"unenrolled":return t.colors.backgroundBaseDisabled;default:throw new Error(`Unsupported Agent status ${e}`)}}const Oe=A()(c.EuiColorPaletteDisplay).withConfig({displayName:"StyledEuiColorPaletteDisplay",componentId:"sc-1wvk6tr-0"})(["&.ingest-agent-status-bar{border:none;border-radius:0;&:after{border:none;}}"]),Re=({agentStatus:e})=>{const{euiTheme:t}=(0,c.useEuiTheme)(),a=(0,s.useMemo)((()=>Le.reduce(((a,s)=>{const l=a.length>0?a[a.length-1].stop:0;return a.push({stop:l+(e[s]||0),color:De(s,t)}),a}),[])),[e,t]);return 0===a[a.length-1].stop?l().createElement(c.EuiSpacer,{size:"s"}):l().createElement(Oe,{"data-test-subj":"agentStatusBar",className:"ingest-agent-status-bar",size:"s",palette:a})},Be=()=>{var e;const{storage:t,uiSettings:a}=(0,u.WeA)(),[n,i]=(0,s.useState)({isOpen:!0}),o=a.get("hideAnnouncements",!1)||!1===(null===(e=t.get(S.EG.AGENT_EXPORT_CSV))||void 0===e?void 0:e.active);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTourStep,{content:(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentExportCSVTour.tourContent",defaultMessage:"Once you have selected the agents, click the action menu to download the CSV file."})),isStepOpen:!o&&n.isOpen,onFinish:()=>{i({isOpen:!1}),t.set(S.EG.AGENT_EXPORT_CSV,{active:!1})},minWidth:360,maxWidth:360,step:1,stepsTotal:1,title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentExportCSVTour.tourTitle",defaultMessage:"Download CSV file"}),anchorPosition:"upLeft",anchor:"#agentListSelectionText"}))},Ne=A().div.withConfig({displayName:"Divider",componentId:"sc-1e6bwq9-0"})(["width:0;height:",";border-left:",";"],(e=>e.theme.eui.euiSizeL),(e=>e.theme.eui.euiBorderThin)),ze=A()(c.EuiFlexItem).withConfig({displayName:"FlexItem",componentId:"sc-1e6bwq9-1"})(["height:",";"],(e=>e.theme.eui.euiSizeL)),Ue=A()(c.EuiButtonEmpty).withConfig({displayName:"Button",componentId:"sc-1e6bwq9-2"})([".euiButtonEmpty__text{font-size:",";}"],(e=>e.theme.eui.euiFontSizeXS)),He=({totalAgents:e,totalManagedAgents:t,selectableAgents:a,managedAgentsOnCurrentPage:s,selectionMode:n,setSelectionMode:i,selectedAgents:o,setSelectedAgents:r})=>{const u="manual"===n&&o.length>0||"query"===n&&e>0,d="manual"===n&&o.length===a&&a<e-s;return l().createElement(l().Fragment,null,l().createElement(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiText,{size:"xs",color:"subdued",id:"agentListSelectionText"},e>S.W?l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.totalAgentsWithLimit",defaultMessage:"Showing {count} of {total} agents",values:{count:l().createElement(p.FormattedNumber,{value:S.W}),total:l().createElement(p.FormattedNumber,{value:e})}}):l().createElement(l().Fragment,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.totalAgents",defaultMessage:"Showing {count, plural, one {# agent} other {# agents}}",values:{count:e}})," ",l().createElement(c.EuiIconTip,{type:"iInCircle",content:l().createElement(p.FormattedMessage,{"data-test-subj":"selectedAgentCountTooltip",id:"xpack.fleet.agentBulkActions.agentsBreakDownTooltip",defaultMessage:" {totalAgents} total agents: {totalSelected} user-managed agents, {totalManagedAgents} on hosted policies",values:{totalAgents:e,totalManagedAgents:t,totalSelected:e-t}})}))),l().createElement(Be,null)),u?l().createElement(l().Fragment,null,l().createElement(ze,{grow:!1},l().createElement(Ne,null)),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiText,{size:"xs",color:"subdued","data-test-subj":"selectedAgentCountLabel"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.agentsSelected",defaultMessage:"{selectionMode, select, manual { {count, plural, one {# agent} other {# agents}} } other {All agents} } selected",values:{selectionMode:n,count:o.length}})," ","query"===n&&l().createElement(c.EuiIconTip,{type:"iInCircle",content:l().createElement(p.FormattedMessage,{"data-test-subj":"selectedAgentCountTooltip",id:"xpack.fleet.agentBulkActions.agentsSelectedTooltip",defaultMessage:"{totalSelected} user-managed agents selected: {totalAgents} total agents, {totalManagedAgents} on hosted policies. Most actions are only available to user-managed agents.",values:{totalAgents:e,totalManagedAgents:t,totalSelected:e-t}})}))),d?l().createElement(l().Fragment,null,l().createElement(ze,{grow:!1},l().createElement(Ne,null)),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Ue,{size:"xs",flush:"left","data-test-subj":"selectedEverythingOnAllPagesButton",onClick:()=>i("query")},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.selectAll",defaultMessage:"Select everything on all pages"})))):null,l().createElement(ze,{grow:!1},l().createElement(Ne,null)),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Ue,{size:"xs",flush:"left","data-test-subj":"clearAgentSelectionButton",onClick:()=>{i("manual"),r([])}},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.clearSelection",defaultMessage:"Clear selection"})))):l().createElement(ze,{grow:!1})))},We=(0,s.memo)((({agentStatus:e})=>(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"m"},Le.map((t=>(0,O.jsx)(c.EuiFlexItem,{key:t,grow:!1},(0,O.jsx)(Ge,{status:t,count:e[t]||0}))))))),Ge=(0,s.memo)((({status:e,count:t})=>{const{euiTheme:a}=(0,c.useEuiTheme)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiHealth,{color:De(e,a)},(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},function(e){switch(e){case"healthy":return f.i18n.translate("xpack.fleet.agentStatus.healthyLabel",{defaultMessage:"Healthy"});case"offline":return f.i18n.translate("xpack.fleet.agentStatus.offlineLabel",{defaultMessage:"Offline"});case"uninstalled":return f.i18n.translate("xpack.fleet.agentStatus.uninstalledLabel",{defaultMessage:"Uninstalled"});case"inactive":return f.i18n.translate("xpack.fleet.agentStatus.inactiveLabel",{defaultMessage:"Inactive"});case"unenrolled":return f.i18n.translate("xpack.fleet.agentStatus.unenrolledLabel",{defaultMessage:"Unenrolled"});case"unhealthy":return f.i18n.translate("xpack.fleet.agentStatus.unhealthyLabel",{defaultMessage:"Unhealthy"});case"orphaned":return f.i18n.translate("xpack.fleet.agentStatus.orphanedLabel",{defaultMessage:"Orphaned"});case"updating":return f.i18n.translate("xpack.fleet.agentStatus.updatingLabel",{defaultMessage:"Updating"});default:throw new Error(`Unsupported Agent status ${e}`)}}(e)),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiNotificationBadge,{size:"s",color:"subdued"},t)))))})),qe=({agentStatus:e,totalAgents:t,totalManagedAgents:a,selectableAgents:s,managedAgentsOnCurrentPage:n,selectionMode:i,setSelectionMode:o,selectedAgents:r,setSelectedAgents:u,clearFilters:d,isUsingFilter:g})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"flexStart",alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(He,{totalAgents:t,totalManagedAgents:a,selectableAgents:s,managedAgentsOnCurrentPage:n,selectionMode:i,setSelectionMode:o,selectedAgents:r,setSelectedAgents:u})),g?(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiLink,{onClick:()=>d()},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.header.clearFiltersLinkText",defaultMessage:"Clear filters"}))):null),(0,O.jsx)(c.EuiFlexItem,{grow:!1},e&&(0,O.jsx)(We,{agentStatus:e}))),(0,O.jsx)(c.EuiSpacer,{size:"s"}),e&&(0,O.jsx)(Re,{agentStatus:e}));var Ke=a(12845),Ve=a(55964),$e=a(7195),Ye=a(34127),Qe=a(85228),Je=a(73476);const Xe=({search:e,selectedAgentPolicies:t,selectedTags:a,selectedStatus:s,selectedAgentIds:l})=>{let n="";if(e&&(n=e.trim()),null!=t&&t.length&&(n&&(n=`(${n}) and`),n=`${n} ${S.Ah}.policy_id : (${t.map((e=>`"${e}"`)).join(" or ")})`),null!=a&&a.length&&(n&&(n=`(${n}) and`),n=`${n} ${S.Ah}.tags : (${a.map((e=>`"${e}"`)).join(" or ")})`),null!=l&&l.length&&(n&&(n=`(${n}) and`),n=`${n} ${S.Ah}.agent.id : (${l.map((e=>`"${e}"`)).join(" or ")})`),null!=s&&s.length){const e=s.map((e=>{switch(e){case"healthy":return z.ir.buildKueryForOnlineAgents();case"unhealthy":return z.ir.buildKueryForErrorAgents();case"offline":return z.ir.buildKueryForOfflineAgents();case"updating":return z.ir.buildKueryForUpdatingAgents();case"inactive":return z.ir.buildKueryForInactiveAgents();case"unenrolled":return z.ir.buildKueryForUnenrolledAgents();case"orphaned":return z.ir.buildKueryForOrphanedAgents();case"uninstalled":return z.ir.buildKueryForUninstalledAgents()}})).filter((e=>void 0!==e)).join(" or ");n=n?`(${n}) and (${e})`:e}return n.trim()},Ze="local_metadata.elastic.agent.version",et="local_metadata.host.hostname",tt=e=>[Ze,et].includes(e)?`${e}.keyword`:e;const at=[{field:"agent.id",description:f.i18n.translate("xpack.fleet.exportCSV.agentIdField",{defaultMessage:"Agent ID"})},{field:"status",description:f.i18n.translate("xpack.fleet.exportCSV.statusField",{defaultMessage:"Status"})},{field:"local_metadata.host.hostname",description:f.i18n.translate("xpack.fleet.exportCSV.hostnameField",{defaultMessage:"Host Name"})},{field:"policy_id",description:f.i18n.translate("xpack.fleet.exportCSV.policyIdField",{defaultMessage:"Policy ID"})},{field:"last_checkin",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinField",{defaultMessage:"Last Checkin Time"})},{field:"local_metadata.elastic.agent.version",description:f.i18n.translate("xpack.fleet.exportCSV.agentVersionField",{defaultMessage:"Agent Version"})}],st=[{field:"active",description:f.i18n.translate("xpack.fleet.exportCSV.activeField",{defaultMessage:"Active"})},{field:"audit_unenrolled_reason",description:f.i18n.translate("xpack.fleet.exportCSV.auditUnenrolledReasonField",{defaultMessage:"Audit Unenrolled Reason"})},{field:"audit_unenrolled_time",description:f.i18n.translate("xpack.fleet.exportCSV.auditUnenrolledTimeField",{defaultMessage:"Audit Unenrolled Time"})},{field:"enrolled_at",description:f.i18n.translate("xpack.fleet.exportCSV.enrolledAtField",{defaultMessage:"Enrolled At"})},{field:"last_checkin_message",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinMessageField",{defaultMessage:"Last Checkin Message"})},{field:"last_checkin_status",description:f.i18n.translate("xpack.fleet.exportCSV.lastCheckinStatusField",{defaultMessage:"Last Checkin Status"})},{field:"last_updated",description:f.i18n.translate("xpack.fleet.exportCSV.lastUpdatedField",{defaultMessage:"Last Updated Time"})},{field:"local_metadata.elastic.agent.build.original",description:f.i18n.translate("xpack.fleet.exportCSV.agentBuildOriginalField",{defaultMessage:"Agent Build Original"})},{field:"local_metadata.elastic.agent.log_level",description:f.i18n.translate("xpack.fleet.exportCSV.logLevelField",{defaultMessage:"Agent Log Level"})},{field:"local_metadata.elastic.agent.snapshot",description:f.i18n.translate("xpack.fleet.exportCSV.agentSnapshotField",{defaultMessage:"Agent Snapshot"})},{field:"local_metadata.elastic.agent.unprivileged",description:f.i18n.translate("xpack.fleet.exportCSV.agentUnprivilegedField",{defaultMessage:"Agent Unprivileged"})},{field:"local_metadata.elastic.agent.upgradeable",description:f.i18n.translate("xpack.fleet.exportCSV.agentUpgradeableField",{defaultMessage:"Agent Upgradeable"})},{field:"local_metadata.host.architecture",description:f.i18n.translate("xpack.fleet.exportCSV.hostArchitectureField",{defaultMessage:"Host Architecture"})},{field:"local_metadata.host.id",description:f.i18n.translate("xpack.fleet.exportCSV.hostIdField",{defaultMessage:"Host ID"})},{field:"local_metadata.host.ip",description:f.i18n.translate("xpack.fleet.exportCSV.hostIpField",{defaultMessage:"Host IP"})},{field:"local_metadata.host.mac",description:f.i18n.translate("xpack.fleet.exportCSV.hostMacField",{defaultMessage:"Host Mac"})},{field:"local_metadata.host.name",description:f.i18n.translate("xpack.fleet.exportCSV.hostNameField",{defaultMessage:"Host Name"})},{field:"local_metadata.os.family",description:f.i18n.translate("xpack.fleet.exportCSV.osFamilyField",{defaultMessage:"OS Family"})},{field:"local_metadata.os.full",description:f.i18n.translate("xpack.fleet.exportCSV.osFullField",{defaultMessage:"OS Full"})},{field:"local_metadata.os.kernel",description:f.i18n.translate("xpack.fleet.exportCSV.osKernelField",{defaultMessage:"OS Kernel"})},{field:"local_metadata.os.name",description:f.i18n.translate("xpack.fleet.exportCSV.osNameField",{defaultMessage:"OS Name"})},{field:"local_metadata.os.platform",description:f.i18n.translate("xpack.fleet.exportCSV.osPlatformField",{defaultMessage:"OS Platform"})},{field:"local_metadata.os.version",description:f.i18n.translate("xpack.fleet.exportCSV.osVersionField",{defaultMessage:"OS Version"})},{field:"tags",description:f.i18n.translate("xpack.fleet.exportCSV.tagsField",{defaultMessage:"Tags"})},{field:"unenrolled_at",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledAtField",{defaultMessage:"Unenrolled At"})},{field:"unenrolled_reason",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledReasonField",{defaultMessage:"Unenrolled Reason"})},{field:"unenrollment_started_at",description:f.i18n.translate("xpack.fleet.exportCSV.unenrolledStartedAtField",{defaultMessage:"Unenrolled Started At"})},{field:"unhealthy_reason",description:f.i18n.translate("xpack.fleet.exportCSV.unhealthyReasonField",{defaultMessage:"Unhealthy Reason"})},{field:"updated_at",description:f.i18n.translate("xpack.fleet.exportCSV.updatedAtField",{defaultMessage:"Updated At"})},{field:"upgrade_started_at",description:f.i18n.translate("xpack.fleet.exportCSV.upgradeStartedAtField",{defaultMessage:"Upgrade Started At"})},{field:"upgrade_status",description:f.i18n.translate("xpack.fleet.exportCSV.upgradeStatusField",{defaultMessage:"Upgrade Status"})},{field:"upgraded_at",description:f.i18n.translate("xpack.fleet.exportCSV.upgradedAtField",{defaultMessage:"Upgraded At"})},{field:"user_provided_metadata",description:f.i18n.translate("xpack.fleet.exportCSV.userProvidedMetadataField",{defaultMessage:"User Provided Metadata"})}],lt=({onClose:e,onSubmit:t,agentCount:a})=>{const[l,n]=(0,s.useState)(at),i=(0,K.uniqBy)([...at,...st],"field"),o={selectable:()=>!0,onSelectionChange:e=>{n(e)},initialSelected:at};return(0,O.jsx)(c.EuiConfirmModal,{"data-test-subj":"agentExportCSVModal",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.exportCSV.modalTitle",defaultMessage:"Download table results as a CSV file"}),onCancel:e,onConfirm:()=>t(l.map((e=>({field:e.field})))),cancelButtonText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.exportCSV.cancelButtonLabel",defaultMessage:"Cancel"}),confirmButtonText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.exportCSV.confirmButtonLabel",defaultMessage:"Download CSV"})},(0,O.jsx)(c.EuiFlexGroup,{direction:"column",gutterSize:"s"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiText,{color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.exportCSV.agentsCountText",defaultMessage:"Agents"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiNotificationBadge,{color:"subdued",size:"m"},a)))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiSpacer,{size:"s"})),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.exportCSV.modalTableDescription",defaultMessage:"Select the table columns to display in the CSV file"}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiInMemoryTable,{tableCaption:"Column",items:i,itemId:"field",columns:[{field:"field",name:"Field",truncateText:!0},{field:"description",name:"Description",truncateText:!0}],selection:o}))))},nt=()=>{const{notifications:e}=(0,u.WeA)(),t=(0,s.useCallback)((async(t,a,s,l)=>{try{const l=await t();if(l.error)throw l.error;const n=!l.data.actionId,i=null!=s?s:f.i18n.translate("xpack.fleet.updateAgentTags.successNotificationTitle",{defaultMessage:"Tag(s) updated"});e.toasts.addSuccess(i),a(n)}catch(t){const a=null!=l?l:f.i18n.translate("xpack.fleet.updateAgentTags.errorNotificationTitle",{defaultMessage:"Tag(s) update failed"});e.toasts.addError(t,{title:a})}}),[e.toasts]);return{updateTags:(0,s.useCallback)((async(e,a,s,l,n)=>{await t((async()=>await(0,u.FA$)(e,{tags:a})),s,l,n)}),[t]),bulkUpdateTags:(0,s.useCallback)((async(e,a,s,l,n,i)=>{await t((async()=>await(0,u.yX1)({agents:e,tagsToAdd:a,tagsToRemove:s,includeInactive:!0})),l,n,i)}),[t])}},it="fleet.lastSeenInactiveAgentsCount";async function ot(){var e,t;const a=await(0,u.voy)({kuery:"status:online",perPage:0,showInactive:!1});if(a.error)throw new Error(a.error.message);return null!==(e=null===(t=a.data)||void 0===t?void 0:t.total)&&void 0!==e?e:0}const rt="fleet.missingEncryptionKeyCalloutHasBeenDismissed",ut=({tagName:e,isTagHovered:t,onTagsUpdated:a})=>{const[n,i]=(0,s.useState)(!1),[o,r]=(0,s.useState)(),[u,d]=(0,s.useState)(t),[g,m]=(0,s.useState)(e);(0,s.useEffect)((()=>{d(t||n)}),[t,n]),(0,s.useEffect)((()=>{m(e)}),[e]);const x=(e=!1)=>{i(!1),e?v():k(g)},h=nt(),E=h.bulkUpdateTags,y='tags:"{name}"',k=t=>{if(t===e||!t)return;const s=y.replace("{name}",e);E(s,[t],[e],(s=>a([t],[e],s)),f.i18n.translate("xpack.fleet.renameAgentTags.successNotificationTitle",{defaultMessage:"Tag renamed"}),f.i18n.translate("xpack.fleet.renameAgentTags.errorNotificationTitle",{defaultMessage:"Tag rename failed"}))},v=()=>{const t=y.replace("{name}",e);h.bulkUpdateTags(t,[],[e],(t=>a([],[e],t)),f.i18n.translate("xpack.fleet.deleteAgentTags.successNotificationTitle",{defaultMessage:"Tag deleted"}),f.i18n.translate("xpack.fleet.deleteAgentTags.errorNotificationTitle",{defaultMessage:"Tag delete failed"}))};return(0,O.jsx)(l().Fragment,null,u&&(0,O.jsx)(c.EuiButtonIcon,{iconType:"boxesHorizontal","aria-label":f.i18n.translate("xpack.fleet.tagOptions.tagOptionsToggleButtonLabel",{defaultMessage:"Tag Options"}),color:"text",onClick:e=>{r(e.currentTarget),i(!n)}}),n&&(0,O.jsx)(c.EuiWrappingPopover,{isOpen:!0,button:o,closePopover:x,anchorPosition:"downCenter"},(0,O.jsx)(c.EuiFlexGroup,{direction:"column",alignItems:"flexStart",gutterSize:"xs"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFieldText,{placeholder:f.i18n.translate("xpack.fleet.tagOptions.nameTextFieldPlaceholder",{defaultMessage:"Enter new name for tag"}),value:g,required:!0,onKeyDown:e=>{"Enter"===e.key&&x()},onChange:e=>{const t=e.currentTarget.value;m(he(t))}})),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiButtonEmpty,{size:"s",color:"danger",onClick:()=>{x(!0)}},(0,O.jsx)(c.EuiIcon,{type:"trash"})," ",(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.tagOptions.deleteText",defaultMessage:"Delete tag"}))))))},dt=A()(c.EuiHighlight).withConfig({displayName:"TruncatedEuiHighlight",componentId:"sc-492jbf-0"})(["width:120px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;"]),ct=({agentId:e,agents:t,allTags:a,selectedTags:n,button:i,onTagsUpdated:o,onClosePopover:r})=>{const u=(0,s.useCallback)(((e,t)=>e.map((e=>({label:e,checked:t.includes(e)?"on":void 0,onFocusBadge:!1})))),[]),[d,g]=(0,s.useState)(u(a,n)),[m,x]=(0,s.useState)(void 0),[h,E]=(0,s.useState)(!0),[y,k]=(0,s.useState)({}),v=nt();(0,s.useEffect)((()=>{g(u(a,n))}),[a,u,n]);const j=(0,s.useMemo)((()=>d.some((e=>e.label===m))),[d,m]),b=(e,t,s=!0,l=!1)=>{if(s)return o();const n=d.filter((e=>"on"===e.checked)).map((e=>e.label)),i=(0,K.difference)(n,t).concat(e),r=(0,K.uniq)(a.concat(i)),c=l?(0,K.difference)(r,t):r;g(u(c,i))},M=async(a,s,l,i)=>{if(e){const t=(0,K.difference)(n,s).concat(a);v.updateTags(e,t,(()=>o()),l,i)}else v.bulkUpdateTags(t,a,s,(e=>b(a,s,e)),l,i)},S=l().createElement(c.EuiButtonEmpty,{color:"text","data-test-subj":"createTagBtn",onClick:()=>{m&&M([m],[],f.i18n.translate("xpack.fleet.createAgentTags.successNotificationTitle",{defaultMessage:"Tag created"}),f.i18n.translate("xpack.fleet.createAgentTags.errorNotificationTitle",{defaultMessage:"Tag creation failed"}))}},l().createElement(c.EuiFlexGroup,{alignItems:"center",gutterSize:"s"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiIcon,{type:"plus"})),l().createElement(c.EuiFlexItem,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.tagsAddRemove.createText",defaultMessage:'Create a new tag "{name}"',values:{name:m}}))));return l().createElement(l().Fragment,null,l().createElement(c.EuiWrappingPopover,{isOpen:h,button:i,closePopover:()=>{E(!1),r()},anchorPosition:"leftUp"},l().createElement(c.EuiSelectable,{onFocus:()=>{},"aria-label":f.i18n.translate("xpack.fleet.tagsAddRemove.selectableTagsLabel",{defaultMessage:"Add / remove tags"}),searchable:!0,searchProps:{"data-test-subj":"addRemoveTags",placeholder:f.i18n.translate("xpack.fleet.tagsAddRemove.findOrCreatePlaceholder",{defaultMessage:"Find or create tag..."}),onChange:e=>{x(he(e))},value:null!=m?m:""},options:d,renderOption:(e,t)=>l().createElement(c.EuiFlexGroup,{gutterSize:"s",onMouseEnter:()=>k({...y,[e.label]:!0}),onMouseLeave:()=>k({...y,[e.label]:!1})},l().createElement(c.EuiFlexItem,null,l().createElement(dt,{search:t,onClick:()=>{const t="on"===e.checked?[]:[e.label],a="on"===e.checked?[e.label]:[];M(t,a)}},e.label)),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(ut,{tagName:e.label,isTagHovered:y[e.label],onTagsUpdated:(e,t,a)=>b(e,t,a,!0)})))},((e,t)=>l().createElement(s.Fragment,null,t,e))),j&&0!==d.length||""===m?null:S))},gt=({nAgentsInTable:e,totalManagedAgentIds:t,selectionMode:a,currentQuery:n,selectedAgents:i,agentsOnCurrentPage:o,refreshAgents:r,allTags:d,agentPolicies:g,sortField:m,sortOrder:x})=>{const h=(0,u.RR_)(),E=(0,u.iO7)(),y=h.hasAtLeast($.l7o),[k,v]=(0,s.useState)(!1),j=()=>v(!1),[b,M]=(0,s.useState)(!1),[S,F]=(0,s.useState)(!1),[I,T]=(0,s.useState)({isOpen:!1,isScheduled:!1,isUpdating:!1}),[w,C]=(0,s.useState)(!1),[A,P]=(0,s.useState)(!1),[_,L]=(0,s.useState)(!1),D=(0,s.useMemo)((()=>{if(t.length){const e=`${$.AhM}.agent.id : (${t.map((e=>`"${e}"`)).join(" or ")})`;return`(${n}) AND NOT (${e})`}return n}),[n,t]),R="manual"===a?i:D,N="manual"===a?i.length:e-(null==t?void 0:t.length),[z,U]=(0,s.useState)(),{generateReportingJobCSV:H}=function(){const e=(0,Je.WeA)(),{notifications:t,http:a,uiSettings:s}=e,l=(0,Je.Q14)(),{data:n}=(0,Je.VmO)({enabled:!0}),i=n||'emit("")',o=new Ye.ReportingAPIClient(a,s,l);return{generateReportingJobCSV:(a,s,l)=>{const n=o.getDecoratedJobParams(((e,t,a)=>{var s,l;const n=new $e.DataView({spec:{title:".fleet-agents",allowHidden:!0,runtimeFieldMap:{status:{type:"keyword",script:{source:i}}}},fieldFormats:{}});let o;o=Array.isArray(e)?`agent.id:(${e.map((e=>e.id)).join(" OR ")})`:e;const r=tt(null!==(s=null==a?void 0:a.field)&&void 0!==s?s:"enrolled_at"),u=null!==(l=null==a?void 0:a.direction)&&void 0!==l?l:$e.SortDirection.desc,d=(0,B.getSortConfig)(r,u),c={type:"search",query:{query:"",language:"kuery"},filter:{meta:{index:"fleet-agents",params:{}},query:(0,Ve.toElasticsearchQuery)((0,Ve.fromKueryExpression)((0,B.removeSOAttributes)(o)))},fields:t,index:n,sort:d};return{title:"Agent List",objectType:"search",columns:t.map((e=>e.field)),searchSource:c}})(a,s,l));return o.createReportingShareJob("csv_searchsource",n).then((()=>{t.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.modalContent.successfullyQueuedReportNotificationTitle",{defaultMessage:"Queued report for CSV"}),text:(0,Qe.Pv)((0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.modalContent.successfullyQueuedReportNotificationDescription",defaultMessage:"Track its progress in {path}.",values:{path:(0,O.jsx)("a",{href:o.getManagementLink()},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.publicNotifier.reportLink.reportingSectionUrlLinkLabel",defaultMessage:"Stack Management > Reporting"}))}}),e),"data-test-subj":"queueReportSuccess"})})).catch((e=>{var a;t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.modalContent.notification.reportingErrorTitle",{defaultMessage:"Unable to create report"}),toastMessage:(0,O.jsx)("span",{dangerouslySetInnerHTML:{__html:null===(a=e.body)||void 0===a?void 0:a.message}})})}))}}}(),W=[{id:0,items:[{name:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.addRemoveTags","data-test-subj":"agentBulkActionsAddRemoveTags",defaultMessage:"Add / remove tags"}),icon:(0,O.jsx)(c.EuiIcon,{type:"tag",size:"m"}),disabled:!E.fleet.allAgents,onClick:e=>{U(e.target.closest("button")),C(!w)}},{name:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.reassignPolicy","data-test-subj":"agentBulkActionsReassign",defaultMessage:"Assign to new policy"}),icon:(0,O.jsx)(c.EuiIcon,{type:"pencil",size:"m"}),disabled:!E.fleet.allAgents,onClick:()=>{j(),M(!0)}},{name:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.upgradeAgents","data-test-subj":"agentBulkActionsUpgrade",defaultMessage:"Upgrade {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),icon:(0,O.jsx)(c.EuiIcon,{type:"refresh",size:"m"}),disabled:!E.fleet.allAgents,onClick:()=>{j(),T({isOpen:!0,isScheduled:!1,isUpdating:!1})}},{name:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.scheduleUpgradeAgents","data-test-subj":"agentBulkActionsScheduleUpgrade",defaultMessage:"Schedule upgrade for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),icon:(0,O.jsx)(c.EuiIcon,{type:"timeRefresh",size:"m"}),disabled:!E.fleet.allAgents||!y,onClick:()=>{j(),T({isOpen:!0,isScheduled:!0,isUpdating:!1})}},{name:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.restartUpgradeAgents","data-test-subj":"agentBulkActionsRestartUpgrade",defaultMessage:"Restart upgrade {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),icon:(0,O.jsx)(c.EuiIcon,{type:"refresh",size:"m"}),disabled:!E.fleet.allAgents,onClick:()=>{j(),T({isOpen:!0,isScheduled:!1,isUpdating:!0})}},{name:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.requestDiagnostics","data-test-subj":"agentBulkActionsRequestDiagnostics",defaultMessage:"Request diagnostics for {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),disabled:!E.fleet.readAgents,icon:(0,O.jsx)(c.EuiIcon,{type:"download",size:"m"}),onClick:()=>{j(),P(!0)}},{name:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.unenrollAgents","data-test-subj":"agentBulkActionsUnenroll",defaultMessage:"Unenroll {agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:N}}),disabled:!E.fleet.allAgents,icon:(0,O.jsx)(c.EuiIcon,{type:"trash",size:"m"}),onClick:()=>{j(),F(!0)}},{name:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.exportAgents","data-test-subj":"bulkAgentExportBtn",defaultMessage:"Export {agentCount, plural, one {# agent} other {# agents}} as CSV",values:{agentCount:N}}),disabled:!E.fleet.readAgents,icon:(0,O.jsx)(c.EuiIcon,{type:"exportAction",size:"m"}),onClick:()=>{j(),L(!0)}}]}],G=(0,s.useMemo)((()=>((e,t,a)=>{const s=e=>e.reduce(((e,t)=>{var s,l;return(e=>{const t=a.find((t=>t.id===e.policy_id));return!!t&&t.is_managed})(t)?e:e.length<1?null!==(l=t.tags)&&void 0!==l?l:[]:(0,K.intersection)(null!==(s=t.tags)&&void 0!==s?s:[],e)}),[]);return Array.isArray(e)?s(t.length>0?t.filter((t=>e.find((e=>e.id===t.id)))):e):s(t)})(R,null!=o?o:[],g)),[R,o,g]);return(0,O.jsx)(l().Fragment,null,b&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.eN,{agents:R,onClose:()=>{M(!1),r()}})),S&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.VH,{agents:R,agentCount:N,onClose:()=>{F(!1),r({refreshTags:!0})}})),_&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(lt,{onSubmit:e=>{H(R,e,{field:m,direction:x}),L(!1)},onClose:()=>{L(!1)},agentCount:N})),I.isOpen&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.YF,{agents:R,agentCount:N,isScheduled:I.isScheduled,isUpdating:I.isUpdating,onClose:()=>{T({isOpen:!1,isScheduled:!1,isUpdating:!1}),r()}})),w&&(0,O.jsx)(ct,{agents:Array.isArray(R)?R.map((e=>e.id)):R,allTags:null!=d?d:[],selectedTags:G,button:z,onTagsUpdated:()=>{r({refreshTags:!0})},onClosePopover:()=>{C(!1),j()}}),A&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(me,{agents:R,agentCount:N,onClose:()=>{P(!1)}})),(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiPopover,{id:"agentBulkActionsMenu",button:(0,O.jsx)(c.EuiButton,{fill:!0,iconType:"arrowDown",iconSide:"right",onClick:()=>v(!k),"data-test-subj":"agentBulkActionsButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentBulkActions.actions",defaultMessage:"Actions"})),isOpen:k,closePopover:j,panelPaddingSize:"none",anchorPosition:"downLeft"},(0,O.jsx)(c.EuiContextMenu,{initialPanelId:0,panels:W})))))},pt=({onClickAgentActivity:e,showAgentActivityTour:t})=>{var a;const{storage:n,uiSettings:i}=(0,u.WeA)(),[o,r]=(0,s.useState)(t),d=i.get("hideAnnouncements",!1)||!1===(null===(a=n.get(S.EG.AGENT_ACTIVITY))||void 0===a?void 0:a.active);(0,s.useEffect)((()=>{r(t)}),[t,r]);const g=()=>{r({isOpen:!1}),n.set(S.EG.AGENT_ACTIVITY,{active:!1})};return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTourStep,{content:(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityButton.tourContent",defaultMessage:"Review in progress, completed, and scheduled agent action activity history here anytime."})),isStepOpen:!d&&o.isOpen,onFinish:g,minWidth:360,maxWidth:360,step:1,stepsTotal:1,title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityButton.tourTitle",defaultMessage:"Agent activity history"}),anchorPosition:"upCenter",footerAction:(0,O.jsx)(c.EuiButtonEmpty,{onClick:g},"OK"),anchor:"#agentActivityButton"}),(0,O.jsx)(c.EuiButtonEmpty,{onClick:()=>{e(),r({isOpen:!1})},"data-test-subj":"agentActivityButton",iconType:"clock",id:"agentActivityButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityButton",defaultMessage:"Agent activity"})))};var ft=a(97050);const mt=[{status:"healthy",label:f.i18n.translate("xpack.fleet.agentList.statusHealthyFilterText",{defaultMessage:"Healthy"})},{status:"unhealthy",label:f.i18n.translate("xpack.fleet.agentList.statusUnhealthyFilterText",{defaultMessage:"Unhealthy"})},{status:"orphaned",label:f.i18n.translate("xpack.fleet.agentList.statusOrphanedFilterText",{defaultMessage:"Orphaned"})},{status:"updating",label:f.i18n.translate("xpack.fleet.agentList.statusUpdatingFilterText",{defaultMessage:"Updating"})},{status:"offline",label:f.i18n.translate("xpack.fleet.agentList.statusOfflineFilterText",{defaultMessage:"Offline"})},{status:"inactive",label:f.i18n.translate("xpack.fleet.agentList.statusInactiveFilterText",{defaultMessage:"Inactive"})},{status:"unenrolled",label:f.i18n.translate("xpack.fleet.agentList.statusUnenrolledFilterText",{defaultMessage:"Unenrolled"})},{status:"uninstalled",label:f.i18n.translate("xpack.fleet.agentList.statusUninstalledFilterText",{defaultMessage:"Uninstalled"})}],xt=A()(c.EuiNotificationBadge).withConfig({displayName:"LeftpaddedNotificationBadge",componentId:"sc-94zpuo-0"})(["margin-left:10px;"]),ht=({children:e,isOpen:t,setInactiveAgentsCalloutHasBeenDismissed:a})=>l().createElement(c.EuiTourStep,{content:l().createElement(c.EuiText,{size:"s"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentList.inactiveAgentsTourStepContent",defaultMessage:"Some agents have become inactive and have been hidden. Use status filters to show inactive or unenrolled agents."})),isStepOpen:t,minWidth:300,step:1,stepsTotal:0,title:"",onFinish:()=>{},anchorPosition:"upCenter",maxWidth:280,footerAction:l().createElement(c.EuiLink,{onClick:()=>{a(!0)}},l().createElement(p.FormattedMessage,{id:"xpack.fleet.addAgentHelpPopover.footActionButton",defaultMessage:"Got it"}))},e),Et=e=>{const{euiTheme:t}=(0,c.useEuiTheme)(),{selectedStatus:a,onSelectedStatusChange:n,disabled:i,totalInactiveAgents:o,isOpenByDefault:r=!1}=e,[u,d]=(()=>{const{storage:e}=(0,Je.WeA)(),[t,a]=(0,s.useState)(0);return(0,s.useEffect)((()=>{const t=e.get(it);t&&a(parseInt(t,10))}),[e]),[t,t=>{e.set(it,t.toString()),a(t)}]})(),{isHidden:g,dismiss:f}=(0,ft.w)("INACTIVE_AGENTS"),m=(0,s.useMemo)((()=>{const e=o-u;return e<0?0:e}),[u,o]);(0,s.useMemo)((()=>{a.length&&a.includes("inactive")&&m&&d(o)}),[a,m,d,o]),(0,s.useMemo)((()=>{o>0&&u>o&&d(o)}),[u,o,d]);const[x,h]=(0,s.useState)(r),E=e=>{e&&m>0&&!g&&f(),h(e)},y=(0,s.useCallback)((()=>mt.map((({label:e,status:t})=>({label:e,checked:a.includes(t)?"on":void 0,key:t,append:"inactive"===t&&m>0?l().createElement(xt,null,m):void 0})))),[a,m]),[k,v]=(0,s.useState)(y());(0,s.useEffect)((()=>{v(y())}),[y]);const j=(0,s.useCallback)((e=>{v(e),e.forEach(((e,t)=>{if(e.checked===k[t].checked);else{const t=e.key;"on"!==e.checked?n([...a.filter((e=>e!==t))]):n([...a,t])}}))}),[n,k,a]);return l().createElement(ht,{isOpen:m>0&&!g,setInactiveAgentsCalloutHasBeenDismissed:f},l().createElement(c.EuiPopover,{ownFocus:!0,zIndex:Number(t.levels.header)-1,button:l().createElement(c.EuiFilterButton,{iconType:"arrowDown",onClick:()=>E(!x),isSelected:x,hasActiveFilters:a.length>0,numActiveFilters:a.length,numFilters:mt.length,disabled:i,"data-test-subj":"agentList.statusFilter"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentList.statusFilterText",defaultMessage:"Status"})),isOpen:x,closePopover:()=>E(!1),panelPaddingSize:"none"},l().createElement(c.EuiSelectable,{options:k,onChange:j,"data-test-subj":"agentList.agentStatusFilterOptions",listProps:{paddingSize:"s",style:{minWidth:140}}},(e=>e))))};function yt(e=V.DEFAULT_SPACE_ID,t,a){var s,l,n,i,o;if("installed"!==(null==t||null===(s=t.item)||void 0===s?void 0:s.status))return a;const r=t.item.installationInfo;return r&&(null==r?void 0:r.installed_kibana_space_id)!==e&&null!==(l=null===(n=r.additional_spaces_installed_kibana)||void 0===n||null===(i=n[e])||void 0===i||null===(o=i.find((({originId:e})=>e===a)))||void 0===o?void 0:o.id)&&void 0!==l?l:a}const kt=()=>{const{data:e}=(0,u.E1o)($.cOw),{spaceId:t}=(0,u.YI3)(),a=(0,u.e3j)(),s=e=>(null==a?void 0:a.getRedirectUrl({dashboardId:e}))||"",n=yt(t,e,$.K$s.ELASTIC_AGENT_OVERVIEW),i=yt(t,e,$.K$s.ELASTIC_AGENT_AGENT_INFO),{dashboardExists:o,loading:r}=(e=>{const{dashboard:t}=(0,u.WeA)(),{data:a,isLoading:s}=(0,x.useQuery)({queryKey:["dashboard_exists",e],queryFn:async()=>{try{const a=await t.findDashboardsService(),[s]=await a.findByIds([e]);return"success"===(null==s?void 0:s.status)}catch(e){return!1}}});return{dashboardExists:null!=a&&a,loading:s}})(n);return r||!o?null:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexStart"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{iconType:"dashboardApp",href:s(n),"data-test-subj":"ingestOverviewLinkButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.ingestOverviewlinkButton",defaultMessage:"Ingest Overview Metrics"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{iconType:"dashboardApp",href:s(i),"data-test-subj":"agentInfoLinkButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.agentInfoLinkButton",defaultMessage:"Agent Info Metrics"})))))},vt=({selectedAgentPolicies:e,onSelectedAgentPoliciesChange:t,agentPolicies:a})=>{const{euiTheme:l}=(0,c.useEuiTheme)(),[n,i]=(0,s.useState)(!1),o=(0,s.useCallback)((()=>a.map((t=>({label:t.name,checked:e.includes(t.id)?"on":void 0,key:t.id,"data-test-subj":"agentList.agentPolicyFilterOption"})))),[a,e]),[r,u]=(0,s.useState)(o());return(0,s.useEffect)((()=>{u(o())}),[o]),(0,O.jsx)(c.EuiPopover,{ownFocus:!0,zIndex:Number(l.levels.header)-1,button:(0,O.jsx)(c.EuiFilterButton,{iconType:"arrowDown",onClick:()=>i(!n),isSelected:n,hasActiveFilters:e.length>0,numActiveFilters:e.length,numFilters:a.length,disabled:0===a.length,"data-test-subj":"agentList.policyFilter"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.policyFilterText",defaultMessage:"Agent policy"})),isOpen:n,closePopover:()=>i(!1),panelPaddingSize:"none"},(0,O.jsx)(c.EuiSelectable,{options:r,onChange:a=>{u(a),a.forEach(((a,s)=>{if(a.checked===r[s].checked)var l;else{const s=a.key;"on"!==a.checked?(l=s,t(e.filter((e=>e!==l)))):(a=>{t([...e,a])})(s)}}))},"data-test-subj":"agentList.agentPolicyFilterOptions",listProps:{paddingSize:"s",style:{minWidth:200}}},(e=>e)))},jt=({tags:e,selectedTags:t,onSelectedTagsChange:a})=>{const{euiTheme:l}=(0,c.useEuiTheme)(),[n,i]=(0,s.useState)(!1),o=(0,s.useCallback)((()=>e.map((e=>({label:e,checked:t.includes(e)?"on":void 0,key:e,"data-test-subj":"agentList.tagFilterOption"})))),[e,t]),[r,u]=(0,s.useState)(o());return(0,s.useEffect)((()=>{u(o())}),[o]),(0,O.jsx)(c.EuiPopover,{ownFocus:!0,zIndex:Number(l.levels.header)-1,button:(0,O.jsx)(c.EuiFilterButton,{iconType:"arrowDown",onClick:()=>i(!n),isSelected:n,hasActiveFilters:t.length>0,numActiveFilters:t.length,numFilters:e.length,disabled:0===e.length,"data-test-subj":"agentList.tagsFilter"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.tagsFilterText",defaultMessage:"Tags"})),isOpen:n,closePopover:()=>i(!1),panelPaddingSize:"none"},(0,O.jsx)(c.EuiSelectable,{options:r,onChange:e=>{e.forEach(((e,s)=>{if(e.checked!==r[s].checked){const s=e.key;return"on"!==e.checked?void(e=>{a(t.filter((t=>t!==e)))})(s):void(e=>{a([...t,e])})(s)}})),u(e)},"data-test-subj":"agentList.agentPolicyFilterOptions",listProps:{paddingSize:"s",style:{minWidth:140}}},(e=>e)),(0,O.jsx)(c.EuiHorizontalRule,{margin:"none"}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",justifyContent:"center",gutterSize:"s"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{iconType:"error",color:"danger","data-test-subj":"agentList.tagFilterClearAllBtn",onClick:()=>{a([])}},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.tagsFilterClearAllBtnText",defaultMessage:"Clear all"})))))},bt=({recentErrors:e,onClick:t})=>0===e?null:(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityBadge.tooltip",defaultMessage:"{recentErrors, plural, one {There is # new agent activity error} other {There are # new agent activity errors}}. Click to view.",values:{recentErrors:e}})},(0,O.jsx)(c.EuiBadge,{color:"warning",onClick:t,onClickAriaLabel:"Open the Agent activity flyout",iconType:"warning",iconOnClick:t,iconOnClickAriaLabel:"Open the Agent activity flyout","data-test-subj":"agentActivityBadge"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.agentActivityBadge.label",defaultMessage:"Review errors"}))),Mt=({agentPolicies:e,draftKuery:t,onDraftKueryChange:a,onSubmitSearch:s,selectedAgentPolicies:n,onSelectedAgentPoliciesChange:i,selectedStatus:o,onSelectedStatusChange:r,showUpgradeable:d,onShowUpgradeableChange:g,tags:f,selectedTags:m,onSelectedTagsChange:x,nAgentsInTable:h,totalInactiveAgents:E,totalManagedAgentIds:y,selectionMode:k,currentQuery:v,selectedAgents:j,refreshAgents:b,onClickAddAgent:F,onClickAddFleetServer:I,agentsOnCurrentPage:T,onClickAgentActivity:w,showAgentActivityTour:C,latestAgentActionErrors:A,sortField:P,sortOrder:_})=>{const L=(0,u.iO7)(),{isFirstTimeAgentUser:D,isLoading:R}=(0,Ke.X)(),{cloud:B}=(0,u.WeA)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFlexGroup,{direction:"column"},(0,O.jsx)(c.EuiFlexGroup,null,(0,O.jsx)(c.EuiFlexItem,null,!R&&!D&&(0,O.jsx)(kt,null)),(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center",justifyContent:"flexEnd"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(bt,{recentErrors:A,onClick:w})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(pt,{onClickAgentActivity:w,showAgentActivityTour:C})),!L.fleet.addFleetServers||null!=B&&B.isServerlessEnabled?null:(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.addFleetServerButton.tooltip",defaultMessage:"Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents"})},(0,O.jsx)(c.EuiButton,{onClick:I,"data-test-subj":"addFleetServerButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.addFleetServerButton",defaultMessage:"Add Fleet Server"})))),L.fleet.addAgents?(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.addAgentButton.tooltip",defaultMessage:"Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack"})},(0,O.jsx)(c.EuiButton,{fill:!0,onClick:F,"data-test-subj":"addAgentButton"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.addButton",defaultMessage:"Add agent"})))):null)),(0,O.jsx)(c.EuiFlexItem,{grow:4},(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s"},(0,O.jsx)(c.EuiFlexItem,{grow:6},(0,O.jsx)(M.IW,{value:t,fieldPrefix:S.Ah,indexPattern:S.QF,onChange:(e,t)=>{a(e),t&&s(e)},dataTestSubj:"agentList.queryInput"})),(0,O.jsx)(c.EuiFlexItem,{grow:2},(0,O.jsx)(c.EuiFilterGroup,null,(0,O.jsx)(Et,{selectedStatus:o,onSelectedStatusChange:r,totalInactiveAgents:E,disabled:0===e.length}),(0,O.jsx)(jt,{tags:f,selectedTags:m,onSelectedTagsChange:x}),(0,O.jsx)(vt,{selectedAgentPolicies:n,onSelectedAgentPoliciesChange:i,agentPolicies:e}),(0,O.jsx)(c.EuiFilterButton,{hasActiveFilters:d,onClick:()=>{g(!d)},"data-test-subj":"agentList.showUpgradeable"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.showUpgradeableFilterLabel",defaultMessage:"Upgrade available"})))),"manual"===k&&j.length||"query"===k&&h>0?(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(gt,{nAgentsInTable:h,totalManagedAgentIds:y,selectionMode:k,currentQuery:v,selectedAgents:j,agentsOnCurrentPage:T,refreshAgents:b,allTags:f,agentPolicies:e,sortField:P,sortOrder:_})):null))))};var St=a(7817);const Ft=({agent:e,agentPolicy:t,onReassignClick:a,onUnenrollClick:l,onGetUninstallCommandClick:n,onUpgradeClick:i,onAddRemoveTagsClick:o,onRequestDiagnosticsClick:r})=>{const{getHref:d}=(0,u.iEg)(),g=(0,St.i)(),f="unenrolling"===e.status,[m,x]=(0,s.useState)(!1),h=[(0,O.jsx)(c.EuiContextMenuItem,{icon:"inspect",href:d("agent_details",{agentId:e.id}),key:"viewAgent"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.viewActionText",defaultMessage:"View agent"}))];return g.fleet.allAgents&&!1===(null==t?void 0:t.is_managed)&&(h.push((0,O.jsx)(c.EuiContextMenuItem,{icon:"tag",onClick:e=>{o(e.target.closest("button"))},disabled:!e.active,key:"addRemoveTags"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.addRemoveTagsActionText",defaultMessage:"Add / remove tags"})),(0,O.jsx)(c.EuiContextMenuItem,{icon:"pencil",onClick:()=>{a()},disabled:!e.active||!0===(null==t?void 0:t.supports_agentless),key:"reassignPolicy"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),(0,O.jsx)(c.EuiContextMenuItem,{key:"agentUnenrollBtn",disabled:!e.active||!0===(null==t?void 0:t.supports_agentless),icon:"trash",onClick:()=>{l()}},f?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"})),(0,O.jsx)(c.EuiContextMenuItem,{key:"agentUpgradeBtn",icon:"refresh",disabled:!(0,z._3)(e)||!0===(null==t?void 0:t.supports_agentless),onClick:()=>{i()},"data-test-subj":"upgradeBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))),g.fleet.allAgents&&(0,ge.isStuckInUpdating)(e)&&h.push((0,O.jsx)(c.EuiContextMenuItem,{key:"agentRestartUpgradeBtn",icon:"refresh",onClick:()=>{i()},"data-test-subj":"restartUpgradeBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.restartUpgradeOneButton",defaultMessage:"Restart upgrade"}))),!g.fleet.allAgents||!e.policy_id||null!=t&&t.supports_agentless||h.push((0,O.jsx)(c.EuiContextMenuItem,{icon:"minusInCircle",onClick:()=>{n(),x(!1)},disabled:!e.active,key:"getUninstallCommand","data-test-subj":"uninstallAgentMenuItem"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.getUninstallCommand",defaultMessage:"Uninstall agent"})))),g.fleet.readAgents&&h.push((0,O.jsx)(c.EuiContextMenuItem,{key:"requestAgentDiagnosticsBtn",icon:"download","data-test-subj":"requestAgentDiagnosticsBtn",disabled:!(0,I.fx)(e),onClick:()=>{r()}},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}))),(0,O.jsx)(M.AK,{isOpen:m,onChange:e=>x(e),items:h})},It={POLICY_REASSIGN:{inProgressText:"Reassigning",completedText:"assigned to a new policy",cancelledText:"assignment"},UPGRADE:{inProgressText:"Upgrading",completedText:"upgraded",cancelledText:"upgrade"},UNENROLL:{inProgressText:"Unenrolling",completedText:"unenrolled",cancelledText:"unenrollment"},FORCE_UNENROLL:{inProgressText:"Force unenrolling",completedText:"force unenrolled",cancelledText:"force unenrollment"},AUTOMATIC_FORCE_UNENROLL:{inProgressText:"Automatic unenrolling",completedText:"automatically unenrolled",cancelledText:"automatic unenrollment"},UPDATE_TAGS:{inProgressText:"Updating tags of",completedText:"updated tags",cancelledText:"update tags"},CANCEL:{inProgressText:"Cancelling",completedText:"cancelled",cancelledText:""},REQUEST_DIAGNOSTICS:{inProgressText:"Requesting diagnostics for",completedText:"requested diagnostics",cancelledText:"request diagnostics"},SETTINGS:{inProgressText:"Updating settings of",completedText:"updated settings",cancelledText:"update settings"},POLICY_CHANGE:{inProgressText:"Applying policy change on",completedText:"applied policy change",cancelledText:"policy change"},INPUT_ACTION:{inProgressText:"Input action in progress of",completedText:"input action completed",cancelledText:"input action"},ACTION:{inProgressText:"Actioning",completedText:"actioned",cancelledText:"action"}},Tt=(e,t)=>{var a;return null!=t&&t.includes("UnenrollInactiveAgentsTask-")?It.AUTOMATIC_FORCE_UNENROLL:null!==(a=It[null!=e?e:"ACTION"])&&void 0!==a?a:It.ACTION},wt=e=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivity.inProgressTitle",defaultMessage:"{inProgressText} {nbAgents} {agents} {reassignText}{upgradeText}{failuresText}",values:{nbAgents:e.nbAgentsAck>=e.nbAgentsActioned?e.nbAgentsAck:0===e.nbAgentsAck?e.nbAgentsActioned:e.nbAgentsActioned-e.nbAgentsAck+" of "+e.nbAgentsActioned,agents:1===e.nbAgentsActioned?"agent":"agents",inProgressText:Tt(e.type,e.actionId).inProgressText,reassignText:"POLICY_REASSIGN"===e.type&&e.newPolicyId?`to ${e.newPolicyId}`:"",upgradeText:"UPGRADE"===e.type?`to version ${e.version}`:"",failuresText:e.nbAgentsFailed>0?`, has ${e.nbAgentsFailed} failure(s)`:""}}),Ct=e=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.startedDescription",defaultMessage:"Started on {date}.",values:{date:At(e)}}),At=e=>e?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"})," ",(0,O.jsx)(p.FormattedTime,{value:e})):null,Pt=({action:e,onClickViewAgents:t})=>{const a=(0,s.useMemo)((()=>e.nbAgentsActionCreated>1e3),[e]);if("UPDATE_TAGS"===e.type)return null;const l=(0,O.jsx)(c.EuiButtonEmpty,{size:"m",onClick:()=>t(e),flush:"left","data-test-subj":"agentActivityFlyout.viewAgentsButton",disabled:a},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButton",defaultMessage:"View Agents"}));return a?(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButtonDisabledMaxTooltip",defaultMessage:"The view agents feature is only available for action impacting less than {agentCount} agents",values:{agentCount:1e3}})},l):"POLICY_CHANGE"===e.type?(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.viewAgentsButtonPolicyChangeTooltip",defaultMessage:"View agents currently assigned to this policy"})},l):l},_t=({action:e,abortUpgrade:t,onClickViewAgents:a})=>{const{docLinks:n}=(0,u.WeA)(),i=(0,c.useEuiTheme)(),[o,r]=(0,s.useState)(!1),d=(0,s.useCallback)((async()=>{try{r(!0),await t(e)}finally{r(!1)}}),[e,t]),g=(0,s.useMemo)((()=>{if(!e.startTime)return!1;const t=Date.now();return new Date(e.startTime).getTime()>t}),[e]),f=(0,s.useMemo)((()=>g||e.hasRolloutPeriod),[e,g]);return(0,O.jsx)(c.EuiPanel,{hasBorder:!0,borderRadius:"none"},(0,O.jsx)(c.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},g?(0,O.jsx)(c.EuiIcon,{type:"clock"}):(0,O.jsx)(c.EuiLoadingSpinner,{size:"m"})),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{color:i.euiTheme.colors.textPrimary,"data-test-subj":"upgradeInProgressTitle"},g&&e.startTime?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.scheduleTitle",defaultMessage:"{nbAgents} agents scheduled to upgrade to version {version}",values:{nbAgents:e.nbAgentsActioned-e.nbAgentsAck,version:e.version}}):wt(e))))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFlexGroup,{direction:"column",alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{color:"subdued","data-test-subj":"upgradeInProgressDescription"},(0,O.jsx)("p",null,g&&e.startTime?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.scheduledDescription",defaultMessage:"Scheduled for "}),(0,O.jsx)("strong",null,At(e.startTime)),". "):(0,O.jsx)(l().Fragment,null,Ct(e.creationTime)," "),(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.upgradeDescription",defaultMessage:"{guideLink} about agent upgrades.",values:{guideLink:(0,O.jsx)(c.EuiLink,{href:n.links.fleet.upgradeElasticAgent,target:"_blank"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.guideLink",defaultMessage:"Learn more"}))}})))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(Pt,{action:e,onClickViewAgents:a})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},f?(0,O.jsx)(c.EuiButton,{size:"s",onClick:d,isLoading:o,"data-test-subj":"abortBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.abortUpgradeButtom",defaultMessage:"Cancel"})):null)))))};var Lt=a(57016);const Dt=({agentId:e,datasets:t,logLevels:a,userQuery:s})=>{const l=`${Lt.JQ.name}:${e}`,n=t.length?t.map((e=>`${Lt.Ep.name}:${e}`)).join(" or "):`${Lt.Ep.name}:${Lt.tO} or ${Lt.Ep.name}:${Lt.sn}`,i=a.map((e=>`${Lt.Jt.name}:${e}`)).join(" or "),o=`${l} and (${n})`,r=i?`${o} and (${i})`:o;return s?`(${r}) and (${s})`:r};var Ot=a(66764);const Rt=e=>new Date(e).getTime(),Bt=({logStreamQuery:e,startTime:t,endTime:a})=>{const{share:l}=(0,u.WeA)(),n=(0,Ot.getLogsLocatorFromUrlService)(l.url),i=(0,u.iO7)(),o=(0,s.useMemo)((()=>{const s=be()().toISOString(),l=be()().subtract(1,"day").toISOString(),i=Rt(l),o=Rt(s);return null==n?void 0:n.getRedirectUrl({time:a||o,timeRange:{from:(0,Ot.getTimeRangeStartFromTime)(t||i),to:(0,Ot.getTimeRangeEndFromTime)(a||o)},query:{language:"kuery",query:e}})}),[a,e,n,t]);return i.fleet.readAgents&&o?(0,O.jsx)(c.EuiButton,{href:o,iconType:"discoverApp","data-test-subj":"viewInLogsBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentLogs.openInDiscoverUiLinkText",defaultMessage:"Open in Discover"})):null},Nt=A()(c.EuiText).withConfig({displayName:"TruncatedEuiText",componentId:"sc-1ioa7tn-0"})(["overflow:hidden;max-height:3rem;text-overflow:ellipsis;"]),zt=({action:e})=>{var t;const a=(0,u.WeA)(),s=(0,c.useEuiTheme)(),n=[{field:"hostname",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.hostnameColumnTitle",{defaultMessage:"Host Name"}),render:e=>l().createElement(c.EuiText,{size:"s","data-test-subj":"hostText"},e)},{field:"error",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.errorColumnTitle",{defaultMessage:"Error Message"}),render:e=>l().createElement(c.EuiToolTip,{content:e},l().createElement(Nt,{size:"s",color:s.euiTheme.colors.textDanger,"data-test-subj":"errorText"},e))},{field:"agentId",name:f.i18n.translate("xpack.fleet.agentList.viewErrors.actionColumnTitle",{defaultMessage:"Action"}),render:t=>{var s;const n=(null!==(s=e.latestErrors)&&void 0!==s?s:[]).find((e=>e.agentId===t));return l().createElement(k.V,{coreStart:a},((e,t)=>{const a=be()(t).subtract(5,"m").toISOString(),s=be()(t).add(5,"m").toISOString(),n=Rt(a),i=Rt(s),o=Dt({agentId:e,datasets:["elastic_agent"],logLevels:["error"],userQuery:""});return l().createElement(Bt,{logStreamQuery:o,startTime:n,endTime:i})})(t,n.timestamp))}}];return l().createElement(l().Fragment,null,l().createElement(c.EuiAccordion,{id:e.actionId+"_errors",buttonContent:"Show errors"},l().createElement(c.EuiBasicTable,{items:null!==(t=e.latestErrors)&&void 0!==t?t:[],columns:n,tableLayout:"auto"})))},Ut=({action:e,onClickViewAgents:t})=>{const a=(0,c.useEuiTheme)(),s="POLICY_CHANGE"===e.type&&0===e.nbAgentsActioned?(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivity.policyChangeCompletedTitle",defaultMessage:"Policy changed"})):(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivity.completedTitle",defaultMessage:"{nbAgents} {agents} {completedText}{offlineText}",values:{nbAgents:e.nbAgentsAck===e.nbAgentsActioned?e.nbAgentsAck:e.nbAgentsAck+" of "+e.nbAgentsActioned,agents:1===e.nbAgentsActioned?"agent":"agents",completedText:Tt(e.type,e.actionId).completedText,offlineText:"ROLLOUT_PASSED"===e.status&&e.nbAgentsActioned-e.nbAgentsAck>0?`, ${e.nbAgentsActioned-e.nbAgentsAck} agent(s) offline during the rollout period`:""}})),l=(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.completedDescription",defaultMessage:"Completed {date}",values:{date:"0001-01-01T00:00:00.000Z"===e.completionTime?null:At(e.completionTime)}}),n=(0,O.jsx)(c.EuiText,{color:"subdued"},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.failureDescription",defaultMessage:"A problem occurred during this operation."})," ",Ct(e.creationTime))),i={IN_PROGRESS:{icon:(0,O.jsx)(c.EuiLoadingSpinner,{size:"m"}),title:(0,O.jsx)(c.EuiText,null,wt(e)),titleColor:a.euiTheme.colors.textPrimary,description:(0,O.jsx)(c.EuiText,{color:"subdued"},Ct(e.creationTime))},ROLLOUT_PASSED:{icon:e.nbAgentsFailed>0?(0,O.jsx)(c.EuiIcon,{size:"m",type:"warning",color:"danger"}):(0,O.jsx)(c.EuiIcon,{size:"m",type:"checkInCircleFilled",color:"success"}),title:s,titleColor:e.nbAgentsFailed>0?a.euiTheme.colors.textDanger:a.euiTheme.colors.textSuccess,description:e.nbAgentsFailed>0?n:(0,O.jsx)(c.EuiText,{color:"subdued"},l)},COMPLETE:{icon:(0,O.jsx)(c.EuiIcon,{size:"m",type:"checkInCircleFilled",color:"success"}),title:s,titleColor:a.euiTheme.colors.textSuccess,description:"POLICY_REASSIGN"===e.type&&e.newPolicyId?(0,O.jsx)(c.EuiText,{color:"subdued"},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.reassignCompletedDescription",defaultMessage:"Assigned to {policy}.",values:{policy:e.newPolicyId}})," ",l)):"POLICY_CHANGE"===e.type?(0,O.jsx)(c.EuiText,{color:"subdued"},(0,O.jsx)("p",null,(0,O.jsx)("b",null,e.policyId)," ",(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.policyChangedDescription",defaultMessage:"changed to revision {rev} at {date}.",values:{rev:e.revision,date:At(e.creationTime)}}))):(0,O.jsx)(c.EuiText,{color:"subdued"},l)},FAILED:{icon:(0,O.jsx)(c.EuiIcon,{size:"m",type:"warning",color:"danger"}),title:s,titleColor:a.euiTheme.colors.textDanger,description:n},CANCELLED:{icon:(0,O.jsx)(c.EuiIcon,{size:"m",type:"warning",color:"subdued"}),titleColor:a.euiTheme.colors.textSubdued,title:(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.cancelledTitle",defaultMessage:"Agent {cancelledText} cancelled",values:{cancelledText:Tt(e.type,e.actionId).cancelledText}})),description:(0,O.jsx)(c.EuiText,{color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.cancelledDescription",defaultMessage:"Cancelled on {date}",values:{date:At(e.cancellationTime)}}))},EXPIRED:{icon:(0,O.jsx)(c.EuiIcon,{size:"m",type:"warning",color:"subdued"}),titleColor:a.euiTheme.colors.textSubdued,title:(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.expiredTitle",defaultMessage:"Agent {expiredText} expired",values:{expiredText:Tt(e.type,e.actionId).cancelledText}})),description:(0,O.jsx)(c.EuiText,{color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.expiredDescription",defaultMessage:"Expired on {date}",values:{date:At(e.expiration)}}))}};return(0,O.jsx)(c.EuiPanel,{hasBorder:!0,borderRadius:"none"},(0,O.jsx)(c.EuiFlexGroup,{direction:"column",gutterSize:"m"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},i[e.status].icon),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{color:i[e.status].titleColor,"data-test-subj":"statusTitle"},i[e.status].title)))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{color:"subdued","data-test-subj":"statusDescription"},i[e.status].description)),(0,O.jsx)(c.EuiFlexItem,{grow:!1},"FAILED"===e.status&&e.latestErrors&&e.latestErrors.length>0?(0,O.jsx)(zt,{action:e}):null)),(0,O.jsx)(c.EuiSpacer,{size:"xs"}),(0,O.jsx)(Pt,{action:e,onClickViewAgents:t}))},Ht=({title:e,actions:t,abortUpgrade:a,onClickViewAgents:s})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiPanel,{color:"subdued",hasBorder:!0,borderRadius:"none"},(0,O.jsx)(c.EuiText,null,(0,O.jsx)("b",null,e))),t.map((e=>"UPGRADE"===e.type&&"IN_PROGRESS"===e.status?(0,O.jsx)(_t,{action:e,abortUpgrade:a,key:e.actionId,onClickViewAgents:s}):(0,O.jsx)(Ut,{action:e,key:e.actionId,onClickViewAgents:s})))),Wt=e=>(0,O.jsx)(c.EuiDatePicker,{"data-test-subj":"agentActivityFlyout.goToDateButton",selected:e.selectedDate,onChange:e.onChangeSelectedDate,maxDate:be()(),customInput:e.filledStyle?(0,O.jsx)(Gt,e):(0,O.jsx)(qt,e)}),Gt=(0,s.forwardRef)((({onClick:e,value:t},a)=>(0,O.jsx)(c.EuiButton,{fill:!0,onClick:e},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.emptyState.goToDateButton",defaultMessage:"Go to date"})))),qt=(0,s.forwardRef)((({onClick:e,value:t},a)=>(0,O.jsx)(c.EuiButtonEmpty,{size:"m",flush:"left",onClick:e},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.goToDateButton",defaultMessage:"Go to date"})))),Kt=()=>(new Date).toISOString().substring(0,10),Vt=A()(c.EuiFlyoutBody).withConfig({displayName:"FullHeightFlyoutBody",componentId:"sc-1p58nye-0"})([".euiFlyoutBody__overflowContent{height:100%;}"]),$t=A()(c.EuiFlexGroup).withConfig({displayName:"ButtonsFlexGroup",componentId:"sc-1p58nye-1"})(["padding-left:24px;"]),Yt=A().div.withConfig({displayName:"ScrollAnchor",componentId:"sc-1p58nye-2"})(["height:0;margin:0;padding:0;"]),Qt=({isFirstLoading:e,currentActions:t,abortUpgrade:a,onClickViewAgents:s,areActionsFullyLoaded:n,onClickShowMore:i,dateFilter:o,onChangeDateFilter:r})=>{const u=l().useRef(null);if(l().useEffect((()=>{var e;null!==(e=u.current)&&void 0!==e&&e.scrollIntoView&&u.current.scrollIntoView()}),[o]),e)return l().createElement(Vt,null,l().createElement(c.EuiFlexGroup,{direction:"row",justifyContent:"center",alignItems:"center",className:"eui-fullHeight"},l().createElement(c.EuiFlexItem,null,l().createElement(pe.Rh,null))));if(0===t.length)return l().createElement(Vt,null,l().createElement(Yt,{ref:u}),l().createElement(c.EuiFlexGroup,{direction:"column",justifyContent:"center",alignItems:"center",className:"eui-fullHeight"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiEmptyPrompt,{iconType:"clock",iconColor:"default",title:l().createElement("h2",null," ",l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.noActivityText",defaultMessage:"No activity to display"})),titleSize:"m",body:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.noActivityDescription",defaultMessage:"Activity feed will appear here as agents are reassigned, upgraded, or unenrolled."})})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Wt,{selectedDate:o,onChangeSelectedDate:r,filledStyle:!0})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{onClick:()=>r(null)},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.emptyState.showMoreButton",defaultMessage:"Clear selected date"})))));const d=t.filter((e=>"IN_PROGRESS"===e.status)),g=t.filter((e=>"IN_PROGRESS"!==e.status)),f=g.filter((e=>e.creationTime.startsWith(Kt()))),m=function(e){const t={};return e.filter((e=>!e.creationTime.startsWith(Kt()))).forEach((e=>{const a=e.creationTime.substring(0,10);t[a]||(t[a]=[]),t[a].push(e)})),t}(g);return l().createElement(Vt,null,l().createElement(Yt,{ref:u}),l().createElement(c.EuiFlexGroup,{direction:"column"},l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiFlexGroup,{direction:"column"},d.length>0?l().createElement(Ht,{title:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.inProgressTitle",defaultMessage:"In progress"}),actions:d,abortUpgrade:a,onClickViewAgents:s}):null,f.length>0?l().createElement(Ht,{title:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.todayTitle",defaultMessage:"Today"}),actions:f,abortUpgrade:a,onClickViewAgents:s}):null,Object.keys(m).map((e=>l().createElement(Ht,{key:e,title:l().createElement(p.FormattedDate,{value:e,year:"numeric",month:"short",day:"2-digit"}),actions:m[e],abortUpgrade:a,onClickViewAgents:s}))))),l().createElement(c.EuiFlexItem,null,l().createElement($t,{direction:"row",gutterSize:"s",alignItems:"center"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{size:"m",onClick:i,disabled:n,flush:"left","data-test-subj":"agentActivityFlyout.showMoreButton"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.showMoreButton",defaultMessage:"Show more"}))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Wt,{selectedDate:o,onChangeSelectedDate:r,filledStyle:!1})),o&&l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{size:"m",onClick:()=>r(null),flush:"left","data-test-subj":"agentActivityFlyout.clearSelectedDateButton"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.clearSelectedDateutton",defaultMessage:"Clear selected date"})))))))},Jt=A()(c.EuiFlyoutFooter).withConfig({displayName:"FlyoutFooterWPadding",componentId:"sc-7yfogs-0"})(["padding:16px 24px !important;"]),Xt=({onClose:e,onAbortSuccess:t,refreshAgentActivity:a,setSearch:n,setSelectedStatus:i})=>{const{notifications:o}=(0,u.WeA)(),{data:r}=(0,u.$sk)({perPage:S.W}),[d,g]=(0,s.useState)(20),[m,x]=(0,s.useState)(null),{currentActions:h,abortUpgrade:E,isFirstLoading:y,areActionsFullyLoaded:k}=function(e,t,a,l){const[n,i]=(0,s.useState)(!0),[o,r]=(0,s.useState)([]),[d,c]=(0,s.useState)(0),[g,p]=(0,s.useState)(!1),{notifications:m,overlays:x}=(0,u.WeA)(),h=(0,s.useCallback)((async()=>{try{const e=await(0,u.RYf)({perPage:a,date:null==l?void 0:l.format()});if(i(!1),e.error)throw e.error;if(!e.data)throw new Error("No data");p(d<a),c(e.data.items.length),r(e.data.items)}catch(e){m.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.actionStatus.fetchRequestError",{defaultMessage:"An error happened while fetching action status"})})}}),[a,l,d,m.toasts]);return n&&h(),(0,s.useEffect)((()=>{t&&h()}),[h,t]),(0,s.useEffect)((()=>{h()}),[h,a]),{currentActions:o,abortUpgrade:(0,s.useCallback)((async t=>{try{if(!await x.openConfirm(f.i18n.translate("xpack.fleet.currentUpgrade.confirmDescription",{defaultMessage:"This action will cancel upgrade of {nbAgents, plural, one {# agent} other {# agents}}",values:{nbAgents:t.nbAgentsActioned-t.nbAgentsAck}}),{title:f.i18n.translate("xpack.fleet.currentUpgrade.confirmTitle",{defaultMessage:"Cancel upgrade?"})}))return;await(0,u.DRU)(t.actionId),await Promise.all([h(),e()])}catch(e){m.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.currentUpgrade.abortRequestError",{defaultMessage:"An error happened while cancelling upgrade"})})}}),[h,m.toasts,x,e]),isFirstLoading:n,areActionsFullyLoaded:g}}(t,a,d,m),v=(0,s.useCallback)((e=>{var t;const a=null==r?void 0:r.items.find((t=>t.id===e));return null!==(t=null==a?void 0:a.name)&&void 0!==t?t:e}),[r]),j=(0,s.useMemo)((()=>h.map((e=>{var t,a;return{...e,newPolicyId:v(null!==(t=e.newPolicyId)&&void 0!==t?t:""),policyId:v(null!==(a=e.policyId)&&void 0!==a?a:"")}}))),[h,v]);return l().createElement(l().Fragment,null,l().createElement(c.EuiFlyout,{"data-test-subj":"agentActivityFlyout",onClose:()=>{a=!1,e()},paddingSize:"none",maxWidth:S.MW},l().createElement(c.EuiFlyoutHeader,{"aria-labelledby":"FleetAgentActivityFlyoutTitle"},l().createElement(c.EuiPanel,{borderRadius:"none",hasShadow:!1,hasBorder:!0},l().createElement(c.EuiFlexGroup,{direction:"column",gutterSize:"m"},l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiTitle,{size:"l"},l().createElement("h1",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.title",defaultMessage:"Agent activity"})))),l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiText,{color:"subdued"},l().createElement("p",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.activityLogText",defaultMessage:"Activity log of Elastic Agent operations will appear here."}))))))),l().createElement(Qt,{isFirstLoading:y,currentActions:j,abortUpgrade:E,onClickViewAgents:async t=>{try{var a;const{data:s}=await(0,u.DTC)({actionIds:[t.actionId]});if(null!=s&&null!==(a=s.items)&&void 0!==a&&a.length){const e=Xe({selectedAgentIds:s.items});n(e)}i(Le),e()}catch(e){o.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentActivityFlyout.error",{defaultMessage:"Error viewing selected agents"})})}},areActionsFullyLoaded:k,onClickShowMore:()=>{g(d+10)},dateFilter:m,onChangeDateFilter:e=>{var t;x(null!==(t=null==e?void 0:e.startOf("day"))&&void 0!==t?t:null),g(20)}}),l().createElement(Jt,null,l().createElement(c.EuiFlexGroup,{justifyContent:"flexStart"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{onClick:e},l().createElement(c.EuiText,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentActivityFlyout.closeBtn",defaultMessage:"Close"}))))))))},Zt=()=>{var e;const{cloud:t}=(0,u.WeA)();(0,u.ifo)("agent_list");const[a,n]=(0,s.useState)([]),[i,r]=(0,s.useState)("manual"),[d,g]=(0,s.useState)({isOpen:!1}),[p,m]=(0,s.useState)(!1),h=(0,u.Wdf)(),[E,y]=(0,s.useState)(void 0),[k,v]=(0,s.useState)(void 0),[j,b]=(0,s.useState)(void 0),[F,T]=(0,s.useState)(void 0),[w,C]=(0,s.useState)(void 0),[A,P]=(0,s.useState)(),[_,L]=(0,s.useState)(!1),[D,R]=(0,s.useState)(void 0),[B,N]=(0,s.useState)({isOpen:!1}),{allTags:U,agentsOnCurrentPage:H,agentsStatus:W,isLoading:G,nAgentsInTable:q,totalInactiveAgents:V,totalManagedAgentIds:$,managedAgentsOnCurrentPage:Y,showUpgradeable:Q,setShowUpgradeable:J,search:X,setSearch:Z,selectedAgentPolicies:ee,setSelectedAgentPolicies:te,sortField:ae,setSortField:se,sortOrder:le,setSortOrder:ne,selectedStatus:ie,setSelectedStatus:oe,selectedTags:re,setSelectedTags:ue,allAgentPolicies:de,agentPoliciesRequest:ce,agentPoliciesIndexedById:fe,pagination:xe,pageSizeOptions:he,setPagination:Ee,kuery:ye,draftKuery:ke,setDraftKuery:ve,fetchData:je,currentRequestRef:be,latestAgentActionErrors:Me,setLatestAgentActionErrors:Se}=function(){const e=function(){const e=(0,u.iO7)(),t=(0,s.useRef)({}),a=(0,s.useCallback)((async a=>{const s=a.reduce(((e,a)=>(t.current[a]||e.push(a),e)),[]);if(s.length){const a=await(0,u.IDi)(s,{full:e.fleet.readAgentPolicies,ignoreMissing:!0});if(a.error)throw a.error;if(!a.data)throw new Error("Invalid bulk GET agent policies response");a.data.items.forEach((e=>{t.current[e.id]=e}))}return a.reduce(((e,a)=>(t.current[a]&&e.push(t.current[a]),e)),[])}),[e.fleet.readAgentPolicies]);return(0,s.useMemo)((()=>({fetchPolicies:a})),[a])}(),{notifications:t}=(0,u.WeA)(),a=(0,o.useHistory)(),{urlParams:l,toUrlParams:n}=(0,u.zmo)(),i=l.kuery||"",r="true"===l.showInactive,[d,c]=(0,s.useState)(!1),[g,p]=(0,s.useState)(i),[m,x]=(0,s.useState)(i),{pagination:h,pageSizeOptions:E,setPagination:y}=(0,u.WQC)(),[k,v]=(0,s.useState)("enrolled_at"),[j,b]=(0,s.useState)("desc"),[M,F]=(0,s.useState)([]),[T,w]=(0,s.useState)(["healthy","unhealthy","orphaned","updating","offline",...r?["inactive"]:[]]),[C,A]=(0,s.useState)([]),P=(0,s.useMemo)((()=>T.some((e=>"inactive"===e))||0===T.length),[T]),_=(0,s.useMemo)((()=>T.some((e=>"unenrolled"===e))||0===T.length),[T]),L=(0,s.useCallback)((e=>{x(e),(""!==e.trim()||l.kuery)&&l.kuery!==e&&a.replace({search:n({...l,kuery:""===e?void 0:e})})}),[l,a,n]);let D=(0,s.useMemo)((()=>Xe({search:m,selectedAgentPolicies:M,selectedTags:C,selectedStatus:T})),[m,M,T,C]);D=_&&D?`status:* AND (${D})`:_?"status:*":D;const[O,R]=(0,s.useState)([]),[B,N]=(0,s.useState)(),[U,H]=(0,s.useState)(),[W,G]=(0,s.useState)(!1),[q,V]=(0,s.useState)(0),[$,Y]=(0,s.useState)(0),[Q,J]=(0,s.useState)([]),[X,Z]=(0,s.useState)(0),[ee,te]=(0,s.useState)({}),[ae,se]=(0,s.useState)([]),le=(0,s.useRef)(!1),ne=(0,s.useRef)(0),ie=(0,s.useCallback)((({refreshTags:a=!1}={})=>{!async function(){if(le.current)return;ne.current++;const s=ne.current;le.current=!0;try{var l,n,i;G(!0);const[t,c,g,p,f]=await Promise.all([(0,u.voy)({page:h.currentPage,perPage:h.pageSize,kuery:D&&""!==D?D:void 0,sortField:tt(k),sortOrder:j,showInactive:P,showUpgradeable:d,getStatusSummary:!0,withMetrics:!0}),(0,u.Wwg)({kuery:z.ir.buildKueryForInactiveAgents()}),(0,u.cnO)({kuery:`${S.mm}.is_managed:true`,perPage:S.W,full:!1}),(0,u.n_W)({showInactive:P}),(0,u.RYf)({latest:35e3,perPage:100})]);if(ne.current!==s)return;if(t.error)throw t.error;if(!t.data)throw new Error("Invalid GET /agents response");if(!c.data)throw new Error("Invalid GET /agents_status response");if(g.error)throw new Error(g.error.message);if(p.error)throw p.error;if(!p.data)throw new Error("Invalid GET /agent/tags response");if(f.error)throw new Error("Invalid GET /agents/action_status response");const x=t.data.statusSummary;if(!x)throw new Error("Invalid GET /agents response - no status summary");const E=t.data.items.map((e=>e.policy_id)),y=await e.fetchPolicies(E);if(le.current=!1,ne.current!==s)return;te(y.reduce(((e,t)=>(e[t.id]=t,e)),{})),N((0,I.db)(x));const v=p.data.items;U&&!a&&(0,K.isEqual)(v,U)||H(v),R(t.data.items),V(t.data.total),Y(c.data.results.inactive||0);const b=null!==(l=null===(n=g.data)||void 0===n?void 0:n.items)&&void 0!==l?l:[];if(0===b.length)J([]),Z(0);else{var o,r;const e=Xe({search:m,selectedAgentPolicies:b.map((e=>e.id)),selectedTags:C,selectedStatus:T}),a=await(0,u.voy)({kuery:`${e}`,perPage:S.W,showInactive:P});if(a.error)throw new Error(a.error.message);const s=null!==(o=null===(r=a.data)||void 0===r?void 0:r.items)&&void 0!==o?o:[],l=null==s?void 0:s.map((e=>e.id));J(l),Z(t.data.items.map((e=>e.id)).filter((e=>l.includes(e))).length)}const M=(null===(i=f.data)||void 0===i?void 0:i.items.filter((e=>{var t,a;return null!==(t=null===(a=e.latestErrors)||void 0===a?void 0:a.length)&&void 0!==t&&t})).map((e=>e.actionId)))||[],F=[...new Set([...ae,...M])];(0,K.isEqual)(ae,F)||se(F)}catch(e){le.current=!1,t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentList.errorFetchingDataTitle",{defaultMessage:"Error fetching agents"})})}G(!1)}()}),[h.currentPage,h.pageSize,D,k,j,P,d,e,U,ae,m,C,T,t.toasts]);(0,s.useEffect)((()=>{ie();const e=setInterval((()=>{ie()}),3e4);return()=>clearInterval(e)}),[ie]);const oe=(0,u.$sk)({page:1,perPage:S.W}),re=(0,s.useMemo)((()=>{var e;return(null===(e=oe.data)||void 0===e?void 0:e.items)||[]}),[oe.data]);return{allTags:U,setAllTags:H,agentsOnCurrentPage:O,agentsStatus:B,isLoading:W,nAgentsInTable:q,totalInactiveAgents:$,totalManagedAgentIds:Q,managedAgentsOnCurrentPage:X,showUpgradeable:d,setShowUpgradeable:c,search:m,setSearch:L,selectedAgentPolicies:M,setSelectedAgentPolicies:F,sortField:k,setSortField:v,sortOrder:j,setSortOrder:b,selectedStatus:T,setSelectedStatus:w,selectedTags:C,setSelectedTags:A,allAgentPolicies:re,agentPoliciesRequest:oe,agentPoliciesIndexedById:ee,pagination:h,pageSizeOptions:E,setPagination:y,kuery:D,draftKuery:g,setDraftKuery:p,fetchData:ie,currentRequestRef:ne,latestAgentActionErrors:ae,setLatestAgentActionErrors:se}}(),Fe=(0,s.useCallback)((e=>{Z(e),Ee({...xe,currentPage:1})}),[Z,xe,Ee]),Ie=!!(X.trim()||ee.length||ie.length||re.length||Q),Te=(0,s.useCallback)((()=>{ve(""),Z(""),te([]),oe([]),ue([]),J(!1)}),[ve,Z,te,oe,ue,J]),we=(0,s.useCallback)((e=>{if(!e.active)return!1;if(!e.policy_id)return!0;const t=fe[e.policy_id];return!(!0===(null==t?void 0:t.is_managed))}),[fe]),Ce=(0,s.useMemo)((()=>{if(!k||!k.policy_id)return!1;const e=fe[k.policy_id];return!!e&&(0,z.ob)(e)}),[k,fe]),[Ae,Le]=(()=>{const{missingOptionalFeatures:e}=(0,u.YI3)(),{storage:t}=(0,u.WeA)(),[a,l]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{const e=t.get(rt);e&&l(Boolean(e))}),[t]),[(0,s.useMemo)((()=>!(a||!e)&&e.includes("encrypted_saved_object_encryption_key_required")),[e,a]),(0,s.useCallback)((()=>{t.set(rt,"true"),l(!0)}),[t])]})(),{isUnhealthy:De}=function(){const e=(0,u.iO7)(),{notifications:t}=(0,u.WeA)(),[a,l]=(0,s.useState)(!0),[n,i]=(0,s.useState)(!1),o=(0,s.useCallback)((async()=>{try{var e;const t=await(0,u.eK3)();if(t.error)throw t.error;null!==(e=t.data)&&void 0!==e&&e.fleet_server.has_active||i(!0),l(!1)}catch(e){t.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.fleetServerUnhealthy.requestError",{defaultMessage:"An error happened while fetching fleet server status"})}),l(!1)}}),[t.toasts]);return(0,s.useEffect)((()=>{e.fleet.addAgents||e.fleet.addFleetServers?o():l(!1)}),[o,e.fleet.addAgents,e.fleet.addFleetServers]),{isLoading:a,isUnhealthy:n}}(),{isFleetServerStandalone:Oe}=(0,u.GER)(),Re=De&&!Oe,{shouldDisplayAgentSoftLimit:Be}=function(){var e;const t=null===(e=(0,u.UKg)().internal)||void 0===e?void 0:e.activeAgentsSoftLimit,{data:a}=(0,x.useQuery)(["fetch-total-online-agents"],ot,{enabled:void 0!==t});return{shouldDisplayAgentSoftLimit:!(!t||!a)&&a>t}}(),Ne=(0,s.useCallback)((()=>{h.openFleetServerFlyout()}),[h]),ze=(0,s.useCallback)((()=>{m(!0),Se([])}),[m,Se]),Ue=({refreshTags:e=!1}={})=>{je({refreshTags:e}),N({isOpen:!0})},He=1===(null==be?void 0:be.current);return(0,O.jsx)(l().Fragment,null,p?(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(Xt,{onAbortSuccess:je,onClose:()=>m(!1),refreshAgentActivity:G,setSearch:Z,setSelectedStatus:oe})):null,d.isOpen?(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(M.rt,{agentPolicy:de.find((e=>e.id===d.selectedPolicyId)),onClose:()=>{g({isOpen:!1}),je(),ce.resendRequest()}})):null,E&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.eN,{agents:[E],onClose:()=>{y(void 0),Ue()}})),k&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.VH,{agents:[k],agentCount:1,onClose:()=>{v(void 0),Ue({refreshTags:!0})},useForceUnenroll:"unenrolling"===k.status,hasFleetServer:Ce})),(null==j?void 0:j.policy_id)&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(M.pc,{target:"agent",policyId:j.policy_id,onClose:()=>{b(void 0),Ue({refreshTags:!0})}})),F&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.YF,{agents:[F],agentCount:1,onClose:()=>{T(void 0),Ue()},isUpdating:(0,ge.isStuckInUpdating)(F)})),D&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(me,{agents:[D],agentCount:1,onClose:()=>{R(void 0)}})),_&&(0,O.jsx)(ct,{agentId:null==w?void 0:w.id,allTags:null!=U?U:[],selectedTags:null!==(e=null==w?void 0:w.tags)&&void 0!==e?e:[],button:A,onTagsUpdated:()=>{Ue()},onClosePopover:()=>{L(!1)}}),Re&&(0,O.jsx)(l().Fragment,null,null!=t&&t.deploymentUrl?(0,O.jsx)(pe.XL,{deploymentUrl:t.deploymentUrl}):(0,O.jsx)(pe.T5,{onClickAddFleetServer:Ne}),(0,O.jsx)(c.EuiSpacer,{size:"l"})),Ae&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(pe.a4,{onClickHandler:Le}),(0,O.jsx)(c.EuiSpacer,{size:"l"})),Be&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(_e,null),(0,O.jsx)(c.EuiSpacer,{size:"l"})),(0,O.jsx)(Mt,{agentPolicies:de,draftKuery:ke,onDraftKueryChange:ve,onSubmitSearch:Fe,selectedAgentPolicies:ee,onSelectedAgentPoliciesChange:e=>{"query"===i&&r("manual"),te(e)},selectedStatus:ie,onSelectedStatusChange:e=>{"query"===i&&r("manual"),oe(e)},showUpgradeable:Q,onShowUpgradeableChange:J,tags:null!=U?U:[],selectedTags:re,onSelectedTagsChange:ue,nAgentsInTable:q,totalInactiveAgents:V,totalManagedAgentIds:$,selectionMode:i,currentQuery:ye,selectedAgents:a,refreshAgents:Ue,onClickAddAgent:()=>g({isOpen:!0}),onClickAddFleetServer:Ne,agentsOnCurrentPage:H,onClickAgentActivity:ze,showAgentActivityTour:B,latestAgentActionErrors:Me.length,sortField:ae,sortOrder:le}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(qe,{totalAgents:q,totalManagedAgents:$.length||0,agentStatus:W,selectableAgents:(null==H?void 0:H.filter(we).length)||0,managedAgentsOnCurrentPage:Y,selectionMode:i,setSelectionMode:r,selectedAgents:a,setSelectedAgents:e=>{n(e),r("manual")},clearFilters:Te,isUsingFilter:Ie}),(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(Pe,{agents:H,sortField:ae,pageSizeOptions:he,sortOrder:le,isLoading:G,agentPoliciesIndexedById:fe,renderActions:e=>{const t="string"==typeof e.policy_id?fe[e.policy_id]:void 0;return(null==w?void 0:w.id)!==e.id||(0,K.isEqual)(e.tags,w.tags)||C(e),(0,O.jsx)(Ft,{agent:e,agentPolicy:t,onReassignClick:()=>y(e),onUnenrollClick:()=>v(e),onUpgradeClick:()=>T(e),onAddRemoveTagsClick:t=>{P(t),C(e),L(!_)},onGetUninstallCommandClick:()=>b(e),onRequestDiagnosticsClick:()=>R(e)})},onSelectionChange:e=>{if("query"===i&&e.length<a.length){if(!(a.length>0&&0===(0,K.differenceBy)(a,H,"id").length))return n(H.filter((e=>we(e))));r("manual")}n(e)},selected:a,showUpgradeable:Q,onTableChange:({page:e,sort:t})=>{const a={...xe,currentPage:e.index+1,pageSize:e.size};Ee(a),se(t.field),ne(t.direction)},pagination:xe,totalAgents:Math.min(q,S.W),isUsingFilter:Ie,setEnrollmentFlyoutState:g,clearFilters:Te,isCurrentRequestIncremented:He}))};var ea=a(43609),ta=a(94655),aa=a(61215),sa=a(58145),la=a(23833),na=a.n(la),ia=a(60362),oa=a.n(ia),ra=a(71952);const ua=(0,s.memo)((({selectedDatasets:e,onToggleDataset:t})=>{const{unifiedSearch:a,data:l}=(0,u.WeA)(),[n,i]=(0,s.useState)(!1),[o,r]=(0,s.useState)(!1),[d,g]=(0,s.useState)([Lt.tO]),p=(0,s.useCallback)((()=>i((e=>!e))),[i]),m=(0,s.useCallback)((()=>i(!1)),[i]),x=(0,s.useCallback)((t=>t.map((t=>({label:t,checked:e.includes(t)?"on":void 0,key:t})))),[e]),[h,E]=(0,s.useState)(x(d));return(0,s.useEffect)((()=>{(async()=>{r(!0);try{const e=(await l.dataViews.getFieldsForWildcard({pattern:Lt.Lr})).reduce(((e,t)=>(e[t.name]=t,e)),{}),t=await l.dataViews.create({title:Lt.Lr,fields:e}),s=await a.autocomplete.getValueSuggestions({indexPattern:t,field:Lt.Ep,query:""});s.length>0&&(g(s.sort()),E(x(s.sort())))}catch(e){g([Lt.tO]),E(x([Lt.tO]))}r(!1)})()}),[l.dataViews,a.autocomplete,x]),(0,O.jsx)(c.EuiPopover,{button:(0,O.jsx)(c.EuiFilterButton,{"data-test-subj":"agentList.datasetFilterBtn",iconType:"arrowDown",onClick:p,isSelected:n,isLoading:o,numFilters:d.length,hasActiveFilters:e.length>0,numActiveFilters:e.length},f.i18n.translate("xpack.fleet.agentLogs.datasetSelectText",{defaultMessage:"Dataset"})),isOpen:n,closePopover:m,panelPaddingSize:"none"},(0,O.jsx)(c.EuiSelectable,{options:h,onChange:e=>{E(e),e.forEach(((e,a)=>{e.checked===h[a].checked||t(e.label)}))},"data-test-subj":"agentList.datasetFilterOptions",isLoading:o,listProps:{paddingSize:"s",style:{minWidth:220}}},(e=>e)))})),da=(0,s.memo)((({selectedLevels:e,onToggleLevel:t})=>{const[a,l]=(0,s.useState)(!1),n=(0,s.useCallback)((()=>l((e=>!e))),[]),i=(0,s.useCallback)((()=>l(!1)),[]),[o,r]=(0,s.useState)($.F$W.map((t=>({label:t,checked:e.includes(t)?"on":void 0,key:t}))));return(0,O.jsx)(c.EuiPopover,{button:(0,O.jsx)(c.EuiFilterButton,{"data-test-subj":"agentList.logLevelFilterBtn",iconType:"arrowDown",onClick:n,isSelected:a,numFilters:o.length,hasActiveFilters:e.length>0,numActiveFilters:e.length},f.i18n.translate("xpack.fleet.agentLogs.logLevelSelectText",{defaultMessage:"Log level"})),isOpen:a,closePopover:i,panelPaddingSize:"none"},(0,O.jsx)(c.EuiSelectable,{options:o,onChange:e=>{r(e),e.forEach(((e,a)=>{e.checked===o[a].checked||t(e.label)}))},"data-test-subj":"agentList.logLevelFilterOptions",listProps:{paddingSize:"s"}},(e=>e)))})),ca=[Lt.JQ.name,Lt.Ep.name,Lt.Jt.name],ga=(0,s.memo)((({query:e,isQueryValid:t,onUpdateQuery:a})=>{const{data:l,unifiedSearch:{ui:{QueryStringInput:n}}}=(0,u.WeA)(),[i,o]=(0,s.useState)();return(0,s.useEffect)((()=>{(async()=>{try{const e=(await l.dataViews.getFieldsForWildcard({pattern:Lt.Lr})||[]).filter((e=>!ca.includes(e.name)));o(e)}catch(e){o(void 0)}})()}),[l.dataViews]),(0,O.jsx)(n,{iconType:"search",autoSubmit:!0,disableLanguageSwitcher:!0,indexPatterns:i?[{title:Lt.Lr,fields:i}]:[],query:{query:e,language:"kuery"},isInvalid:!t,disableAutoFocus:!0,placeholder:f.i18n.translate("xpack.fleet.agentLogs.searchPlaceholderText",{defaultMessage:"Search logs…"}),onChange:e=>{a(e.query)},onSubmit:e=>{a(e.query,!0)},appName:f.i18n.translate("xpack.fleet.appTitle",{defaultMessage:"Fleet"})})})),pa=(0,s.memo)((({agent:e,agentPolicyLogLevel:t=$.OHG})=>{var a,n,i,o,r,d,g;const m=(0,u.iO7)(),{notifications:x}=(0,u.WeA)(),[h,E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(!1),v=na()(null===(a=e.local_metadata)||void 0===a||null===(n=a.elastic)||void 0===n||null===(i=n.agent)||void 0===i?void 0:i.version,"8.15.0",!0),[j,b]=(0,s.useState)(null!==(o=null===(r=e.local_metadata)||void 0===r||null===(d=r.elastic)||void 0===d||null===(g=d.agent)||void 0===g?void 0:g.log_level)&&void 0!==o?o:$.OHG),[M,S]=(0,s.useState)(j),F=(0,s.useCallback)((()=>{k(!0),async function(){try{const a=await(0,u.wtt)(e.id,{action:{type:"SETTINGS",data:{log_level:null}}});if(a.error)throw a.error;b(t),S(t),x.toasts.addSuccess(f.i18n.translate("xpack.fleet.agentLogs.resetLogLevel.successText",{defaultMessage:"Reset agent logging level to policy"}))}catch(e){x.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentLogs.resetLogLevel.errorTitleText",{defaultMessage:"Error resetting agent logging level"})})}k(!1)}()}),[e.id,t,x]),I=(0,s.useCallback)((()=>{E(!0),async function(){try{const t=await(0,u.wtt)(e.id,{action:{type:"SETTINGS",data:{log_level:M}}});if(t.error)throw t.error;b(M),x.toasts.addSuccess(f.i18n.translate("xpack.fleet.agentLogs.selectLogLevel.successText",{defaultMessage:"Changed agent logging level to ''{logLevel}''",values:{logLevel:M}}))}catch(e){x.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.agentLogs.selectLogLevel.errorTitleText",{defaultMessage:"Error updating agent logging level"})})}E(!1)}()}),[x,M,e.id]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"m",alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiFormLabel,{htmlFor:"selectAgentLogLevel"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentLogs.selectLogLevelLabelText",defaultMessage:"Agent logging level"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiSelect,{disabled:h||!m.fleet.allAgents,compressed:!0,id:"selectAgentLogLevel","data-test-subj":"selectAgentLogLevel",value:M,onChange:e=>{S(e.target.value)},options:$.F$W.map((e=>({value:e,text:e})))})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{flush:"both",size:"xs",disabled:!m.fleet.allAgents,isLoading:h||y,iconType:"check",onClick:I,"data-test-subj":"applyLogLevelBtn"},h?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentLogs.updateButtonLoadingText",defaultMessage:"Applying changes..."}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentLogs.updateButtonText",defaultMessage:"Apply changes"}))),v&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{flush:"both",size:"xs",disabled:!m.fleet.allAgents,isLoading:h||y,iconType:"cross",onClick:F,"data-test-subj":"resetLogLevelBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentLogs.resetLogLevelLabelText",defaultMessage:"Reset to policy"})))))})),fa=A()(c.EuiFlexGroup).withConfig({displayName:"WrapperFlexGroup",componentId:"sc-fcgfrk-0"})(["height:100%;"]),ma=A()(c.EuiFlexItem).withConfig({displayName:"DatePickerFlexItem",componentId:"sc-fcgfrk-1"})(["max-width:312px;"]),xa={type:"log-view-reference",logViewId:"default"},ha=[{type:"timestamp"},{field:"event.dataset",type:"field"},{field:"component.id",type:"field"},{type:"message"},{field:"error.message",type:"field"}],Ea=(0,aa.createStateContainerReactHelpers)(),ya=({agentPolicy:e})=>{const{getHref:t}=(0,u.iEg)();return l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiCallOut,{size:"m",color:"primary",iconType:"iInCircle",title:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentLogs.logDisabledCallOutTitle",defaultMessage:"Log collection is disabled"})},e.is_managed?null:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentLogs.logDisabledCallOutDescription",defaultMessage:"Update the agent's policy {settingsLink} to enable logs collection.",values:{settingsLink:l().createElement(c.EuiLink,{href:t("policy_details",{policyId:e.id,tabId:"settings"})},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentLogs.settingsLink",defaultMessage:"settings"}))}})))},ka=(0,s.memo)((({agent:e,agentPolicy:t,state:a})=>{var n,i,o,r,d;const{data:g,application:f}=(0,u.WeA)(),{update:m}=Ea.useTransitions(),x=(0,s.useCallback)((e=>{const{min:t,max:a}=g.query.timefilter.timefilter.calculateBounds(e);return t&&a?{start:t.valueOf(),end:a.valueOf()}:void 0}),[g.query.timefilter.timefilter]),h=(0,s.useCallback)((e=>{x(e)&&m({start:e.from,end:e.to})}),[x,m]),[E,y]=(0,s.useState)(x({from:a.start,to:a.end})||x({from:Lt.Rc.start,to:Lt.Rc.end}));(0,s.useEffect)((()=>{const e=x({from:a.start,to:a.end});e?y(e):h({from:Lt.Rc.start,to:Lt.Rc.end})}),[a.start,a.end,x,h]);const v=(0,s.useCallback)((e=>{try{return(0,Ve.fromKueryExpression)(e),!0}catch(e){return!1}}),[]),[j,b]=(0,s.useState)(a.query),[M,S]=(0,s.useState)(v(a.query)),F=(0,s.useCallback)(((e,t)=>{b(e),v(e)?(S(!0),t&&m({query:e})):S(!1)}),[v,m]),I=(0,s.useMemo)((()=>Dt({agentId:e.id,datasets:a.datasets,logLevels:a.logLevels,userQuery:a.query})),[e.id,a.datasets,a.logLevels,a.query]),T=null===(n=e.local_metadata)||void 0===n||null===(i=n.elastic)||void 0===i||null===(o=i.agent)||void 0===o?void 0:o.version,w=(0,s.useMemo)((()=>{var e;if(!T)return!1;const t=null===(e=oa()(T))||void 0===e?void 0:e.version;return!!t&&na()(t,"7.11.0")}),[T]),[C,{height:A}]=(0,sa.A)(),P=(0,s.useMemo)((()=>Math.max(A,600)),[A]);return w?l().createElement(fa,{direction:"column",gutterSize:"m"},t&&!(null!==(r=t.monitoring_enabled)&&void 0!==r&&r.includes("logs"))&&l().createElement(ya,{agentPolicy:t}),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiFlexGroup,{gutterSize:"m"},l().createElement(c.EuiFlexItem,null,l().createElement(ga,{query:j,onUpdateQuery:F,isQueryValid:M})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiFilterGroup,null,l().createElement(ua,{selectedDatasets:a.datasets,onToggleDataset:e=>{const t=[...a.datasets],s=t.indexOf(e);s>=0?(t.splice(s,1),m({datasets:t})):m({datasets:[...a.datasets,e]})}}),l().createElement(da,{selectedLevels:a.logLevels,onToggleLevel:e=>{const t=[...a.logLevels],s=t.indexOf(e);s>=0?(t.splice(s,1),m({logLevels:t})):m({logLevels:[...a.logLevels,e]})}}))),l().createElement(ma,{grow:!1},l().createElement(c.EuiSuperDatePicker,{showUpdateButton:!1,start:a.start,end:a.end,onTimeChange:({start:e,end:t})=>{h({from:e,to:t})}})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(k.V,{coreStart:{application:f}},l().createElement(Bt,{logStreamQuery:I,startTime:Rt(a.start),endTime:Rt(a.end)}))))),l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiPanel,{paddingSize:"none",panelRef:C,grow:!1},l().createElement(ra.LogStream,{logView:xa,height:P,startTimestamp:E.start,endTimestamp:E.end,query:I,columns:ha}))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(pa,{agent:e,agentPolicyLogLevel:null==t||null===(d=t.advanced_settings)||void 0===d?void 0:d.agent_logging_level}))):l().createElement(c.EuiCallOut,{size:"m",color:"warning",title:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentLogs.oldAgentWarningTitle",defaultMessage:"The Logs view requires Elastic Agent 7.11 or higher. To upgrade an agent, go to the Actions menu, or {downloadLink} a newer version.",values:{downloadLink:l().createElement(c.EuiLink,{href:"https://ela.st/download-elastic-agent",external:!0,target:"_blank"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentLogs.downloadLink",defaultMessage:"download"}))}})})})),va=(0,s.memo)((({agent:e,agentPolicy:t})=>{const a=(0,s.useMemo)((()=>(0,aa.createStateContainer)({...Lt.ky,...(0,aa.getStateFromKbnUrl)(Lt.CK,window.location.href,{getFromHashQuery:!1})},{update:e=>t=>({...e,...t})})),[]),l=(0,s.useMemo)((()=>Ea.connect((e=>({state:e||Lt.ky})))(ka)),[]),[n,i]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{const e=(0,aa.createKbnUrlStateStorage)({useHashQuery:!1,useHash:!1}),{start:t,stop:s}=(0,aa.syncState)({storageKey:Lt.CK,stateContainer:a,stateStorage:e});return t(),i(!0),()=>{s(),a.set(Lt.ky)}}),[a]),(0,O.jsx)(Ea.Provider,{value:a},n?(0,O.jsx)(l,{agent:e,agentPolicy:t}):null)})),ja=(0,s.memo)((({agent:e,onClose:t})=>{var a,s;const l=JSON.stringify(e,null,2),n="string"==typeof(null===(a=e.local_metadata)||void 0===a||null===(s=a.host)||void 0===s?void 0:s.hostname)?e.local_metadata.host.hostname:e.id,{docLinks:i}=(0,u.WeA)();return(0,O.jsx)(c.EuiFlyout,{onClose:t,maxWidth:S.MW},(0,O.jsx)(c.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(c.EuiTitle,{size:"m"},(0,O.jsx)("h2",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutTitle",defaultMessage:"''{name}'' agent details",values:{name:n}})))),(0,O.jsx)(c.EuiFlyoutBody,null,(0,O.jsx)(c.EuiText,null,(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutDescription",defaultMessage:"The JSON below is the raw agent data tracked by Fleet. This data can be useful for debugging or troubleshooting Elastic Agent. For more information, see the {doc}.",values:{doc:(0,O.jsx)(c.EuiLink,{href:i.links.fleet.troubleshooting},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.jsonFlyoutDocLink",defaultMessage:"troubleshooting documentation"}))}}))),(0,O.jsx)(c.EuiSpacer,null),(0,O.jsx)(c.EuiCodeBlock,{language:"json",isCopyable:!0},l)),(0,O.jsx)(c.EuiFlyoutFooter,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{onClick:t,flush:"left"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsJsonFlyoutCloseButtonLabel",defaultMessage:"Close"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{iconType:"download",onClick:()=>{const e=document.createElement("a");e.href=`data:text/json;charset=utf-8,${encodeURIComponent(l)}`,e.download=`${n}-agent-details.json`,e.click()}},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsJsonDownloadButtonLabel",defaultMessage:"Download JSON"}))))))})),ba=(0,s.memo)((({agent:e,assignFlyoutOpenByDefault:t=!1,onCancelReassign:a,agentPolicy:n})=>{const i=(0,u.iO7)(),o=i.fleet.allAgents,r=(0,ta.a)(),[d,g]=(0,s.useState)(t),[f,m]=(0,s.useState)(!1),[x,h]=(0,s.useState)(!1),[E,y]=(0,s.useState)(!1),[k,v]=(0,s.useState)(!1),j="unenrolling"===e.status,b=(0,ge.isStuckInUpdating)(e),[S,F]=(0,s.useState)(!1),T=(0,s.useCallback)((e=>{F(e)}),[F]),w=n&&(0,z.ob)(n),C=(0,s.useMemo)((()=>a||(()=>g(!1))),[a,g]),A=[...!o||null!=n&&n.is_managed?[]:[(0,O.jsx)(c.EuiContextMenuItem,{icon:"pencil",onClick:()=>{g(!0)},disabled:!e.active&&!n||!0===(null==n?void 0:n.supports_agentless),key:"reassignPolicy"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.reassignActionText",defaultMessage:"Assign to new policy"})),(0,O.jsx)(c.EuiContextMenuItem,{icon:"refresh",disabled:!(0,z._3)(e)||!0===(null==n?void 0:n.supports_agentless),onClick:()=>{h(!0)},key:"upgradeAgent","data-test-subj":"upgradeBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.upgradeOneButton",defaultMessage:"Upgrade agent"}))],...o&&b?[(0,O.jsx)(c.EuiContextMenuItem,{icon:"refresh",onClick:()=>{h(!0)},key:"restartUpgradeAgent","data-test-subj":"restartUpgradeBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.restartUpgradeOneButton",defaultMessage:"Restart upgrade"}))]:[],(0,O.jsx)(c.EuiContextMenuItem,{icon:"inspect",onClick:()=>{F(!1),v(!k)},key:"agentDetailsJson","data-test-subj":"viewAgentDetailsJsonBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.viewAgentDetailsJsonText",defaultMessage:"View agent JSON"})),...i.fleet.readAgents?[(0,O.jsx)(c.EuiContextMenuItem,{icon:"download",disabled:!(0,I.fx)(e),onClick:()=>{y(!0)},"data-test-subj":"requestAgentDiagnosticsBtn",key:"requestDiagnostics"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}))]:[],...!o||null!=n&&n.is_managed?[]:[(0,O.jsx)(c.EuiContextMenuItem,{icon:"trash",disabled:!o||!e.active||!0===(null==n?void 0:n.supports_agentless),onClick:()=>{m(!0)},key:"unenrollAgent"},j?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.forceUnenrollOneButton",defaultMessage:"Force unenroll"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentList.unenrollOneButton",defaultMessage:"Unenroll agent"}))]];return(0,O.jsx)(l().Fragment,null,d&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.eN,{agents:[e],onClose:C})),f&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.VH,{agents:[e],agentCount:1,onClose:()=>{m(!1),r()},useForceUnenroll:j,hasFleetServer:w})),x&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(pe.YF,{agents:[e],agentCount:1,onClose:()=>{h(!1),r()},isUpdating:b})),E&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(me,{agents:[e],agentCount:1,onClose:()=>{y(!1)}})),k&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(ja,{agent:e,onClose:()=>v(!1)})),(0,O.jsx)(M.AK,{isOpen:S,onChange:T,button:{props:{iconType:"arrowDown",iconSide:"right",color:"primary"},children:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.actionsButton",defaultMessage:"Actions"})},items:A}))})),Ma=A()(c.EuiButton).withConfig({displayName:"EuiButtonCompressed",componentId:"sc-1y6vsns-0"})(["height:32px;"]),Sa=({agent:e,agentPolicy:t})=>{var a,s;const{isInstalled:n,link:i,isLoading:o}=function(e){const{isLoading:t,data:a}=(0,u.E1o)($.cOw),{spaceId:s}=(0,u.YI3)(),l=function(e,t){var a,s;if("installed"!==(null==t||null===(a=t.item)||void 0===a?void 0:a.status))return!1;const l=t.item.installationInfo;return!(!l||"installed"!==l.install_status)&&(l.installed_kibana_space_id===e||e&&(null===(s=l.additional_spaces_installed_kibana)||void 0===s?void 0:s[e]))}(s,a),n=(0,u.e3j)();return{isLoading:t,isInstalled:l,link:null==n?void 0:n.getRedirectUrl({dashboardId:yt(s,a,$.K$s.ELASTIC_AGENT_AGENT_METRICS),query:{language:"kuery",query:`elastic_agent.id:${e.id}`}})}}(e),{getHref:r}=(0,u.iEg)(),g=null!==(a=null==t||null===(s=t.monitoring_enabled)||void 0===s?void 0:s.length)&&void 0!==a&&a,f=n&&!o&&g?{href:i}:{disabled:!0},m=l().createElement(Ma,(0,d.default)({},f,{isLoading:o,color:"primary",iconType:"dashboardApp"}),l().createElement(p.FormattedMessage,{"data-test-subj":"agentDetails.viewMoreMetricsButton",id:"xpack.fleet.agentDetails.viewDashboardButtonLabel",defaultMessage:"View more agent metrics"}));return o||g||!t?n?m:l().createElement(c.EuiToolTip,{content:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.viewDashboardButton.disabledNoIntegrationTooltip",defaultMessage:"Agent dashboard not found, you need to install the elastic_agent integration."})},m):l().createElement(c.EuiToolTip,{content:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.viewDashboardButton.disabledNoLogsAndMetricsTooltip",defaultMessage:"Logs and metrics for agent are not enabled in the agent policy."})},l().createElement(Ma,{"data-test-subj":"agentDetails.enableLogsAndMetricsButton",isLoading:o,color:"primary",href:r("policy_details",{policyId:t.id,tabId:"settings"}),disabled:null==t?void 0:t.is_managed},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.enableLogsAndMetricsLabel",defaultMessage:"Enable logs and metrics"})))},Fa=A()(c.EuiLink).withConfig({displayName:"TruncatedEuiLink",componentId:"sc-7tcs8-0"})(["overflow:hidden;text-overflow:ellipsis;white-space:nowrap;width:120px;"]),Ia=({outputs:e,isMonitoring:t})=>{var a,n,i,o;const{getHref:r}=(0,u.iEg)(),[d,g]=(0,s.useState)(!1),p=null==e?void 0:e.monitoring,m=null==e?void 0:e.data,x=(0,s.useMemo)((()=>null!=m&&m.integrations?((null==m?void 0:m.integrations)||[]).map(((e,t)=>{var a;return{"data-test-subj":`output-integration-${t}`,label:`${e.integrationPolicyName}: ${e.name}`,href:r("settings_edit_outputs",{outputId:null!==(a=null==e?void 0:e.id)&&void 0!==a?a:""}),iconType:"dot"}})):[]),[r,null==m?void 0:m.integrations]);return l().createElement(c.EuiFlexGroup,{gutterSize:"s",alignItems:"baseline",responsive:!1,justifyContent:"flexStart"},t?l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Fa,{href:r("settings_edit_outputs",{outputId:null!==(a=null==p||null===(n=p.output)||void 0===n?void 0:n.id)&&void 0!==a?a:""}),title:null==p?void 0:p.output.name,"data-test-subj":"outputNameLink"},null==p?void 0:p.output.name)):l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Fa,{href:r("settings_edit_outputs",{outputId:null!==(i=null==m||null===(o=m.output)||void 0===o?void 0:o.id)&&void 0!==i?i:""}),title:null==m?void 0:m.output.name,"data-test-subj":"outputNameLink"},null==m?void 0:m.output.name)),(null==m?void 0:m.integrations)&&(null==m?void 0:m.integrations.length)>=1&&!t&&l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiBadge,{color:"hollow","data-test-subj":"outputsIntegrationsNumberBadge",onClick:()=>g(!d),onClickAriaLabel:"Open output integrations popover"},"+",null==m?void 0:m.integrations.length),l().createElement(c.EuiPopover,{"data-test-subj":"outputPopover",isOpen:d,closePopover:()=>g(!1),anchorPosition:"downCenter"},l().createElement(c.EuiPopoverTitle,null,f.i18n.translate("xpack.fleet.AgentPolicyOutputsSummary.popover.title",{defaultMessage:"Output for integrations"})),l().createElement("div",{style:{width:"280px"}},l().createElement(c.EuiListGroup,{listItems:x,color:"primary",size:"s",gutterSize:"none"})))))},Ta=A()(c.EuiFlexItem).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1y4d0ny-0"})(["min-width:0px;"]),wa=(0,s.memo)((({agent:e,agentPolicy:t})=>{var a,s,n,i,o,r,d,g,m,x,h,E,y,k,v,j,b,S,F,I;const T=(0,u.JhS)(),w=(0,u.zQn)(null==t?void 0:t.id),C=null==w||null===(a=w.data)||void 0===a?void 0:a.item;return l().createElement(c.EuiPanel,null,l().createElement(c.EuiDescriptionList,{compressed:!0},l().createElement(c.EuiFlexGroup,{direction:"column",gutterSize:"m","data-test-subj":"agentDetailsOverviewSection"},l().createElement(c.EuiFlexGroup,null,l().createElement(Ta,{grow:5},l().createElement(c.EuiFlexGroup,{direction:"column",gutterSize:"m"},[{title:l().createElement(c.EuiToolTip,{content:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.cpuTooltip",defaultMessage:"Average CPU usage in the last 5 minutes"})},l().createElement("span",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.cpuTitle",defaultMessage:"CPU"})," ",l().createElement(c.EuiIcon,{type:"iInCircle"}))),description:ke(e.metrics,t)},{title:l().createElement(c.EuiToolTip,{content:l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.memoryTooltip",defaultMessage:"Average memory usage in the last 5 minutes"})},l().createElement("span",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.memoryTitle",defaultMessage:"Memory"})," ",l().createElement(c.EuiIcon,{type:"iInCircle"}))),description:ve(e.metrics,t)}].map((({title:e,description:t})=>{const a="string"==typeof t&&t.length>20?t:"";return l().createElement(c.EuiFlexGroup,null,l().createElement(Ta,{grow:8},l().createElement(c.EuiDescriptionListTitle,null,e)),l().createElement(Ta,{grow:4},l().createElement(c.EuiToolTip,{position:"top",content:a},l().createElement(c.EuiDescriptionListDescription,{className:"eui-textTruncate"},t))))})))),l().createElement(Ta,{grow:5},l().createElement(c.EuiFlexGroup,{justifyContent:"flexEnd"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Sa,{agent:e,agentPolicy:t}))))),[{title:f.i18n.translate("xpack.fleet.agentDetails.statusLabel",{defaultMessage:"Status"}),description:l().createElement(pe.u0,{agent:e,fromDetails:!0})},{title:f.i18n.translate("xpack.fleet.agentDetails.lastActivityLabel",{defaultMessage:"Last activity"}),description:e.last_checkin?l().createElement(p.FormattedRelative,{value:new Date(e.last_checkin)}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.lastCheckinMessageLabel",{defaultMessage:"Last checkin message"}),description:e.last_checkin_message?e.last_checkin_message:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.agentIdLabel",{defaultMessage:"Agent ID"}),description:e.id},{title:f.i18n.translate("xpack.fleet.agentDetails.agentPolicyLabel",{defaultMessage:"Agent policy"}),description:t?l().createElement(M.an,{policy:t,agent:e}):l().createElement(c.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.versionLabel",{defaultMessage:"Agent version"}),description:"string"==typeof(null===(s=e.local_metadata)||void 0===s||null===(n=s.elastic)||void 0===n||null===(i=n.agent)||void 0===i?void 0:i.version)?l().createElement(c.EuiFlexGroup,{gutterSize:"s",alignItems:"center",style:{minWidth:0}},l().createElement(c.EuiFlexItem,{grow:!1,className:"eui-textNoWrap"},e.local_metadata.elastic.agent.version),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Te,{isAgentUpgradable:!(!0===(null==t?void 0:t.is_managed)||!(0,z._3)(e)),agent:e,latestAgentVersion:T}))):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.hostNameLabel",{defaultMessage:"Host name"}),description:"string"==typeof(null===(o=e.local_metadata)||void 0===o||null===(r=o.host)||void 0===r?void 0:r.hostname)?e.local_metadata.host.hostname:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.hostIdLabel",{defaultMessage:"Host ID"}),description:"string"==typeof(null===(d=e.local_metadata)||void 0===d||null===(g=d.host)||void 0===g?void 0:g.id)?e.local_metadata.host.id:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.outputForMonitoringLabel",{defaultMessage:"Output for integrations"}),description:C?l().createElement(Ia,{outputs:C}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.outputForMonitoringLabel",{defaultMessage:"Output for monitoring"}),description:C?l().createElement(Ia,{outputs:C,isMonitoring:!0}):"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.logLevel",{defaultMessage:"Logging level"}),description:"string"==typeof(null===(m=e.local_metadata)||void 0===m||null===(x=m.elastic)||void 0===x||null===(h=x.agent)||void 0===h?void 0:h.log_level)?e.local_metadata.elastic.agent.log_level:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.privilegeModeLabel",{defaultMessage:"Privilege mode"}),description:!0===e.local_metadata.elastic.agent.unprivileged?l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModeUnprivilegedText",defaultMessage:"Running as non-root"}):l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.privilegeModePrivilegedText",defaultMessage:"Running as root"})},{title:f.i18n.translate("xpack.fleet.agentDetails.releaseLabel",{defaultMessage:"Agent release"}),description:"boolean"==typeof(null===(E=e.local_metadata)||void 0===E||null===(y=E.elastic)||void 0===y||null===(k=y.agent)||void 0===k?void 0:k.snapshot)?!0===e.local_metadata.elastic.agent.snapshot?"snapshot":"stable":"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.platformLabel",{defaultMessage:"Platform"}),description:"string"==typeof(null===(v=e.local_metadata)||void 0===v||null===(j=v.os)||void 0===j?void 0:j.platform)?e.local_metadata.os.platform:"-"},{title:f.i18n.translate("xpack.fleet.agentDetails.monitorLogsLabel",{defaultMessage:"Monitor logs"}),description:Array.isArray(null==t?void 0:t.monitoring_enabled)?null!=t&&null!==(b=t.monitoring_enabled)&&void 0!==b&&b.includes("logs")?l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentList.monitorLogsEnabledText",defaultMessage:"Enabled"}):l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentList.monitorLogsDisabledText",defaultMessage:"Disabled"}):l().createElement(c.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.monitorMetricsLabel",{defaultMessage:"Monitor metrics"}),description:Array.isArray(null==t?void 0:t.monitoring_enabled)?null!=t&&null!==(S=t.monitoring_enabled)&&void 0!==S&&S.includes("metrics")?l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentList.monitorMetricsEnabledText",defaultMessage:"Enabled"}):l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentList.monitorMetricsDisabledText",defaultMessage:"Disabled"}):l().createElement(c.EuiSkeletonText,{lines:1})},{title:f.i18n.translate("xpack.fleet.agentDetails.tagsLabel",{defaultMessage:"Tags"}),description:(null!==(F=e.tags)&&void 0!==F?F:[]).length>0?l().createElement(ye,{tags:null!==(I=e.tags)&&void 0!==I?I:[]}):"-"}].map((({title:e,description:t})=>{const a="string"==typeof t&&t.length>20?t:"";return l().createElement(c.EuiFlexGroup,null,l().createElement(Ta,{grow:3},l().createElement(c.EuiDescriptionListTitle,null,e)),l().createElement(Ta,{grow:7},l().createElement(c.EuiToolTip,{position:"top",content:a},l().createElement(c.EuiDescriptionListDescription,{className:"eui-textTruncate"},t))))})))))}));var Ca=a(91785);const Aa=A()(c.EuiFlexItem).withConfig({displayName:"FlexItemWithMinWidth",componentId:"sc-1n7kbng-0"})(["min-width:0px;"]),Pa=(0,s.memo)((({agent:e,agentPolicy:t})=>l().createElement(l().Fragment,null,l().createElement(c.EuiFlexGroup,{alignItems:"flexStart"},l().createElement(Aa,null,l().createElement(c.EuiTitle,{size:"s"},l().createElement("h3",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.overviewSectionTitle",defaultMessage:"Overview"}))),l().createElement(c.EuiSpacer,{size:"s"}),l().createElement(wa,{agent:e,agentPolicy:t})),l().createElement(Aa,null,l().createElement(c.EuiTitle,{size:"s"},l().createElement("h3",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentDetails.integrationsSectionTitle",defaultMessage:"Integrations"}))),l().createElement(c.EuiSpacer,{size:"s"}),l().createElement(Ca.P,{agent:e,agentPolicy:t})))))),_a=({agent:e})=>{const t=(0,u.iO7)(),{notifications:a}=(0,u.WeA)(),{getAbsolutePath:n}=(0,u.iEg)(),[i,o]=(0,s.useState)(!0),[r,d]=(0,s.useState)(!1),[g,m]=(0,s.useState)([]),[x,h]=(0,s.useState)([]),[E,y]=(0,s.useState)([]),[k,v]=(0,s.useState)(1e4),[j,b]=(0,s.useState)(!1),M=(0,s.useCallback)((async()=>{try{const t=await(0,u.uWX)(e.id),a=t.error;if(a)throw a;if(!t.data)throw new Error("No data");const s=t.data.items;h(s),o(!1),s.some((e=>"IN_PROGRESS"===e.status||"AWAITING_UPLOAD"===e.status))?v(3e3):v(1e4)}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.requestDiagnostics.errorLoadingUploadsNotificationTitle",{defaultMessage:"Error loading diagnostics uploads"})})}}),[e.id,a.toasts,v]);(0,s.useEffect)((()=>{M();const e=setInterval((async()=>{M()}),k);return()=>{e&&clearInterval(e)}}),[M,k]),(0,s.useEffect)((()=>{y(x),E.length>0&&x.filter((e=>{const t=E.find((t=>t.id===e.id));return"READY"===e.status&&(!t||"READY"!==(null==t?void 0:t.status))})).forEach((e=>{a.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.requestDiagnostics.readyNotificationTitle",{defaultMessage:"Agent diagnostics {name} ready",values:{name:e.name}})},{toastLifeTimeMs:5e3})}))}),[E,x,a.toasts]),(0,s.useEffect)((()=>{m(r?x:x.filter((e=>"EXPIRED"!==e.status)))}),[x,r]);const S=[{field:"id",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.fileLabelText",{defaultMessage:"File"}),render:e=>{const t=x.find((t=>t.id===e));return"READY"===(null==t?void 0:t.status)?(0,O.jsx)(c.EuiLink,{href:n(null==t?void 0:t.filePath),download:!0,target:"_blank"},(0,O.jsx)(c.EuiIcon,{type:"download"}),"   ",null==t?void 0:t.name):"IN_PROGRESS"===(null==t?void 0:t.status)||"AWAITING_UPLOAD"===(null==t?void 0:t.status)?(0,O.jsx)(c.EuiLink,{color:"subdued",disabled:!0},(0,O.jsx)(c.EuiLoadingSpinner,null),"  ",(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.generatingText",defaultMessage:"Generating diagnostics file..."})):(0,O.jsx)(c.EuiLink,{color:"subdued",disabled:!0},(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"s",direction:"row",alignItems:"center"},null!=t&&t.error?(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.errorGeneratingFileMessage",defaultMessage:"Error generating file: {reason}",values:{reason:t.error}})},(0,O.jsx)(c.EuiIcon,{type:"warning",color:"danger"}))):null!=t&&t.status?(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:t.status},(0,O.jsx)(c.EuiIcon,{type:"warning",color:"danger"}))):null,(0,O.jsx)(c.EuiFlexItem,null,null==t?void 0:t.name)))}},{field:"id",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.dateLabelText",{defaultMessage:"Date"}),dataType:"date",render:e=>{const t=x.find((t=>t.id===e));return(0,O.jsx)(c.EuiText,{size:"s",color:"READY"===(null==t?void 0:t.status)?"default":"subdued"},(0,c.formatDate)(null==t?void 0:t.createTime,"lll"))}},...t.fleet.allAgents?[{name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.actionsLabelText",{defaultMessage:"Actions"}),width:"70px",actions:[{type:"icon",icon:"trash",color:"danger",name:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.deleteButtonText",{defaultMessage:"Delete"}),available:e=>"READY"===e.status,description:f.i18n.translate("xpack.fleet.requestDiagnostics.tableColumns.deleteButtonDesc",{defaultMessage:"Delete diagnostics file"}),onClick:e=>{var t;t=e.id,(0,u.A$L)(t).then((({data:e,error:t})=>{t||!1===(null==e?void 0:e.deleted)?a.toasts.addError(t||new Error("Request returned `deleted: false`"),{title:f.i18n.translate("xpack.fleet.requestDiagnostics.errorDeletingUploadNotificationTitle",{defaultMessage:"Error deleting diagnostics file"})}):a.toasts.addSuccess({title:f.i18n.translate("xpack.fleet.requestDiagnostics.successDeletingUploadNotificationTitle",{defaultMessage:"Diagnostics file deleted"})}),M()}))}}]}]:[]],F=(0,O.jsx)(c.EuiButton,{fill:!0,size:"s",onClick:()=>{b(!0)},disabled:!(0,I.fx)(e)||!t.fleet.readAgents},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.diagnosticsOneButton",defaultMessage:"Request diagnostics .zip"}));return(0,O.jsx)(l().Fragment,null,j&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(me,{agents:[e],agentCount:1,onClose:()=>{b(!1),M()}})),(0,O.jsx)(c.EuiText,{size:"s"},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.calloutText",defaultMessage:"Consider changing the log level to debug before requesting a diagnostic. Diagnostics files are stored in Elasticsearch, and as such can incur storage costs. By default, files are deleted periodically through an ILM policy."}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{direction:"row",gutterSize:"m",alignItems:"center",justifyContent:"spaceBetween"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,I.fx)(e)?F:(0,O.jsx)(c.EuiToolTip,{content:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.notSupportedTooltip",defaultMessage:"Requesting agent diagnostics is not supported for agents before version {version}.",values:{version:I.dS}})},F)),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiSwitch,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.requestDiagnostics.showExpiredFilesLabel",defaultMessage:"Show expired file requests"}),checked:r,onChange:e=>d(e.target.checked)}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),i?(0,O.jsx)(c.EuiSkeletonText,{lines:3}):(0,O.jsx)(c.EuiBasicTable,{items:g,columns:S}))},La=()=>{var e,t,a;const{params:{agentId:n,tabId:i=""}}=(0,o.useRouteMatch)(),{getHref:r}=(0,u.iEg)(),{isLoading:d,isInitialRequest:g,error:m,data:x,resendRequest:h}=(0,u.rXq)(n,{pollIntervalMs:5e3,query:{withMetrics:!0}}),{isLoading:E,data:y,sendRequest:k}=(0,u.ZJQ)(null==x||null===(e=x.item)||void 0===e?void 0:e.policy_id),{application:{navigateToApp:v}}=(0,u.WeA)(),j=(0,u.g7J)(),b="true"===new URLSearchParams((0,o.useLocation)().search).get("openReassignFlyout"),S=(0,s.useCallback)((()=>{j&&j.onDoneNavigateTo&&v(j.onDoneNavigateTo[0],j.onDoneNavigateTo[1])}),[j,v]),I=null==x||null===(t=x.item)||void 0===t||null===(a=t.local_metadata)||void 0===a?void 0:a.host,T=(0,s.useMemo)((()=>(0,O.jsx)(c.EuiFlexGroup,{direction:"column",gutterSize:"s",alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiButtonEmpty,{iconType:"arrowLeft",href:r("agent_list"),flush:"left",size:"xs"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.viewAgentListTitle",defaultMessage:"View all agents"}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{className:"eui-textBreakWord"},(0,O.jsx)("h1",null,d&&g?(0,O.jsx)(M.Rh,null):"object"==typeof I&&"string"==typeof(null==I?void 0:I.hostname)?I.hostname:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.agentDetailsTitle",defaultMessage:"Agent ''{id}''",values:{id:n}})))))),[I,n,r,g,d]),w=(0,s.useMemo)((()=>x&&x.item?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"flexEnd",alignItems:"center",gutterSize:"s",direction:"row"},!E&&(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(ba,{agent:x.item,agentPolicy:null==y?void 0:y.item,assignFlyoutOpenByDefault:b,onCancelReassign:j&&j.onDoneNavigateTo?S:void 0})))):void 0),[y,x,r,E]),C=(0,s.useMemo)((()=>[{id:"details",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.detailsTab",{defaultMessage:"Agent details"}),href:r("agent_details",{agentId:n,tabId:"details"}),isSelected:!i||"details"===i},{id:"logs",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.logsTab",{defaultMessage:"Logs"}),href:r("agent_details_logs",{agentId:n,tabId:"logs"}),isSelected:"logs"===i},{id:"diagnostics",name:f.i18n.translate("xpack.fleet.agentDetails.subTabs.diagnosticsTab",{defaultMessage:"Diagnostics"}),href:r("agent_details_diagnostics",{agentId:n,tabId:"diagnostics"}),isSelected:"diagnostics"===i}]),[r,n,i]);return(0,O.jsx)(ta.U.Provider,{value:{refresh:()=>{h(),k()}}},(0,O.jsx)(F.QA,{leftColumn:T,rightColumn:w,tabs:C},d&&g?(0,O.jsx)(M.Rh,null):m?(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.unexceptedErrorTitle",defaultMessage:"Error loading agent"}),error:m}):x&&x.item?(0,O.jsx)(Da,{agent:x.item,agentPolicy:null==y?void 0:y.item}):(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentDetails.agentNotFoundErrorTitle",defaultMessage:"Agent not found"}),error:f.i18n.translate("xpack.fleet.agentDetails.agentNotFoundErrorDescription",{defaultMessage:"Cannot find agent ID {agentId}",values:{agentId:n}})})))},Da=({agent:e,agentPolicy:t})=>((0,u.ifo)("agent_details",{agentHost:"object"==typeof e.local_metadata.host&&"string"==typeof e.local_metadata.host.hostname?e.local_metadata.host.hostname:"-"}),(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:S.X5.agent_details_logs,render:()=>(0,O.jsx)(va,{agent:e,agentPolicy:t})}),(0,O.jsx)(r.Route,{path:S.X5.agent_details_diagnostics,render:()=>(0,O.jsx)(_a,{agent:e})}),(0,O.jsx)(r.Route,{path:S.X5.agent_details,render:()=>(0,O.jsx)(Pa,{agent:e,agentPolicy:t})}))),Oa=(0,o.withRouter)((({actionSection:e,title:t,children:a})=>(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceAround"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiPageSection,{color:"transparent"},(0,O.jsx)(c.EuiEmptyPrompt,{color:"plain",iconType:"logoBeats",title:(0,O.jsx)("h2",null,t),body:a,actions:e})))))),Ra=(0,p.injectI18n)((({intl:e})=>(0,O.jsx)(Oa,{title:e.formatMessage({id:"xpack.fleet.noAccess.accessDeniedTitle",defaultMessage:"Access denied"}),actionSection:[]},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.noAccess.accessDeniedDescription",defaultMessage:"You are not authorized to access Elastic Fleet. To use Elastic Fleet, you need a user role that contains All permissions for this application."}))))),Ba=()=>{var e;(0,u.ifo)("agent_list");const{agents:t}=(0,u.UKg)(),a=(0,u.iO7)(),s=(0,u.YI3)(),n=(0,u.Wdf)();if(!t.enabled)return null;if(!s.missingRequirements&&s.isLoading)return(0,O.jsx)(M.Rh,null);if(s.error)return(0,O.jsx)(F.gv,null,(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.agentsInitializationErrorMessageTitle",defaultMessage:"Unable to initialize central management for Elastic Agents"}),error:s.error}));const i=1===(null==s||null===(e=s.missingRequirements)||void 0===e?void 0:e.length)&&"fleet_server"===s.missingRequirements[0],o=a.fleet.allAgents&&(s.forceDisplayInstructions||i);if(!i&&s.missingRequirements&&s.missingRequirements.length>0)return(0,O.jsx)(ea.O,{missingRequirements:s.missingRequirements});if(!a.fleet.readAgents)return(0,O.jsx)(Ra,null);const d=o?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"flexEnd"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{fill:!0,iconType:"plusInCircle",onClick:()=>n.openEnrollmentFlyout(),"data-test-subj":"addAgentBtnTop"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.addAgentButton",defaultMessage:"Add Agent"}))))):void 0;return(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:S.X5.agent_details},(0,O.jsx)(La,null)),(0,O.jsx)(r.Route,{path:S.X5.agents},(0,O.jsx)(F.iW,{section:"agents",rightColumn:d},o?(0,O.jsx)(ea.Q,{showEnrollmentRecommendation:!1}):(0,O.jsx)(Zt,null))))};var Na=a(72945);const za=e=>{const{discover:t}=(0,Je.WeA)(),[a,l]=(0,s.useState)(null);return(0,s.useEffect)((()=>{(async()=>{if(t&&t.locator){const a=await t.locator.getUrl({indexPatternId:"logs-*",timeRange:{from:"now-1h",to:"now",mode:"relative"},filters:[{meta:{alias:"Recently enrolled agents",index:"logs-*"},query:{terms:{"agent.id":e}}}]});l(a)}})()}),[t,e]),a};var Ua=a(89700);const Ha=A()("h1").withConfig({displayName:"CentralTitle",componentId:"sc-ve6hfp-0"})(["text-align:center;"]),Wa=({children:e})=>l().createElement(l().Fragment,null,l().createElement(c.EuiSpacer,{size:"s"}),l().createElement(c.EuiTitle,{size:"l"},l().createElement(Ha,null,e)),l().createElement(c.EuiSpacer,{size:"xl"})),Ga=A()(c.EuiText).withConfig({displayName:"SubtitleText",componentId:"sc-ve6hfp-1"})(["max-width:250px;margin:0 auto;text-align:center;"]),qa=A()(c.EuiStepNumber).withConfig({displayName:"CenteredEuiStepNumber",componentId:"sc-ve6hfp-2"})(["margin:0 auto;"]),Ka=e=>l().createElement("div",{style:{margin:"0 auto"}},l().createElement(c.EuiImage,(0,d.default)({role:"presentation"},e))),Va=({children:e})=>{const t=(0,c.useIsWithinMaxBreakpoint)("s");return l().createElement(c.EuiFlexGroup,{direction:"column",gutterSize:t?"xs":"l",alignItems:"center",justifyContent:"center",wrap:!0},e)},$a=()=>{const{http:e}=(0,u.WeA)(),t=e.basePath.prepend("/plugins/fleet/assets/");return l().createElement(c.EuiFlexGroup,{alignItems:"center",justifyContent:"spaceEvenly",gutterSize:"none"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Va,null,l().createElement(c.EuiFlexItem,null,l().createElement(qa,{status:"incomplete",number:1})),l().createElement(c.EuiFlexItem,null,l().createElement("div",{style:{margin:"0 auto"}},l().createElement(Ka,{alt:"",src:t+"1_install_agent.svg"}))),l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentStepTitle",defaultMessage:"Install Elastic Agent"}))),l().createElement(Ga,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentStep",defaultMessage:"Install agents on the hosts that you want to connect to Elastic."}))))),l().createElement(c.EuiShowFor,{sizes:["s","xs"]},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiSpacer,{size:"xl"}))),l().createElement(c.EuiHideFor,{sizes:["s","xs"]},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Ka,{alt:"",src:t+"arrow_right_curve_over.svg"}))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Va,null,l().createElement(c.EuiFlexItem,null,l().createElement(qa,{status:"incomplete",number:2})),l().createElement(c.EuiFlexItem,null,l().createElement(Ka,{alt:"",src:t+"2_add_integration.svg"})),l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationStepTitle",defaultMessage:"Add the integration"}))),l().createElement(Ga,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationStep",defaultMessage:"Make a few selections to finalize how Elastic receives your data."}))))),l().createElement(c.EuiShowFor,{sizes:["s","xs"]},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiSpacer,{size:"xl"}))),l().createElement(c.EuiHideFor,{sizes:["s","xs"]},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Ka,{alt:"",src:t+"arrow_right_curve_under.svg"}))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(Va,null,l().createElement(c.EuiFlexItem,null,l().createElement(qa,{status:"incomplete",number:3})),l().createElement(c.EuiFlexItem,null,l().createElement(Ka,{alt:"",src:t+"3_confirm_data.svg"})),l().createElement(c.EuiFlexItem,null,l().createElement(c.EuiText,{textAlign:"center",size:"xs"},l().createElement("h2",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.confirmDataStepTitle",defaultMessage:"Confirm incoming data"}))),l().createElement(Ga,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.confirmDataStep",defaultMessage:"Explore and analyze the incoming data."}))))))},Ya=A()("div").withConfig({displayName:"NotObscuredByBottomBar",componentId:"sc-ve6hfp-3"})(["padding-bottom:100px;"]),Qa=()=>{const{docLinks:e}=(0,u.WeA)();return l().createElement(c.EuiFlexGroup,{justifyContent:"spaceAround"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiLink,{href:e.links.fleet.elasticAgent,target:"_blank"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.learnMoreLink",defaultMessage:"Learn more about installing Elastic Agent"}))))},Ja=({integrationInfo:e,packageInfo:t,isLoading:a,error:s,cancelUrl:n,cancelClickHandler:i,onNext:o})=>{if(s)return l().createElement(M.$D,{title:l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:s});const r=l().createElement(Wa,null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.pageTitle",defaultMessage:"Ready to add your first integration?"}));return l().createElement(F.QA,{topContent:r},l().createElement(l().Fragment,null,l().createElement(c.EuiSpacer,{size:"xxl"}),l().createElement(c.EuiSpacer,{size:"xxl"}),l().createElement($a,null),l().createElement(c.EuiSpacer,{size:"xxl"}),l().createElement(c.EuiSpacer,{size:"xxl"}),l().createElement(Ya,null,l().createElement(Qa,null)),l().createElement(ts,{cancelUrl:n,cancelMessage:l().createElement("span",{"data-test-subj":"skipAgentInstallation"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.skipAddAgentButton",defaultMessage:"Add integration only (skip agent installation)"})),cancelClickHandler:i,isLoading:a,onNext:o,noAnimation:!0,actionMessage:l().createElement(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.installAgentButton",defaultMessage:"Install Elastic Agent"})}),t&&l().createElement(Ua.I3,{pkgTitle:(null==e?void 0:e.title)||t.title,pkgkey:(0,z.Ku)(t),integration:null==e?void 0:e.name})))},Xa=A()(c.EuiBottomBar).withConfig({displayName:"CenteredRoundedBottomBar",componentId:"sc-113t0u1-0"})(["max-width:820px;margin:0 auto !important;border-radius:8px 8px 0px 0px;"]),Za=A()(Xa).withConfig({displayName:"NoAnimationCenteredRoundedBottomBar",componentId:"sc-113t0u1-1"})(["animation-delay:-99s;#stop bottom bar flying in on step change"]),es=A()("div").withConfig({displayName:"NotObscuredByBottomBar",componentId:"sc-113t0u1-2"})(["padding-bottom:100px;"]),ts=({isLoading:e,loadingMessage:t,onNext:a,cancelClickHandler:s,cancelUrl:n,actionMessage:i,cancelMessage:o,isDisabled:r=!1,noAnimation:u=!1})=>{const d=u?Za:Xa;return l().createElement(d,null,l().createElement(c.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{color:"text",size:"s",href:n,onClick:s},o||l().createElement(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.backButton",defaultMessage:"Go back"})))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButton,{color:"primary",fill:!0,size:"m",isDisabled:r,isLoading:!r&&e,onClick:a},e?t||l().createElement(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.loading",defaultMessage:"Loading..."}):i))))},as=({onNext:e,cancelClickHandler:t,cancelUrl:a,noAnimation:s=!1})=>{const n=s?Za:Xa;return l().createElement(n,null,l().createElement(c.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{color:"text",size:"s",href:a,onClick:t},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentStandaloneBottomBar.backButton",defaultMessage:"Go back"})))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButton,{color:"primary",fill:!0,size:"m",onClick:e},l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentStandaloneBottomBar.viewIncomingDataBtn",defaultMessage:"View incoming data"})))))},ss=({pkgkey:e})=>{const t=e.includes(B.FLEET_KUBERNETES_PACKAGE),{getHref:a}=(0,Je.iEg)(),{getAbsolutePath:s}=(0,Je.iEg)();return l().createElement(Xa,null,l().createElement(c.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{color:"text",size:"s",href:a("integrations_all")},l().createElement(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicyBottomBar.addAnotherIntegration",defaultMessage:"Add another integration"})))),!t&&l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButton,{color:"success",fill:!0,size:"m",href:a("integration_details_assets",{pkgkey:e})},l().createElement(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.viewDataAssetsButtonText'",defaultMessage:"View assets"}))),t&&l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButton,{color:"success",fill:!0,size:"m",href:s("/app/dashboards#/view/kubernetes-f4dc26db-1b53-4ea2-a78b-1bfab8ea267c")},l().createElement(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingData. '",defaultMessage:"View Kubernetes metrics dashboards"})))))},ls=({troubleshootLink:e,agentIds:t,integration:a})=>{const s=za(t);return l().createElement(Xa,null,l().createElement(c.EuiFlexGroup,{justifyContent:"spaceBetween",alignItems:"center"},l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonEmpty,{color:"text",size:"s",href:e,iconType:"popout",target:"_blank"},l().createElement(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.troubleshootLinkBottomBar",defaultMessage:"Troubleshooting guide"}))),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButton,{color:"success",fill:!0,href:null!=s?s:""},l().createElement(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.discoverLogsLink",defaultMessage:"View incoming {integration} logs",values:{integration:null!=a?a:""}})))))},ns=e=>{const{packageInfo:t,integrationInfo:a,steps:s,currentStep:n,error:i}=e;if(i)return(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:i});const o=s[n].component,r=(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTitle,{size:"l",className:"eui-textCenter"},(0,O.jsx)("h1",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.multiPageTitle",defaultMessage:"Set up {title} integration",values:{title:t.title}}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(os,{currentStep:n,steps:s.map((e=>e.title))}),(0,O.jsx)(c.EuiSpacer,{size:"xl"}));return(0,O.jsx)(F.QA,{topContent:r,restrictHeaderWidth:866,restrictWidth:866},(0,O.jsx)(o,e),t&&(0,O.jsx)(Ua.I3,{pkgTitle:(null==a?void 0:a.title)||t.title,pkgkey:(0,z.Ku)(t),integration:null==a?void 0:a.name}))},is=(e,t,a)=>e===t?a?"complete":"current":e>t?"complete":"incomplete",os=({steps:e,currentStep:t=0,currentStepComplete:a=!1})=>{const s=e.map(((e,s)=>({title:e,status:is(t,s,a),onClick:()=>{}})));return(0,O.jsx)(c.EuiStepsHorizontal,{size:"xs",steps:s})};var rs=a(8683),us=a(50152),ds=a(4888);var cs=A()(c.EuiCodeBlock).withConfig({displayName:"_StyledEuiCodeBlock",componentId:"sc-oz6m9j-1"})(["max-width:1100px;"]);const gs=e=>{var t,a;const{cancelUrl:n,onNext:i,cancelClickHandler:o,setIsManaged:r,agentPolicy:u,enrollmentAPIKey:d,fleetServerHost:g,fleetProxy:m,enrolledAgentIds:x}=e,h=(0,Je.WeA)(),{docLinks:E}=h,y=E.links.fleet.troubleshooting,k=(0,Je.JhS)(),[v,j]=(0,s.useState)(!1),[b,S]=(0,s.useState)(!1);if(!d)return(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:"Enrollment API key not found"});const F="kubernetes"===e.packageInfo.name?"IS_KUBERNETES_MULTIPAGE":"IS_NOT_KUBERNETES",T=(0,I.dF)(null!==(t=null==u?void 0:u.package_policies)&&void 0!==t?t:[]),w=(0,ds.w)({apiKey:d.api_key,fleetProxy:m,fleetServerHost:g,agentVersion:k||"",showInstallServers:T}),C=[(0,us.YD)({installCommand:w,apiKeyData:{item:d},enrollToken:d.api_key,isK8s:F,selectedApiKeyId:d.id,isComplete:v||!!x.length,fullCopyButton:!0,fleetServerHost:g,onCopy:()=>j(!0),rootIntegrations:(0,I.uo)(null!==(a=null==u?void 0:u.package_policies)&&void 0!==a?a:[])})];return"IS_KUBERNETES_MULTIPAGE"===F&&C.push((({isComplete:e,fullCopyButton:t,onCopy:a})=>{const[n,i]=(0,s.useState)(!1),o=A().pre.withConfig({displayName:"CommandCode",componentId:"sc-oz6m9j-0"})({overflow:"auto"});return{status:e?"complete":void 0,title:f.i18n.translate("xpack.fleet.agentEnrollment.stepKubernetesApplyManifest",{defaultMessage:"Run the apply command"}),children:l().createElement(l().Fragment,null,l().createElement(c.EuiText,null,l().createElement(c.EuiSpacer,{size:"s"}),l().createElement(p.FormattedMessage,{id:"xpack.fleet.agentEnrollment.kubernetesCommandInstructions",defaultMessage:"From the directory where the manifest is downloaded, run the apply command."}),l().createElement(c.EuiSpacer,{size:"m"})),l().createElement(cs,{onClick:()=>{a&&a()},fontSize:"m",isCopyable:!t,paddingSize:"m"},l().createElement(o,null,"kubectl apply -f elastic-agent-managed-kubernetes.yml")),l().createElement(c.EuiSpacer,{size:"s"}),t&&l().createElement(c.EuiCopy,{textToCopy:"kubectl apply -f elastic-agent-managed-kubernetes.yml"},(e=>l().createElement(c.EuiButton,{color:"primary",iconType:"copyClipboard",size:"m",onClick:()=>(e=>{e(),i(!0),a&&a()})(e)},n?l().createElement(p.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.copyButtonClicked",defaultMessage:"Copied"}):l().createElement(p.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.copyButton",defaultMessage:"Copy to clipboard"})))))}})({isComplete:b||!!x.length,fullCopyButton:!0,onCopy:()=>S(!0)})),C.push((0,us.nV)({selectedPolicyId:null==u?void 0:u.id,troubleshootLink:y,agentCount:x.length,showLoading:!0,poll:v})),k?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.addIntegration.installAgentStepTitle",defaultMessage:"These steps configure and enroll the Elastic Agent in Fleet to automatically deploy updates and centrally manage the agent. As an alternative to Fleet, advanced users can run agents in {standaloneLink}.",values:{standaloneLink:(0,O.jsx)(c.EuiLink,{onClick:()=>r(!1)},"standalone mode")}})),(0,O.jsx)(c.EuiSpacer,{size:"xl"}),(0,O.jsx)(c.EuiSteps,{steps:C}),!!x.length&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(es,null),(0,O.jsx)(ts,{cancelUrl:n,cancelClickHandler:o,onNext:i,actionMessage:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.addFirstIntegrationSplash.addIntegrationButton",defaultMessage:"Add the integration"})}))):(0,O.jsx)(c.EuiLoadingSpinner,null)};var ps=a(96104);const fs=e=>{var t;const{setIsManaged:a,agentPolicy:n,cancelUrl:i,onNext:o,cancelClickHandler:r}=e,u=(0,Je.Q14)(),[d,g]=(0,s.useState)(!1),[f,m]=(0,s.useState)(!1),{yaml:x,onCreateApiKey:h,isCreatingApiKey:E,apiKey:y,downloadYaml:k}=(0,ps.Pe)(n);if(!n)return(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.errorLoadingPackageTitle",defaultMessage:"Error loading package information"}),error:"Agent policy not provided"});const v=(0,ds.p)({agentVersion:u}),j=[(0,us.N9)({selectedPolicyId:null==n?void 0:n.id,yaml:x,downloadYaml:k,apiKey:y,onCreateApiKey:h,isCreatingApiKey:E,isComplete:f,onCopy:()=>m(!0)}),(0,us.iR)({installCommand:v,isComplete:x&&d,fullCopyButton:!0,onCopy:()=>g(!0),rootIntegrations:(0,I.uo)(null!==(t=null==n?void 0:n.package_policies)&&void 0!==t?t:[])})];return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(js,{setIsManaged:a}),(0,O.jsx)(c.EuiSpacer,{size:"xl"}),(0,O.jsx)(c.EuiSteps,{steps:j}),d&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(es,null),(0,O.jsx)(as,{cancelUrl:i,onNext:o,cancelClickHandler:r})))};var ms=a(92604),xs=a(74892),hs=a(33342),Es=a(49688),ys=a(43721);const ks=({children:e})=>{const[t,a]=(0,s.useState)(!1);return(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceBetween",direction:"column"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceBetween",direction:"row"},(0,O.jsx)(c.EuiFlexItem,null),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{size:"s",iconType:t?"arrowUp":"arrowDown",iconSide:"right",onClick:()=>a(!t),flush:"left"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.createPackagePolicy.stepConfigure.advancedOptionsToggleLinkText",defaultMessage:"Advanced options"}))))),t&&(0,O.jsx)(c.EuiFlexItem,null,e)))},vs=({error:e,title:t})=>(0,O.jsx)(M.$D,{title:t||(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.addIntegration.errorTitle",defaultMessage:"Error adding integration"}),error:e}),js=({setIsManaged:e})=>(0,O.jsx)(c.EuiCallOut,{title:"Setting up to run Elastic Agent in standalone mode",color:"primary",iconType:"iInCircle"},(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.addIntegration.standaloneWarning",defaultMessage:"Setting up integrations by running Elastic Agent in standalone mode is advanced. When possible, we recommend using {link} instead. ",values:{link:(0,O.jsx)(c.EuiLink,{href:"#"},"Fleet-managed agents")}})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiButton,{onClick:()=>e(!0),color:"primary"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.addIntegration.switchToManagedButton",defaultMessage:"Enroll in Fleet instead (recommended)"})));var bs=a(69433),Ms=a(93230),Ss=a.n(Ms),Fs=a(30276);const Is=({agentIds:e,troubleshootLink:t,packageInfo:a})=>{var s;const n=za(e);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTitle,null,(0,O.jsx)("h3",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.title",defaultMessage:"Confirming data is taking longer than expected"}))),(0,O.jsx)(c.EuiText,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.body",defaultMessage:"If the system is not generating data, it may help to generate some to ensure data is being collected correctly. If you're having trouble, see our {troubleshootLink}, or you may check later by viewing {discoverLink}.",values:{troubleshootLink:(0,O.jsx)(c.EuiLink,{external:!0,href:t,target:"_blank"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.troubleshootLink",defaultMessage:"troubleshooting guide"})),discoverLink:(0,O.jsx)(c.EuiLink,{external:!0,href:null!=n?n:"",target:"_blank"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingData.timeout.discoverLink",defaultMessage:"{integration} logs in Discover",values:{integration:null!==(s=null==a?void 0:a.title)&&void 0!==s?s:""}}))}})),(0,O.jsx)(es,null),(0,O.jsx)(ls,{agentIds:e,troubleshootLink:t,integration:null==a?void 0:a.title}))},Ts=["agent.ephemeral_id","agent.id","elastic_agent.id","data_stream.namespace","@timestamp"],ws=A()(c.EuiDescriptionList).withConfig({displayName:"CleanOverflowDescriptionList",componentId:"sc-6co0kl-0"})(["overflow:hidden;max-height:125px;word-break:break-all;white-space:pre-wrap;"]),Cs=A()("pre").withConfig({displayName:"CompressedPre",componentId:"sc-6co0kl-1"})(["&&&{background:none;padding:0 0;}"]),As=({hit:e})=>{const t=Ss()((0,bs.getFlattenedObject)(e._source),Ts),a=Object.entries(t).map((([e,t])=>({title:`${e}:`,description:JSON.stringify(t)})));return l().createElement("pre",null,l().createElement("code",null,l().createElement(ws,{listItems:a,type:"inline",align:"left",compressed:!0})))},Ps=({hit:e})=>{const t=(null==e?void 0:e._source)||{},a=(null==t?void 0:t["@timestamp"])||"-";return l().createElement(c.EuiText,{size:"xs"},l().createElement(Cs,null,a?(0,c.formatDate)(a,"MMM D, YYYY @ HH:mm:ss.SSS"):"-"))},_s=({dataPreview:e})=>{const t=e.slice(0,5);return l().createElement(l().Fragment,null,t.map((e=>l().createElement("div",{id:e._id},l().createElement(c.EuiFlexGroup,{gutterSize:"xs"},l().createElement(c.EuiFlexItem,{style:{minWidth:"220px"}},l().createElement(Ps,{hit:e})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(As,{hit:e}))),l().createElement(c.EuiHorizontalRule,{margin:"s"})))))},Ls=({agentIds:e,packageInfo:t,agentDataConfirmed:a,setAgentDataConfirmed:s,troubleshootLink:n})=>{const{incomingData:i,dataPreview:o,isLoading:r,hasReachedTimeout:u}=(0,Fs.Tm)({agentIds:e,previewData:!0,stopPollingAfterPreviewLength:5}),{enrolledAgents:d,numAgentsWithData:g}=(0,Fs.VK)(i,t),m=(0,Je.df5)(null==t?void 0:t.name),{guidedOnboarding:x}=(0,Je.WeA)();var h;return!r&&d>0&&g>0&&(s(!0),m&&(null==x||null===(h=x.guidedOnboardingApi)||void 0===h||h.completeGuidedOnboardingForIntegration(null==t?void 0:t.name))),a?l().createElement(l().Fragment,null,l().createElement(c.EuiCallOut,{"data-test-subj":"IncomingDataConfirmedCallOut",title:f.i18n.translate("xpack.fleet.confirmIncomingDataWithPreview.title",{defaultMessage:"Incoming data received from {numAgentsWithData} enrolled { numAgentsWithData, plural, one {agent} other {agents}}.",values:{numAgentsWithData:g}}),color:"success",iconType:"check"}),l().createElement(c.EuiSpacer,{size:"m"}),l().createElement(c.EuiText,null,l().createElement("h3",null,l().createElement(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.previewTitle",defaultMessage:"Preview of incoming data:"}))),l().createElement(c.EuiSpacer,{size:"m"}),l().createElement(_s,{dataPreview:o})):l().createElement(l().Fragment,null,l().createElement(c.EuiText,null,l().createElement(c.EuiCallOut,{size:"m",color:"primary",iconType:c.EuiLoadingSpinner,title:l().createElement(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.listening",defaultMessage:"Listening for incoming data from enrolled agents..."})}),l().createElement(c.EuiSpacer,{size:"m"}),u?l().createElement(Is,{agentIds:e,troubleshootLink:n,packageInfo:t}):l().createElement(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataWithPreview.loading",defaultMessage:"It might take a few minutes for the data to get to Elasticsearch. If you're not seeing any, try generating some to verify. If you're having trouble connecting, check out the {link}.",values:{link:l().createElement(c.EuiLink,{target:"_blank",external:!0,href:n},l().createElement(p.FormattedMessage,{id:"xpack.fleet.enrollmentInstructions.troubleshootingLink",defaultMessage:"troubleshooting guide"}))}})),l().createElement(c.EuiSpacer,{size:"m"}),l().createElement(c.EuiSkeletonText,{lines:10}))},Ds=({troubleshootLink:e})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,null,(0,O.jsx)(c.EuiCallOut,{size:"m",color:"primary",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.title",defaultMessage:"Data preview is not available for standalone agents. "})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.description",defaultMessage:"You can check for agent data in the integration asset tab. If you're having trouble seeing data, check out the {link}.",values:{link:(0,O.jsx)(c.EuiLink,{target:"_blank",external:!0,href:e},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.confirmIncomingDataStandalone.troubleshootingLink",defaultMessage:"troubleshooting guide"}))}})))),Os={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.installAgentStepTitle",{defaultMessage:"Install Elastic Agent"}),component:e=>{var t;const[a,l]=(0,s.useState)(e.isManaged),[n,i]=(0,s.useState)(!1),{enrolledAgentIds:o}=(0,rs.X)((null===(t=e.agentPolicy)||void 0===t?void 0:t.id)||"",{noLowerTimeLimit:!0,pollImmediately:!0}),r=()=>{e.setEnrolledAgentIds(o),e.onNext()},u={...e,onNext:r,enrolledAgentIds:o,setIsManaged:n?l:e.setIsManaged};if(a)return(0,O.jsx)(gs,u);const d={...e,onNext:r,enrolledAgentIds:o,setIsManaged:e=>{e&&i(!0),l(e)}};return(0,O.jsx)(fs,d)}},Rs={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.addIntegrationStepTitle",{defaultMessage:"Add the integration"}),component:e=>{var t;const{onNext:a,onBack:n,isManaged:i,setIsManaged:o,packageInfo:r,integrationInfo:d,agentPolicy:g}=e,[m,x]=(0,s.useState)(),{notifications:h}=(0,u.WeA)(),[E,y]=(0,s.useState)("VALID"),[k,v]=(0,s.useState)(),b=(0,j.wsd)(),[S,F]=(0,s.useState)({name:"",description:"",namespace:"",policy_id:"",policy_ids:[""],enabled:!0,inputs:[]}),T=(0,s.useCallback)((e=>{const t=(0,hs.bS)({...S,...e},r,ms.Hh);return v(t),ys.debug("Package policy validation results",t),t}),[r,S]),w=(0,s.useCallback)((e=>{const t={...S,...e};F(t),ys.debug("Package policy updated",t);const a=T(t),s=t.package,l=!!a&&(0,hs.nt)(a);y(s&&!l?"VALID":"INVALID")}),[S,T]),C=(0,s.useCallback)((async({force:e=!1}={})=>{const t=!!k&&(0,hs.nt)(k);if("VALID"===E&&t)return void y("INVALID");y("LOADING");const{error:s}=await(async({newPackagePolicy:e,force:t})=>{y("LOADING");const{policy:a,forceCreateNeeded:s}=await(0,Es.E)(e),l=await(0,u.H_o)({...a,force:s||t});return y("SUBMITTED"),l})({newPackagePolicy:S,force:e});if(s){if((0,xs.G0)(s))return void(await b(r)?C({force:!0}):y("VALID"));h.toasts.addError(s,{title:"Error"}),y("VALID")}else a()}),[k,E,S,h.toasts,b,r,a]);(0,s.useEffect)((()=>{(async()=>{if(!g)return;const{packagePolicy:e,error:t}=await(async(e,t,a)=>{const{data:s,error:l}=await(0,u.TR6)({perPage:$.WaW,page:1,kuery:`${N.f$}.package.name:${t.name}`}),n={name:(0,I.sW)(t.name,null==s?void 0:s.items),description:"",namespace:"",policy_id:e,policy_ids:[e],enabled:!0,inputs:[]};return{packagePolicy:(0,z.eE)(t,e,n.namespace,n.name,n.description,a),error:l}})(g.id,r,null==d?void 0:d.name);t&&x(t),w(e)})()}),[]);const A=(0,u.fWy)(null!==(t=r.name)&&void 0!==t?t:"","package-policy-create-multi-step"),P=(0,s.useMemo)((()=>A&&(0,O.jsx)(M.BA,null,(0,O.jsx)(A.Component,null))),[A]),_=(0,s.useMemo)((()=>{if("endpoint"!==r.name)return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"l"}),(0,O.jsx)(Ua.lS,{packageInfo:r,showOnlyIntegration:null==d?void 0:d.name,packagePolicy:S,updatePackagePolicy:w,validationResults:k,submitAttempted:"INVALID"===E,noTopRule:!0}),k&&(0,O.jsx)(ks,null,(0,O.jsx)(Ua.os,{packageInfo:r,packagePolicy:S,updatePackagePolicy:w,validationResults:k,submitAttempted:"INVALID"===E,noAdvancedToggle:!0})))}),[E,null==d?void 0:d.name,r,S,w,k]);return g?m?(0,O.jsx)(vs,{error:m}):(0,O.jsx)(l().Fragment,null,i?null:(0,O.jsx)(js,{setIsManaged:o}),_,P,(0,O.jsx)(es,null),(0,O.jsx)(ts,{cancelClickHandler:i?n:()=>o(!0),onNext:C,isLoading:"LOADING"===E,isDisabled:"INVALID"===E,loadingMessage:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.savingPackagePolicy",defaultMessage:"Saving policy..."}),actionMessage:i?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.confirmIncomingDataButton",defaultMessage:"Confirm incoming data"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.createFirstPackagePolicy.installAgentButton",defaultMessage:"Save and continue"})})):(0,O.jsx)(vs,{error:f.i18n.translate("xpack.fleet.addIntegration.noAgentPolicy",{defaultMessage:"Error creating agent policy."})})}},Bs={title:f.i18n.translate("xpack.fleet.createFirstPackagePolicy.confirmDataStepTitle",{defaultMessage:"Confirm incoming data"}),component:e=>{const{enrolledAgentIds:t,packageInfo:a,isManaged:n}=e,i=(0,u.WeA)(),[o,r]=(0,s.useState)(!1),{docLinks:d}=i,c=d.links.fleet.troubleshooting,g=(0,O.jsx)(l().Fragment,null,(0,O.jsx)(es,null),(0,O.jsx)(ss,{pkgkey:`${a.name}-${a.version}`}));return n?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Ls,{agentIds:t,packageInfo:a,agentDataConfirmed:o,setAgentDataConfirmed:r,troubleshootLink:c}),!!o&&g):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Ds,{troubleshootLink:c}),g)}},Ns=[Os,Rs,Bs],zs=[Rs,Os,Bs],Us=({queryParamsPolicyId:e,prerelease:t})=>{const{params:a}=(0,o.useRouteMatch)(),{pkgkey:l,policyId:n,integration:i}=a,{pkgName:r,pkgVersion:d}=(0,I.CB)(l),[c,g]=(0,s.useState)(!0),[p,m]=(0,s.useState)(0),[x,h]=(0,s.useState)(!0),{getHref:E}=(0,u.iEg)(),[y,k]=(0,s.useState)([]),v=n||e,{data:j,error:b,isLoading:M}=(0,u.E1o)(r,d,{prerelease:t,full:!0}),{agentPolicy:S,enrollmentAPIKey:F,error:T,isLoading:w}=function(e){const{spaceId:t,isSpaceAwarenessEnabled:a}=(0,Je.YI3)(),[l,n]=(0,s.useState)(!0),[i,o]=(0,s.useState)(),[r,u]=(0,s.useState)(),[d,c]=(0,s.useState)(),[g,p]=(0,s.useState)(),m="fleet-first-agent-policy",x=(0,s.useMemo)((()=>a&&"default"!==t?`${t}:${m}`:m),[a,t]),h=(0,s.useMemo)((()=>Object.freeze((0,_.b)({id:x,name:f.i18n.translate("xpack.fleet.createPackagePolicy.firstAgentPolicyNameText",{defaultMessage:"My first agent policy"})}))),[x]);return(0,s.useEffect)((()=>{(async()=>{var t;n(!0);const a=e||x,{data:s,error:l}=await(async e=>{var t;let a,s;try{a=await(0,Je.Ag1)(e),a.error&&(s=a.error)}catch(e){s=e}return s&&404!==s.statusCode?{error:s}:{data:null===(t=a)||void 0===t?void 0:t.data}})(a),i=null==s?void 0:s.item;if(e&&!i)return n(!1),void o(new Error(`Agent policy ${a} not found`));let r;if(l)return n(!1),void o(l);if(!i){const{data:e,error:t}=await Je.iF6.bind(null,h)();if(t)return n(!1),void o(t);r=e.item,p(!0)}u(i||r);const{data:d,error:g}=await(0,Je.d1z)({page:1,perPage:1,kuery:`policy_id:"${a}"`});g?(n(!1),o(g)):d&&null!==(t=d.items)&&void 0!==t&&t.length?(n(!1),c(d.items[0])):(n(!1),o(new Error(`No enrollment API key found for policy ${a}`)))})()}),[e,h,x]),{isLoading:l,error:i,agentPolicy:r,enrollmentAPIKey:d,created:g}}(v),C=(0,s.useMemo)((()=>null==j?void 0:j.item),[j]),A=(0,s.useMemo)((()=>{var e;if(i)return null==C||null===(e=C.policy_templates)||void 0===e?void 0:e.find((e=>e.name===i))}),[null==C?void 0:C.policy_templates,i]),{fleetServerHost:P,fleetProxy:L,downloadSource:D,isLoadingInitialRequest:R}=(0,u.Dc7)(S),B=E("add_integration_to_policy",{pkgkey:l,useMultiPageLayout:!1,...i?{integration:i}:{},...v?{agentPolicyId:v}:{}});if(c||!C)return(0,O.jsx)(Ja,{isLoading:M||R||w,error:b||T,integrationInfo:A,packageInfo:C,cancelUrl:B,onNext:()=>{g(!1)}});const N=x?Ns:zs;return(0,O.jsx)(ns,{fleetServerHost:P,fleetProxy:L,downloadSource:D,agentPolicy:S,enrollmentAPIKey:F,currentStep:p,steps:N,packageInfo:C,integrationInfo:A,cancelUrl:B,onNext:()=>{p!==N.length-1&&m(p+1)},onBack:()=>{0!==p&&m(p-1)},isManaged:x,setIsManaged:e=>{h(e),m(0)},setEnrolledAgentIds:k,enrolledAgentIds:y})},Hs=()=>{const{search:e}=(0,o.useLocation)(),{params:t}=(0,o.useRouteMatch)(),a=(0,s.useMemo)((()=>new URLSearchParams(e)),[e]),n=(0,s.useMemo)((()=>a.has("useMultiPageLayout")),[a]),i=(0,s.useMemo)((()=>{var e;return null!==(e=a.get("policyId"))&&void 0!==e?e:void 0}),[a]),[r,d]=l().useState(!1),{data:c}=(0,u.ZwD)();(0,s.useEffect)((()=>{const e=Boolean(null==c?void 0:c.item.prerelease_integrations_enabled);null!=c&&c.item&&d(e)}),[null==c?void 0:c.item]);const g={from:"policyId"in t||i?"policy":"package",queryParamsPolicyId:i,prerelease:r};return n?(0,O.jsx)(Us,g):(0,O.jsx)(Na.M,g)},Ws=({apiKeyId:e,length:t,sendGetAPIKey:a,tokenGetter:l})=>{const{euiTheme:n}=(0,c.useEuiTheme)(),{notifications:i}=(0,Je.WeA)(),[o,r]=(0,s.useState)("HIDDEN"),[u,d]=(0,s.useState)(),g=(0,s.useMemo)((()=>"•".repeat(t)),[t]);return(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiText,{color:"subdued",size:"xs",css:(0,O.css)("font-family:",n.font.familyCode,";",""),"data-test-subj":"apiKeyField"},"VISIBLE"===o?u:g)),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiToolTip,{content:"VISIBLE"===o?f.i18n.translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):f.i18n.translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"})},(0,O.jsx)(c.EuiButtonIcon,{"aria-label":"VISIBLE"===o?f.i18n.translate("xpack.fleet.enrollmentTokensList.hideTokenButtonLabel",{defaultMessage:"Hide token"}):f.i18n.translate("xpack.fleet.enrollmentTokensList.showTokenButtonLabel",{defaultMessage:"Show token"}),color:"text",onClick:async()=>{if("VISIBLE"===o)r("HIDDEN");else if("HIDDEN"===o)try{r("LOADING");const t=await a(e);if(t.error)throw t.error;d(l(t)),r("VISIBLE")}catch(e){i.toasts.addError(e,{title:"Error"}),r("HIDDEN")}},iconType:"VISIBLE"===o?"eyeClosed":"eye","data-test-subj":"showHideTokenButton"}))))};var Gs=a(13788);const qs=e=>{const{onCancel:t,onConfirm:a,enrollmentKey:s}=e;return(0,O.jsx)(c.EuiConfirmModal,{title:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.title",{defaultMessage:"Revoke enrollment token"}),onCancel:t,onConfirm:a,cancelButtonText:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.cancelButton",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.deleteButton",{defaultMessage:"Revoke enrollment token"}),defaultFocusedButton:"confirm",buttonColor:"danger"},(0,O.jsx)(c.EuiCallOut,{title:f.i18n.translate("xpack.fleet.enrollmentTokenDeleteModal.description",{defaultMessage:"Are you sure you want to revoke {keyName}? New agents will no longer be able to be enrolled using this token.",values:{keyName:s.name}}),color:"danger"}))},Ks=({apiKey:e,refresh:t})=>{const{notifications:a}=(0,u.WeA)(),[n,i]=(0,s.useState)("CONFIRM_HIDDEN");return(0,O.jsx)(l().Fragment,null,"CONFIRM_VISIBLE"===n&&(0,O.jsx)(qs,{enrollmentKey:e,onCancel:()=>i("CONFIRM_HIDDEN"),onConfirm:async()=>{try{const t=await(0,u.TOj)(e.id);if(t.error)throw t.error}catch(e){a.toasts.addError(e,{title:"Error"})}i("CONFIRM_HIDDEN"),t()}}),(0,O.jsx)(c.EuiToolTip,{content:f.i18n.translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"})},(0,O.jsx)(c.EuiButtonIcon,{"data-test-subj":"enrollmentTokenTable.revokeBtn","aria-label":f.i18n.translate("xpack.fleet.enrollmentTokensList.revokeTokenButtonLabel",{defaultMessage:"Revoke token"}),onClick:()=>i("CONFIRM_VISIBLE"),iconType:"trash",color:"danger"})))},Vs=()=>{var e,t,a;(0,u.ifo)("enrollment_tokens");const[l,n]=(0,s.useState)(!1),[i,o]=(0,s.useState)(""),{pagination:r,setPagination:d,pageSizeOptions:g}=(0,u.WQC)(),m=(0,u.c3w)({page:r.currentPage,perPage:r.pageSize,kuery:""!==i.trim()?i:void 0}),x=(0,u.$sk)({page:1,perPage:S.W}),h=x.data?x.data.items:[],E=h.reduce(((e,t)=>(e[t.id]=t,e)),{}),y=null!==(e=null==m||null===(t=m.data)||void 0===t?void 0:t.total)&&void 0!==e?e:0,k=(null==m||null===(a=m.data)||void 0===a?void 0:a.items.filter((e=>{if(!h.length||!e.policy_id)return!1;const t=E[e.policy_id];return!(null!=t&&t.is_managed)})))||[],v=[{field:"name",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.nameTitle",{defaultMessage:"Name"}),render:e=>(0,O.jsx)("span",{className:"eui-textTruncate",title:e},e)},{field:"id",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.secretTitle",{defaultMessage:"Secret"}),width:"215px",render:e=>(0,O.jsx)(Ws,{apiKeyId:e,sendGetAPIKey:u.aGY,tokenGetter:e=>{var t;return null===(t=e.data)||void 0===t?void 0:t.item.api_key},length:60})},{field:"policy_id",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.policyTitle",{defaultMessage:"Agent policy"}),render:e=>{const t=E[e],a=t?t.name:e;return(0,O.jsx)("span",{className:"eui-textTruncate",title:a},a)}},{field:"created_at",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.createdAtTitle",{defaultMessage:"Created on"}),width:"150px",render:e=>e?(0,O.jsx)(p.FormattedDate,{year:"numeric",month:"short",day:"2-digit",value:e}):null},{field:"active",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.activeTitle",{defaultMessage:"Active"}),width:"70px",align:"center",render:e=>(0,O.jsx)(c.EuiIcon,{size:"m",color:e?"success":"danger",type:"dot"})},{field:"actions",name:f.i18n.translate("xpack.fleet.enrollmentTokensList.actionsTitle",{defaultMessage:"Actions"}),width:"70px",render:(e,t)=>{const a=h.find((e=>e.id===t.policy_id));return t.active&&!(null!=a&&a.is_managed)&&(0,O.jsx)(Ks,{apiKey:t,refresh:()=>m.resendRequest()})}}],j=m.isLoading&&m.isInitialRequest||x.isLoading&&x.isInitialRequest;return(0,O.jsx)(F.iW,{section:"enrollment_tokens"},l&&(0,O.jsx)(M.jY,{agentPolicies:h,onClose:e=>{n(!1),m.resendRequest()}}),(0,O.jsx)(c.EuiText,{color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.enrollmentTokensList.pageDescription",defaultMessage:"Create and revoke enrollment tokens. An enrollment token enables one or more agents to enroll in Fleet and send data."})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(Gs.I,{value:i,indexPattern:S.Al,fieldPrefix:S.w1,onChange:e=>{d({...r,currentPage:1}),o(e)},dataTestSubj:"enrollmentKeysList.queryInput"})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{"data-test-subj":"createEnrollmentTokenButton",fill:!0,iconType:"plusInCircle",onClick:()=>n(!0)},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.enrollmentTokensList.newKeyButton",defaultMessage:"Create enrollment token"})))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiBasicTable,{"data-test-subj":"enrollmentTokenListTable",loading:j,noItemsMessage:j?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.enrollemntAPIKeyList.loadingTokensMessage",defaultMessage:"Loading enrollment tokens..."}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.enrollemntAPIKeyList.emptyMessage",defaultMessage:"No enrollment tokens found."}),items:y?k:[],itemId:"id",columns:v,pagination:{pageIndex:r.currentPage-1,pageSize:r.pageSize,totalItemCount:y,pageSizeOptions:g},onChange:({page:e})=>{const t={...r,currentPage:e.index+1,pageSize:e.size};d(t)}}))};var $s=a(50998),Ys=a(1442);const Qs=f.i18n.translate("xpack.fleet.uninstallTokenList.policyIdTitle",{defaultMessage:"Policy ID"}),Js=f.i18n.translate("xpack.fleet.uninstallTokenList.policyNameTitle",{defaultMessage:"Policy name"}),Xs=f.i18n.translate("xpack.fleet.uninstallTokenList.createdAtTitle",{defaultMessage:"Created at"}),Zs=f.i18n.translate("xpack.fleet.uninstallTokenList.tokenTitle",{defaultMessage:"Token"}),el=f.i18n.translate("xpack.fleet.uninstallTokenList.actionsTitle",{defaultMessage:"Actions"}),tl=f.i18n.translate("xpack.fleet.uninstallTokenList.viewUninstallCommandLabel",{defaultMessage:"View uninstall command"}),al=f.i18n.translate("xpack.fleet.uninstallTokenList.searchByPolicyIdOrNamePlaceholder",{defaultMessage:"Search by policy ID or policy name"}),sl=f.i18n.translate("xpack.fleet.uninstallTokenList.searchByPolicyIdOrNameHint",{defaultMessage:"If an Agent policy is deleted, its policy name is also deleted. Use the policy ID to search for uninstall tokens related to deleted Agent policies."}),ll=({text:e,dataTestSubj:t})=>(0,O.jsx)(c.EuiText,{size:"s",className:"eui-textTruncate",title:e,"data-test-subj":t},e),nl=({onClick:e})=>(0,O.jsx)(c.EuiToolTip,{content:tl},(0,O.jsx)(c.EuiButtonIcon,{"data-test-subj":"uninstallTokensViewCommandButton","aria-label":tl,onClick:e,iconType:"inspect",color:"text"})),il=({isLoading:e})=>e?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.loadingTokensMessage",defaultMessage:"Loading uninstall tokens..."}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.emptyMessage",defaultMessage:"No uninstall tokens found."}),ol=()=>{var e,t;(0,u.ifo)("uninstall_tokens");const[a,l]=(0,s.useState)(""),[n,i]=(0,s.useState)(null),{pagination:o,setPagination:r,pageSizeOptions:d}=(0,u.WQC)(),{isLoading:g,data:f}=(0,Ys.oH)({perPage:o.pageSize,page:o.currentPage,search:a}),m=null!==(e=null==f?void 0:f.items)&&void 0!==e?e:[],x=null!==(t=null==f?void 0:f.total)&&void 0!==t?t:0,h=(0,s.useMemo)((()=>[{field:"policy_name",name:Js,render:e=>null===e?(0,O.jsx)($s.C,null):(0,O.jsx)(ll,{text:e})},{field:"policy_id",name:Qs,render:e=>(0,O.jsx)(ll,{text:e,dataTestSubj:"uninstallTokensPolicyIdField"})},{field:"created_at",name:Xs,width:"130px",render:e=>e?(0,O.jsx)(p.FormattedDate,{year:"numeric",month:"short",day:"2-digit",value:e}):null},{field:"id",name:Zs,width:"300px",render:e=>(0,O.jsx)(Ws,{apiKeyId:e,sendGetAPIKey:Ys.Wz,tokenGetter:e=>{var t;return null===(t=e.data)||void 0===t?void 0:t.item.token},length:32})},{field:"actions",name:el,align:"center",width:"70px",render:(e,{id:t})=>(0,O.jsx)(nl,{onClick:()=>i(t)})}]),[]),E=(0,s.useCallback)((({page:e})=>{r((t=>({...t,currentPage:e.index+1,pageSize:e.size})))}),[r]),y=(0,s.useCallback)((e=>{l(e),r((e=>({...e,currentPage:1})))}),[r]);return(0,O.jsx)(F.iW,{section:"uninstall_tokens"},n&&(0,O.jsx)(M.pc,{onClose:()=>i(null),target:"agent",uninstallTokenId:n}),(0,O.jsx)(c.EuiText,{color:"subdued",size:"s"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.uninstallTokenList.pageDescription",defaultMessage:"An uninstall token allows you to use the uninstall command to remove Elastic Agent from a host."})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{direction:"row",alignItems:"center"},(0,O.jsx)(c.EuiFieldSearch,{onSearch:y,incremental:!0,fullWidth:!0,maxLength:50,placeholder:al,"data-test-subj":"uninstallTokensPolicyIdSearchInput"}),(0,O.jsx)(c.EuiToolTip,{content:sl},(0,O.jsx)(c.EuiIcon,{type:"iInCircle"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiBasicTable,{"data-test-subj":"uninstallTokenListTable",items:m,columns:h,itemId:"id",loading:g,pagination:{pageIndex:o.currentPage-1,pageSize:o.pageSize,totalItemCount:x,pageSizeOptions:d},onChange:E,noItemsMessage:(0,O.jsx)(il,{isLoading:g})}),(0,O.jsx)(c.EuiSpacer,{size:"xl"}))},rl=A()(c.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-1t6qzy1-0"})(["max-width:250px;"]),ul=A()(c.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-1t6qzy1-1"})(["min-width:0px;"]),dl=({fleetServerHosts:e,deleteFleetServerHost:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(c.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(rl,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate"},e.name)),e.is_preconfigured&&l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.managedTooltip",{defaultMessage:"This Fleet server host is managed outside of Fleet. Please refer to your kibana config file for more info."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,field:"host_urls",render:e=>l().createElement(ul,{direction:"column",gutterSize:"xs"},e.map((e=>l().createElement(c.EuiFlexItem,{key:e},l().createElement("p",{title:e,className:"eui-textTruncate"},e))))),name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.hostUrlsColumnTitle",{defaultMessage:"Host URLs"})},{render:e=>e.is_default?l().createElement(c.EuiIcon,{type:"check","data-test-subj":"fleetServerHostTable.defaultIcon"}):null,width:"200px",name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&!e.is_preconfigured&&a.fleet.allSettings;return l().createElement(c.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(c.EuiFlexItem,{grow:!1},s&&l().createElement(c.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.deleteButtonTitle",{defaultMessage:"Delete"}),"data-test-subj":"fleetServerHostsTable.delete.btn"})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_fleet_server_hosts",{itemId:e.id}),title:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"fleetServerHostsTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.fleetServerHostsTable.actionsColumnTitle",{defaultMessage:"Actions"})}]),[n,t,a.fleet.allSettings]);return l().createElement(c.EuiBasicTable,{columns:i,items:e,"data-test-subj":"settingsFleetServerHostsTable"})},cl=({fleetServerHosts:e,deleteFleetServerHost:t})=>{const a=(0,u.iO7)(),{docLinks:s}=(0,u.WeA)(),{getHref:n}=(0,u.iEg)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h4",{"data-test-subj":"fleetServerHostHeader"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostSectionTitle",defaultMessage:"Fleet server hosts"}))),(0,O.jsx)(c.EuiSpacer,{size:"xs"}),(0,O.jsx)(c.EuiText,{color:"subdued",size:"m"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostSectionSubtitle",defaultMessage:"Specify the URLs that your agents will use to connect to a Fleet Server. If multiple URLs exist, Fleet will show the first provided URL for enrollment purposes. For more information, see the {guideLink} .",values:{guideLink:(0,O.jsx)(c.EuiLink,{href:s.links.fleet.guide,target:"_blank",external:!0},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetUserGuideLink",defaultMessage:"Fleet and Elastic Agent Guide"}))}})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(dl,{fleetServerHosts:e,deleteFleetServerHost:t}),a.fleet.addFleetServers?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiButtonEmpty,{iconType:"plusInCircle",href:n("settings_create_fleet_server_hosts"),"data-test-subj":"settings.fleetServerHosts.addFleetServerHostBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostCreateButtonLabel",defaultMessage:"Add Fleet Server"}))):null,(0,O.jsx)(c.EuiSpacer,{size:"m"}))},gl=({output:e,showBadge:t})=>{var a,n;const{notifications:i}=(0,u.WeA)(),[o,r]=(0,s.useState)(),{data:d}=(0,x.useQuery)(["outputHealth",e.id],(()=>(0,u.IaD)(e.id)),{refetchInterval:1e4});(0,s.useEffect)((()=>{null!=d&&d.error&&i.toasts.addError(null==d?void 0:d.error,{title:f.i18n.translate("xpack.fleet.output.errorFetchingOutputHealth",{defaultMessage:"Error fetching output state"})}),r(null==d?void 0:d.data)}),[d,i.toasts]);const g={DEGRADED:(0,O.jsx)(c.EuiCallOut,{title:"Error",color:"danger",iconType:"error","data-test-subj":"outputHealthDegradedCallout"},(0,O.jsx)("p",{className:"eui-textBreakWord"},f.i18n.translate("xpack.fleet.output.calloutText",{defaultMessage:'Unable to connect to "{name}" at {host}.',values:{name:e.name,host:null!==(a=null===(n=e.hosts)||void 0===n?void 0:n.join(","))&&void 0!==a?a:""}})),(0,O.jsx)("p",null,f.i18n.translate("xpack.fleet.output.calloutPromptText",{defaultMessage:"Please check the details are correct."}))),HEALTHY:(0,O.jsx)(c.EuiCallOut,{title:"Healthy",color:"success",iconType:"check","data-test-subj":"outputHealthHealthyCallout"},(0,O.jsx)("p",null,f.i18n.translate("xpack.fleet.output.successCalloutText",{defaultMessage:"Connection with remote output established."})))},m={DEGRADED:(0,O.jsx)(c.EuiBadge,{color:"danger","data-test-subj":"outputHealthDegradedBadge"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.outputHealth.degradedStatusText",defaultMessage:"Unhealthy"})),HEALTHY:(0,O.jsx)(c.EuiBadge,{color:"success","data-test-subj":"outputHealthHealthyBadge"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.outputHealth.healthyStatusText",defaultMessage:"Healthy"}))},h=new Date((null==o?void 0:o.timestamp)||0).getTime(),E=h?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.outputHealth.timestampTooltipText",defaultMessage:"Last reported {timestamp}",values:{timestamp:(0,O.jsx)(p.FormattedRelative,{value:h})}})):null,y=(null==o?void 0:o.state)&&m[null==o?void 0:o.state]||null;return t?E&&null!=o&&o.state?(0,O.jsx)(c.EuiToolTip,{position:"top",content:E,"data-test-subj":"outputHealthBadgeTooltip"},(0,O.jsx)(l().Fragment,null,y," ")):y:(null==o?void 0:o.state)&&g[o.state]||null},pl=l().memo((({output:e})=>{const t=(0,s.useMemo)((()=>{const t=[];return e.is_default&&t.push((0,O.jsx)(fl,{key:"default-output"})),e.is_default_monitoring&&t.push((0,O.jsx)(ml,{key:"default-monitoring-output"})),t}),[e]);return(0,O.jsx)(c.EuiBadgeGroup,{gutterSize:"xs"},t.map(((e,t)=>e)))})),fl=()=>(0,O.jsx)(c.EuiBadge,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.outputs.defaultOutputBadgeTitle",defaultMessage:"Agent integrations"})),ml=()=>(0,O.jsx)(c.EuiBadge,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.outputs.defaultMonitoringOutputBadgeTitle",defaultMessage:"Agent monitoring"})),xl=A()(c.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-uvxtm0-0"})(["max-width:250px;"]),hl=A()(c.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-uvxtm0-1"})(["min-width:0px;"]),El=({outputs:e,deleteOutput:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(c.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(xl,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate"},e.name)),e.is_preconfigured&&l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.outputsTable.managedTooltip",{defaultMessage:"This output is managed outside of Fleet."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.outputsTable.nameColumnTitle",{defaultMessage:"Name"})},{width:"172px",render:e=>function(e){switch(e){case"elasticsearch":return f.i18n.translate("xpack.fleet.settings.outputsTable.elasticsearchTypeLabel",{defaultMessage:"Elasticsearch"});case"remote_elasticsearch":return f.i18n.translate("xpack.fleet.settings.outputsTable.remoteElasticsearchTypeLabel",{defaultMessage:"Remote Elasticsearch"});default:return e}}(e.type),name:f.i18n.translate("xpack.fleet.settings.outputsTable.typeColumnTitle",{defaultMessage:"Type"})},{truncateText:!0,render:e=>l().createElement(hl,{direction:"column",gutterSize:"xs"},(e.hosts||[]).map((e=>l().createElement(c.EuiFlexItem,{key:e},l().createElement("p",{title:e,className:"eui-textTruncate"},e))))),name:f.i18n.translate("xpack.fleet.settings.outputsTable.hostColumnTitle",{defaultMessage:"Hosts"})},{render:e=>null!=e&&e.id&&"remote_elasticsearch"===e.type?l().createElement(gl,{output:e,showBadge:!0}):null,name:f.i18n.translate("xpack.fleet.settings.outputsTable.statusColumnTitle",{defaultMessage:"Status"})},{render:e=>l().createElement(pl,{output:e}),width:"200px",name:f.i18n.translate("xpack.fleet.settings.outputSection.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&!e.is_default_monitoring&&!e.is_preconfigured&&a.fleet.allSettings;return l().createElement(c.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(c.EuiFlexItem,{grow:!1},s&&l().createElement(c.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:f.i18n.translate("xpack.fleet.settings.outputSection.deleteButtonTitle",{defaultMessage:"Delete"})})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_outputs",{outputId:e.id}),title:f.i18n.translate("xpack.fleet.settings.outputSection.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"editOutputBtn"})))},name:f.i18n.translate("xpack.fleet.settings.outputSection.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a.fleet.allSettings]);return l().createElement(c.EuiBasicTable,{columns:i,items:e,"data-test-subj":"settingsOutputsTable"})},yl=({outputs:e,deleteOutput:t})=>{const a=(0,u.iO7)(),{getHref:s}=(0,u.iEg)(),{docLinks:n}=(0,u.WeA)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h4",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.outputSectionTitle",defaultMessage:"Outputs"}))),(0,O.jsx)(c.EuiSpacer,{size:"xs"}),(0,O.jsx)(c.EuiText,{color:"subdued",size:"m"},(0,O.jsx)(c.EuiLink,{href:n.links.fleet.settings,external:!0,target:"_blank"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.outputSectionSubtitle",defaultMessage:"Specify where agents will send data."}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(El,{outputs:e,deleteOutput:t}),a.fleet.allSettings&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiButtonEmpty,{iconType:"plusInCircle",href:s("settings_create_outputs"),"data-test-subj":"addOutputBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.outputCreateButtonLabel",defaultMessage:"Add output"}))))},kl=A()(c.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-xsf6c1-0"})(["max-width:250px;"]),vl=A()(c.EuiFlexGroup).withConfig({displayName:"FlexGroupWithMinWidth",componentId:"sc-xsf6c1-1"})(["min-width:0px;"]),jl=({downloadSources:e,deleteDownloadSource:t,hasAllSettingsPrivileges:a})=>{const{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(c.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(kl,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate","data-test-subj":"editDownloadSourceTable.name"},e.name))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,render:e=>l().createElement(vl,{direction:"column",gutterSize:"xs"},l().createElement(c.EuiFlexItem,{key:e.host},l().createElement("p",{title:e.host,className:"eui-textTruncate","data-test-subj":"editDownloadSourceTable.host"},e.host))),name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.hostColumnTitle",{defaultMessage:"Host"})},{render:e=>e.is_default?l().createElement(c.EuiIcon,{type:"check","data-test-subj":"editDownloadSourceTable.defaultIcon"}):null,width:"200px",name:f.i18n.translate("xpack.fleet.settings.downloadSourcesTable.defaultColumnTitle",{defaultMessage:"Default"})},{width:"68px",render:e=>{const s=!e.is_default&&a;return l().createElement(c.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(c.EuiFlexItem,{grow:!1},s&&l().createElement(c.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:f.i18n.translate("xpack.fleet.settings.downloadSourceSection.deleteButtonTitle",{defaultMessage:"Delete"}),"data-test-subj":"editDownloadSourceTable.delete.btn"})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_download_sources",{downloadSourceId:e.id}),title:f.i18n.translate("xpack.fleet.settings.downloadSourceSection.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"editDownloadSourceTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.downloadSourceSection.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a]);return l().createElement(c.EuiBasicTable,{columns:i,items:e,"data-test-subj":"AgentDownloadSourcesTable"})},bl=({downloadSources:e,deleteDownloadSource:t})=>{const{getHref:a}=(0,u.iEg)(),s=(0,u.iO7)().fleet.allSettings;return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h4",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.Title",defaultMessage:"Agent Binary Download"}))),(0,O.jsx)(c.EuiSpacer,{size:"xs"}),(0,O.jsx)(c.EuiText,{color:"subdued",size:"m"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.Subtitle",defaultMessage:"List of sources used by Elastic agents to download their binaries. The default source applies to all agent policies that don't have a specific binary source specified."})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(jl,{downloadSources:e,deleteDownloadSource:t,hasAllSettingsPrivileges:s}),s&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiButtonEmpty,{iconType:"plusInCircle",href:a("settings_create_download_sources"),"data-test-subj":"addDownloadSourcesBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.downloadSourcesSection.CreateButtonLabel",defaultMessage:"Add agent binary source"}))))},Ml=A()(c.EuiFlexItem).withConfig({displayName:"NameFlexItemWithMaxWidth",componentId:"sc-czjc9c-0"})(["max-width:250px;"]),Sl=({proxies:e,deleteFleetProxy:t})=>{const a=(0,u.iO7)(),{getHref:n}=(0,u.iEg)(),i=(0,s.useMemo)((()=>[{render:e=>l().createElement(c.EuiFlexGroup,{alignItems:"center",gutterSize:"xs"},l().createElement(Ml,{grow:!1},l().createElement("p",{title:e.name,className:"eui-textTruncate","data-test-subj":"fleetProxiesTable.name"},e.name)),e.is_preconfigured&&l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiIconTip,{content:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.managedTooltip",{defaultMessage:"This proxy is managed outside of Fleet. Please refer to your kibana config file for more info."}),type:"lock",size:"m",color:"subdued"}))),width:"288px",name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.nameColumnTitle",{defaultMessage:"Name"})},{truncateText:!0,field:"url",name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.urlColumnTitle",{defaultMessage:"Url"})},{width:"68px",render:e=>{const s=a.fleet.allSettings&&!e.is_preconfigured;return l().createElement(c.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd"},l().createElement(c.EuiFlexItem,{grow:!1},s&&l().createElement(c.EuiButtonIcon,{color:"text",iconType:"trash",onClick:()=>t(e),title:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.deleteButtonTitle",{defaultMessage:"Delete"}),"data-test-subj":"fleetProxiesTable.delete.btn"})),l().createElement(c.EuiFlexItem,{grow:!1},l().createElement(c.EuiButtonIcon,{color:"text",iconType:"pencil",href:n("settings_edit_fleet_proxy",{itemId:e.id}),title:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.editButtonTitle",{defaultMessage:"Edit"}),"data-test-subj":"fleetProxiesTable.edit.btn"})))},name:f.i18n.translate("xpack.fleet.settings.fleetProxiesTable.actionsColumnTitle",{defaultMessage:"Actions"})}]),[t,n,a.fleet.allSettings]);return l().createElement(c.EuiBasicTable,{columns:i,items:e,"data-test-subj":"fleetProxiesTable"})},Fl=({proxies:e,deleteFleetProxy:t})=>{const a=(0,u.iO7)(),{getHref:s}=(0,u.iEg)(),{docLinks:n}=(0,u.WeA)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFlexGroup,{gutterSize:"xs"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h4",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.title",defaultMessage:"Proxies"}))))),(0,O.jsx)(c.EuiText,{color:"subdued",size:"m"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.subtitle",defaultMessage:"Specify any proxy URLs to be used in Fleet servers, Outputs or Agent binary download sources. For more information see our {docLink}.",values:{docLink:(0,O.jsx)(c.EuiLink,{target:"_blank",external:!0,href:n.links.fleet.proxiesSettings},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.link",defaultMessage:"docs"}))}})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Sl,{proxies:e,deleteFleetProxy:t}),a.fleet.allSettings&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiButtonEmpty,{iconType:"plusInCircle",href:s("settings_create_fleet_proxy"),"data-test-subj":"addProxyBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxiesSection.CreateButtonLabel",defaultMessage:"Add proxy"}))))},Il=({})=>{var e,t,a,n,i,o,r,d;const g=(0,u.iO7)(),{docLinks:m,notifications:x}=(0,u.WeA)(),h=null!==(e=null===(t=(0,u.ZwD)().data)||void 0===t||null===(a=t.item)||void 0===a||null===(n=a.delete_unenrolled_agents)||void 0===n?void 0:n.enabled)&&void 0!==e&&e,E=null!==(i=null===(o=(0,u.ZwD)().data)||void 0===o||null===(r=o.item)||void 0===r||null===(d=r.delete_unenrolled_agents)||void 0===d?void 0:d.is_preconfigured)&&void 0!==i&&i,[y,k]=l().useState(h),{mutateAsync:v}=(0,u.Zd9)();(0,s.useEffect)((()=>{h&&k(h)}),[h]);const j=(0,s.useCallback)((async e=>{try{k(e);const t=await v({delete_unenrolled_agents:{enabled:e,is_preconfigured:!1}});if(t.error)throw t.error}catch(t){k(!e),x.toasts.addError(t,{title:f.i18n.translate("xpack.fleet.errorUpdatingSettings",{defaultMessage:"Error updating settings"})})}}),[v,x.toasts]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h4",{"data-test-subj":"advancedHeader"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.advancedSectionTitle",defaultMessage:"Advanced Settings"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiForm,{component:"form"},(0,O.jsx)(c.EuiDescribedFormGroup,{title:(0,O.jsx)("h3",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Delete unenrolled agents"})),description:(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.switchLabel",defaultMessage:"Switching on this setting will enable auto deletion of unenrolled agents. For more information see our {docLink}.",values:{docLink:(0,O.jsx)(c.EuiLink,{target:"_blank",external:!0,href:m.links.fleet.settings},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.advancedSection.link",defaultMessage:"docs"}))}}))},(0,O.jsx)(c.EuiFormRow,{label:""},(0,O.jsx)(c.EuiToolTip,{content:E?f.i18n.translate("xpack.fleet.settings.advancedSection.preconfiguredTitle",{defaultMessage:"This setting is preconfigured and cannot be updated."}):void 0},(0,O.jsx)(c.EuiSwitch,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteUnenrolledAgentsLabel",defaultMessage:"Delete unenrolled agents"}),checked:y,onChange:e=>j(e.target.checked),disabled:!g.fleet.allSettings||E}))))),(0,O.jsx)(c.EuiSpacer,{size:"m"}))},Tl=({outputs:e,proxies:t,fleetServerHosts:a,deleteOutput:s,deleteFleetServerHost:n,downloadSources:i,deleteDownloadSource:o,deleteFleetProxy:r})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(cl,{fleetServerHosts:a,deleteFleetServerHost:n}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(yl,{outputs:e,deleteOutput:s}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(bl,{downloadSources:i,deleteDownloadSource:o}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Fl,{proxies:t,deleteFleetProxy:r}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Il,null));var wl=a(47907),Cl=a(54761);const Al=({label:e,inputProps:t,placeholder:a,dataTestSubj:s})=>(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:e},t.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":s,fullWidth:!0},t.props,{placeholder:a}))),Pl=({label:e,inputProps:t,placeholder:a,dataTestSubj:s})=>(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:e},t.formRowProps),(0,O.jsx)(c.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5,"data-test-subj":s},t.props,{placeholder:a}))),_l=()=>(0,O.jsx)(c.EuiCallOut,{iconType:"warning",color:"warning",size:"s",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.proxyWarning.warningTitle",defaultMessage:"Be aware that changing the proxy settings may cause Elastic Agents to lose connectivity. Please ensure that agents have reachability to the proxy in the context that it is being used for."})});var Ll=a(38684);const Dl=({onClose:e,fleetServerHost:t,defaultFleetServerHost:a,proxies:n})=>{const{docLinks:i,cloud:o}=(0,u.WeA)(),r=(0,Ll.ao)(t,e,a),{inputs:g}=r,m=(0,s.useMemo)((()=>n.map((e=>({value:e.id,label:e.name})))),[n]);return(0,O.jsx)(c.EuiFlyout,{onClose:e,maxWidth:S.MW},(0,O.jsx)(c.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiTitle,{size:"m"},(0,O.jsx)("h2",null,t?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.editTitle",defaultMessage:"Edit Fleet Server"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.addTitle",defaultMessage:"Add Fleet Server"}))),!t&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiText,{color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.serverlessInfoText",defaultMessage:"You may create another Fleet Server definition reachable via a proxy. In context of the serverless project, Fleet Service is managed by Elastic. Creation of a new one is therefore not permitted."}))))),(0,O.jsx)(c.EuiFlyoutBody,null,t&&(0,O.jsx)(c.EuiCallOut,{size:"m",color:"warning",iconType:"warning",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutTitle",defaultMessage:"Changing these settings can break your agent connections"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.warningCalloutDescription",defaultMessage:"Invalid settings can break the connection between Elastic Agent and Fleet Server. If this happens, you will need to re-enroll your agents."})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiForm,{onSubmit:r.submit},(0,O.jsx)(Al,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.nameInputLabel",defaultMessage:"Name"}),inputProps:g.nameInput,dataTestSubj:"fleetServerHostsFlyout.nameInput",placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.hostUrlLabel",defaultMessage:"URL"})},(0,O.jsx)(l().Fragment,null,!(null!=o&&o.isServerlessEnabled)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{color:"subdued",size:"relative"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.description",defaultMessage:"Specify multiple URLs to scale out your deployment and provide automatic failover. If multiple URLs exist, Fleet shows the first provided URL for enrollment purposes. Enrolled Elastic Agents will connect to the URLs in round robin order until they connect successfully. For more information, see the {link} .",values:{link:(0,O.jsx)(c.EuiLink,{href:i.links.fleet.settingsFleetServerHostSettings,target:"_blank",external:!0},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.userGuideLink",defaultMessage:"Fleet and Elastic Agent Guide"}))}})),(0,O.jsx)(c.EuiSpacer,{size:"m"})),(0,O.jsx)(Cl.G,(0,d.default)({},g.hostUrlsInput.props,{id:"fleet-server-inputs",placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.fleetServerHostsInputPlaceholder",{defaultMessage:"Specify host URL"}),isUrl:!0,helpText:(null==o?void 0:o.isServerlessEnabled)&&(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.serverlessHostUrlsHelpText",defaultMessage:"Custom host URLs are not allowed in serverless."})})))),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.proxyIdLabel",defaultMessage:"Proxy"})},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"fleetServerHostsFlyout.proxyIdInput"},g.proxyIdInput.props,{onChange:e=>{var t,a;return g.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==g.proxyIdInput.value?m.filter((e=>e.value===g.proxyIdInput.value)):[],options:m,singleSelection:{asPlainText:!0},isDisabled:g.proxyIdInput.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.fleetServerHostsFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})})),(0,O.jsx)(c.EuiSpacer,{size:"xs"}),(0,O.jsx)(_l,null))),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},g.isDefaultInput.formRowProps),(0,O.jsx)(c.EuiSwitch,(0,d.default)({"data-test-subj":"fleetServerHostsFlyout.isDefaultSwitch"},g.isDefaultInput.props,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.defaultOutputSwitchLabel",defaultMessage:"Make this Fleet server the default one."})}))))),(0,O.jsx)(c.EuiFlyoutFooter,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{fill:!0,isLoading:r.isLoading,isDisabled:r.isDisabled,onClick:r.submit,"data-test-subj":"saveApplySettingsBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},Ol=()=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetProxy.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),Rl=({})=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetProxy.confirmModalText",defaultMessage:"This action will change agent policies currently using that proxy. Are you sure you wish to continue?"});async function Bl(e){var t,a;let s=`${S.mm}.data_output_id:"${e.id}" or ${S.mm}.monitoring_output_id:"${e.id}"`;const l=`${S.f$}.output_id:"${e.id}"`;e.is_default&&(s+=` or (not ${S.mm}.data_output_id:*)`);const n=await(0,u.cnO)({kuery:s,page:1,perPage:S.W,noAgentCount:!0});if(n.error)throw n.error;const i=await(0,u.TR6)({kuery:l,page:1,perPage:S.W});if(i.error)throw n.error;const o=((null===(t=n.data)||void 0===t?void 0:t.items)||[]).map((e=>e.id)),r=((null===(a=i.data)||void 0===a?void 0:a.items)||[]).reduce(((e,t)=>[...e,...t.policy_ids||[]]),[]),d=new Set([...o,...r]),c=d.size;let g=0;if(c>0){var p,f;const e=await(0,u.voy)({page:1,perPage:0,showInactive:!1,kuery:[...d].map((e=>`policy_id:"${e}"`)).join(" or ")});if(e.error)throw e.error;g=null!==(p=null===(f=e.data)||void 0===f?void 0:f.total)&&void 0!==p?p:0}return{agentPolicyCount:c,agentCount:g}}const Nl=()=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),zl=({output:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalText",defaultMessage:"This action will delete {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,O.jsx)("strong",null,e.name),agents:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteOutput.confirmModalTextWithCount",defaultMessage:"This action will delete {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,O.jsx)("strong",null,e.name)}}),Ul=()=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetServerHosts.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),Hl=({})=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteFleetServerHosts.confirmModalText",defaultMessage:"This action will change agent policies currently enrolled in this Fleet Server, to instead enroll in your default Fleet server. Are you sure you wish to continue?"});async function Wl(e){var t,a,s;let l=`${S.mm}.download_source_id:"${e.id}"`;e.is_default&&(l+=` or (not ${S.mm}.download_source_id:*)`);const n=await(0,u.cnO)({kuery:l,page:1,perPage:S.W});if(n.error)throw n.error;const i=null!==(t=null===(a=n.data)||void 0===a||null===(s=a.items)||void 0===s?void 0:s.length)&&void 0!==t?t:0;let o=0;if(i>0){var r,d,c;const e=await(0,u.voy)({page:1,perPage:0,showInactive:!1,kuery:null===(r=n.data)||void 0===r?void 0:r.items.map((e=>`policy_id:"${e.id}"`)).join(" or ")});if(e.error)throw e.error;o=null!==(d=null===(c=e.data)||void 0===c?void 0:c.total)&&void 0!==d?d:0}return{agentPolicyCount:i,agentCount:o}}const Gl=({downloadSource:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalText","data-test-subj":"editDownloadSourcesConfirmModal.confirmModalText",defaultMessage:"This action will update {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,O.jsx)("strong",null,e.name),agents:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalTextWithoutCount","data-test-subj":"editDownloadSourcesConfirmModal.confirmModalText",defaultMessage:"This action will update {downloadSourceName} agent binary source. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,O.jsx)("strong",null,e.name)}});function ql(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}function Kl(e){try{if(!e)return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.HostIsRequiredErrorMessage",{defaultMessage:"Host is required"})];const t=new URL(e);if(!["http:","https:"].includes(t.protocol))throw new Error("Invalid protocol")}catch(e){return[f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.hostError",{defaultMessage:"Invalid URL"})]}}const Vl=({onClose:e,downloadSource:t,proxies:a})=>{(0,u.ifo)("settings");const l=function(e,t){var a,l,n,i;const o=(0,u.iO7)(),[r,d]=(0,s.useState)(!1),{notifications:c}=(0,u.WeA)(),{confirm:g}=(0,wl.fl)(),m=!o.fleet.allSettings,x=(0,u.Gez)(null!==(a=null==t?void 0:t.name)&&void 0!==a?a:"",ql,m),h=(0,u.MbH)(null!==(l=null==t?void 0:t.is_default)&&void 0!==l&&l,(null==t?void 0:t.is_default)||m),E=(0,u.Gez)(null!==(n=null==t?void 0:t.host)&&void 0!==n?n:"",Kl,m),y=(0,u.Gez)(null!==(i=null==t?void 0:t.proxy_id)&&void 0!==i?i:"",(()=>{}),m),k={nameInput:x,hostInput:E,defaultDownloadSourceInput:h,proxyIdInput:y},v=Object.values(k).some((e=>e.hasChanged)),j=(0,s.useCallback)((()=>{const e=x.validate(),t=E.validate();return e&&t}),[x,E]),b=(0,s.useCallback)((async()=>{try{if(!j())return;d(!0);const a={name:x.value.trim(),host:E.value.trim(),is_default:h.value,proxy_id:y.value||null};if(t){if(!await async function(e,t){const{agentCount:a,agentPolicyCount:s}=await Wl(e).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));return t((0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateDownloadSourceModal.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),(0,O.jsx)(Gl,{agentCount:a,agentPolicyCount:s,downloadSource:e}))}(t,g))return void d(!1);const e=await(0,u.liT)(t.id,a);if(e.error)throw e.error}else{const e=await(0,u.YLO)(a);if(e.error)throw e.error}e(),d(!1)}catch(e){d(!1),c.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.dowloadSourceFlyoutForm.errorToastTitle",{defaultMessage:"Error while saving binary source"})})}}),[g,h.value,t,E.value,x.value,c.toasts,e,y.value,j]);return{inputs:k,submit:b,isLoading:r,isDisabled:r||t&&!v||m}}(e,t),n=l.inputs,{docLinks:i}=(0,u.WeA)(),o=(0,s.useMemo)((()=>a.map((e=>({value:e.id,label:e.name})))),[a]);return(0,O.jsx)(c.EuiFlyout,{onClose:e,maxWidth:S.MW},(0,O.jsx)(c.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(c.EuiTitle,{size:"m"},(0,O.jsx)("h2",{id:"FleetEditDownloadSourcesFlyoutTitle"},t?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.editTitle",defaultMessage:"Edit agent binary source","data-test-subj":"editDownloadSourcesFlyout.edit.title"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.createTitle",defaultMessage:"Add new agent binary source","data-test-subj":"editDownloadSourcesFlyout.add.title"})))),(0,O.jsx)(c.EuiFlyoutBody,null,(0,O.jsx)(c.EuiForm,null,(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.nameInputLabel",defaultMessage:"Name"})},n.nameInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.nameInput",fullWidth:!0},n.nameInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editDownloadSourcesFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}))),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:(0,O.jsx)(p.FormattedMessage,{"data-test-subj":"editDownloadSourcesFlyout.hostHelpText",id:"xpack.fleet.settings.editDownloadSourcesFlyout.hostsInputDescription",defaultMessage:"Enter the address of the directory containing the binaries to download. {guideLink}",values:{guideLink:(0,O.jsx)(c.EuiLink,{href:i.links.fleet.settings,target:"_blank",external:!0},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetSettingsLink",defaultMessage:"Learn more"}))}}),label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.hostInputLabel",defaultMessage:"Host"})},n.hostInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.hostInput",fullWidth:!0},n.hostInput.props,{placeholder:"https://artifacts.elastic.co/downloads"}))),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdLabel",defaultMessage:"Proxy"}),helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.proxyInputDescription",defaultMessage:"Proxy used for accessing the download source. Currently only the proxy URL is used, headers and certificates are not supported."})},(0,O.jsx)(c.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.proxyIdInput"},n.proxyIdInput.props,{onChange:e=>{var t,a;return n.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==n.proxyIdInput.value?o.filter((e=>e.value===n.proxyIdInput.value)):[],options:o,singleSelection:{asPlainText:!0},isDisabled:n.proxyIdInput.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.editDownloadSourcesFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})}))),(0,O.jsx)(c.EuiSpacer,{size:"xs"}),(0,O.jsx)(_l,null),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},n.defaultDownloadSourceInput.formRowProps),(0,O.jsx)(c.EuiSwitch,(0,d.default)({"data-test-subj":"editDownloadSourcesFlyout.isDefaultSwitch"},n.defaultDownloadSourceInput.props,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.defaultSwitchLabel",defaultMessage:"Make this host the default for all agent policies."})}))))),(0,O.jsx)(c.EuiFlyoutFooter,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{onClick:e,flush:"left","data-test-subj":"editDownloadSourcesFlyout.cancelBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{fill:!0,isLoading:l.isLoading,isDisabled:l.isDisabled,onClick:l.submit,"data-test-subj":"editDownloadSourcesFlyout.submitBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editDownloadSourcesFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},$l=()=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalTitle",defaultMessage:"Delete and deploy changes?"}),Yl=({downloadSource:e,agentCount:t,agentPolicyCount:a})=>void 0!==t&&void 0!==a?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalText",defaultMessage:"This action will delete {downloadSourceName} agent binary source. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,O.jsx)("strong",null,e.name),agents:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.deleteDowloadSource.confirmModalTextWithoutCount",defaultMessage:"This action will delete {downloadSourceName} agent binary source and it will update its related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{downloadSourceName:(0,O.jsx)("strong",null,e.name)}}),Ql=()=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),Jl=({})=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.confirmModalText",defaultMessage:"This action will update agent policies using this proxy. This action can not be undone. Are you sure you wish to continue?"});function Xl(e){return e&&""!==e?e.match($.lyu)?void 0:[f.i18n.translate("xpack.fleet.settings.fleetProxyFlyoutUrlError",{defaultMessage:"Invalid URL"})]:[f.i18n.translate("xpack.fleet.settings.fleetProxyFlyoutUrlRequired",{defaultMessage:"URL is required"})]}function Zl(e){if(e&&""!==e){const t=(0,ms.Hh)(e);if("object"!=typeof t||Object.values(t).some((e=>{const t=typeof e;return"string"!==t&&"number"!==t&&"boolean"!==t})))return[f.i18n.translate("xpack.fleet.settings.fleetProxy.proxyHeadersErrorMessage",{defaultMessage:"Proxy headers is not a valid key: value object."})]}}function en(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.fleetProxy.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}const tn=({onClose:e,fleetProxy:t})=>{const a=function(e,t){var a,l,n,i,o,r;const[d,c]=(0,s.useState)(!1),g=(0,u.iO7)(),{notifications:p}=(0,u.WeA)(),{confirm:m}=(0,wl.fl)(),x=null!==(a=!g.fleet.allSettings||(null==e?void 0:e.is_preconfigured))&&void 0!==a&&a,h=(0,u.Gez)(null!==(l=null==e?void 0:e.name)&&void 0!==l?l:"",en,x),E=(0,u.Gez)(null!==(n=null==e?void 0:e.url)&&void 0!==n?n:"",Xl,x),y=(0,u.Gez)(null!=e&&e.proxy_headers?(0,ms.Bh)(e.proxy_headers):"",Zl,x),k=(0,u.Gez)(null!==(i=null==e?void 0:e.certificate_authorities)&&void 0!==i?i:"",(()=>{}),x),v=(0,u.Gez)(null!==(o=null==e?void 0:e.certificate)&&void 0!==o?o:"",(()=>{}),x),j=(0,u.Gez)(null!==(r=null==e?void 0:e.certificate_key)&&void 0!==r?r:"",(()=>{}),x),b=(0,s.useMemo)((()=>({nameInput:h,urlInput:E,proxyHeadersInput:y,certificateAuthoritiesInput:k,certificateInput:v,certificateKeyInput:j})),[h,E,y,k,v,j]),M=(0,s.useCallback)((()=>(0,u.C11)(b)),[b]),S=(0,s.useCallback)((async()=>{try{if(!M())return;if(e&&!await m((0,O.jsx)(Ql,null),(0,O.jsx)(Jl,null)))return;c(!0);const a={name:h.value,url:E.value,proxy_headers:""===y.value?void 0:(0,ms.Hh)(y.value),certificate_authorities:k.value,certificate:v.value,certificate_key:j.value};if(e){const t=await(0,u.aCR)(e.id,a);if(t.error)throw t.error}else{const e=await(0,u.nJY)(a);if(e.error)throw e.error}p.toasts.addSuccess(f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.successToastTitle",{defaultMessage:"Fleet proxy saved"})),c(!1),await t()}catch(e){c(!1),p.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.errorToastTitle",{defaultMessage:"An error happened while saving Fleet Server host"})})}}),[e,h.value,E.value,y.value,k.value,v.value,j.value,M,p,m,t]),F=Object.values(b).some((e=>e.hasChanged));return{isLoading:d,isDisabled:d||!F||h.props.isInvalid||E.props.isInvalid,submit:S,inputs:b}}(t,e),{inputs:l}=a;return(0,O.jsx)(c.EuiFlyout,{onClose:e,maxWidth:S.MW},(0,O.jsx)(c.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(c.EuiTitle,{size:"m"},(0,O.jsx)("h2",null,t?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.editTitle",defaultMessage:"Edit Proxy"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.addTitle",defaultMessage:"Add Proxy"})))),(0,O.jsx)(c.EuiFlyoutBody,null,(0,O.jsx)(_l,null),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiForm,{onSubmit:a.submit},(0,O.jsx)(Al,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.nameInputLabel",defaultMessage:"Name"}),inputProps:l.nameInput,"data-test-subj":"fleetProxyFlyout.nameInput",placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}),(0,O.jsx)(Al,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.urlInputLabel",defaultMessage:"Proxy Url"}),dataTestSubj:"fleetProxyFlyout.urlInput",inputProps:l.urlInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.urlInputPlaceholder",{defaultMessage:"Specify proxy url"})}),(0,O.jsx)(Pl,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.proxyHeadersLabel",defaultMessage:"Proxy headers"}),dataTestSubj:"fleetProxyFlyout.proxyHeadersInput",inputProps:l.proxyHeadersInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.proxyHeadersPlaceholder",{defaultMessage:"Specify proxy headers"})}),(0,O.jsx)(Al,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesLabel",defaultMessage:"Certificate authorities"}),dataTestSubj:"fleetProxyFlyout.certificateAuthoritiesInput",inputProps:l.certificateAuthoritiesInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificateAuthoritiesPlaceholder",{defaultMessage:"Specify certificate authorities"})}),(0,O.jsx)(Al,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateLabel",defaultMessage:"Certificate"}),dataTestSubj:"fleetProxyFlyout.certificateInput",inputProps:l.certificateInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificatePlaceholder",{defaultMessage:"Specify certificate"})}),(0,O.jsx)(Al,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.certificateKeyLabel",defaultMessage:"Certificate key"}),dataTestSubj:"fleetProxyFlyout.certificateKeyInput",inputProps:l.certificateKeyInput,placeholder:f.i18n.translate("xpack.fleet.settings.fleetProxyFlyout.certificateKeyPlaceholder",{defaultMessage:"Specify certificate key"})}))),(0,O.jsx)(c.EuiFlyoutFooter,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{onClick:()=>e(),flush:"left"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{fill:!0,isLoading:a.isLoading,isDisabled:a.isDisabled,onClick:a.submit,"data-test-subj":"saveApplySettingsBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetProxyFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))};var an=a(2912);const sn=({inputs:e})=>{const t=(0,s.useMemo)((()=>$.HDJ.map((e=>({label:e,value:e})))),[]);return(0,O.jsx)(c.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaTopicsPanel"},(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaHeaders"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopcisTitle",defaultMessage:"Topics"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",defaultMessage:"Default topic"})},(0,O.jsx)(c.EuiRadioGroup,(0,d.default)({style:{flexDirection:"row",flexWrap:"wrap",columnGap:30},"data-test-subj":"editOutputFlyout.kafkaTopicsRadioInput",options:$.HV8,compressed:!0},e.kafkaTopicsInput.props))),(()=>{switch(e.kafkaTopicsInput.value){case $.LXo.Static:return(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaTopicsDefaultTopicLabel",defaultMessage:"Default topic"})},e.kafkaStaticTopicInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaStaticTopicInput",fullWidth:!0},e.kafkaStaticTopicInput.props)));case $.LXo.Dynamic:return(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,helpText:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicHelptext",{defaultMessage:"Select a topic from the list. If a topic is not available, create a custom one."}),label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaDynamicTopicLabel",defaultMessage:"Topic from field"})},e.kafkaDynamicTopicInput.formRowProps),(0,O.jsx)(c.EuiComboBox,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaDynamicTopicInput",fullWidth:!0,isClearable:!0,options:t,customOptionText:"Use custom field (not recommended)",singleSelection:{asPlainText:!0}},e.kafkaDynamicTopicInput.props)))}})(),(0,O.jsx)(c.EuiSpacer,{size:"m"}))},ln=e=>{const{inputs:t}=e,{props:{onChange:a},value:l,formRowProps:{error:n}}=t.kafkaHeadersInput,[i,o]=(0,s.useState)(!1),r=(0,s.useCallback)(((e,t,s)=>{const n=l.map(((a,l)=>l===e?{...a,[t]:s}:a));a(n)}),[l,a]),u=(0,s.useCallback)((()=>{o(!0);const e=[...l,{key:"",value:""}];a(e)}),[l,a]),g=(0,s.useCallback)((e=>{const t=l.filter(((t,a)=>a!==e));a(t)}),[l,a]),m=1===l.length,x=1===l.length&&(""===l[0].key||""===l[0].value),h=e=>null!=e&&e.length?e.map(((e,t)=>(0,O.jsx)(c.EuiFormErrorText,{key:t},e))):null,E=(0,s.useMemo)((()=>(e,t)=>null==n?void 0:n.filter((a=>a.index===e&&("key"===t?a.hasKeyError:a.hasValueError))).map((e=>e.message))),[n]),y=(0,s.useMemo)((()=>n&&n.filter((e=>void 0===e.index)).map((({message:e})=>e))),[n]);return(0,O.jsx)(c.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaHeadersPanel"},(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaHeaders"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeadersTitle",defaultMessage:"Headers"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),l.map(((e,t)=>{var a,s;const l=E(t,"key"),n=E(t,"value");return(0,O.jsx)("div",{key:t},t>0&&(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart",gutterSize:"none",style:{gap:30}},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeaderKeyInputLabel",defaultMessage:"Key"}),error:h(l),isInvalid:(null!==(a=null==l?void 0:l.length)&&void 0!==a?a:0)>0},(0,O.jsx)(c.EuiFieldText,{"data-test-subj":`settingsOutputsFlyout.kafkaHeadersKeyInput${t}`,fullWidth:!0,value:e.key,onChange:e=>r(t,"key",e.target.value),autoFocus:i}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHeaderValueInputLabel",defaultMessage:"Value"}),error:h(n),isInvalid:(null!==(s=null==n?void 0:n.length)&&void 0!==s?s:0)>0},(0,O.jsx)(c.EuiFieldText,{"data-test-subj":`settingsOutputsFlyout.kafkaHeadersValueInput${t}`,fullWidth:!0,value:e.value,onChange:e=>r(t,"value",e.target.value)}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1,style:{marginTop:28}},(0,O.jsx)(c.EuiButtonIcon,{"data-test-subj":`settingsOutputsFlyout.kafkaHeadersDeleteButton${t}`,color:"text",onClick:()=>g(t),iconType:"cross",disabled:m,"aria-label":f.i18n.translate("xpack.fleet.kafkaHeadersInput.deleteButton",{defaultMessage:"Delete row"})}))))})),h(y),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiButtonEmpty,{"data-test-subj":"kafkaHeaders.multiRowInput.addRowButton",disabled:x,size:"xs",flush:"left",iconType:"plusInCircle",onClick:u},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.kafkaHeadersInput.addRow",defaultMessage:"Add header"})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaClientIdLabel",defaultMessage:"Client ID"})},t.kafkaClientIdInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaClientIdInput",fullWidth:!0},t.kafkaClientIdInput.props))))},nn=e=>{const{inputs:t}=e,a=(0,s.useMemo)((()=>Array.from({length:6},((e,t)=>10*(t+1))).map((e=>({text:e,label:`${e} seconds`})))),[]),l=e=>{switch(e){case $.NAW.DoNotWait:return"No response";case $.NAW.Replica:return"Wait for all replicas to commit";default:case $.NAW.Commit:return"Wait for local commit"}},n=(0,s.useMemo)((()=>Object.keys($.NAW).map((e=>({text:$.NAW[e],label:l($.NAW[e])})))),[]);return(0,O.jsx)(c.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaBrokerSettingsPanel"},(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaBrokerSettings"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerSettingsTitle",defaultMessage:"Broker settings"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputLabel",defaultMessage:"Broker timeout"}),helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerTimeoutInputHelpText",defaultMessage:"Define how long a Kafka server waits for data in the same cluster."})},(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerTimeoutInput"},t.kafkaBrokerTimeoutInput.props,{options:a}))),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputLabel",defaultMessage:"Broker reachability timeout"}),helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerReachabilityTimeoutInputHelpText",defaultMessage:"Define how long an Agent would wait for a response from Kafka broker."})},(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerReachabilityTimeoutInput"},t.kafkaBrokerReachabilityTimeoutInput.props,{options:a}))),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputLabel",defaultMessage:"ACK Reliability"}),helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaBrokerAckReliabilityInputHelpText",defaultMessage:"Reliability level required from the broker."})},(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaBrokerAckReliabilityInputLabel"},t.kafkaBrokerAckReliabilityInput.props,{options:n}))))},on=e=>{const{inputs:t}=e,a=(0,s.useMemo)((()=>Object.keys($.jZS).filter((e=>"None"!==e)).map((e=>({text:$.jZS[e],label:$.jZS[e]})))),[]),n=(0,s.useMemo)((()=>Array.from({length:9},((e,t)=>t+1)).map((e=>({text:e,label:e.toString()})))),[]);return(0,O.jsx)(c.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaCompressionPanel"},(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaCompression"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionTitle",defaultMessage:"Compression"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiSwitch,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaCompressionSwitch"},t.kafkaCompressionInput.props,{onChange:e=>{e.target.checked||t.kafkaCompressionCodecInput.setValue($.jZS.None),t.kafkaCompressionInput.setValue(e.target.checked)},label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionSwitchLabel",defaultMessage:"Enable compression"})})),t.kafkaCompressionInput.value?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionCodecInputLabel",defaultMessage:"Codec"})},(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaCompressionCodecInput"},t.kafkaCompressionCodecInput.props,{options:a}))),t.kafkaCompressionCodecInput.value===$.jZS.Gzip&&(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaCompressionLevelInputLabel",defaultMessage:"Level"})},(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0},t.kafkaCompressionLevelInput.props,{"data-test-subj":"settingsOutputsFlyout.kafkaCompressionLevelInput",options:n})))):null)},rn=[{id:$.BwZ.Random,label:"Random","data-test-subj":"kafkaPartitionRandomRadioButton"},{id:$.BwZ.RoundRobin,label:"Round robin","data-test-subj":"kafkaPartitionRoundRobinRadioButton"},{id:$.BwZ.Hash,label:"Hash","data-test-subj":"kafkaPartitionHashRadioButton"}],un=e=>{const{inputs:t}=e;return(0,O.jsx)(c.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaPartitionPanel"},(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaPartitionTitle"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTitle",defaultMessage:"Partitioning"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitioningInputLabel",defaultMessage:"Partitioning strategy"})},(0,O.jsx)(c.EuiRadioGroup,(0,d.default)({style:{flexDirection:"row",flexWrap:"wrap",columnGap:30},"data-test-subj":"settingsOutputsFlyout.kafkaPartitioningRadioInput",options:rn,compressed:!0},t.kafkaPartitionTypeInput.props))),(()=>{switch(t.kafkaPartitionTypeInput.value){case $.BwZ.Random:return(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRandomInputLabel",defaultMessage:"Number of events"})},t.kafkaPartitionTypeRandomInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeRandomInput",fullWidth:!0},t.kafkaPartitionTypeRandomInput.props)));case $.BwZ.RoundRobin:return(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeRoundRobinInputLabel",defaultMessage:"Number of events"})},t.kafkaPartitionTypeRoundRobinInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeRoundRobinInput",fullWidth:!0},t.kafkaPartitionTypeRoundRobinInput.props)));case $.BwZ.Hash:default:return(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashInputLabel",defaultMessage:"List of fields"}),helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPartitionTypeHashHelpTextLabel",defaultMessage:"Comma separated."})},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaPartitionTypeHashInput",fullWidth:!0},t.kafkaPartitionTypeHashInput.props))))}})())},dn=({fullWidth:e,error:t,isInvalid:a,children:n,clear:i,title:o,initialValue:r,onToggleSecretStorage:u,cancelEdit:d,useSecretsStorage:g,isConvertedToSecret:m=!1,label:x,disabled:h})=>{const E=!!r,[y,k]=(0,s.useState)(m||!r),v=(0,O.jsx)(c.EuiPanel,{color:"subdued",borderRadius:"none",hasShadow:!1},h?(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.outputForm.secretValueHiddenAndDisabledMessage",defaultMessage:"The saved {varName} is hidden.",values:{varName:o}})):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.outputForm.secretValueHiddenMessage",defaultMessage:"The saved {varName} is hidden. You can only replace the {varName}.",values:{varName:o}})),(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiButtonEmpty,{onClick:()=>k(!0),color:"primary",iconType:"refresh",iconSide:"left",size:"xs"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.outputForm.editSecretValue",defaultMessage:"Replace {varName}",values:{varName:o}})))),j=(0,O.jsx)(c.EuiButtonEmpty,{onClick:()=>{k(!1),d&&d()},color:"primary",iconType:"refresh",iconSide:"left",size:"xs"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.editPackagePolicy.stepConfigure.fieldSecretValueSetCancelButton",defaultMessage:"Cancel {varName} change",values:{varName:o}})),b=(0,O.jsx)(l().Fragment,null,n,E&&!m&&(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"flexEnd","data-test-subj":"secretCancelChangeBtn"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},j))),M=(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiIcon,{type:"lock","data-test-subj":"lockIcon"})," ",o," ",(0,O.jsx)(c.EuiToolTip,{content:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTooltip",{defaultMessage:"This value will be stored as a secret, meaning once saved the value cannot be viewed again"})},(0,O.jsx)(c.EuiIcon,{type:"questionInCircle"}))),S=(0,s.useMemo)((()=>h?null:m?(0,O.jsx)(c.EuiCallOut,{size:"s",color:"warning"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeySecretInputConvertedCalloutTitle",defaultMessage:"This field will be re-saved using secret storage from plain text storage. Secrets storage requires Fleet Server v8.12.0 and above. {revertLink}",values:{revertLink:(0,O.jsx)(c.EuiLink,{onClick:()=>u(!1),color:"primary"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.revertToPlaintextLink",defaultMessage:"Click to use plain text storage instead"}))}})):r?void 0:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeySecretInputCalloutTitle",defaultMessage:"This field uses secret storage and requires Fleet Server v8.12.0 and above. {revertLink}",values:{revertLink:(0,O.jsx)(c.EuiLink,{onClick:()=>u(!1),color:"primary"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.revertToPlaintextLink",defaultMessage:"Click to use plain text storage instead"}))}})),[h,r,m,u]),F=h?null:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.secretInputCalloutTitle",defaultMessage:"This field should be stored as a secret, currently it is set to be stored as plain text. {enableSecretLink}",values:{enableSecretLink:(0,O.jsx)(c.EuiLink,{onClick:()=>u(!0),color:"primary"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.revertToSecretStorageLink",defaultMessage:"Click to use secret storage instead"}))}}),I=y?b:v;return g?(0,O.jsx)(c.EuiFormRow,{fullWidth:e,label:M,error:t,isInvalid:a,helpText:S},I):(0,O.jsx)(c.EuiFormRow,{fullWidth:e,error:t,isInvalid:a,label:x,helpText:F},I)},cn=[{id:$.N9h.Plain,label:"Plain","data-test-subj":"kafkaSaslPlainRadioButton"},{id:$.N9h.ScramSha256,label:"SCRAM-SHA-256","data-test-subj":"kafkaSaslScramSha256RadioButton"},{id:$.N9h.ScramSha512,label:"SCRAM-SHA-512","data-test-subj":"kafkaSaslScramSha512RadioButton"}],gn=[{id:$.NB8.None,label:"None","data-test-subj":"kafkaAuthenticationNoneRadioButton"},{id:$.NB8.Userpass,label:"Username / Password","data-test-subj":"kafkaAuthenticationUsernamePasswordRadioButton"},{id:$.NB8.Ssl,label:"SSL","data-test-subj":"kafkaAuthenticationSSLRadioButton"}],pn=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,[i,o]=l().useState({kafkaAuthPassword:!1,kafkaSslKey:!1}),[r,u]=l().useState(!0);(0,s.useEffect)((()=>{r&&(u(!1),a&&(t.kafkaAuthPasswordInput.value&&!t.kafkaAuthPasswordSecretInput.value&&(t.kafkaAuthPasswordSecretInput.setValue(t.kafkaAuthPasswordInput.value),t.kafkaAuthPasswordInput.clear(),o({...i,kafkaAuthPassword:!0})),t.kafkaSslKeyInput.value&&!t.kafkaSslKeySecretInput.value&&(t.kafkaSslKeySecretInput.setValue(t.kafkaSslKeyInput.value),t.kafkaSslKeyInput.clear(),o({...i,kafkaSslKey:!0}))))}),[a,t.kafkaAuthPasswordInput,t.kafkaAuthPasswordSecretInput,t.kafkaSslKeyInput,t.kafkaSslKeySecretInput,r,u,i]);const g=e=>{e?(t.kafkaAuthPasswordInput.clear(),t.kafkaSslKeyInput.clear()):(t.kafkaAuthPasswordSecretInput.setValue(""),t.kafkaSslKeySecretInput.setValue("")),o({kafkaAuthPassword:!1,kafkaSslKey:!1}),n(e)},m=(0,s.useMemo)((()=>Object.keys($.i36).map((e=>({text:$.i36[e],label:e})))),[]),x=(0,s.useMemo)((()=>Object.keys($.zPI).map((e=>({id:$.zPI[e],label:e,"data-test-subj":`kafkaConnectionType${e}RadioButton`})))),[]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiPanel,{borderRadius:"m",hasShadow:!1,paddingSize:"m",color:"subdued","data-test-subj":"settingsOutputsFlyout.kafkaAuthenticationPanel"},(0,O.jsx)(c.EuiTitle,{size:"s"},(0,O.jsx)("h3",{id:"FleetEditOutputFlyoutKafkaAuthenticationTitle"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaAuthenticationTitle",defaultMessage:"Authentication"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0},(0,O.jsx)(c.EuiRadioGroup,(0,d.default)({style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaAuthenticationRadioInput",options:gn,compressed:!0},t.kafkaAuthMethodInput.props))),(()=>{switch(t.kafkaAuthMethodInput.value){case $.NB8.None:return(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaConnectionTypeLabel",defaultMessage:"Connection"})},(0,O.jsx)(c.EuiRadioGroup,(0,d.default)({style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaConnectionTypeRadioInput",options:x,compressed:!0},t.kafkaConnectionTypeInput.props)));case $.NB8.Ssl:return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",defaultMessage:"Client SSL certificate"})},t.kafkaSslCertificateInput.formRowProps),(0,O.jsx)(c.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.kafkaSslCertificateInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder",{defaultMessage:"Specify ssl certificate"})}))),a?(0,O.jsx)(dn,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaPasswordSecretInputTitle",{defaultMessage:"Client SSL certificate key"})},t.kafkaSslKeySecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:i.kafkaSslKey,onToggleSecretStorage:g,cancelEdit:t.kafkaSslKeySecretInput.cancelEdit}),(0,O.jsx)(c.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5,"data-test-subj":"kafkaSslKeySecretInput"},t.kafkaSslKeySecretInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))):(0,O.jsx)(dn,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",defaultMessage:"Client SSL certificate key"})},t.kafkaSslKeyInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:g}),(0,O.jsx)(c.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.kafkaSslKeyInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))));default:case $.NB8.Userpass:return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaUsernameInputLabel",defaultMessage:"Username"})},t.kafkaAuthUsernameInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaUsernameInput",fullWidth:!0},t.kafkaAuthUsernameInput.props))),a?(0,O.jsx)(dn,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputtitle",{defaultMessage:"Password"})},t.kafkaAuthPasswordSecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:i.kafkaAuthPassword,onToggleSecretStorage:g,cancelEdit:t.kafkaAuthPasswordSecretInput.cancelEdit}),(0,O.jsx)(c.EuiFieldPassword,(0,d.default)({type:"dual","data-test-subj":"settingsOutputsFlyout.kafkaPasswordSecretInput",fullWidth:!0},t.kafkaAuthPasswordSecretInput.props))):(0,O.jsx)(dn,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaPasswordInputLabel",defaultMessage:"Password"})},t.kafkaAuthPasswordInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:g}),(0,O.jsx)(c.EuiFieldPassword,(0,d.default)({type:"dual","data-test-subj":"settingsOutputsFlyout.kafkaPasswordInput",fullWidth:!0},t.kafkaAuthPasswordInput.props))),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaSaslInputLabel",defaultMessage:"SASL Mechanism"})},(0,O.jsx)(c.EuiRadioGroup,(0,d.default)({style:{display:"flex",gap:30},"data-test-subj":"settingsOutputsFlyout.kafkaSaslInput",options:cn,compressed:!0},t.kafkaSaslMechanismInput.props))))}})()),t.kafkaConnectionTypeInput.value!==$.zPI.Plaintext||t.kafkaAuthMethodInput.value!==$.NB8.None?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Cl.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder",{defaultMessage:"Specify certificate authority"}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel",{defaultMessage:"Server SSL certificate authorities (optional)"}),multiline:!0,sortable:!1},t.kafkaSslCertificateAuthoritiesInput.props)),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaVerificationModeInputLabel",defaultMessage:"Verification mode"})},(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaVerificationModeInput"},t.kafkaVerificationModeInput.props,{options:m})))):null)},fn=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,{docLinks:i}=(0,Je.WeA)(),o=(0,s.useMemo)((()=>$.y6d.map((e=>({text:e,label:e})))),[]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaVersionInputLabel",defaultMessage:"Kafka version"})},(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.kafkaVersionInput"},t.kafkaVersionInput.props,{options:o}))),(0,O.jsx)(Cl.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaHostsInputPlaceholder",{defaultMessage:"Specify host"}),sortable:!0,helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaHostsInputDescription",defaultMessage:"Specify the URLs that your agents will use to connect to Kafka. {guideLink}.",values:{guideLink:(0,O.jsx)(c.EuiLink,{href:i.links.fleet.kafkaSettings,target:"_blank",external:!0},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.kafkaUserGuideLink",defaultMessage:"Learn more"}))}}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.kafkaHostsInputLabel",{defaultMessage:"Hosts"})},t.kafkaHostsInput.props)),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(pn,{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(un,{inputs:t}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(sn,{inputs:t}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(ln,{inputs:t}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(on,{inputs:t}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(nn,{inputs:t}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaKeyInputLabel",defaultMessage:"Key (optional)"}),helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.kafkaKeyInputHelpText",defaultMessage:"If configured, the event key can be extracted from the event using a format string."})},(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.kafkaKeyInput",fullWidth:!0},t.kafkaKeyInput.props))))};var mn=a(9424);const xn=A().div.withConfig({displayName:"CodeEditorContainer",componentId:"sc-1u19e39-0"})(["min-height:0;position:relative;height:116px;"]),hn=A()(c.EuiTextColor).attrs((e=>({color:"subdued",size:"xs"}))).withConfig({displayName:"CodeEditorPlaceholder",componentId:"sc-1u19e39-1"})(["position:absolute;top:0;left:0;font-family:Menlo,Monaco,'Courier New',monospace;font-size:12px;line-height:21px;pointer-events:none;"]),En={minimap:{enabled:!1},ariaLabel:f.i18n.translate("xpack.fleet.settings.yamlCodeEditor",{defaultMessage:"YAML Code Editor"}),scrollBeyondLastLine:!1,wordWrap:"on",wrappingIndent:"indent",automaticLayout:!0,tabSize:2,lineNumbers:"off",lineNumbersMinChars:0,glyphMargin:!1,folding:!1,lineDecorationsWidth:0},yn=e=>{const{placeholder:t,disabled:a,...s}=e;return a?l().createElement(c.EuiCodeBlock,{style:{height:"116px"},language:"yaml",isCopyable:!1,paddingSize:"s"},l().createElement("pre",null,s.value)):l().createElement(xn,null,l().createElement(mn.CodeEditor,(0,d.default)({languageId:"yaml",width:"100%",height:"116px",options:En},s)),(!s.value||""===s.value)&&l().createElement(hn,null,t))},kn=e=>t=>{if("object"!=typeof t)return e(null!=t?t:"")};function vn(e){const t=[],a={};if(e.forEach(((e,s)=>{if(!e)return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostFieldRequiredError",{defaultMessage:"Host is required"})});const l=e.split(":");if(2!==l.length||!l[0]||!l[1])return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostPortError",{defaultMessage:'Invalid format. Expected "host:port" without protocol.'}),index:s});const n=parseInt(l[1],10);(isNaN(n)||n<1||n>65535)&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPortError",{defaultMessage:"Invalid port number. Expected a number between 1 and 65535"}),index:s});const i=a[e]||[];a[e]=[...i,s]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostDuplicateError",{defaultMessage:"Duplicate URL"}),index:e})))})),0===e.length&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHostRequiredError",{defaultMessage:"Host is required"})}),t.length)return t}function jn(e){const t=[],a={},s=f.i18n.translate("xpack.fleet.settings.outputForm.elasticUrlRequiredError",{defaultMessage:"URL is required"});if(e.forEach(((e,l)=>{try{if(e){const a=new URL(e);["http:","https:"].includes(a.protocol)||t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.invalidProtocolError",{defaultMessage:"Invalid protocol"}),index:l})}else t.push({message:s,index:l})}catch(e){t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.elasticHostError",{defaultMessage:"Invalid URL"}),index:l})}const n=a[e]||[];a[e]=[...n,l]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.elasticHostDuplicateError",{defaultMessage:"Duplicate URL"}),index:e})))})),0===e.length&&t.push({message:s}),t.length)return t}function bn(e){const t=[],a={};if(e.forEach(((e,s)=>{try{if(e.match(/^http([s]){0,1}:\/\//))return void t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostProtocolError",{defaultMessage:"Host address must begin with a domain name or IP address"}),index:s});if(new URL(`http://${e}`).host!==e.toLowerCase())throw new Error("Invalid host")}catch(a){0===e.length?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostRequiredError",{defaultMessage:"Host is required"}),index:s}):t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostError",{defaultMessage:"Invalid Host"}),index:s})}const l=a[e]||[];a[e]=[...l,s]})),Object.values(a).filter((({length:e})=>e>1)).forEach((e=>{e.forEach((e=>t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostDuplicateError",{defaultMessage:"Duplicate Host"}),index:e})))})),0===e.length&&t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.logstashHostRequiredError",{defaultMessage:"Host is required"})}),t.length)return t}function Mn(e){try{return void(0,ms.Hh)(e)}catch(e){return[f.i18n.translate("xpack.fleet.settings.outputForm.invalidYamlFormatErrorMessage",{defaultMessage:"Invalid YAML: {reason}",values:{reason:e.message}})]}}function Sn(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.nameIsRequiredErrorMessage",{defaultMessage:"Name is required"})]}function Fn(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaUsernameIsRequired",{defaultMessage:"Username is required"})]}function In(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPasswordIsRequired",{defaultMessage:"Password is required"})]}const Tn=kn(In);function wn(e){if(""!==e&&!e.match(/^[a-zA-Z0-9]+$/))return[f.i18n.translate("xpack.fleet.settings.outputForm.caTrusterdFingerprintInvalidErrorMessage",{defaultMessage:"CA trusted fingerprint should be valid HEX encoded SHA-256 of a CA certificate"})]}function Cn(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.serviceTokenRequiredErrorMessage",{defaultMessage:"Service token is required"})]}const An=kn(Cn);function Pn(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.sslCertificateRequiredErrorMessage",{defaultMessage:"SSL certificate is required"})]}function _n(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.sslKeyRequiredErrorMessage",{defaultMessage:"SSL key is required"})]}const Ln=kn(_n);function Dn(e){if(!e||""===e)return[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaDefaultTopicRequiredMessage",{defaultMessage:"Default topic is required"})]}function On(e){const t=[];if(e.forEach(((e,a)=>{e||t.push(f.i18n.translate("xpack.fleet.settings.outputForm.kafkaTopicFieldRequiredMessage",{defaultMessage:"Topic is required"}))})),0===e.length&&t.push(f.i18n.translate("xpack.fleet.settings.outputForm.kafkaTopicRequiredMessage",{defaultMessage:"Topic is required"})),t.length)return t}function Rn(e){return/^[A-Za-z0-9._-]+$/.test(e)?void 0:[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaClientIdFormattingMessage",{defaultMessage:"Client ID is invalid. Only letters, numbers, dots, underscores, and dashes are allowed."})]}function Bn(e){return/^[0-9]+$/.test(e)?void 0:[f.i18n.translate("xpack.fleet.settings.outputForm.kafkaPartitioningGroupEventsFormattingMessage",{defaultMessage:"Number of events must be a number"})]}function Nn(e){const t=[],a=new Set;if(e.forEach(((e,s)=>{const{key:l,value:n}=e,i=!!l,o=!!n;i&&!o?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersMissingKeyError",{defaultMessage:'Missing value for key "{key}"',values:{key:l}}),index:s,hasKeyError:!1,hasValueError:!0}):!i&&o?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersMissingValueError",{defaultMessage:'Missing key for value "{value}"',values:{value:n}}),index:s,hasKeyError:!0,hasValueError:!1}):i&&o&&(a.has(l)?t.push({message:f.i18n.translate("xpack.fleet.settings.outputForm.kafkaHeadersDuplicateKeyError",{defaultMessage:'Duplicate key "{key}"',values:{key:l}}),index:s,hasKeyError:!0,hasValueError:!1}):a.add(l))})),t.length)return t}const zn=()=>(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.confirmModalTitle",defaultMessage:"Save and deploy changes?"}),Un=({output:e,agentCount:t,agentPolicyCount:a})=>(0,O.jsx)(l().Fragment,null,void 0!==t&&void 0!==a?(0,O.jsx)(p.FormattedMessage,{"data-test-subj":"settings.outputModal",id:"xpack.fleet.settings.updateOutput.confirmModalText",defaultMessage:"This action will update {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,O.jsx)("strong",null,e.name),agents:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.agentsCount",defaultMessage:"{agentCount, plural, one {# agent} other {# agents}}",values:{agentCount:t}})),policies:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.agentPolicyCount",defaultMessage:"{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",values:{agentPolicyCount:a}}))}}):(0,O.jsx)(p.FormattedMessage,{"data-test-subj":"settings.outputModal",id:"xpack.fleet.settings.updateOutput.confirmModalTextWithoutCount",defaultMessage:"This action will update {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",values:{outputName:(0,O.jsx)("strong",null,e.name)}}),"logstash"===e.type?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiCallOut,{iconType:"warning",color:"warning",size:"m",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.warningTitle",defaultMessage:"Logstash output for agent integration is not supported for fleet server and synthetics."})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.updateOutput.warningMessage",defaultMessage:"Fleet server and synthetics policies will keep using the existing ES output."}))," "):null);const Hn=({enabled:e,inputs:t})=>{const{diskQueueEnabledInput:a,diskQueuePathInput:s,diskQueueMaxSizeInput:n,loadBalanceEnabledInput:i,diskQueueEncryptionEnabled:o,diskQueueCompressionEnabled:r,compressionLevelInput:u,memQueueEvents:g,queueFlushTimeout:m,maxBatchBytes:x}=t,{showExperimentalShipperOptions:h}=z.ZX.get();return e?(0,O.jsx)(c.EuiAccordion,{id:"advancedOutputOptions",arrowDisplay:"left",buttonContent:(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.advancedOptionsToggleLabel",defaultMessage:"Advanced options"})),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiBetaBadge,{label:"Experimental",color:"subdued"})))},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},x.formRowProps,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescriptionLabel",defaultMessage:"Maximum Batch Size"})}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFieldNumber,(0,d.default)({},x.props,{placeholder:"Batching Bytes",min:0}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.maxBatchSizeDescription",defaultMessage:"Data will be sent to the output when the agent has more events in the queue than this number."}))))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},m.formRowProps,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutLabel",defaultMessage:"Flush Timeout"})}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFieldNumber,(0,d.default)({},m.props,{placeholder:"Seconds",min:0}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.queueFlushTimeoutDescription",defaultMessage:"Upon expiry the output queue is flushed and data is written to the output."}))))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},g.formRowProps,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.memQueueEventsLabel",defaultMessage:"Memory Queue Size"})}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFieldNumber,(0,d.default)({},g.props,{placeholder:"Events",min:0}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.memQueueEventsSizeDescription",defaultMessage:"Maximum number of events that can be stored in the queue. Default is set to 4096. When this queue is full, new events are dropped."}))))),h&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiHorizontalRule,null),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},a.formRowProps),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.diskQueueSwitch"},a.props,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueSwitchLabel",defaultMessage:"Disk Queue"})}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueSwitchDescription",defaultMessage:"Once enabled, events will be queued on disk if, for some reason, agent is not able to send them."}))))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},o.formRowProps),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.diskQueueEncryption"},o.props,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionLabel",defaultMessage:"Disk Queue Encryption"})}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueEncryptionDescription",defaultMessage:"Enable encryption of data written to the disk queue."}))))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueuePathLabel",defaultMessage:"Disk Queue Path"})},s.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.diskQueuePath"},s.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.diskQueuePathPlaceholder",{defaultMessage:"path_data/diskqueue"})}))),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},n.formRowProps,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueMaxSize",defaultMessage:"Maximum Disk Queue Size"})}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFieldNumber,(0,d.default)({},n.props,{placeholder:"Bytes",min:0}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.diskQueueMaxSizeDescription",defaultMessage:"Limits the disk queue size for spooling of data. When data in the queue exceeds this limit, new events will be dropped."}))))),(0,O.jsx)(c.EuiHorizontalRule,null),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},i.formRowProps),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.loadBalancingSwitch"},i.props,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.loadBalancingSwitchLabel",defaultMessage:"Load Balancing"})}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.loadBalancingDescription",defaultMessage:"Once enabled, the agents will balance the load across all the hosts defined for this output. This will increase the number of connections opened by the agent."}))))),(0,O.jsx)(c.EuiHorizontalRule,null),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0},(0,O.jsx)(c.EuiFlexGroup,{alignItems:"flexStart"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiSwitch,(0,d.default)({"data-test-subj":"editOutputFlyout.compressionSwitch"},r.props,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.compressionSwitchLabel",defaultMessage:"Compression"})}))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiSelect,(0,d.default)({"data-test-subj":"editOutputFlyout.compressionLevelSelect",id:"selectCompressionLevel","aria-label":"Use aria labels when no actual label is in use"},u.props))),(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiText,{size:"s",color:"subdued"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.compressionSwitchDescription",defaultMessage:"Level 1 compression is the fastest, Level 9 however would provide the most compression."})))))))):null},Wn=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n}=e,[i,o]=l().useState({serviceToken:!1}),[r,u]=l().useState(!0);(0,s.useEffect)((()=>{r&&(u(!1),a&&t.serviceTokenInput.value&&!t.serviceTokenSecretInput.value&&(t.serviceTokenSecretInput.setValue(t.serviceTokenInput.value),t.serviceTokenInput.clear(),o({serviceToken:!0})))}),[a,t.serviceTokenInput,t.serviceTokenSecretInput,r,u,i]);const g=e=>{e?t.serviceTokenInput.clear():t.serviceTokenSecretInput.setValue(""),o({...i,serviceToken:!1}),n(e)};return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Cl.G,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.hostUrlInput",label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputLabel",{defaultMessage:"Hosts"}),placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteEsHostsInputPlaceholder",{defaultMessage:"Specify host URL"})},t.elasticsearchUrlInput.props,{isUrl:!0})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),a?(0,O.jsx)(dn,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",{defaultMessage:"Service token"})},t.serviceTokenSecretInput.formRowProps,{cancelEdit:t.serviceTokenSecretInput.cancelEdit,useSecretsStorage:a,isConvertedToSecret:i.serviceToken,onToggleSecretStorage:g}),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"serviceTokenSecretInput",fullWidth:!0},t.serviceTokenSecretInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder",{defaultMessage:"Specify service token"})}))):(0,O.jsx)(dn,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serviceTokenLabel",defaultMessage:"Service token"})},t.serviceTokenInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:g}),(0,O.jsx)(c.EuiFieldText,(0,d.default)({fullWidth:!0,"data-test-subj":"serviceTokenSecretInput"},t.serviceTokenInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.remoteESHostPlaceholder",{defaultMessage:"Specify service token"})}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiCallOut,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serviceTokenCalloutText",defaultMessage:"Generate a service token by running this API request in the Remote Kibana Console and copy the response value"}),"data-test-subj":"serviceTokenCallout"},(0,O.jsx)(c.EuiCodeBlock,{isCopyable:!0},'POST kbn:/api/fleet/service_tokens\n{\n  "remote": true\n}')),(0,O.jsx)(c.EuiSpacer,{size:"m"}))};var Gn=a(40622);const qn=()=>{const{docLinks:e}=(0,u.WeA)();return(0,O.jsx)(Kn,{iconType:"iInCircle",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.calloutTitle",defaultMessage:"Additional Logstash configuration required"})},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.description",defaultMessage:"Add an Elastic Agent pipeline configuration to Logstash to receive events from the Elastic Agent framework. {documentationLink}.",values:{documentationLink:(0,O.jsx)(c.EuiLink,{external:!0,href:e.links.logstash.inputElasticAgent},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.documentationLink",defaultMessage:"Learn more"}))}}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Vn,null)))},Kn=({children:e,...t})=>{const[a,n]=(0,s.useState)(!1),i=(0,u.iO7)().fleet.allSettings;return(0,O.jsx)(c.EuiCallOut,t,(0,O.jsx)(c.EuiSpacer,{size:"s"}),a?(0,O.jsx)(c.EuiButton,{onClick:()=>n(!1)},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.collapseInstructionsButtonLabel",defaultMessage:"Collapse steps"})):(0,O.jsx)(Gn.m,{missingPrivilege:i?void 0:"Settings All",position:"left"},(0,O.jsx)(c.EuiButton,{onClick:()=>n(!0),fill:!0,disabled:!i},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.viewInstructionButtonLabel",defaultMessage:"View steps"}))),a&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),e))},Vn=()=>{const{docLinks:e}=(0,u.WeA)(),t=function(){const[e,t]=(0,s.useState)(!1),[a,n]=(0,s.useState)(),i=(0,u.WeA)(),{notifications:o}=i,r=(0,s.useCallback)((async()=>{try{var e;t(!0);const a=await(0,u.waY)();if(a.error)throw a.error;n(null===(e=a.data)||void 0===e?void 0:e.api_key)}catch(e){403===e.statusCode?o.toasts.addDanger({title:f.i18n.translate("xpack.fleet.settings.logstashInstructions.generateApiKeyError",{defaultMessage:"Cannot generate an API key"}),text:(0,Qe.Pv)((0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.generateApiKeyPermissions",defaultMessage:"You need the cluster permissions: {clusterPermissions}{br} and the index permissions: {indexPermissions}{br}for indexes: {br}{indexes}",values:{clusterPermissions:(0,O.jsx)(c.EuiCode,null,$.pfJ.join(", ")),indexPermissions:(0,O.jsx)(c.EuiCode,null,$.MVu.join(", ")),indexes:$.xPW.map((e=>(0,O.jsx)(l().Fragment,{key:e},(0,O.jsx)(c.EuiCode,null,e),(0,O.jsx)("br",null)))),br:(0,O.jsx)("br",null)}}),i)},{}):o.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.logstashInstructions.generateApiKeyError",{defaultMessage:"Cannot generate an API key"})})}finally{t(!1)}}),[o.toasts,i]);return(0,s.useMemo)((()=>({isLoading:e,generateApiKey:r,apiKey:a})),[e,r,a])}(),a=(0,u.iO7)().fleet.allSettings,n=(0,s.useMemo)((()=>{return[{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.apiKeyStepDescription",defaultMessage:"We recommend authorizing Logstash to output to Elasticsearch with minimal privileges for Elastic Agent."}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),t.apiKey?(0,O.jsx)(c.EuiCodeBlock,{paddingSize:"m"},(0,O.jsx)("h5",null,"API Key"),t.apiKey,(0,O.jsx)("div",{className:"euiCodeBlock__controls"},(0,O.jsx)("div",{className:"euiCodeBlock__copyButton"},(0,O.jsx)(c.EuiCopy,{textToCopy:t.apiKey},(e=>(0,O.jsx)(c.EuiButtonIcon,{onClick:e,iconType:"copyClipboard",color:"text",disabled:!a,"aria-label":f.i18n.translate("xpack.fleet.settings.logstashInstructions.copyApiKeyButtonLabel",{defaultMessage:"Copy message"})})))))):(0,O.jsx)(c.EuiButton,{isLoading:t.isLoading,onClick:t.generateApiKey,disabled:!a},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.generateApiKeyButtonLabel",defaultMessage:"Generate API key"})),(0,O.jsx)(c.EuiSpacer,{size:"m"}))},{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.editPipelineStepDescription",defaultMessage:"Next, open the {pipelineConfFile} file and insert the following content:",values:{pipelineConfFile:(0,O.jsx)(c.EuiCode,null,"elastic-agent-pipeline.conf")}}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiCodeBlock,{paddingSize:"m",language:"yaml",isCopyable:!0},(s=t.apiKey,'input {\n  elastic_agent {\n    port => 5044\n    ssl_enabled => true\n    ssl_certificate_authorities => ["<ca_path>"]\n    ssl_certificate => "<server_cert_path>"\n    ssl_key => "<server_cert_key_in_pkcs8>"\n    ssl_client_authentication => "required"\n  }\n}\n\noutput {\n  elasticsearch {\n    hosts => "<es_host>"\n    api_key => "<api_key>"\n    data_stream => true\n    ssl_enabled => true\n    # ssl_certificate_authorities => "<elasticsearch_ca_path>"\n  }\n}'.replace("<api_key>",s||"<api_key>"))))},{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.addPipelineStepDescription",defaultMessage:"In your Logstash configuration directory, open the {pipelineFile} file and add the following configuration. Replace the path to your file.",values:{pipelineFile:(0,O.jsx)(c.EuiCode,null,"pipelines.yml")}}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiCodeBlock,{paddingSize:"m",language:"yaml",isCopyable:!0},'- pipeline.id: elastic-agent-pipeline\n  path.config: "/etc/path/to/elastic-agent-pipeline.conf"\n'))},{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.replaceStepDescription",defaultMessage:"Replace the parts between the brackets with your generated SSL certificate file paths. View {documentationLink} to generate the certificates.",values:{documentationLink:(0,O.jsx)(c.EuiLink,{external:!0,href:e.links.fleet.secureLogstash},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.ourDocumentationLink",defaultMessage:"our documentation"}))}}),(0,O.jsx)(c.EuiSpacer,{size:"m"}))},{children:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.logstashInstructions.saveAndRestartStepDescription",defaultMessage:"Save the pipeline and restart Logstash so the changes take effect."}),(0,O.jsx)(c.EuiSpacer,{size:"m"}))}];var s}),[t,e,a]);return(0,O.jsx)("ol",null,n.map(((e,t)=>(0,O.jsx)("li",{key:t},e.children))))},$n=()=>{const{docLinks:e}=(0,u.WeA)();return(0,O.jsx)(c.EuiCallOut,{iconType:"warning",color:"warning",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.calloutTitle",defaultMessage:"Additional setup required"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.calloutDescription",defaultMessage:"You must configure an encryption key before configuring this output. {link}",values:{link:(0,O.jsx)(c.EuiLink,{href:e.links.kibana.secureSavedObject,target:"_blank",external:!0},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.encryptionKeyRequired.link",defaultMessage:"Learn more"}))}}))},Yn=e=>{const{inputs:t,useSecretsStorage:a,onToggleSecretStorage:n,hasEncryptedSavedObjectConfigured:i}=e,{docLinks:o}=(0,u.WeA)(),[r,g]=l().useState(!0),[m,x]=l().useState({sslKey:!1});(0,s.useEffect)((()=>{r&&(g(!1),a&&t.sslKeyInput.value&&!t.sslKeySecretInput.value&&(t.sslKeySecretInput.setValue(t.sslKeyInput.value),t.sslKeyInput.clear(),x({...m,sslKey:!0})))}),[a,t.sslKeyInput,t.sslKeySecretInput,r,g,m]);const h=e=>{e?t.sslKeyInput.clear():t.sslKeySecretInput.setValue(""),x({sslKey:!1}),n(e)};return(0,O.jsx)(l().Fragment,null,!i&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)($n,null)),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(qn,null),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Cl.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashHostsInputPlaceholder",{defaultMessage:"Specify host"}),sortable:!1,helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.logstashHostsInputDescription",defaultMessage:"Specify the addresses that your agents will use to connect to Logstash. {guideLink}.",values:{guideLink:(0,O.jsx)(c.EuiLink,{href:o.links.fleet.logstashSettings,target:"_blank",external:!0},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetSettingsLink",defaultMessage:"Learn more"}))}}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.logstashHostsInputLabel",{defaultMessage:"Logstash hosts"})},t.logstashHostsInput.props)),(0,O.jsx)(Cl.G,(0,d.default)({placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputPlaceholder",{defaultMessage:"Specify certificate authority"}),label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateAuthoritiesInputLabel",{defaultMessage:"Server SSL certificate authorities (optional)"}),multiline:!0,sortable:!1},t.sslCertificateAuthoritiesInput.props)),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslCertificateInputLabel",defaultMessage:"Client SSL certificate"})},t.sslCertificateInput.formRowProps),(0,O.jsx)(c.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.sslCertificateInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslCertificateInputPlaceholder",{defaultMessage:"Specify ssl certificate"})}))),a?(0,O.jsx)(dn,(0,d.default)({fullWidth:!0,title:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputTitle",{defaultMessage:"Client SSL certificate key"})},t.sslKeySecretInput.formRowProps,{useSecretsStorage:a,isConvertedToSecret:m.sslKey,onToggleSecretStorage:h,cancelEdit:t.sslKeySecretInput.cancelEdit}),(0,O.jsx)(c.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.sslKeySecretInput.props,{"data-test-subj":"sslKeySecretInput",placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeySecretInputPlaceholder",{defaultMessage:"Specify certificate key"})}))):(0,O.jsx)(dn,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.sslKeyInputLabel",defaultMessage:"Client SSL certificate key"})},t.sslKeyInput.formRowProps,{useSecretsStorage:a,onToggleSecretStorage:h}),(0,O.jsx)(c.EuiTextArea,(0,d.default)({fullWidth:!0,rows:5},t.sslKeyInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.sslKeyInputPlaceholder",{defaultMessage:"Specify certificate key"})}))))},Qn=e=>{const{inputs:t}=e,{cloud:a}=(0,u.WeA)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(Cl.G,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.hostUrlInput",label:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esHostsInputLabel",{defaultMessage:"Hosts"}),placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esHostsInputPlaceholder",{defaultMessage:"Specify host URL"})},t.elasticsearchUrlInput.props,{isUrl:!0,helpText:(null==a?void 0:a.isServerlessEnabled)&&(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.serverlessHostUrlsHelpText",defaultMessage:"Custom host URLs are not allowed in serverless."})})),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputLabel",defaultMessage:"Elasticsearch CA trusted fingerprint (optional)"})},t.caTrustedFingerprintInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({fullWidth:!0},t.caTrustedFingerprintInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.caTrustedFingerprintInputPlaceholder",{defaultMessage:"Specify Elasticsearch CA trusted fingerprint"})}))))},Jn=({defaultOuput:e,onClose:t,output:a,proxies:n})=>{(0,u.ifo)("settings");const i=function(e,t,a){var l,n,i,o,r,d,c,g,p,m,x,h,E,y,k,v,j,b,M,S,F,I,T,w,C,A,P,_,L,D,R,B,N,U,H,W,G,q,K,V,Y,Q,J,X,Z,ee,te,ae,se,le,ne,ie,oe,re,ue,de,ce,ge,pe,fe,me,xe,he,Ee,ye,ke,ve,je,be,Me,Se,Fe,Ie,Te;const we=(0,u.YI3)(),Ce=(0,u.iO7)(),{showExperimentalShipperOptions:Ae}=z.ZX.get(),Pe=!(null!==(l=we.missingOptionalFeatures)&&void 0!==l&&l.includes("encrypted_saved_object_encryption_key_required")),[_e,Le]=(0,s.useState)(!1),{notifications:De,cloud:Oe}=(0,u.WeA)(),{confirm:Re}=(0,wl.fl)(),Be=null!==(n=null==t?void 0:t.is_preconfigured)&&void 0!==n&&n,Ne=null!==(i=null==t?void 0:t.allow_edit)&&void 0!==i?i:[];function ze(e){return!Ce.fleet.allSettings||!!Be&&!Ne.includes(e)}const Ue=(0,u.Gez)(null!==(o=null==t?void 0:t.name)&&void 0!==o?o:"",Sn,ze("name")),He=(0,u.Gez)(null!==(r=null==t?void 0:t.type)&&void 0!==r?r:"elasticsearch",void 0,ze("type")),We=(0,u.Gez)(null!==(d=null==t?void 0:t.config_yaml)&&void 0!==d?d:"",Mn,ze("config_yaml")),Ge=(0,u.MbH)(null!==(c=null==t?void 0:t.is_default)&&void 0!==c&&c,ze("is_default")||(null==t?void 0:t.is_default)),qe=(0,u.MbH)(null!==(g=null==t?void 0:t.is_default_monitoring)&&void 0!==g&&g,ze("is_default_monitoring")||(null==t?void 0:t.is_default_monitoring)),Ke=(0,u.Gez)(null!==(p=null==t?void 0:t.ca_trusted_fingerprint)&&void 0!==p?p:"",wn,ze("ca_trusted_fingerprint")),Ve=null==Oe?void 0:Oe.isServerlessEnabled,$e=!Ve||null!=t&&t.hosts?(null==t?void 0:t.hosts)||[]:(null==a?void 0:a.hosts)||[],Ye=Ve||ze("hosts"),Qe=(0,u.U6y)("esHostsComboxBox",$e,jn,Ye),Je=(0,u.Gez)(null!==(m=null==t?void 0:t.preset)&&void 0!==m?m:(0,an.lX)(null!==(x=null==t?void 0:t.config_yaml)&&void 0!==x?x:"",ms.Hh),(()=>{}),ze("preset")),Xe=(0,u.Gez)(null!==(h=null==t?void 0:t.service_token)&&void 0!==h?h:"",Cn,ze("service_token")),Ze=(0,u.YZM)(null!==(E=null==t||null===(y=t.secrets)||void 0===y?void 0:y.service_token)&&void 0!==E?E:"",An,ze("service_token")),et=null!=t&&t.config_yaml?(0,ms.Hh)(null==t?void 0:t.config_yaml):{},tt=!(null!=et&&et.shipper)||!1===(null==et||null===(k=et.shipper)||void 0===k?void 0:k.enabled),at=(0,u.MbH)(null!==(v=null==t||null===(j=t.shipper)||void 0===j?void 0:j.disk_queue_enabled)&&void 0!==v&&v),st=(0,u.Gez)(null!==(b=null==t||null===(M=t.shipper)||void 0===M?void 0:M.disk_queue_path)&&void 0!==b?b:"",void 0,null!==(S=!at.value)&&void 0!==S&&S),lt=(0,u.hp)(null!==(F=null==t||null===(I=t.shipper)||void 0===I?void 0:I.disk_queue_max_size)&&void 0!==F?F:4096,void 0,null!==(T=!at.value)&&void 0!==T&&T),nt=(0,u.MbH)(null!==(w=null==t||null===(C=t.shipper)||void 0===C?void 0:C.disk_queue_encryption_enabled)&&void 0!==w&&w,null!==(A=!at.value)&&void 0!==A&&A),it=(0,u.MbH)(null!==(P=null==t||null===(_=t.shipper)||void 0===_?void 0:_.disk_queue_enabled)&&void 0!==P&&P),ot=(0,u.MbH)(null!==(L=null==t||null===(D=t.shipper)||void 0===D?void 0:D.disk_queue_compression_enabled)&&void 0!==L&&L),rt=Array.from(Array(10).keys()).slice(1).map((e=>({value:`${e}`,text:`Level ${e}`}))),ut=(0,u.aOf)(rt,null!==(R=`${null==t||null===(B=t.shipper)||void 0===B?void 0:B.compression_level}`)&&void 0!==R?R:rt[0].value,null!==(N=!ot.value)&&void 0!==N&&N),dt=(0,u.hp)((null==t||null===(U=t.shipper)||void 0===U?void 0:U.mem_queue_events)||void 0),ct=(0,u.hp)((null==t||null===(H=t.shipper)||void 0===H?void 0:H.queue_flush_timeout)||void 0),gt=(0,u.hp)((null==t||null===(W=t.shipper)||void 0===W?void 0:W.max_batch_bytes)||void 0),pt=ze("ssl"),ft=(0,u.U6y)("logstashHostsComboxBox",null!==(G=null==t?void 0:t.hosts)&&void 0!==G?G:[],bn,ze("hosts")),mt=(0,u.U6y)("sslCertificateAuthoritiesComboxBox",null!==(q=null==t||null===(K=t.ssl)||void 0===K?void 0:K.certificate_authorities)&&void 0!==q?q:[],void 0,pt),xt=(0,u.Gez)(null!==(V=null==t||null===(Y=t.ssl)||void 0===Y?void 0:Y.certificate)&&void 0!==V?V:"",Pn,pt),ht=(0,u.Gez)(null!==(Q=null==t||null===(J=t.ssl)||void 0===J?void 0:J.key)&&void 0!==Q?Q:"",_n,pt),Et=(0,u.YZM)(null==t||null===(X=t.secrets)||void 0===X||null===(Z=X.ssl)||void 0===Z?void 0:Z.key,Ln,pt),yt=(0,u.Gez)(null!==(ee=null==t?void 0:t.proxy_id)&&void 0!==ee?ee:"",(()=>{}),ze("proxy_id")),kt=t,vt=(0,u.Gez)(null!==(te=null==kt?void 0:kt.version)&&void 0!==te?te:"1.0.0",void 0,ze("version")),jt=(0,u.U6y)("kafkaHostsComboBox",null!==(ae=null==t?void 0:t.hosts)&&void 0!==ae?ae:[],vn,ze("hosts")),bt=(0,u.RIP)(null!==(se=null==kt?void 0:kt.auth_type)&&void 0!==se?se:$.NB8.None,ze("auth_type")),Mt=(0,u.RIP)(null!==(le=null==kt?void 0:kt.connection_type)&&void 0!==le?le:$.zPI.Plaintext,ze("connection_type")),St=(0,u.Gez)(null!==(ne=null==kt?void 0:kt.username)&&void 0!==ne?ne:void 0,bt.value===$.NB8.Userpass?Fn:void 0,ze("username")),Ft=(0,u.Gez)(null!==(ie=null==kt?void 0:kt.password)&&void 0!==ie?ie:void 0,bt.value===$.NB8.Userpass?In:void 0,ze("password")),It=(0,u.YZM)(null==kt||null===(oe=kt.secrets)||void 0===oe?void 0:oe.password,bt.value===$.NB8.Userpass?Tn:void 0,ze("password")),Tt=(0,u.U6y)("kafkaSslCertificateAuthoritiesComboBox",null!==(re=null==kt||null===(ue=kt.ssl)||void 0===ue?void 0:ue.certificate_authorities)&&void 0!==re?re:[],void 0,pt),wt=(0,u.Gez)(null==kt||null===(de=kt.ssl)||void 0===de?void 0:de.certificate,bt.value===$.NB8.Ssl?Pn:void 0,pt),Ct=(0,u.Gez)(null==kt||null===(ce=kt.ssl)||void 0===ce?void 0:ce.key,bt.value===$.NB8.Ssl?_n:void 0,pt),At=(0,u.YZM)(null==kt||null===(ge=kt.secrets)||void 0===ge||null===(pe=ge.ssl)||void 0===pe?void 0:pe.key,bt.value===$.NB8.Ssl?Ln:void 0,pt),Pt=(0,u.Gez)(null!==(fe=null==kt||null===(me=kt.ssl)||void 0===me?void 0:me.verification_mode)&&void 0!==fe?fe:$.i36.Full,void 0,pt),_t=(0,u.RIP)(null!==(xe=null==kt||null===(he=kt.sasl)||void 0===he?void 0:he.mechanism)&&void 0!==xe?xe:$.N9h.Plain,ze("sasl")),Lt=(0,u.RIP)(null!==(Ee=null==kt?void 0:kt.partition)&&void 0!==Ee?Ee:$.BwZ.Random,ze("partition")),Dt=(0,u.Gez)(null!=kt&&null!==(ye=kt.random)&&void 0!==ye&&ye.group_events?`${kt.random.group_events}`:"1",Lt.value===$.BwZ.Random?Bn:void 0,ze("partition")),Ot=(0,u.Gez)(null==kt||null===(ke=kt.hash)||void 0===ke?void 0:ke.hash,void 0,ze("partition")),Rt=(0,u.Gez)(null!=kt&&null!==(ve=kt.round_robin)&&void 0!==ve&&ve.group_events?`${kt.round_robin.group_events}`:"1",Lt.value===$.BwZ.RoundRobin?Bn:void 0,ze("partition")),Bt=(0,u.RIP)(null!=kt&&kt.topic&&null!=kt&&null!==(je=kt.topic)&&void 0!==je&&je.includes("%{[")?$.LXo.Dynamic:$.LXo.Static,ze("topic")),Nt=(0,u.Gez)(null!=(zt=kt)&&null!==(Ut=zt.topic)&&void 0!==Ut&&Ut.includes("%{[")?"":(null==zt?void 0:zt.topic)||"",Bt.value===$.LXo.Static?Dn:void 0,ze("topic"));var zt,Ut;const Ht=(0,u.whI)("kafkaDynamicTopicComboBox",function(e){var t;if(null==e||!e.topic||null!=e&&e.topic&&(null===(t=e.topic)||void 0===t||!t.includes("%{[")))return[];const a=e.topic.match(/(%\{\[)(\S*)(\]\})/),s=null!=a&&a.length?a[2]:"";return[{label:s,value:s}]}(kt),Bt.value===$.LXo.Dynamic?On:void 0,ze("topic")),Wt=(0,u.kt3)("kafkaHeadersComboBox",null!==(be=null==kt?void 0:kt.headers)&&void 0!==be?be:[{key:"",value:""}],Nn,ze("headers")),Gt=(0,u.Gez)(null!==(Me=null==kt?void 0:kt.client_id)&&void 0!==Me?Me:"Elastic",Rn,ze("client_id")),qt=(0,u.MbH)(!(null==kt||!kt.compression||kt.compression===$.jZS.None),ze("compression")),Kt=(0,u.Gez)(`${null!==(Se=null==kt?void 0:kt.compression_level)&&void 0!==Se?Se:4}`,void 0,ze("compression_level")),Vt=(0,u.Gez)(null!=kt&&kt.compression&&kt.compression!==$.jZS.None?kt.compression:$.jZS.Gzip,void 0,ze("compression")),$t=(0,u.Gez)(`${null!==(Fe=null==kt?void 0:kt.timeout)&&void 0!==Fe?Fe:30}`,void 0,ze("broker_timeout")),Yt=(0,u.Gez)(`${null!==(Ie=null==kt?void 0:kt.broker_timeout)&&void 0!==Ie?Ie:30}`,void 0,ze("timeout")),Qt=(0,u.Gez)(`${null!==(Te=null==kt?void 0:kt.required_acks)&&void 0!==Te?Te:$.NAW.Commit}`,void 0,ze("required_acks")),Jt=(0,u.Gez)(null==kt?void 0:kt.key,void 0,ze("key")),Xt=He.value===$.gf.Logstash,Zt=He.value===$.gf.Kafka,ea=He.value===$.gf.RemoteElasticsearch,ta={nameInput:Ue,typeInput:He,elasticsearchUrlInput:Qe,diskQueueEnabledInput:at,diskQueuePathInput:st,diskQueueEncryptionEnabled:nt,diskQueueMaxSizeInput:lt,diskQueueCompressionEnabled:ot,compressionLevelInput:ut,logstashHostsInput:ft,presetInput:Je,additionalYamlConfigInput:We,defaultOutputInput:Ge,defaultMonitoringOutputInput:qe,caTrustedFingerprintInput:Ke,serviceTokenInput:Xe,serviceTokenSecretInput:Ze,sslCertificateInput:xt,sslKeyInput:ht,sslKeySecretInput:Et,sslCertificateAuthoritiesInput:mt,proxyIdInput:yt,loadBalanceEnabledInput:it,memQueueEvents:dt,queueFlushTimeout:ct,maxBatchBytes:gt,kafkaVersionInput:vt,kafkaHostsInput:jt,kafkaVerificationModeInput:Pt,kafkaAuthMethodInput:bt,kafkaConnectionTypeInput:Mt,kafkaAuthUsernameInput:St,kafkaAuthPasswordInput:Ft,kafkaAuthPasswordSecretInput:It,kafkaSaslMechanismInput:_t,kafkaPartitionTypeInput:Lt,kafkaPartitionTypeRandomInput:Dt,kafkaPartitionTypeHashInput:Ot,kafkaPartitionTypeRoundRobinInput:Rt,kafkaHeadersInput:Wt,kafkaClientIdInput:Gt,kafkaCompressionInput:qt,kafkaCompressionLevelInput:Kt,kafkaCompressionCodecInput:Vt,kafkaBrokerTimeoutInput:$t,kafkaBrokerReachabilityTimeoutInput:Yt,kafkaBrokerAckReliabilityInput:Qt,kafkaKeyInput:Jt,kafkaSslCertificateAuthoritiesInput:Tt,kafkaSslCertificateInput:wt,kafkaSslKeyInput:Ct,kafkaSslKeySecretInput:At,kafkaTopicsInput:Bt,kafkaStaticTopicInput:Nt,kafkaDynamicTopicInput:Ht},aa=Object.values(ta).some((e=>e.hasChanged)),sa=(0,s.useCallback)((()=>{const e=Ue.validate(),t=Qe.validate(),a=jt.validate(),s=St.validate(),l=Ft.validate(),n=It.validate(),i=Gt.validate(),o=wt.validate(),r=Ct.validate(),u=At.validate(),d=Wt.validate(),c=ft.validate(),g=We.validate(),p=Ke.validate(),f=Xe.validate(),m=Ze.validate(),x=xt.validate(),h=ht.validate(),E=Et.validate(),y=st.validate(),k=Dt.validate(),v=Rt.validate(),j=Nt.validate(),b=Ht.validate(),M=Ct.value?r:u,S=Ft.value?l:n;return Xt?c&&g&&e&&x&&(ht.value&&h||Et.value&&E):Zt?e&&a&&o&&M&&s&&S&&d&&g&&i&&k&&v&&j&&b:ea?t&&g&&e&&(Xe.value&&f||Ze.value&&m):t&&g&&e&&p&&y}),[Ue,Qe,jt,St,Ft,It,Gt,wt,Ct,At,Wt,ft,We,Ke,Xe,Ze,xt,ht,Et,st,Dt,Rt,Nt,Ht,Xt,Zt,ea]),la=(0,s.useCallback)((async()=>{try{if(!sa())return;Le(!0);let a={};tt||(a={shipper:{mem_queue_events:dt.value?Number(dt.value):null,queue_flush_timeout:ct.value?Number(ct.value):null,max_batch_bytes:gt.value?Number(gt.value):null}}),!tt&&Ae&&(a={...a,shipper:{disk_queue_enabled:at.value,disk_queue_path:at.value&&st.value?st.value:"",disk_queue_max_size:at.value&&lt.value?lt.value:null,disk_queue_encryption_enabled:at.value&&nt.value,disk_queue_compression_enabled:ot.value,compression_level:ot.value?Number(ut.value):null,loadbalance:it.value}});const s=""!==yt.value?yt.value:null,l=(()=>{const e=e=>{if(void 0!==e){const t=parseInt(e,10);if(!isNaN(t))return t}};switch(He.value){case $.gf.Kafka:const t=Tt.value.filter((e=>""!==e)).length,l=function(e){const t={};return!e.kafkaSslKeyInput.value&&e.kafkaSslKeySecretInput.value&&(t.ssl={key:e.kafkaSslKeySecretInput.value}),!e.kafkaAuthPasswordInput.value&&e.kafkaAuthPasswordSecretInput.value&&(t.password=e.kafkaAuthPasswordSecretInput.value),Object.keys(t).length?t:null}({kafkaSslKeyInput:Ct,kafkaSslKeySecretInput:At,kafkaAuthPasswordInput:Ft,kafkaAuthPasswordSecretInput:It});return{name:Ue.value,type:$.gf.Kafka,hosts:jt.value,is_default:Ge.value,is_default_monitoring:qe.value,config_yaml:We.value,...Mt.value!==$.zPI.Plaintext||bt.value!==$.NB8.None?{ssl:{...t?{certificate_authorities:Tt.value.filter((e=>""!==e))}:{},...bt.value===$.NB8.Ssl?{certificate:wt.value,key:Ct.value}:{},verification_mode:Pt.value}}:{},proxy_id:s,client_id:Gt.value||void 0,version:vt.value,...Jt.value?{key:Jt.value}:{},compression:qt.value?Vt.value:$.jZS.None,...qt.value&&Vt.value===$.jZS.Gzip?{compression_level:e(Kt.value)}:{},auth_type:bt.value,...bt.value===$.NB8.None?{connection_type:Mt.value}:{},...bt.value===$.NB8.Userpass&&St.value?{username:St.value}:{},...bt.value===$.NB8.Userpass&&Ft.value?{password:Ft.value}:{},...bt.value===$.NB8.Userpass&&_t.value?{sasl:{mechanism:_t.value}}:{},partition:Lt.value,...Lt.value===$.BwZ.Random&&Dt.value?{random:{group_events:e(Dt.value)}}:{},...Lt.value===$.BwZ.RoundRobin&&Rt.value?{round_robin:{group_events:e(Rt.value)}}:{},...Lt.value===$.BwZ.Hash&&Ot.value?{hash:{hash:Ot.value}}:{},...Bt.value===$.LXo.Static&&Nt.value?{topic:Nt.value}:Bt.value===$.LXo.Dynamic&&Ht.value?{topic:`%{[${Ht.value}]}`}:{},headers:Wt.value,timeout:e($t.value),broker_timeout:e(Yt.value),required_acks:e(Qt.value),...a,...l?{secrets:l}:{}};case $.gf.Logstash:return{name:Ue.value,type:$.gf.Logstash,hosts:ft.value,is_default:Ge.value,is_default_monitoring:qe.value,config_yaml:We.value,ssl:{certificate:xt.value,key:ht.value||void 0,certificate_authorities:mt.value.filter((e=>""!==e))},...!ht.value&&Et.value&&{secrets:{ssl:{key:Et.value}}},proxy_id:s,...a};case $.gf.RemoteElasticsearch:return{name:Ue.value,type:$.gf.RemoteElasticsearch,hosts:Qe.value,is_default:Ge.value,is_default_monitoring:qe.value,preset:Je.value,config_yaml:We.value,service_token:Xe.value||void 0,...!Xe.value&&Ze.value&&{secrets:{service_token:Ze.value}},proxy_id:s,...a};case $.gf.Elasticsearch:default:return{name:Ue.value,type:$.gf.Elasticsearch,hosts:Qe.value,is_default:Ge.value,is_default_monitoring:qe.value,preset:Je.value,config_yaml:We.value,ca_trusted_fingerprint:Ke.value,proxy_id:s,...a}}})();if(t){if(!await async function(e,t){const{agentCount:a,agentPolicyCount:s}=await Bl(e).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));return t((0,O.jsx)(zn,null),(0,O.jsx)(Un,{agentCount:a,agentPolicyCount:s,output:e}))}(t,Re))return void Le(!1);const e=await(0,u.xEL)(t.id,l);if(e.error)throw e.error}else{const e=await(0,u.S6i)(l);if(e.error)throw e.error}e(),Le(!1)}catch(e){Le(!1),De.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.outputForm.errorToastTitle",{defaultMessage:"Error while saving output"})})}}),[sa,tt,Ae,yt.value,t,e,dt.value,ct.value,gt.value,at.value,st.value,lt.value,nt.value,ot.value,ut.value,it.value,He.value,Tt.value,Ct,At,Ft,It,Ue.value,jt.value,Ge.value,qe.value,We.value,Mt.value,bt.value,wt.value,Pt.value,Gt.value,vt.value,Jt.value,qt.value,Vt.value,Kt.value,St.value,_t.value,Lt.value,Dt.value,Rt.value,Ot.value,Bt.value,Nt.value,Ht.value,Wt.value,$t.value,Yt.value,Qt.value,ft.value,xt.value,ht.value,mt.value,Et.value,Qe.value,Je.value,Xe.value,Ze.value,Ke.value,Re,De.toasts]);return{inputs:ta,submit:la,isLoading:_e,hasEncryptedSavedObjectConfigured:Pe,isShipperEnabled:!tt,isDisabled:_e||t&&!aa||Xt&&!Pe}}(t,a,e),o=i.inputs,{docLinks:r,cloud:g}=(0,u.WeA)(),m=(0,u.YI3)(),[x,h]=(0,s.useState)("disabled");void 0!==m.isSecretsStorageEnabled&&"disabled"===x&&h(m.isSecretsStorageEnabled);const E=e=>{"disabled"!==x&&h(e)},y=!0===x,k=(0,s.useMemo)((()=>n.map((e=>({value:e.id,label:e.name})))),[n]),v=o.typeInput.value===$.gf.RemoteElasticsearch,j=o.typeInput.value===$.gf.Elasticsearch,b=!!o.typeInput.value&&(0,an.$N)(o.typeInput.value),M=!(null!=g&&g.isServerlessEnabled),F=[{value:$.gf.Elasticsearch,text:"Elasticsearch"},...M?[{value:$.gf.RemoteElasticsearch,text:"Remote Elasticsearch"}]:[],{value:$.gf.Logstash,text:"Logstash"},{value:$.gf.Kafka,text:"Kafka"}];return(0,O.jsx)(c.EuiFlyout,{onClose:t,maxWidth:S.MW},(0,O.jsx)(c.EuiFlyoutHeader,{hasBorder:!0},(0,O.jsx)(c.EuiTitle,{size:"m"},(0,O.jsx)("h2",{id:"FleetEditOutputFlyoutTitle"},a?(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.editTitle",defaultMessage:"Edit output"}):(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.createTitle",defaultMessage:"Add new output"})))),(0,O.jsx)(c.EuiFlyoutBody,null,(null==a?void 0:a.is_preconfigured)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiCallOut,{iconType:"lock",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutTitle",defaultMessage:"This output is managed outside of Fleet"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.preconfiguredOutputCalloutDescription",defaultMessage:"Most actions related to this output are unavailable. Refer to your kibana config for more detail."})),(0,O.jsx)(c.EuiSpacer,{size:"m"})),(0,O.jsx)(c.EuiForm,null,(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.nameInputLabel",defaultMessage:"Name"})},o.nameInput.formRowProps),(0,O.jsx)(c.EuiFieldText,(0,d.default)({"data-test-subj":"settingsOutputsFlyout.nameInput",fullWidth:!0},o.nameInput.props,{placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.nameInputPlaceholder",{defaultMessage:"Specify name"})}))),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(l().Fragment,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.typeInputLabel",defaultMessage:"Type"}))},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.typeInput"},o.typeInput.props,{options:F})),j||v?v?(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiText,{size:"s"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.remoteESTypeText",defaultMessage:"Enter your output hosts, service token for your remote cluster, and any advanced YAML configuration. Learn more about how to use these parameters in {doc}.",values:{doc:(0,O.jsx)(c.EuiLink,{href:r.links.fleet.remoteESOoutput,target:"_blank"},f.i18n.translate("xpack.fleet.settings.editOutputFlyout.docLabel",{defaultMessage:"our documentation"}))}}))):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"xs"}),(0,O.jsx)(c.EuiCallOut,{"data-test-subj":`settingsOutputsFlyout.${o.typeInput.value}OutputTypeCallout`,title:(o.typeInput.value,$.gf.Elasticsearch,f.i18n.translate("xpack.fleet.settings.editOutputFlyout.esOutputTypeCallout",{defaultMessage:"This output type does not support connectivity to a remote Elasticsearch cluster, please use the Remote Elasticsearch type for that."})),iconType:"alert",color:"warning",size:"s",heading:"p"})):null)),(e=>{switch(e){case $.gf.Logstash:return(0,O.jsx)(Yn,{inputs:o,useSecretsStorage:y,onToggleSecretStorage:E,hasEncryptedSavedObjectConfigured:i.hasEncryptedSavedObjectConfigured});case $.gf.Kafka:return(0,O.jsx)(fn,{inputs:o,useSecretsStorage:y,onToggleSecretStorage:E});case $.gf.RemoteElasticsearch:return(0,O.jsx)(Wn,{inputs:o,useSecretsStorage:y,onToggleSecretStorage:E});case $.gf.Elasticsearch:default:return(0,O.jsx)(Qn,{inputs:o})}})(o.typeInput.value),v?null:(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.proxyIdLabel",defaultMessage:"Proxy"})},(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiComboBox,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.proxyIdInput"},o.proxyIdInput.props,{onChange:e=>{var t,a;return o.proxyIdInput.setValue(null!==(t=null==e||null===(a=e[0])||void 0===a?void 0:a.value)&&void 0!==t?t:"")},selectedOptions:""!==o.proxyIdInput.value?k.filter((e=>e.value===o.proxyIdInput.value)):[],options:k,singleSelection:{asPlainText:!0},isDisabled:o.proxyIdInput.props.disabled,isClearable:!0,placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.proxyIdPlaceholder",{defaultMessage:"Select proxy"})})),(0,O.jsx)(c.EuiSpacer,{size:"xs"}),(0,O.jsx)(_l,null))),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},o.defaultOutputInput.formRowProps),(0,O.jsx)(c.EuiSwitch,(0,d.default)({},o.defaultOutputInput.props,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.defaultOutputSwitchLabel",defaultMessage:"Make this output the default for {boldAgentIntegrations}.",values:{boldAgentIntegrations:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.agentIntegrationsBold",defaultMessage:"agent integrations"}))}})}))),(0,O.jsx)(c.EuiFormRow,(0,d.default)({fullWidth:!0},o.defaultMonitoringOutputInput.formRowProps),(0,O.jsx)(c.EuiSwitch,(0,d.default)({},o.defaultMonitoringOutputInput.props,{label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.defaultMontoringOutputSwitchLabel",defaultMessage:"Make this output the default for {boldAgentMonitoring}.",values:{boldAgentMonitoring:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.agentMonitoringBold",defaultMessage:"agent monitoring"}))}})}))),b&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"l"}),(0,O.jsx)(c.EuiFormRow,{fullWidth:!0,label:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningLabel",defaultMessage:"Performance tuning"}),helpText:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningHelpText",defaultMessage:"Performance tuning presets are curated output settings for common use cases. You can also select {custom} to specify your own settings in the Advanced YAML Configuration box below. For a detailed list of settings configured by each preset, see {link}.",values:{custom:(0,O.jsx)("strong",null,"Custom"),link:(0,O.jsx)(c.EuiLink,{href:r.links.fleet.performancePresets,external:!0,target:"_blank"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningHelpTextLink",defaultMessage:"our documentation"}))}})},(0,O.jsx)(c.EuiSelect,(0,d.default)({fullWidth:!0,"data-test-subj":"settingsOutputsFlyout.presetInput"},o.presetInput.props,{onChange:e=>o.presetInput.setValue(e.target.value),disabled:o.presetInput.props.disabled||(0,an.o8)(o.additionalYamlConfigInput.value,ms.Hh),options:[{value:"balanced",text:"Balanced"},{value:"custom",text:"Custom"},{value:"throughput",text:"Throughput"},{value:"scale",text:"Scale"},{value:"latency",text:"Latency"}]})))),b&&(0,an.o8)(o.additionalYamlConfigInput.value,ms.Hh)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiCallOut,{color:"warning",iconType:"alert",size:"s",title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarning",defaultMessage:'Performance tuning preset must be "Custom" due to presence of reserved key in advanced YAML configuration'})},(0,O.jsx)(c.EuiAccordion,{id:"performanceTuningMustBeCustomWarningDetails",buttonContent:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.editOutputFlyout.performanceTuningMustBeCustomWarningDetails",defaultMessage:"Show reserved keys"})},(0,O.jsx)("ul",null,$.uhU.map((e=>(0,O.jsx)("li",{key:e},(0,O.jsx)(c.EuiCode,null,e)))))))),(0,O.jsx)(c.EuiSpacer,{size:"l"}),(0,O.jsx)(c.EuiFormRow,(0,d.default)({label:(0,O.jsx)(c.EuiLink,{href:r.links.fleet.esSettings,external:!0,target:"_blank"},f.i18n.translate("xpack.fleet.settings.editOutputFlyout.yamlConfigInputLabel",{defaultMessage:"Advanced YAML configuration"}))},o.additionalYamlConfigInput.formRowProps,{fullWidth:!0}),(0,O.jsx)(yn,{value:o.additionalYamlConfigInput.value,onChange:e=>{(0,an.o8)(e,ms.Hh)&&o.presetInput.setValue("custom"),o.additionalYamlConfigInput.setValue(e)},disabled:o.additionalYamlConfigInput.props.disabled,placeholder:f.i18n.translate("xpack.fleet.settings.editOutputFlyout.yamlConfigInputPlaceholder",{defaultMessage:"# YAML settings here will be added to the output section of each agent policy."})})),(0,O.jsx)(Hn,{enabled:i.isShipperEnabled,inputs:o})),null!=a&&a.id&&"remote_elasticsearch"===a.type?(0,O.jsx)(gl,{output:a}):null),(0,O.jsx)(c.EuiFlyoutFooter,null,(0,O.jsx)(c.EuiFlexGroup,{justifyContent:"spaceBetween"},(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButtonEmpty,{onClick:t,flush:"left"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.cancelButtonLabel",defaultMessage:"Cancel"}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{fill:!0,isLoading:i.isLoading,isDisabled:i.isDisabled,onClick:i.submit,"data-test-subj":"saveApplySettingsBtn"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.settings.fleetServerHostsFlyout.saveButton",defaultMessage:"Save and apply settings"}))))))},Xn=(0,wl.$H)((()=>{var e,t,a,l,n,i,d,g,p;(0,u.ifo)("settings");const m=(0,o.useHistory)(),x=(0,u.Wdf)(),{outputs:h,fleetServerHosts:E,downloadSources:y,proxies:k}={outputs:(0,u.Eiq)(),fleetServerHosts:(0,u.OVZ)(),downloadSources:(0,u.SFz)(),proxies:(0,u.qyb)()},v=null===(e=h.data)||void 0===e?void 0:e.items.filter((e=>!e.is_internal)),j=null===(t=E.data)||void 0===t?void 0:t.items.filter((e=>!e.is_internal)),{deleteOutput:b}=function(e){const{confirm:t}=(0,wl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteOutput:(0,s.useCallback)((async s=>{try{const{agentCount:a,agentPolicyCount:l}=await Bl(s).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));if(!await t((0,O.jsx)(Nl,null),(0,O.jsx)(zl,{output:s,agentCount:a,agentPolicyCount:l}),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteOutputs.confirmButtonLabel",{defaultMessage:"Delete and deploy"})}))return;const n=await(0,u.pE1)(s.id);if(n.error)throw n.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteOutputs.errorToastTitle",{defaultMessage:"Error deleting output"})})}}),[t,a.toasts,e])}}(h.resendRequest),{deleteDownloadSource:I}=function(e){const{confirm:t}=(0,wl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteDownloadSource:(0,s.useCallback)((async s=>{try{const{agentCount:a,agentPolicyCount:l}=await Wl(s).catch((()=>({agentCount:void 0,agentPolicyCount:void 0})));if(!await t((0,O.jsx)($l,null),(0,O.jsx)(Yl,{"data-test-subj":"editDownloadSourcesDeleteModal.confirmModalText",downloadSource:s,agentCount:a,agentPolicyCount:l}),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteDownloadSource.confirmButtonLabel",{defaultMessage:"Delete and deploy"})}))return;const n=await(0,u.taj)(s.id);if(n.error)throw n.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteDownloadSource.errorToastTitle",{defaultMessage:"Error deleting agent binary source."})})}}),[t,a.toasts,e])}}(y.resendRequest),{deleteFleetServerHost:T}=function(e){const{confirm:t}=(0,wl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteFleetServerHost:(0,s.useCallback)((async s=>{try{if(!await t((0,O.jsx)(Ul,null),(0,O.jsx)(Hl,null),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteFleetServerHosts.confirmButtonLabel",{defaultMessage:"Delete and deploy changes"})}))return;const a=await(0,u.D7A)(s.id);if(a.error)throw a.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteFleetServerHosts.errorToastTitle",{defaultMessage:"Error deleting Fleet Server hosts"})})}}),[t,a.toasts,e])}}(E.resendRequest),{deleteFleetProxy:w}=function(e){const{confirm:t}=(0,wl.fl)(),{notifications:a}=(0,u.WeA)();return{deleteFleetProxy:(0,s.useCallback)((async s=>{try{if(!await t((0,O.jsx)(Ol,null),(0,O.jsx)(Rl,null),{buttonColor:"danger",confirmButtonText:f.i18n.translate("xpack.fleet.settings.deleteFleetProxy.confirmButtonLabel",{defaultMessage:"Delete and deploy changes"})}))return;const a=await(0,u.mwZ)(s.id);if(a.error)throw a.error;e()}catch(e){a.toasts.addError(e,{title:f.i18n.translate("xpack.fleet.settings.deleteFleetProxy.errorToastTitle",{defaultMessage:"Error deleting proxy"})})}}),[t,a.toasts,e])}}(k.resendRequest),C=h.resendRequest,A=y.resendRequest,P=E.resendRequest,_=k.resendRequest,L=(0,s.useCallback)((()=>{x.closeFleetServerFlyout(),C(),A(),P(),_(),m.replace(S.tn.settings()[1])}),[x,C,A,P,_,m]),{cloud:D}=(0,u.WeA)();return h.isLoading&&h.isInitialRequest||!v||E.isLoading&&E.isInitialRequest||!j||y.isLoading&&y.isInitialRequest||null===(a=y.data)||void 0===a||!a.items||k.isLoading&&k.isInitialRequest||null===(l=k.data)||void 0===l||!l.items?(0,O.jsx)(F.iW,{section:"settings"},(0,O.jsx)(M.Rh,null)):(0,O.jsx)(F.iW,{section:"settings"},(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:S.X5.settings_edit_fleet_server_hosts},(e=>{var t,a;const s=j.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.itemId)===t.id}));return s?(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(Dl,{proxies:null!==(t=null===(a=k.data)||void 0===a?void 0:a.items)&&void 0!==t?t:[],onClose:L,fleetServerHost:s})):(0,O.jsx)(o.Redirect,{to:S.X5.settings})})),(0,O.jsx)(r.Route,{path:S.X5.settings_create_fleet_server_hosts},(0,O.jsx)(c.EuiPortal,null,null!=D&&D.isServerlessEnabled?(0,O.jsx)(Dl,{proxies:null!==(n=null===(i=k.data)||void 0===i?void 0:i.items)&&void 0!==n?n:[],onClose:L,defaultFleetServerHost:null===(d=E.data)||void 0===d?void 0:d.items.find((e=>e.id===$.Z24))}):(0,O.jsx)(M.Jh,{onClose:L}))),(0,O.jsx)(r.Route,{path:S.X5.settings_create_outputs},(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(Jn,{proxies:k.data.items,onClose:L,defaultOuput:null===(g=h.data)||void 0===g?void 0:g.items.find((e=>e.id===$.VE))}))),(0,O.jsx)(r.Route,{path:S.X5.settings_create_fleet_proxy},(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(tn,{onClose:L}))),(0,O.jsx)(r.Route,{path:S.X5.settings_edit_fleet_proxy},(e=>{var t;const a=null===(t=k.data)||void 0===t?void 0:t.items.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.itemId)===t.id}));return a?(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(tn,{onClose:L,fleetProxy:a})):(0,O.jsx)(o.Redirect,{to:S.X5.settings})})),(0,O.jsx)(r.Route,{path:S.X5.settings_edit_outputs},(e=>{var t,a,s;const l=v.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.outputId)===t.id}));return l?(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(Jn,{proxies:null!==(t=null===(a=k.data)||void 0===a?void 0:a.items)&&void 0!==t?t:[],onClose:L,output:l,defaultOuput:null===(s=h.data)||void 0===s?void 0:s.items.find((e=>e.id===$.VE))})):(0,O.jsx)(o.Redirect,{to:S.X5.settings})})),(0,O.jsx)(r.Route,{path:S.X5.settings_create_download_sources},(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(Vl,{onClose:L,proxies:(null==k||null===(p=k.data)||void 0===p?void 0:p.items)||[]}))),(0,O.jsx)(r.Route,{path:S.X5.settings_edit_download_sources},(e=>{var t,a;const s=null===(t=y.data)||void 0===t?void 0:t.items.find((t=>{var a;return(null===(a=e.match)||void 0===a?void 0:a.params.downloadSourceId)===t.id}));return s?(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(Vl,{onClose:L,downloadSource:s,proxies:(null==k||null===(a=k.data)||void 0===a?void 0:a.items)||[]})):(0,O.jsx)(o.Redirect,{to:S.X5.settings})}))),(0,O.jsx)(Tl,{deleteFleetProxy:w,proxies:k.data.items,outputs:v,fleetServerHosts:j,deleteOutput:b,deleteFleetServerHost:T,downloadSources:y.data.items,deleteDownloadSource:I}))})),Zn=({value:e})=>(0,O.jsx)(mn.CodeEditor,{isCopyable:!0,languageId:"",height:"600px",width:"100%",options:{minimap:{enabled:!1},scrollBeyondLastLine:!1,readOnly:!0,tabSize:2,lineNumbers:"off",lineNumbersMinChars:0,glyphMargin:!1,lineDecorationsWidth:0,overviewRulerBorder:!1},value:e}),ei=async()=>{const e=await(0,u.cnO)({full:!0,perPage:100,sortOrder:"asc"});if(e.error)throw new Error(e.error.message);return e};var ti=a(10885);const ai=async()=>{var e;const t=await(0,u.OQl)({prerelease:!0});if(t.error)throw new Error(t.error.message);return null===(e=t.data)||void 0===e?void 0:e.items.filter((({status:e})=>"installed"===e))},si=({name:e,setName:t,type:a,setNamesStatus:l})=>{const{data:n,status:i}=(0,x.useQuery)(["debug-saved-object-names",a],(()=>(async e=>{var t;const a=await(0,u.w$b)({method:"post",path:I.xw.getSavedObjectNamesPath(),body:{type:e},version:$.BoD.internal.v1});if(a.error)throw new Error(a.error.message);return null===(t=a.data)||void 0===t?void 0:t.aggregations.names.buckets})(a)),{refetchOnWindowFocus:!1});(0,s.useEffect)((()=>{l(i)}),[i,l]);const o=(null!=n?n:[]).map((e=>({label:e.key,value:e.key}))),r=o.find((t=>t.value===e)),d=r?[r]:[];return(0,O.jsx)(c.EuiComboBox,{prepend:"Name","aria-label":f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel",{defaultMessage:"Select a Saved Object"}),placeholder:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectedSavedObjectLabel",{defaultMessage:"Select a Saved Object"}),fullWidth:!0,options:o,singleSelection:{asPlainText:!0},selectedOptions:d,isLoading:"loading"===i,onChange:e=>{e.length?t(e[0].value):t(void 0)}})},li=async()=>{var e,t;const a=`${S.mm}.is_preconfigured:true`,s=await(0,u.cnO)({kuery:a,perPage:100,full:!0});if(s.error)throw new Error(s.error.message);return null!==(e=null===(t=s.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[]},ni=async()=>{var e,t;const a=await(0,u.W1E)();if(a.error)throw new Error(a.error.message);return null!==(e=null===(t=a.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[]},ii=new x.QueryClient,oi=[{title:f.i18n.translate("xpack.fleet.debug.HealthCheckStatus.title",{defaultMessage:"Health Check Status"}),id:"healthCheckStatus",component:(0,O.jsx)((()=>{var e;const[t,a]=(0,s.useState)(),{data:n}=(0,u.OVZ)(),i=(0,s.useMemo)((()=>{var e;return null!==(e=null==n?void 0:n.items)&&void 0!==e?e:[]}),[null==n?void 0:n.items]);(0,s.useEffect)((()=>{const e=i.find((e=>!0===e.is_default));e&&a(e)}),[i]);const o=(0,s.useMemo)((()=>(null==t?void 0:t.id)||""),[null==t?void 0:t.id]),[r,d]=(0,s.useState)(),[g,f]=(0,s.useState)(),{data:m}=(0,x.useQuery)(["fleetServerHealth",o],(()=>(0,u.RUT)({id:o})),{refetchInterval:1e4,enabled:!!o});(0,s.useEffect)((()=>{d(null==m?void 0:m.data),null!=m&&m.error&&f(m.error)}),[m]);const h=(0,s.useMemo)((()=>[...i.map((e=>({inputDisplay:`${e.name} (${e.host_urls[0]})`,value:e.id})))]),[i]);return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.description",defaultMessage:"Select the host used to enroll Fleet Server. The connection is refreshed every {interval}s.",values:{interval:10}}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,O.jsx)(c.EuiSuperSelect,{fullWidth:!0,"data-test-subj":"fleetDebug.fleetServerHostsSelect",prepend:(0,O.jsx)(c.EuiText,{size:"relative",color:""},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.fleetServerHostsLabel",defaultMessage:"Fleet Server Hosts"})),onChange:e=>{d(void 0),a(i.find((t=>t.id===e)))},valueOfSelected:null==t?void 0:t.id,options:h})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},null!=r&&r.status&&o===(null==r?void 0:r.host_id)?(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center"},(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.status",defaultMessage:"Status:"})),(0,O.jsx)(c.EuiFlexItem,null,(e=>{if(!e)return null;let t;switch(e){case"HEALTHY":t="success";break;case"UNHEALTHY":t="warning";break;default:t="subdued"}return(0,O.jsx)(c.EuiHealth,{color:t},e)})(null==r?void 0:r.status))):null)),g&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiCallOut,{title:"Error",color:"danger"},null!==(e=null==g?void 0:g.message)&&void 0!==e?e:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.healthCheckPanel.fetchError",defaultMessage:"Message: {errorMessage}",values:{errorMessage:null==g?void 0:g.message}}))))}),null)},{title:f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.title",{defaultMessage:"Agent Policy Debugger"}),id:"agentPolicyDebugger",component:(0,O.jsx)((()=>{var e,t;const{getHref:a}=(0,u.iEg)(),[n,i]=(0,s.useState)(),{data:o,status:r}=(0,x.useQuery)(["debug-agent-policies"],ei),d=null!==(e=null==o||null===(t=o.data)||void 0===t?void 0:t.items)&&void 0!==e?e:[],g=d.map((e=>({label:`${e.name} - ${e.id}`,value:e.id}))),m=n?[g.find((e=>e.value===n))]:[],h=d.find((e=>e.id===n)),E=()=>{i(void 0),ii.invalidateQueries(["debug-agent-policies"])};return"error"===r?(0,O.jsx)(c.EuiCallOut,{title:"Error",color:"danger"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.fetchError",defaultMessage:"Error fetching Agent Policies"})):(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.description",defaultMessage:"Search for an Agent Policy using its name or {codeId} value. Use the code block below to diagnose any potential issues with the policy's configuration.",values:{codeId:(0,O.jsx)(c.EuiCode,null,"id")}}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,O.jsx)(c.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,O.jsx)(c.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.selectLabel",{defaultMessage:"Select an Agent Policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.agentPolicyDebugger.selectLabel",{defaultMessage:"Select an Agent Policy"}),fullWidth:!0,options:g,singleSelection:{asPlainText:!0},selectedOptions:m,isLoading:"loading"===r,onChange:e=>{e.length?i(e[0].value):i(void 0)}})),n&&(0,O.jsx)(w.wq,{agentPolicy:h,hasFleetServer:(0,z.ob)(h)},(e=>(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(c.EuiButton,{color:"danger",onClick:()=>e(n,E)},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.policyForm.deletePolicyActionText",defaultMessage:"Delete policy"}))))))),n&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiLink,{target:"_blank",href:a("policy_details",{policyId:n})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.agentPolicyDebugger.viewAgentPolicyLink",defaultMessage:"View Agent Policy in Fleet UI"})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Zn,{value:JSON.stringify(h,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.title",{defaultMessage:"Integration Debugger"}),id:"integrationDebugger",component:(0,O.jsx)((()=>{var e,t,a,n,i;const{http:o,notifications:r}=(0,u.WeA)(),{getHref:d}=(0,u.iEg)(),[g,m]=(0,s.useState)(),[h,E]=(0,s.useState)(!1),[y,k]=(0,s.useState)(!1),v=(0,x.useQuery)(["debug-integrations"],ai),j=(0,x.useMutation)((async e=>{const t=await(0,u.Jip)({pkgName:e.name,pkgVersion:e.version},{force:!0});if(t.error)throw r.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.uninstall.error",{defaultMessage:"Error uninstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:t.error.message}),k(!1),new Error(t.error.message);return r.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.integrationDebugger.uninstall.success",{defaultMessage:"Successfully uninstalled {integrationTitle}",values:{integrationTitle:e.title}})),m(void 0),k(!1),ii.invalidateQueries(["debug-integrations"]),t.data})),b=(0,x.useMutation)((async e=>{const t=await(0,u.Jip)({pkgName:e.name,pkgVersion:e.version},{force:!0});if(t.error)throw r.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.error",{defaultMessage:"Error reinstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:t.error.message}),E(!1),new Error(t.error.message);const a=await(0,u.Q8y)(e.name,e.version);if(a.error)throw r.toasts.addError(new Error(a.error.message),{title:f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.error",{defaultMessage:"Error reinstalling {integrationTitle}",values:{integrationTitle:e.title}}),toastMessage:a.error.message}),E(!1),new Error(a.error.message);return r.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.integrationDebugger.reinstall.success",{defaultMessage:"Successfully reinstalled {integrationTitle}",values:{integrationTitle:e.title}})),m(void 0),E(!1),ii.invalidateQueries(["debug-integrations"]),a.data}));if("error"===v.status)return(0,O.jsx)(c.EuiCallOut,{title:"Error",color:"danger"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.fetchError",defaultMessage:"Error fetching installed Integrations"}));const M=null!==(e=null===(t=v.data)||void 0===t?void 0:t.map((e=>({label:e.name,value:e.id,icon:(0,ti.d)(e,o.basePath)}))))&&void 0!==e?e:[],S=g?[M.find((e=>e.value===g))]:[],F=null===(a=v.data)||void 0===a?void 0:a.find((e=>e.id===g));return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.description",defaultMessage:"Use this tool to uninstall or reinstall installed integrations."})),(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.reinstallationDescription",defaultMessage:"Reinstalling an integration will uninstall and then immediately install it again. This can be useful in restoring broken or malformed integration installations when a user hasn't done much customization."}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,O.jsx)(c.EuiFlexItem,{grow:!1,css:"\n            min-width: 600px;\n          "},(0,O.jsx)(c.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.integrationDebugger.selectLabel",{defaultMessage:"Select an Integration"}),placeholder:f.i18n.translate("xpack.fleet.debug.integrationDebugger.selectLabel",{defaultMessage:"Select an Integration"}),fullWidth:!0,options:M,singleSelection:{asPlainText:!0},selectedOptions:S,isDisabled:"loading"===v.status,prepend:S.length>0?(0,O.jsx)(c.EuiButtonEmpty,null,(0,O.jsx)(c.EuiIcon,{type:null!==(n=null===(i=S[0])||void 0===i?void 0:i.icon)&&void 0!==n?n:"fleetApp"})):void 0,renderOption:(e,t,a)=>(0,O.jsx)("span",{className:a},(0,O.jsx)(c.EuiIcon,{type:e.icon})," ",(0,O.jsx)(c.EuiHighlight,{search:t},e.label)),onChange:e=>{e.length?m(e[0].value):m(void 0)}})),F&&(0,O.jsx)(c.EuiFlexGroup,null,(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{color:"primary",onClick:()=>E(!0)},"Reinstall")),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)(c.EuiButton,{color:"danger",onClick:()=>k(!0)},"Uninstall")),h&&(0,O.jsx)(c.EuiConfirmModal,{title:`Reinstall ${F.title}`,onCancel:()=>E(!1),onConfirm:()=>b.mutate(F),isLoading:b.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.cancelReinstall",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.confirmReinstall",{defaultMessage:"Reinstall"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.reinstallModal",defaultMessage:"Are you sure you want to reinstall {integrationTitle}?",values:{integrationTitle:F.title}})),y&&(0,O.jsx)(c.EuiConfirmModal,{title:`Uninstall ${F.title}`,onCancel:()=>k(!1),onConfirm:()=>j.mutate(F),isLoading:j.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.cancelUninstall",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.integrationDebugger.confirmUninstall",{defaultMessage:"Uninstall"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.uninstallModal",defaultMessage:"Are you sure you want to uninstall {integrationTitle}?",values:{integrationTitle:F.title}})))),F&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiLink,{target:"_blank",href:d("integration_details_overview",{pkgkey:(0,z.Ku)({name:F.name,version:F.version})})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.integrationDebugger.viewIntegrationLink",defaultMessage:"View integration settings in Integrations UI"}))))}),null)},{title:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.title",{defaultMessage:"Saved Object Debugger"}),id:"savedObjectDebugger",component:(0,O.jsx)((()=>{const e=[{value:`${$.mm9}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.agentPolicyLabel",{defaultMessage:"Agent policy"})},{value:`${$.RNf}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.packagePolicyLabel",{defaultMessage:"Integration policy"})},{value:`${$.Lmx}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.outputLabel",{defaultMessage:"Output"})},{value:`${$.fAG}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.packageLabel",{defaultMessage:"Packages"})},{value:`${$.y_r}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.downloadSourceLabel",{defaultMessage:"Download Sources"})},{value:`${$.twQ}`,text:f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.fleetServerHostLabel",{defaultMessage:"Fleet Server Hosts"})}],[t,a]=(0,s.useState)(e[0].value),[n,i]=(0,s.useState)(),[o,r]=(0,s.useState)(),{data:d,status:g}=(0,x.useQuery)(["debug-saved-objects",t,n],(()=>(async(e,t)=>{var a;if(!e||!t)return[];const s=await(0,u.w$b)({method:"post",path:I.xw.getSavedObjectsPath(),body:{type:e,name:t},version:$.BoD.internal.v1});if(s.error)throw new Error(s.error.message);return null===(a=s.data)||void 0===a?void 0:a.saved_objects})(t,n)));return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.savedObjectDebugger.description",defaultMessage:"Search for Fleet-related saved objects by selecting a type and name. Use the code block below to diagnose any potential issues."}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,{alignItems:"center",justifyContent:"flexStart"},(0,O.jsx)(c.EuiFlexItem,{grow:!1,css:"\n            min-width: 300px;\n          "},(0,O.jsx)(c.EuiFormRow,null,(0,O.jsx)(c.EuiSelect,{prepend:"Type",id:"soType",options:e,value:t,onChange:e=>(e=>{a(e.target.value),i(void 0)})(e),"aria-label":f.i18n.translate("xpack.fleet.debug.savedObjectDebugger.selectTypeLabel",{defaultMessage:"Select saved object type"})}))),(0,O.jsx)(c.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,O.jsx)(c.EuiFormRow,null,(0,O.jsx)(si,{name:n,setName:i,type:t,setNamesStatus:r})))),d&&("error"===g||"error"===o)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiCallOut,{title:"Error",color:"danger"},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.savedObjectDebugger.fetchError",defaultMessage:"Error fetching Saved Objects"}))),(d||"loading"===g)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Zn,{value:JSON.stringify(d,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.title",{defaultMessage:"Fleet Index Debugger"}),id:"fleetIndexDebugger",component:(0,O.jsx)((()=>{var e,t,a,n;const i=[{label:B.AGENTS_INDEX,value:B.AGENTS_INDEX},{label:B.AGENT_ACTIONS_INDEX,value:B.AGENT_ACTIONS_INDEX},{label:S.Al,value:S.Al}],[o,r]=(0,s.useState)(),{data:d,status:g}=(0,x.useQuery)(["debug-indices",o],(()=>(async e=>e?await(0,u.w$b)({method:"post",path:I.xw.getIndexPath(),body:{index:e},version:B.API_VERSIONS.internal.v1}):null)(o)),{retry:!1}),m=o?[i.find((e=>e.value===o))]:[];return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.fleetIndexDebugger.description",defaultMessage:"Search for the contents of Fleet indices. Use the code block below to diagnose any potential issues. "}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,null,(0,O.jsx)(c.EuiFlexItem,null,(0,O.jsx)(c.EuiFormRow,null,(0,O.jsx)(c.EuiComboBox,{prepend:"Index","aria-label":f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.selectLabel",{defaultMessage:"Select an index"}),placeholder:f.i18n.translate("xpack.fleet.debug.fleetIndexDebugger.selectLabel",{defaultMessage:"Select an index"}),fullWidth:!0,options:i,singleSelection:{asPlainText:!0},selectedOptions:m,isLoading:"loading"===g,onChange:e=>{e.length?r(e[0].value):r(void 0)}})))),(null==d?void 0:d.error)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiCallOut,{title:"Error",color:"danger"},null!==(e=null==d||null===(t=d.error)||void 0===t||null===(a=t.error)||void 0===a?void 0:a.reason)&&void 0!==e?e:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.fleetIndexDebugger.fetchError",defaultMessage:"Error fetching index data"}))),d&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Zn,{value:JSON.stringify(null===(n=d.data)||void 0===n?void 0:n.hits,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.title",{defaultMessage:"Preconfiguration Debugger"}),id:"preconfigurationDebugger",component:(0,O.jsx)((()=>{var e,t,a,n;const{getHref:i}=(0,u.iEg)(),{notifications:o}=(0,u.WeA)(),[r,d]=(0,s.useState)(),[g,m]=(0,s.useState)(!1),[h,E]=(0,s.useState)(!1),y=(0,x.useQuery)(["debug-preconfigured-policies"],li),k=null!==(e=null===(t=y.data)||void 0===t?void 0:t.map((e=>({label:e.name,value:e.id}))))&&void 0!==e?e:[],v=r?[k.find((({value:e})=>e===r))]:[],j=null===(a=y.data)||void 0===a?void 0:a.find((e=>e.id===r)),b=(0,x.useMutation)((async e=>{const t=await(0,u.W$e)(e);if(t.error)throw o.toasts.addError(t.error,{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetError",{defaultMessage:"Error resetting policy"}),toastMessage:t.error.message}),new Error(t.error.message);return o.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetSuccess",{defaultMessage:"Successfully reset policy"})),ii.invalidateQueries(["debug-preconfigured-policies"]),d(void 0),m(!1),t.data})),M=(0,x.useMutation)((async()=>{const e=await(0,u.Vg9)();if(e.error)throw o.toasts.addError(e.error,{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllError",{defaultMessage:"Error resetting policies"}),toastMessage:e.error.message}),new Error(e.error.message);return o.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllSuccess",{defaultMessage:"Successfully reset policies"})),ii.invalidateQueries(["debug-preconfigured-policies"]),d(void 0),E(!1),e.data}));return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.description",defaultMessage:"This tool can be used to reset preconfigured policies that are managed via {codeKibanaYml}. This includes Fleet's default policies that may exist in cloud environments.",values:{codeKibanaYml:(0,O.jsx)(c.EuiCode,null,"kibana.yml")}})),(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetInstructions",defaultMessage:'You may reset a single preconfigured policy or use the "Reset all" button to reset all preconfigured policies at once.'}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,null,(0,O.jsx)(c.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,O.jsx)(c.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.selectLabel",{defaultMessage:"Select a preconfigured policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.selectLabel",{defaultMessage:"Select a preconfigured policy"}),fullWidth:!0,options:k,singleSelection:{asPlainText:!0},selectedOptions:v,onChange:e=>{e.length?d(e[0].value):d(void 0)}})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(c.EuiButton,{color:"warning",isDisabled:!r,onClick:()=>m(!0)},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetButton",defaultMessage:"Reset"})))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(c.EuiButton,{color:"danger",isDisabled:!(null!==(n=y.data)&&void 0!==n&&n.length),onClick:()=>E(!0)},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetAllButton",defaultMessage:"Reset all"}))))),g&&j&&r&&(0,O.jsx)(c.EuiConfirmModal,{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalTitle",{defaultMessage:"Reset {policyName}",values:{policyName:j.name}}),onCancel:()=>m(!1),onConfirm:()=>b.mutate(r),isLoading:b.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalCancel",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetModalConfirm",{defaultMessage:"Reset"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetModalBody",defaultMessage:"Are you sure you want to reset {policyName}?",values:{policyName:j.name}})),h&&(0,O.jsx)(c.EuiConfirmModal,{title:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalTitle",{defaultMessage:"Reset all preconfigured policies"}),onCancel:()=>E(!1),onConfirm:()=>M.mutate(),isLoading:M.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalCancel",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.preconfigurationDebugger.resetAllModalConfirm",{defaultMessage:"Reset all"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.resetAllModalBody",defaultMessage:"Are you sure you want to reset all preconfigured policies?"})),r&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiLink,{target:"_blank",href:i("policy_details",{policyId:r})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.preconfigurationDebugger.viewAgentPolicyLink",defaultMessage:"View Agent Policy in Fleet UI"})),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Zn,{value:JSON.stringify(j,null,2)})))}),null)},{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.title",{defaultMessage:"Orphaned Integration Policy Debugger"}),id:"orphanedIntegrationPolicyDebugger",component:(0,O.jsx)((()=>{var e;const{notifications:t}=(0,u.WeA)(),[a,n]=(0,s.useState)(),[i,o]=(0,s.useState)(!1),[r,d]=(0,s.useState)(!1),{data:g}=(0,x.useQuery)(["debug-orphaned-policies"],ni),m=null!==(e=null==g?void 0:g.map((e=>({label:e.name,value:e.id}))))&&void 0!==e?e:[],h=a?[m.find((({value:e})=>e===a))]:[],E=null==g?void 0:g.find((e=>e.id===a)),y=(0,x.useMutation)((async e=>{const a=await(0,u.Ot1)({packagePolicyIds:[e],force:!0});if(a.error)throw t.toasts.addError(a.error,{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteError",{defaultMessage:"Error deleting policy"}),toastMessage:a.error.message}),new Error(a.error.message);return t.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteSuccess",{defaultMessage:"Successfully deleted orphaned policy"})),ii.invalidateQueries(["debug-orphaned-policies"]),n(void 0),o(!1),a.data})),k=(0,x.useMutation)((async()=>{const e=await(0,u.Ot1)({packagePolicyIds:null==g?void 0:g.map((e=>e.id)),force:!0});if(e.error)throw t.toasts.addError(e.error,{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllError",{defaultMessage:"Error deleting orphaned policies"}),toastMessage:e.error.message}),new Error(e.error.message);return t.toasts.addSuccess(f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllSuccess",{defaultMessage:"Successfully deleted all orphaned policies"})),ii.invalidateQueries(["debug-orphaned-policies"]),n(void 0),d(!1),e.data}));return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.description",defaultMessage:'This tool can be used to delete "orphaned" integration policies that have been unlinked from their parent agent policy objects'})),(0,O.jsx)("p",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteOptions",defaultMessage:'You may delete a single orphaned integration policy or use the "Delete all" button to delete all orphaned integration policies at once.'}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiFlexGroup,null,(0,O.jsx)(c.EuiFlexItem,{grow:!1,css:"\n            min-width: 400px;\n          "},(0,O.jsx)(c.EuiComboBox,{"aria-label":f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel",{defaultMessage:"Select an orphaned integration policy"}),placeholder:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.selectLabel",{defaultMessage:"Select an orphaned integration policy"}),fullWidth:!0,options:m,singleSelection:{asPlainText:!0},selectedOptions:h,onChange:e=>{e.length?n(e[0].value):n(void 0)}})),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(c.EuiButton,{color:"warning",isDisabled:!a,onClick:()=>o(!0)},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteButton",defaultMessage:"Delete"})))),(0,O.jsx)(c.EuiFlexItem,{grow:!1},(0,O.jsx)("div",null,(0,O.jsx)(c.EuiButton,{color:"danger",isDisabled:!(null!=g&&g.length),onClick:()=>d(!0)},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllButton",defaultMessage:"Delete all"}))))),i&&E&&a&&(0,O.jsx)(c.EuiConfirmModal,{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalTitle",{defaultMessage:"Delete {policyName}",values:{policyName:E.name}}),onCancel:()=>o(!1),onConfirm:()=>y.mutate(a),isLoading:y.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDelete",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDelete",{defaultMessage:"Delete"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteModalBody",defaultMessage:"Are you sure you want to delete {policyName}?",values:{policyName:E.name}})),r&&(0,O.jsx)(c.EuiConfirmModal,{title:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalTitle",{defaultMessage:"Delete all orphaned integration policies"}),onCancel:()=>d(!1),onConfirm:()=>k.mutate(),isLoading:k.isLoading,cancelButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.cancelDeleteAll",{defaultMessage:"Cancel"}),confirmButtonText:f.i18n.translate("xpack.fleet.debug.orphanedIntegrationPolicyDebugger.confirmDeleteAll",{defaultMessage:"Delete all"})},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.orphanedIntegrationPolicyDebugger.deleteAllModalBody",defaultMessage:"Are you sure you want to delete all orphaned integration policies?"})),a&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(Zn,{value:JSON.stringify(E,null,2)})))}),null)}],ri=({isInitialized:e,setupError:t})=>{const{chrome:a}=(0,u.WeA)(),{getHref:s}=(0,u.iEg)();return a.docTitle.change(["Debug","Fleet"]),(0,O.jsx)(x.QueryClientProvider,{client:ii},(0,O.jsx)(c.EuiPage,{paddingSize:"xl"},(0,O.jsx)(c.EuiPageBody,{panelled:!0},(0,O.jsx)(c.EuiPageSection,null,(0,O.jsx)(c.EuiPageHeader,{pageTitle:f.i18n.translate("xpack.fleet.debug.pageTitle",{defaultMessage:"Fleet Debugging Dashboard"}),iconType:"wrench"}),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiCallOut,{color:"danger",iconType:"warning",title:"Danger zone"},(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.description",defaultMessage:"This page provides an interface for directly managing Fleet's underlying data and diagnosing issues. Be aware that these debugging tools can be {strongDestructive} in nature and can result in {strongLossOfData}. Please proceed with caution.",values:{strongDestructive:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.destructive",defaultMessage:"destructive"})),strongLossOfData:(0,O.jsx)("strong",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.dangerZone.lossOfData",defaultMessage:"loss of data"}))}}))),!e&&(null==t?void 0:t.message)&&(0,O.jsx)(l().Fragment,null,(0,O.jsx)(c.EuiSpacer,{size:"s"}),(0,O.jsx)(c.EuiCallOut,{color:"danger",iconType:"warning",title:"Setup error"},(0,O.jsx)(c.EuiText,{grow:!1},(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.initializationError.description",defaultMessage:"{message}. You can use this page to debug the error.",values:{message:null==t?void 0:t.message}}))))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiPageSection,null,oi.map((({title:e,id:t,component:a})=>(0,O.jsx)("div",{key:t},(0,O.jsx)(c.EuiAccordion,{id:t,initialIsOpen:!0,buttonContent:(0,O.jsx)(c.EuiTitle,{size:"l"},(0,O.jsx)("h2",null,e))},(0,O.jsx)(c.EuiSpacer,{size:"m"}),a),(0,O.jsx)(c.EuiHorizontalRule,null)))),(0,O.jsx)(c.EuiTitle,{size:"l"},(0,O.jsx)("h2",null,(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.debug.usefulLinks.title",defaultMessage:"Useful links"}))),(0,O.jsx)(c.EuiSpacer,{size:"m"}),(0,O.jsx)(c.EuiListGroup,{listItems:[{label:f.i18n.translate("xpack.fleet.debug.usefulLinks.viewAgents",{defaultMessage:"View Agents in Fleet UI"}),href:s("agent_list"),iconType:"agentApp",target:"_blank"},{label:f.i18n.translate("xpack.fleet.debug.usefulLinks.troubleshootingGuide",{defaultMessage:"Troubleshooting Guide"}),href:"https://www.elastic.co/guide/en/fleet/current/fleet-troubleshooting.html",iconType:"popout",target:"_blank"}]})))),(0,O.jsx)(h.ReactQueryDevtools,{initialIsOpen:!1}))},ui=new x.QueryClient,di=(0,s.memo)((({children:e})=>{(0,u.ifo)("base");const t=(0,u.WeA)(),{notifications:a}=t,n=(0,u.iO7)(),i=n.fleet.readEnrollmentTokens||n.fleet.readAgents||n.fleet.readAgentPolicies||n.fleet.readSettings,[r,d]=(0,s.useState)(!1),[c,g]=(0,s.useState)(),[m,x]=(0,s.useState)(!1),[h,E]=(0,s.useState)(null),y=!!(0,o.useRouteMatch)(S.X5.add_integration_to_policy),k=!!(0,o.useRouteMatch)(S.X5.debug);return(0,s.useEffect)((()=>{(async()=>{d(!1),g(void 0),x(!1),E(null);try{var e;d(!0);const n=await(0,u.nXS)();if(d(!1),null!==(e=n.data)&&void 0!==e&&e.success){try{var t,s;const e=await(0,u.i0)();e.error&&E(e.error),null!==(t=e.data)&&void 0!==t&&null!==(s=t.nonFatalErrors)&&void 0!==s&&s.length&&a.toasts.addError(e.data.nonFatalErrors[0],{title:f.i18n.translate("xpack.fleet.setup.uiPreconfigurationErrorTitle",{defaultMessage:"Configuration error"})}),i||g("MISSING_PRIVILEGES")}catch(e){E(e)}x(!0)}else{var l;g((null===(l=n.data)||void 0===l?void 0:l.error)||"REQUEST_ERROR")}}catch(e){g("REQUEST_ERROR")}})()}),[a.toasts,i]),r||c?(0,O.jsx)(F.x$,{isAddIntegrationsPath:y},r?(0,O.jsx)(M.Rh,null):(0,O.jsx)(F.LA,{error:c})):k?(0,O.jsx)(ri,{setupError:h,isInitialized:m}):!m||h?(0,O.jsx)(F.x$,{isAddIntegrationsPath:y},h?(0,O.jsx)(M.$D,{title:(0,O.jsx)(p.FormattedMessage,{id:"xpack.fleet.initializationErrorMessageTitle",defaultMessage:"Unable to initialize Fleet"}),error:h}):(0,O.jsx)(M.uq,null)):(0,O.jsx)(l().Fragment,null,e)})),ci=(0,s.memo)((({children:e,startServices:t,config:a,history:s,kibanaVersion:l,extensions:n,routerHistory:i,fleetStatus:o})=>{const c=(0,m.A)(t.theme.theme$),p=c&&c.darkMode;return(0,O.jsx)(g.KibanaRenderContextProvider,(0,d.default)({},t,{theme:t.theme,modify:{breakpoint:{xxl:1600}}}),(0,O.jsx)(k.V,{coreStart:{application:t.application}},(0,O.jsx)(y.KibanaContextProvider,{services:{...t}},(0,O.jsx)(u.QOw.Provider,{value:a},(0,O.jsx)(u.g4O.Provider,{value:l},(0,O.jsx)(v.EuiThemeProvider,{darkMode:p},(0,O.jsx)(x.QueryClientProvider,{client:ui},(0,O.jsx)(h.ReactQueryDevtools,{initialIsOpen:!1}),(0,O.jsx)(u.K8T.Provider,{value:n},(0,O.jsx)(u.aOH,{defaultFleetStatus:o},(0,O.jsx)(b.M,null,(0,O.jsx)(r.Router,{history:s},(0,O.jsx)(j.hn1,{startServices:t},(0,O.jsx)(u.iGT,null,e)))))))))))))})),gi=(0,s.memo)((({setHeaderActionMenu:e,isReadOnly:t})=>{const a=(0,u.WeA)(),{euiTheme:s}=(0,c.useEuiTheme)(),n=l().useMemo((()=>(0,E.css)("color:",s.colors.textParagraph,";","")),[s]),{TopNavMenu:i}=a.navigation.ui,o=[];return t&&o.push({label:f.i18n.translate("xpack.fleet.appNavigation.readOnlyBtn",{defaultMessage:"Read-only"}),disableButton:!0,className:n,iconType:"glasses",tooltip:f.i18n.translate("xpack.fleet.appNavigation.readOnlyTooltip",{defaultMessage:"You can view most Fleet settings, but your current privileges don't allow you to perform all actions."}),run:()=>{}}),o.push({label:f.i18n.translate("xpack.fleet.appNavigation.sendFeedbackButton",{defaultMessage:"Send feedback"}),iconType:"popout",run:()=>window.open("https://ela.st/fleet-feedback")}),(0,O.jsx)(i,{appName:f.i18n.translate("xpack.fleet.appTitle",{defaultMessage:"Fleet"}),config:o,setMenuMountPoint:e})})),pi=({children:e,setHeaderActionMenu:t,isReadOnly:a})=>(0,O.jsx)(l().Fragment,null,(0,O.jsx)(gi,{setHeaderActionMenu:t,isReadOnly:a}),e),fi=(0,s.memo)((({setHeaderActionMenu:e})=>{var t;const a=(0,u.Wdf)(),s=(0,u.YI3)(),n=(0,u.iO7)();return(0,O.jsx)(l().Fragment,null,(0,O.jsx)(r.Routes,null,(0,O.jsx)(r.Route,{path:S.X5.agents,key:S.X5.agents},n.fleet.readAgents?(0,O.jsx)(pi,{setHeaderActionMenu:e,isReadOnly:!n.fleet.allAgents},(0,O.jsx)(Ba,null)):(0,O.jsx)(pi,{setHeaderActionMenu:e},(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents Read"})))),(0,O.jsx)(r.Route,{path:S.X5.policies},n.fleet.readAgentPolicies?(0,O.jsx)(pi,{setHeaderActionMenu:e,isReadOnly:!n.fleet.allAgentPolicies},(0,O.jsx)(oe,null)):(0,O.jsx)(pi,{setHeaderActionMenu:e},(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Agent policies Read"})))),(0,O.jsx)(r.Route,{path:S.X5.enrollment_tokens},n.fleet.allAgents?(0,O.jsx)(pi,{setHeaderActionMenu:e},(0,O.jsx)(Vs,null)):(0,O.jsx)(pi,{setHeaderActionMenu:e},(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents All"})))),(0,O.jsx)(r.Route,{path:S.X5.uninstall_tokens},n.fleet.allAgents?(0,O.jsx)(pi,{setHeaderActionMenu:e},(0,O.jsx)(ol,null)):(0,O.jsx)(pi,{setHeaderActionMenu:e},(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Agents All"})))),(0,O.jsx)(r.Route,{path:S.X5.data_streams},(0,O.jsx)(pi,{setHeaderActionMenu:e},(0,O.jsx)(ce,null))),(0,O.jsx)(r.Route,{path:S.X5.settings},n.fleet.readSettings?(0,O.jsx)(pi,{setHeaderActionMenu:e,isReadOnly:!n.fleet.allSettings},(0,O.jsx)(Xn,null)):(0,O.jsx)(F.x$,{isAddIntegrationsPath:!1},(0,O.jsx)(pi,{setHeaderActionMenu:e},(0,O.jsx)(F.LA,{error:"MISSING_PRIVILEGES",requiredFleetRole:"Settings Read"})))),(0,O.jsx)(r.Route,{path:S.X5.add_integration_to_policy},(0,O.jsx)(Hs,null)),(0,O.jsx)(r.Route,{render:({location:e})=>{if(!(""===e.pathname&&e.hash.length>0)){const e=n.fleet.readAgents?S.X5.agents:n.fleet.readAgentPolicies?S.X5.policies:S.X5.settings;return(0,O.jsx)(o.Redirect,{to:e})}const t=e.hash.replace(/^#(\/fleet)?/,"");return(0,O.jsx)(o.Redirect,{to:{...e,pathname:t,hash:void 0}})}})),a.isEnrollmentFlyoutOpen&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(M.rt,{defaultMode:!s.isReady||null!==(t=s.missingRequirements)&&void 0!==t&&t.includes("fleet_server")?"standalone":"managed",isIntegrationFlow:!0,onClose:()=>a.closeEnrollmentFlyout()})),a.isFleetServerFlyoutOpen&&(0,O.jsx)(c.EuiPortal,null,(0,O.jsx)(M.Jh,{onClose:()=>a.closeFleetServerFlyout()})))})),mi=({startServices:e,config:t,history:a,kibanaVersion:s,extensions:l,setHeaderActionMenu:n})=>(0,O.jsx)(ci,{startServices:e,config:t,history:a,kibanaVersion:s,extensions:l},(0,O.jsx)(di,null,(0,O.jsx)(fi,{setHeaderActionMenu:n})));function xi(e,{element:t,history:a,setHeaderActionMenu:s},l,n,o){return i().render((0,O.jsx)(mi,{startServices:e,config:l,history:a,kibanaVersion:n,extensions:o,setHeaderActionMenu:s}),t),()=>{i().unmountComponentAtNode(t)}}const hi=e=>{e.chrome.docTitle.reset(),e.chrome.setBreadcrumbs([]),u.Fjq.stop()}},58145:(e,t,a)=>{"use strict";var s=a(1941),l=a(84286),n=s.__importDefault(a(96943)),i=a(84756),o={x:0,y:0,width:0,height:0,top:0,left:0,bottom:0,right:0};t.A=i.isClient&&window.ResizeObserver?function(){var e=l.useState(null),t=e[0],a=e[1],s=l.useState(o),i=s[0],r=s[1],u=l.useMemo((function(){return new window.ResizeObserver((function(e){if(e[0]){var t=e[0].contentRect,a=t.x,s=t.y,l=t.width,n=t.height,i=t.top,o=t.left,u=t.bottom,d=t.right;r({x:a,y:s,width:l,height:n,top:i,left:o,bottom:u,right:d})}}))}),[]);return n.default((function(){if(t)return u.observe(t),function(){u.disconnect()}}),[t]),[a,i]}:function(){return[function(){},o]}},93230:(e,t,a)=>{e.exports=a(52497)(47027)}}]);