"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetDownloadSourceResponseSchema = exports.DownloadSourceSchema = exports.DownloadSourceResponseSchema = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DownloadSourceBaseSchema = {
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  name: _configSchema.schema.string(),
  host: _configSchema.schema.uri({
    scheme: ['http', 'https']
  }),
  is_default: _configSchema.schema.boolean({
    defaultValue: false
  }),
  proxy_id: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal(null), _configSchema.schema.string({
    meta: {
      description: 'The ID of the proxy to use for this download source. See the proxies API for more information.'
    }
  })]))
};
const DownloadSourceSchema = exports.DownloadSourceSchema = _configSchema.schema.object({
  ...DownloadSourceBaseSchema
});
const DownloadSourceResponseSchema = exports.DownloadSourceResponseSchema = DownloadSourceSchema.extends({
  id: _configSchema.schema.string()
});
const GetDownloadSourceResponseSchema = exports.GetDownloadSourceResponseSchema = _configSchema.schema.object({
  item: DownloadSourceResponseSchema
});