"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validatePolicyNamespaceForSpace = validatePolicyNamespaceForSpace;
var _app_context = require("../app_context");
var _errors = require("../../../common/errors");
var _space_settings = require("./space_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function validatePolicyNamespaceForSpace({
  namespace,
  spaceId
}) {
  const experimentalFeature = _app_context.appContextService.getExperimentalFeatures();
  if (!experimentalFeature.useSpaceAwareness) {
    return;
  }
  const settings = await (0, _space_settings.getSpaceSettings)(spaceId);
  if (!settings.allowed_namespace_prefixes || settings.allowed_namespace_prefixes.length === 0) {
    return;
  }
  let valid = false;
  for (const allowedNamespacePrefix of settings.allowed_namespace_prefixes) {
    if (namespace.startsWith(allowedNamespacePrefix)) {
      valid = true;
      break;
    }
  }
  if (!valid) {
    throw new _errors.PolicyNamespaceValidationError(`Invalid namespace, supported namespace prefixes: ${settings.allowed_namespace_prefixes.join(', ')}`);
  }
}