"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetEncryptedSavedObjectEncryptionKeyRequired = exports.EnrollmentKeyNotFoundError = exports.EnrollmentKeyNameExistsError = exports.DownloadSourceNotFound = exports.DownloadSourceError = exports.DeleteUnenrolledAgentsPreconfiguredError = exports.ConcurrentInstallOperationError = exports.BundledPackageLocationNotFoundError = exports.ArtifactsElasticsearchError = exports.ArtifactsClientError = exports.ArtifactsClientAccessDeniedError = exports.ArchiveNotFoundError = exports.AgentlessPolicyExistsRequestError = exports.AgentlessAgentUpgradeError = exports.AgentlessAgentDeleteError = exports.AgentlessAgentCreateError = exports.AgentlessAgentConfigError = exports.AgentRequestInvalidError = exports.AgentReassignmentError = exports.AgentPolicyNotFoundError = exports.AgentPolicyNameExistsError = exports.AgentPolicyInvalidError = exports.AgentPolicyError = exports.AgentNotFoundError = exports.AgentActionNotFoundError = void 0;
Object.defineProperty(exports, "FleetError", {
  enumerable: true,
  get: function () {
    return _errors.FleetError;
  }
});
exports.KibanaSOReferenceError = exports.InputNotFoundError = exports.HostedAgentPolicyRestrictionRelatedError = exports.GenerateServiceTokenError = exports.FleetUnauthorizedError = exports.FleetTooManyRequestsError = exports.FleetSetupError = exports.FleetServerHostUnauthorizedError = exports.FleetServerHostNotFoundError = exports.FleetProxyUnauthorizedError = exports.FleetNotFoundError = exports.FleetFilesClientError = exports.FleetFileNotFound = void 0;
Object.defineProperty(exports, "OutputInvalidError", {
  enumerable: true,
  get: function () {
    return _errors.OutputInvalidError;
  }
});
exports.StreamNotFoundError = exports.SigningServiceNotFoundError = exports.RegistryResponseError = exports.RegistryError = exports.RegistryConnectionError = exports.PackageUnsupportedMediaTypeError = exports.PackageSavedObjectConflictError = exports.PackageRemovalError = exports.PackagePolicyValidationError = exports.PackagePolicyRestrictionRelatedError = exports.PackagePolicyRequestError = exports.PackagePolicyOutputError = exports.PackagePolicyNotFoundError = exports.PackagePolicyNameExistsError = exports.PackagePolicyMultipleAgentPoliciesError = exports.PackagePolicyIneligibleForUpgradeError = exports.PackagePolicyContentPackageError = exports.PackageOutdatedError = exports.PackageNotFoundError = exports.PackageInvalidDeploymentMode = exports.PackageInvalidArchiveError = exports.PackageFailedVerificationError = exports.PackageESError = exports.PackageAlreadyInstalledError = exports.OutputUnauthorizedError = exports.OutputNotFoundError = exports.OutputLicenceError = void 0;
Object.defineProperty(exports, "defaultFleetErrorHandler", {
  enumerable: true,
  get: function () {
    return _handlers.defaultFleetErrorHandler;
  }
});
Object.defineProperty(exports, "fleetErrorToResponseOptions", {
  enumerable: true,
  get: function () {
    return _handlers.fleetErrorToResponseOptions;
  }
});
Object.defineProperty(exports, "isESClientError", {
  enumerable: true,
  get: function () {
    return _utils.isESClientError;
  }
});
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _errors = require("../../common/errors");
var _utils = require("./utils");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable max-classes-per-file */

class RegistryError extends _errors.FleetError {}
exports.RegistryError = RegistryError;
class RegistryConnectionError extends RegistryError {}
exports.RegistryConnectionError = RegistryConnectionError;
class RegistryResponseError extends RegistryError {
  constructor(message, status) {
    super(message);
    this.status = status;
  }
}

// Package errors
exports.RegistryResponseError = RegistryResponseError;
class PackageInvalidDeploymentMode extends _errors.FleetError {}
exports.PackageInvalidDeploymentMode = PackageInvalidDeploymentMode;
class PackageOutdatedError extends _errors.FleetError {}
exports.PackageOutdatedError = PackageOutdatedError;
class PackageFailedVerificationError extends _errors.FleetError {
  constructor(pkgName, pkgVersion) {
    super(`${pkgName}-${pkgVersion} failed signature verification.`);
    this.attributes = {
      type: 'verification_failed'
    };
  }
}
exports.PackageFailedVerificationError = PackageFailedVerificationError;
class PackageUnsupportedMediaTypeError extends _errors.FleetError {}
exports.PackageUnsupportedMediaTypeError = PackageUnsupportedMediaTypeError;
class PackageInvalidArchiveError extends _errors.FleetError {}
exports.PackageInvalidArchiveError = PackageInvalidArchiveError;
class PackageRemovalError extends _errors.FleetError {}
exports.PackageRemovalError = PackageRemovalError;
class PackageESError extends _errors.FleetError {}
exports.PackageESError = PackageESError;
class ConcurrentInstallOperationError extends _errors.FleetError {}
exports.ConcurrentInstallOperationError = ConcurrentInstallOperationError;
class PackageSavedObjectConflictError extends _errors.FleetError {}
exports.PackageSavedObjectConflictError = PackageSavedObjectConflictError;
class KibanaSOReferenceError extends _errors.FleetError {}
exports.KibanaSOReferenceError = KibanaSOReferenceError;
class PackageAlreadyInstalledError extends _errors.FleetError {}
exports.PackageAlreadyInstalledError = PackageAlreadyInstalledError;
class AgentPolicyError extends _errors.FleetError {}
exports.AgentPolicyError = AgentPolicyError;
class AgentRequestInvalidError extends _errors.FleetError {}
exports.AgentRequestInvalidError = AgentRequestInvalidError;
class AgentPolicyInvalidError extends _errors.FleetError {}
exports.AgentPolicyInvalidError = AgentPolicyInvalidError;
class AgentlessAgentCreateError extends _errors.FleetError {
  constructor(message) {
    super(`Error creating agentless agent in Fleet, ${message}`);
  }
}
exports.AgentlessAgentCreateError = AgentlessAgentCreateError;
class AgentlessAgentDeleteError extends _errors.FleetError {
  constructor(message) {
    super(`Error deleting agentless agent in Fleet, ${message}`);
  }
}
exports.AgentlessAgentDeleteError = AgentlessAgentDeleteError;
class AgentlessAgentUpgradeError extends _errors.FleetError {
  constructor(message) {
    super(`Error upgrading agentless agent in Fleet, ${message}`);
  }
}
exports.AgentlessAgentUpgradeError = AgentlessAgentUpgradeError;
class AgentlessAgentConfigError extends _errors.FleetError {
  constructor(message) {
    super(`Error validating Agentless API configuration in Fleet, ${message}`);
  }
}
exports.AgentlessAgentConfigError = AgentlessAgentConfigError;
class AgentlessPolicyExistsRequestError extends AgentPolicyError {
  constructor(message) {
    super(`Unable to create integration. ${message}`);
  }
}
exports.AgentlessPolicyExistsRequestError = AgentlessPolicyExistsRequestError;
class AgentPolicyNameExistsError extends AgentPolicyError {}
exports.AgentPolicyNameExistsError = AgentPolicyNameExistsError;
class AgentReassignmentError extends _errors.FleetError {}
exports.AgentReassignmentError = AgentReassignmentError;
class PackagePolicyIneligibleForUpgradeError extends _errors.FleetError {}
exports.PackagePolicyIneligibleForUpgradeError = PackagePolicyIneligibleForUpgradeError;
class PackagePolicyValidationError extends _errors.FleetError {}
exports.PackagePolicyValidationError = PackagePolicyValidationError;
class PackagePolicyNameExistsError extends _errors.FleetError {}
exports.PackagePolicyNameExistsError = PackagePolicyNameExistsError;
class BundledPackageLocationNotFoundError extends _errors.FleetError {}
exports.BundledPackageLocationNotFoundError = BundledPackageLocationNotFoundError;
class PackagePolicyRequestError extends _errors.FleetError {}
exports.PackagePolicyRequestError = PackagePolicyRequestError;
class PackagePolicyMultipleAgentPoliciesError extends _errors.FleetError {}
exports.PackagePolicyMultipleAgentPoliciesError = PackagePolicyMultipleAgentPoliciesError;
class PackagePolicyOutputError extends _errors.FleetError {}
exports.PackagePolicyOutputError = PackagePolicyOutputError;
class PackagePolicyContentPackageError extends _errors.FleetError {}
exports.PackagePolicyContentPackageError = PackagePolicyContentPackageError;
class EnrollmentKeyNameExistsError extends _errors.FleetError {}
exports.EnrollmentKeyNameExistsError = EnrollmentKeyNameExistsError;
class HostedAgentPolicyRestrictionRelatedError extends _errors.FleetError {
  constructor(message = 'Cannot perform that action') {
    super(`${message} in Fleet because the agent policy is managed by an external orchestration solution, such as Elastic Cloud, Kubernetes, etc. Please make changes using your orchestration solution.`);
  }
}
exports.HostedAgentPolicyRestrictionRelatedError = HostedAgentPolicyRestrictionRelatedError;
class PackagePolicyRestrictionRelatedError extends _errors.FleetError {
  constructor(message = 'Cannot perform that action') {
    super(`${message} in Fleet because the package policy is managed by an external orchestration solution, such as Elastic Cloud, Kubernetes, etc. Please make changes using your orchestration solution.`);
  }
}
exports.PackagePolicyRestrictionRelatedError = PackagePolicyRestrictionRelatedError;
class FleetEncryptedSavedObjectEncryptionKeyRequired extends _errors.FleetError {}
exports.FleetEncryptedSavedObjectEncryptionKeyRequired = FleetEncryptedSavedObjectEncryptionKeyRequired;
class FleetSetupError extends _errors.FleetError {}
exports.FleetSetupError = FleetSetupError;
class GenerateServiceTokenError extends _errors.FleetError {}
exports.GenerateServiceTokenError = GenerateServiceTokenError;
class FleetUnauthorizedError extends _errors.FleetError {}
exports.FleetUnauthorizedError = FleetUnauthorizedError;
class FleetNotFoundError extends _errors.FleetError {}
exports.FleetNotFoundError = FleetNotFoundError;
class FleetTooManyRequestsError extends _errors.FleetError {}
exports.FleetTooManyRequestsError = FleetTooManyRequestsError;
class OutputUnauthorizedError extends _errors.FleetError {}
exports.OutputUnauthorizedError = OutputUnauthorizedError;
class OutputLicenceError extends _errors.FleetError {}
exports.OutputLicenceError = OutputLicenceError;
class DownloadSourceError extends _errors.FleetError {}
exports.DownloadSourceError = DownloadSourceError;
class DeleteUnenrolledAgentsPreconfiguredError extends _errors.FleetError {}

// Not found errors
exports.DeleteUnenrolledAgentsPreconfiguredError = DeleteUnenrolledAgentsPreconfiguredError;
class AgentNotFoundError extends FleetNotFoundError {}
exports.AgentNotFoundError = AgentNotFoundError;
class AgentPolicyNotFoundError extends FleetNotFoundError {}
exports.AgentPolicyNotFoundError = AgentPolicyNotFoundError;
class AgentActionNotFoundError extends FleetNotFoundError {}
exports.AgentActionNotFoundError = AgentActionNotFoundError;
class DownloadSourceNotFound extends FleetNotFoundError {}
exports.DownloadSourceNotFound = DownloadSourceNotFound;
class EnrollmentKeyNotFoundError extends FleetNotFoundError {}
exports.EnrollmentKeyNotFoundError = EnrollmentKeyNotFoundError;
class FleetServerHostNotFoundError extends FleetNotFoundError {}
exports.FleetServerHostNotFoundError = FleetServerHostNotFoundError;
class SigningServiceNotFoundError extends FleetNotFoundError {}
exports.SigningServiceNotFoundError = SigningServiceNotFoundError;
class InputNotFoundError extends FleetNotFoundError {}
exports.InputNotFoundError = InputNotFoundError;
class OutputNotFoundError extends FleetNotFoundError {}
exports.OutputNotFoundError = OutputNotFoundError;
class PackageNotFoundError extends FleetNotFoundError {}
exports.PackageNotFoundError = PackageNotFoundError;
class ArchiveNotFoundError extends FleetNotFoundError {}
exports.ArchiveNotFoundError = ArchiveNotFoundError;
class PackagePolicyNotFoundError extends FleetNotFoundError {}
exports.PackagePolicyNotFoundError = PackagePolicyNotFoundError;
class StreamNotFoundError extends FleetNotFoundError {}
exports.StreamNotFoundError = StreamNotFoundError;
class FleetServerHostUnauthorizedError extends FleetUnauthorizedError {}
exports.FleetServerHostUnauthorizedError = FleetServerHostUnauthorizedError;
class FleetProxyUnauthorizedError extends FleetUnauthorizedError {}
exports.FleetProxyUnauthorizedError = FleetProxyUnauthorizedError;
class ArtifactsClientError extends _errors.FleetError {}
exports.ArtifactsClientError = ArtifactsClientError;
class ArtifactsClientAccessDeniedError extends _errors.FleetError {
  constructor(deniedPackageName, allowedPackageName) {
    super(`Access denied. Artifact package name (${deniedPackageName}) does not match ${allowedPackageName}`);
  }
}
exports.ArtifactsClientAccessDeniedError = ArtifactsClientAccessDeniedError;
class ArtifactsElasticsearchError extends _errors.FleetError {
  constructor(meta) {
    var _meta$meta$body, _meta$meta$body$error, _meta$meta$body2, _meta$meta$body2$erro;
    super(`${(0, _utils.isESClientError)(meta) && (_meta$meta$body = meta.meta.body) !== null && _meta$meta$body !== void 0 && (_meta$meta$body$error = _meta$meta$body.error) !== null && _meta$meta$body$error !== void 0 && _meta$meta$body$error.reason ? (_meta$meta$body2 = meta.meta.body) === null || _meta$meta$body2 === void 0 ? void 0 : (_meta$meta$body2$erro = _meta$meta$body2.error) === null || _meta$meta$body2$erro === void 0 ? void 0 : _meta$meta$body2$erro.reason : `Elasticsearch error while working with artifacts: ${meta.message}`}`);
    (0, _defineProperty2.default)(this, "requestDetails", void 0);
    this.meta = meta;
    if ((0, _utils.isESClientError)(meta)) {
      const {
        method,
        path,
        querystring = '',
        body = ''
      } = meta.meta.meta.request.params;
      this.requestDetails = `${method} ${path}${querystring ? `?${querystring}` : ''}${body ? `\n${body}` : ''}`;
    } else {
      this.requestDetails = 'unable to determine request details';
    }
  }
}
exports.ArtifactsElasticsearchError = ArtifactsElasticsearchError;
class FleetFilesClientError extends _errors.FleetError {}
exports.FleetFilesClientError = FleetFilesClientError;
class FleetFileNotFound extends FleetFilesClientError {}
exports.FleetFileNotFound = FleetFileNotFound;