"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldShowInstallationStatus = exports.getLineClampStyles = exports.InstallationStatus = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _constants = require("../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const installedLabel = _i18n.i18n.translate('xpack.fleet.packageCard.installedLabel', {
  defaultMessage: 'Installed'
});
const installStatusMapToColor = {
  installed: {
    color: 'success',
    iconType: 'check',
    title: installedLabel
  },
  install_failed: {
    color: 'warning',
    iconType: 'warning',
    title: installedLabel
  }
};
const getLineClampStyles = lineClamp => lineClamp ? `-webkit-line-clamp: ${lineClamp};display: -webkit-box;-webkit-box-orient: vertical;overflow: hidden;` : '';
exports.getLineClampStyles = getLineClampStyles;
const shouldShowInstallationStatus = ({
  installStatus,
  showInstallationStatus
}) => showInstallationStatus && (installStatus === _constants.installationStatuses.Installed || installStatus === _constants.installationStatuses.InstallFailed);
exports.shouldShowInstallationStatus = shouldShowInstallationStatus;
const InstallationStatus = exports.InstallationStatus = /*#__PURE__*/_react.default.memo(({
  installStatus,
  showInstallationStatus
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return shouldShowInstallationStatus({
    installStatus,
    showInstallationStatus
  }) ? /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          position: absolute;
          border-radius: 0 0 ${euiTheme.border.radius.medium} ${euiTheme.border.radius.medium};
          bottom: 0;
          left: 0;
          width: 100%;
          overflow: hidden;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    "data-test-subj": "installation-status-spacer",
    size: "m",
    css: (0, _react2.css)`
            background: ${euiTheme.colors.emptyShade};
          `
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, (0, _extends2.default)({
    "data-test-subj": "installation-status-callout",
    css: (0, _react2.css)`
            padding: ${euiTheme.size.s} ${euiTheme.size.m};
            text-align: center;
          `
  }, installStatus ? installStatusMapToColor[installStatus] : {}))) : null;
});