"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSection = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AdvancedSection = ({}) => {
  var _useGetSettings$data$, _useGetSettings$data, _useGetSettings$data$2, _useGetSettings$data$3, _useGetSettings$data$4, _useGetSettings$data2, _useGetSettings$data3, _useGetSettings$data4;
  const authz = (0, _hooks.useAuthz)();
  const {
    docLinks,
    notifications
  } = (0, _hooks.useStartServices)();
  const deleteUnenrolledAgents = (_useGetSettings$data$ = (_useGetSettings$data = (0, _hooks.useGetSettings)().data) === null || _useGetSettings$data === void 0 ? void 0 : (_useGetSettings$data$2 = _useGetSettings$data.item) === null || _useGetSettings$data$2 === void 0 ? void 0 : (_useGetSettings$data$3 = _useGetSettings$data$2.delete_unenrolled_agents) === null || _useGetSettings$data$3 === void 0 ? void 0 : _useGetSettings$data$3.enabled) !== null && _useGetSettings$data$ !== void 0 ? _useGetSettings$data$ : false;
  const isPreconfigured = (_useGetSettings$data$4 = (_useGetSettings$data2 = (0, _hooks.useGetSettings)().data) === null || _useGetSettings$data2 === void 0 ? void 0 : (_useGetSettings$data3 = _useGetSettings$data2.item) === null || _useGetSettings$data3 === void 0 ? void 0 : (_useGetSettings$data4 = _useGetSettings$data3.delete_unenrolled_agents) === null || _useGetSettings$data4 === void 0 ? void 0 : _useGetSettings$data4.is_preconfigured) !== null && _useGetSettings$data$4 !== void 0 ? _useGetSettings$data$4 : false;
  const [deleteUnenrolledAgentsChecked, setDeleteUnenrolledAgentsChecked] = _react.default.useState(deleteUnenrolledAgents);
  const {
    mutateAsync: mutateSettingsAsync
  } = (0, _hooks.usePutSettingsMutation)();
  (0, _react.useEffect)(() => {
    if (deleteUnenrolledAgents) {
      setDeleteUnenrolledAgentsChecked(deleteUnenrolledAgents);
    }
  }, [deleteUnenrolledAgents]);
  const updateSettings = (0, _react.useCallback)(async deleteFlag => {
    try {
      setDeleteUnenrolledAgentsChecked(deleteFlag);
      const res = await mutateSettingsAsync({
        delete_unenrolled_agents: {
          enabled: deleteFlag,
          is_preconfigured: false
        }
      });
      if (res.error) {
        throw res.error;
      }
    } catch (error) {
      setDeleteUnenrolledAgentsChecked(!deleteFlag);
      notifications.toasts.addError(error, {
        title: _i18n.i18n.translate('xpack.fleet.errorUpdatingSettings', {
          defaultMessage: 'Error updating settings'
        })
      });
    }
  }, [mutateSettingsAsync, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", {
    "data-test-subj": "advancedHeader"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.advancedSectionTitle",
    defaultMessage: "Advanced Settings"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.deleteUnenrolledAgentsLabel",
      defaultMessage: "Delete unenrolled agents"
    })),
    description: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.advancedSection.switchLabel",
      defaultMessage: "Switching on this setting will enable auto deletion of unenrolled agents. For more information see our {docLink}.",
      values: {
        docLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          target: "_blank",
          external: true,
          href: docLinks.links.fleet.settings
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.settings.advancedSection.link",
          defaultMessage: "docs"
        }))
      }
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: ""
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isPreconfigured ? _i18n.i18n.translate('xpack.fleet.settings.advancedSection.preconfiguredTitle', {
      defaultMessage: 'This setting is preconfigured and cannot be updated.'
    }) : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.deleteUnenrolledAgentsLabel",
      defaultMessage: "Delete unenrolled agents"
    }),
    checked: deleteUnenrolledAgentsChecked,
    onChange: e => updateSettings(e.target.checked),
    disabled: !authz.fleet.allSettings || isPreconfigured
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.AdvancedSection = AdvancedSection;